#include "HttpInstance.h"

#include "HttpModule.h"
#include "LogHeroUsdk.h"
#include "UsdkHttpManager.h"
#include "Interfaces/IHttpResponse.h"


HttpInstance::HttpInstance(int32 id, const FString& Url, const FString& Content,
	const TFunction<void(int32 statueCode, FString contentString, bool bWasSuccessful)>& Callback)
{
	_id = id;
	_url = Url;
	_content = Content;
	_callback = Callback;
	Post();
}


void HttpInstance::Post()
{
	const auto ret_request = FHttpModule::Get().CreateRequest();
	const FString FullUrl = FUsdkHttpManager::GetInst().GetCurrentFullUrl()+_url;
	UE_LOG(LogHeroUsdk, Log, TEXT(" HttpInstance post url: %s"), *FullUrl);
	ret_request->SetURL(FullUrl);
	ret_request->SetHeader(TEXT("Content-Type"), TEXT("application/x-www-form-urlencoded"));
	ret_request->SetContentAsString(_content);
	ret_request->SetTimeout(8);
	ret_request->SetVerb(TEXT("POST"));
	ret_request->OnProcessRequestComplete().BindRaw(this,&HttpInstance::OnResponse);
	ret_request->ProcessRequest();
}

void HttpInstance::OnResponse(FHttpRequestPtr HttpRequest, FHttpResponsePtr HttpResponse, bool bSuccess)
{
	if(!bSuccess)
	{
		if(++_tryCount < FUsdkHttpManager::GetInst().TotalGolbalAddressNum)
		{
			UE_LOG(LogHeroUsdk,Warning,TEXT("%s request failed,try %d times,start next try"),*HttpRequest->GetURL(),_tryCount)
			FUsdkHttpManager::GetInst().IncreaseUrlIndex();
			Post();
		}
		else
		{
			UE_LOG(LogHeroUsdk,Error,TEXT("%s request failed,try %d times"),*HttpRequest->GetURL(),_tryCount)
			_callback(0,"",bSuccess);
			FUsdkHttpManager::GetInst().intsMap.Remove(_id);
		}
		return;
	
	}

	UE_LOG(LogHeroUsdk,Warning,TEXT("%s request Success"),*HttpRequest->GetURL())
	_callback(HttpResponse->GetResponseCode(),HttpResponse->GetContentAsString(),bSuccess);
	FUsdkHttpManager::GetInst().intsMap.Remove(_id);
	

	
}
