#include "UsdkHttpManager.h"

#include "HttpModule.h"
#include "LogHeroUsdk.h"

FUsdkHttpManager::FUsdkHttpManager()
{
	globalServerAddresses.Emplace("https://hgsdkcdn.herogame.com/hgsrv/");
	globalServerAddresses.Emplace("https://hgsdkeu.herogame.com/hgsrv/");
	globalServerAddresses.Emplace("https://hgsdkus.herogame.com/hgsrv/");
	globalServerAddresses.Emplace("https://asia.0sdk.com/hgsrv/");
	TotalGolbalAddressNum = 4;
}

FString FUsdkHttpManager::GetCurrentFullUrl()
{
	if(currentSeverIndex<globalServerAddresses.Num() )
	{
		return globalServerAddresses[currentSeverIndex];
	}
	else if(globalDirectAddress.Len()>0 && currentSeverIndex+1==TotalGolbalAddressNum)
	{
		return globalDirectAddress;
	}
	return TEXT("");
}

void FUsdkHttpManager::Register(const TSharedPtr<FJsonObject>& JsonDataObject)
{

	
	
	if (JsonDataObject->HasField("heroglobalpc"))
	{
		const TSharedPtr<FJsonObject> HeroGlobalPcObject = JsonDataObject->GetObjectField(TEXT("heroglobalpc"));
		if(HeroGlobalPcObject.IsValid())
		{
			FString global_server_address = HeroGlobalPcObject->GetStringField(TEXT("global_server_address"));
			if(global_server_address.Len()>0)
			{
				global_server_address.ParseIntoArray(globalServerAddresses,TEXT(","));
				TotalGolbalAddressNum = globalServerAddresses.Num();
			}
			FString global_direct_address = HeroGlobalPcObject->GetStringField(TEXT("global_direct_address"));
			if(global_direct_address.Len()>0)
			{
				globalDirectAddress = global_direct_address;
				TotalGolbalAddressNum++;
			}
		}
	}
}

void FUsdkHttpManager::Post(const FString& Url, const FString& Content,
                            const TFunction<void(int32 statueCode, FString contentString, bool bWasSuccessful)>& Callback)
{
	int32 id = _current_id++;
	auto HttpInstanceShare = MakeShared<HttpInstance>(id,Url,Content,Callback);
	intsMap.Emplace(id,HttpInstanceShare);
}

void FUsdkHttpManager::IncreaseUrlIndex()
{
	++currentSeverIndex;
	if(currentSeverIndex>TotalGolbalAddressNum)
	{
		currentSeverIndex%=TotalGolbalAddressNum;
	}
}


