#pragma once
#include "HttpInstance.h"

class FUsdkHttpManager
{
	friend HttpInstance;
public:
	FUsdkHttpManager();

	static FUsdkHttpManager& GetInst()
	{
		static FUsdkHttpManager UsdkHttpManager;
		return UsdkHttpManager;
	}

	
	FString GetCurrentFullUrl();
	void Register(const TSharedPtr<FJsonObject>& JsonDataObject);
	void Unregister()
	{
		currentSeverIndex = 0;
		globalDirectAddress.Empty();
		TotalGolbalAddressNum = 0;
		_current_id = 0;
		intsMap.Empty();
	}
	void Post(const FString& Url,const FString& Content,const TFunction<void(int32 statueCode,FString contentString,bool bWasSuccessful)>& Callback);
private:
	void IncreaseUrlIndex();
	TArray<FString> globalServerAddresses;
	int32 currentSeverIndex = 0;
	FString globalDirectAddress;
	int32 TotalGolbalAddressNum = 4;
	int32 _current_id = 0;
	TMap<int32,TSharedPtr<HttpInstance>> intsMap;
};
