#include "HeroUsdkSubsystem.h"
#include "HeroUsdkSupportKit.h"
#if PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
#include "Manager/HeroUsdkSupportPcDelegate.h"
#endif
#include "PC_PayPannel.h"
#include "DotManager/DotManager.h"
#include "Http/UsdkHttpManager.h"
#include "Log/LogHeroUsdk.h"
#include "UObject/ConstructorHelpers.h"

UHeroUsdkSubsystem::UHeroUsdkSubsystem()
{
#if !UE_SERVER
	static auto BP_ProtoClass = ConstructorHelpers::FClassFinder<UPC_ProtocolPannel>(TEXT("/HeroUSDKPlugin/PC_ProtocolPannel.PC_ProtocolPannel_C"));
	BP_Proto  = BP_ProtoClass.Class;
	static auto BP_LoginClass = ConstructorHelpers::FClassFinder<UPC_LoginPannel>(TEXT("/HeroUSDKPlugin/PC_LoginPannel.PC_LoginPannel_C"));
	BP_Login  = BP_LoginClass.Class;
	static auto BP_PayClass = ConstructorHelpers::FClassFinder<UPC_PayPannel>(TEXT("/HeroUSDKPlugin/PC_PayPannel.PC_PayPannel_C"));
	BP_Pay  = BP_PayClass.Class;
	static auto BP_SwitchAccountClass = ConstructorHelpers::FClassFinder<UPC_SwitchAccountPannel>(TEXT("/HeroUSDKPlugin/PC_SwitchAccountPannel.PC_SwitchAccountPannel_C"));
	BP_SwitchAccount  = BP_SwitchAccountClass.Class;
	static auto BP_AccountCenterClass = ConstructorHelpers::FClassFinder<UPC_AccountCenterPannel>(TEXT("/HeroUSDKPlugin/PC_AccountCenterPannel.PC_AccountCenterPannel_C"));
	BP_AccountCenter  = BP_AccountCenterClass.Class;
	static auto BP_SurveyClass = ConstructorHelpers::FClassFinder<UPC_SurveyPanel>(TEXT("/HeroUSDKPlugin/Browser/Components/W_SurveyBrowser.W_SurveyBrowser_C"));
	BP_Survey  = BP_SurveyClass.Class;
#endif
	
}

void UHeroUsdkSubsystem::Initialize(FSubsystemCollectionBase& Collection)
{
	Super::Initialize(Collection);
	
	// Initialize subsystem with project identifier provided by user
	// UUsdkProjectSettings* Settings = FUsdkSettingsModule::Get().GetSettings();
	// Initialize(Settings);
	HeroUsdkSupportKit::GetInstance().Register(this);
	FDotManager::GetInstance().Register();
	FDotManager::GetInstance().CallDot("$AppStart");
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSubsystem subsystem initialized"));
}

void UHeroUsdkSubsystem::Deinitialize()
{
	Super::Deinitialize();
	FDotManager::GetInstance().CallDot("$AppEnd");
	HeroUsdkSupportKit::GetInstance().Unregister();

#if PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	
	FUsdkHttpManager::GetInst().Unregister();
	
#endif
	FDotManager::GetInstance().UnRegister();
}


