// Fill out your copyright notice in the Description page of Project Settings.


#include "HeroUsdkSupportKit.h"
#include "Misc/Base64.h"
#include "HeroUsdkSubsystem.h"
#include "HeroUsdkSupportNotify.h" 
#include "LogHeroUsdk.h"
#if UE_EDITOR
#include "Env/ReleaseEnv/China/EnvChinaRelease.h"
#include "Env/ReleaseEnv/Global/EnvGlobalRelease.h"
#include "Platform/IOS/Config/Channel/Global/IosGlobalConfig.h"
#include "Platform/IOS/Config/Channel/Mainland/IosMainlandConfig.h"
#include "PreInit/Global/IosGlobalManager.h"
#include "PreInit/Mainland/IosMainlandManager.h"
#endif
#include "Env/DebugEnv/China/EnvChinaDebug.h"
#include "Manager/Channel/China/ChinaManager.h"
#include "Setting/UsdkSettings.h"
#include "Setting/UsdkSettingsTypes.h"


#if PLATFORM_IOS
#import "Platform/IOS/PlatformManagerIOS.h"
#import <HeroUSDK/HeroUPlatform.h>
#elif PLATFORM_ANDROID
#include "Platform/Android/PlatformManagerAndroid.h"
#else
#include "Manager/PlatformManagerPc.h"
#endif



HeroUsdkSupportKit& HeroUsdkSupportKit::GetInstance()
{
	static HeroUsdkSupportKit Inst;
	return Inst;
}

void HeroUsdkSupportKit::Register(UHeroUsdkSubsystem* InSubsystem)
{



	
#if PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
#endif
	
	Subsystem = InSubsystem;
	bIsAlive = true;

	const UUsdkSettings* const Setting = GetMutableDefault<UUsdkSettings>();

	if(Setting->UsdkConfig.IsEmpty())
	{
		UE_LOG(LogHeroUsdk,Error,TEXT("渠道参数未配置，请配置渠道参数"));
	}
	EHeroUSDKChannel Channel = Setting->Channel;
	
	
	TSharedPtr<FJsonObject> HeroConfig = MakeShareable(new FJsonObject);
	auto config = Setting->MirrorConfig;
	if (!config.Len())
	{
		config = Setting->UsdkConfig;	
	}
	TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(config);
	if (FJsonSerializer::Deserialize(Reader, HeroConfig))
	{
		ProductId = HeroConfig->GetStringField(TEXT("productId"));
		ProductKey = HeroConfig->GetStringField(TEXT("productKey"));
	}

#if PLATFORM_IOS
	PlatformManager = MakeUnique<FPlatformManagerIOS>(InSubsystem, HeroConfig);
#elif PLATFORM_ANDROID
	PlatformManager = MakeUnique<FPlatformManagerAndroid>(InSubsystem);
#else
	PlatformManager = MakeUnique<FPlatformManagerPc>(InSubsystem,HeroConfig);
#endif

}

void HeroUsdkSupportKit::Unregister()
{
	Subsystem = nullptr;
	bIsAlive = false;
	PlatformManager.Reset();
}

#if UE_EDITOR
void HeroUsdkSupportKit::GenInitConfig(const FString& Config)
{
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	const TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(Config);
	if (!FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		UE_LOG(LogTemp, Error, TEXT("设置PC配置文件失败，json字符串格式错误,Json:%s"), *Config);
		return;
	}

	ProductId = JsonObject->GetStringField(TEXT("productId"));
	ProductKey = JsonObject->GetStringField(TEXT("productKey"));
	HeroUsdkSupportPcDelegate::GenInitConfig(JsonObject);
	
	TSharedPtr<FIosMainlandConfig> ChinaConfig = MakeShareable(new FIosMainlandConfig);
	ChinaConfig->Parse(JsonObject->GetObjectField("ihero"));
	auto ChinaEnvMode = MakeShareable(new FEnvChinaRelease);
	static TSharedPtr<FIosMainlandManager> ChinaManager =  MakeShareable(new FIosMainlandManager(nullptr,ChinaConfig,ChinaEnvMode));
	ChinaManager->GenInitConfig();
	
	TSharedPtr<FIosGlobalConfig> GlobalConfig = MakeShareable(new FIosGlobalConfig);
	GlobalConfig->Parse(JsonObject->GetObjectField("iheroglobal"));
	auto GlobalEnvMode = MakeShareable(new FEnvGlobalRelease);
	static TSharedPtr<FIosGlobalManager> GlobalManager =  MakeShareable(new FIosGlobalManager(nullptr,GlobalConfig,GlobalEnvMode));
	GlobalManager->GenInitConfig();

}
#endif

/*
 * 设置回调
 */
void HeroUsdkSupportKit::SetNotify(HeroUsdkSupportNotify* Notify)
{
	NotifyObject = Notify;
	PlatformManager->SetNotify();
}

/*
 * 根据key获取value
 */
FString HeroUsdkSupportKit::getChanelValueByKey(FString key, const TSharedPtr<FJsonObject> JsonObject)
{
	FString valueString = "";
	bool result = JsonObject->TryGetStringField(key, valueString);
	if (result)
	{
		valueString = JsonObject->GetStringField(key);
	}
	return valueString;
}

/*
 * 融合SDK初始化
 */
void HeroUsdkSupportKit::init()
{
	PlatformManager->Init();
}

/*
 * 融合SDK登录
 */
void HeroUsdkSupportKit::login()
{
	PlatformManager->Login();
}

/*
 * 进入游戏
 */
void HeroUsdkSupportKit::enterGame(FHeroHDCGameRoleInfo roleInfo)
{
	PlatformManager->EnterGame(roleInfo);
}

/*
 * 角色注册
 */
void HeroUsdkSupportKit::createNewRole(FHeroHDCGameRoleInfo roleInfo)
{
	PlatformManager->CreateNewRole(roleInfo);
}

/*
 * 角色升级
 */
void HeroUsdkSupportKit::roleLevelUp(FHeroHDCGameRoleInfo roleInfo)
{
	PlatformManager->RoleLevelUp(roleInfo);
}

/*
 * 注销、退出登录
 */
void HeroUsdkSupportKit::logout()
{
	PlatformManager->logout();
}

/*
 * 支付
 */
void HeroUsdkSupportKit::pay(FHeroUPaymentParameters paymentParametersData, FHeroHDCGameRoleInfo roleInfo)
{
	PlatformManager->Pay(paymentParametersData,roleInfo);
}

/*
 * 扫描(登录在PC端登录,SDK需要登录状态）
 */
void HeroUsdkSupportKit::showScanViewWithExt(FString exit)
{
	PlatformManager->showScanViewWithExt(exit);
}

/*
 * 收到踢下线结果回调SDK
 */
void HeroUsdkSupportKit::cpKickOffCallBackWithResult(FString result)
{
	PlatformManager->cpKickOffCallBackWithResult(result);
}

/*
 * 获取协议内容
 */
FString HeroUsdkSupportKit::getProtocolResult()
{
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit getProtocolResult !"));

	return PlatformManager->getProtocolResult();
}

/*
 * 点击同意通知
 */
void HeroUsdkSupportKit::setAgreeProtocol()
{
	PlatformManager->setAgreeProtocol();
}

/*
 * 打开用户中心
 */
void HeroUsdkSupportKit::showAccountCenter()
{
	PlatformManager->showAccountCenter();
}

/*
 * 注销账号 
 */
void HeroUsdkSupportKit::accountCancellation()
{
	PlatformManager->accountCancellation();
}

/*
 * 撤回注销账号
 */
void HeroUsdkSupportKit::accountUnCancellation()
{
	PlatformManager->accountUnCancellation();
}

/*
 * 上报问题 
 */
void HeroUsdkSupportKit::uploadIssue()
{
	PlatformManager->uploadIssue();
}

void HeroUsdkSupportKit::SetUsdkLanguage(EHeroUsdkLanguageFlag Language)
{
	PlatformManager->SetUsdkLanguage(Language);
}

/*
 * 打开内置浏览器
 * </summary>
 * <param name="openID">中台配置URL地址的ID</param>
 */
void HeroUsdkSupportKit::openBrowser(FString openID)
{
	PlatformManager->openBrowser(openID);
}

void HeroUsdkSupportKit::OpenSurvey( const FString& WebId)
{
	PlatformManager->OpenSurvey(WebId);
}

void HeroUsdkSupportKit::OpenService()
{
	PlatformManager->OpenService();
}

/*
 * 全球无界面切换账号
 */
void HeroUsdkSupportKit::switchAccount()
{
	PlatformManager->switchAccount();
}

/*
 * 调用 track 接口，追踪一个带有属性的 event
*/
void HeroUsdkSupportKit::trackWithProperties(FString eventName, TMap<FString, FString> parameters)
{
	PlatformManager->trackWithProperties(eventName,parameters);
}

/*
 * 获取USDK内部埋点事件
 */
void HeroUsdkSupportKit::trackEventDataCallback()
{
	PlatformManager->trackEventDataCallback();
}

/*
 * 打开Xsolla商城支付
 */
void HeroUsdkSupportKit::startXsollaPayWithXsollaProperties(TMap<FString, FString> propertys)
{
	PlatformManager->startXsollaPayWithXsollaProperties(propertys);
}

/*
 * 获取全球渠道账户绑定的状态
 */
void HeroUsdkSupportKit::getGlobalBindState()
{
	PlatformManager->getGlobalBindState();
}

/*
	 * 分享
	 */
void HeroUsdkSupportKit::share(FShareInfo shareInfo)
{
	
	PlatformManager->share(shareInfo);
}

/*
 * 保存图片到相册
 */
void HeroUsdkSupportKit::addPicToAlbum(FString imagePath,FString albumName)
{
	PlatformManager->addPicToAlbum(imagePath,albumName);
}

/*
 * 应用跳转
 */
void HeroUsdkSupportKit::jumpToApp(FString url)
{
	PlatformManager->jumpToApp(url);
	
}

/*
 * 获取UE4插件版本号
 */
FString HeroUsdkSupportKit::getHeroUsdkUE4Version()
{
	return "4.7.0.1";
	
	/*
	 *	USDK版本4.5.0
	 *  Android 4.5.0版本 
	 *  iOS 国内版本3.6.9
	 *  iOS 全球版本4.5.3
	 *  TEXT("HeroUSDK Plugin Version : 4.5.0 \n "
		" Android USDK Version : 4.5.0 \n"
		" iOS USDK Version : 4.5.0 \n "
		" iOS 国内SDK Version : 3.6.9 \n "
		" iOS 全球SDK Version : 4.5.3 \n");
		
	 *   
	 */
	
}

/*
 *  ============================== iOS ===========================
 */

/*
 * 获取登录用户名
 */
FString HeroUsdkSupportKit::getUserName()
{
	return PlatformManager->getUserName();
}

/*
 * 获取登录用户ID
 */
FString HeroUsdkSupportKit::getUserId()
{
	return PlatformManager->getUserId();
}

/*
 * 获取ID（部分游戏使用@"id"字段作为唯一标示符）
 */
FString HeroUsdkSupportKit::getSdkId()
{
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit getSdkId !"));
	return PlatformManager->getSdkId();
}

/*
 * 获取设备号(优先取的IDFA、没取到则取的UUID)
 */
FString HeroUsdkSupportKit::getDeviceNum()
{
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit getDeviceNum"));
	return PlatformManager->getDeviceNum();
}

void HeroUsdkSupportKit::getIDFA()
{
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit getIDFA !"));
	PlatformManager->getIDFA();
}

void HeroUsdkSupportKit::getIDFV()
{
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit getIDFV !"));
	PlatformManager->getIDFV();
}

/*
 * iOS【注销、退出登陆并显示账号历史界面】
 */
void HeroUsdkSupportKit::logoutAndSowLoginView()
{
	PlatformManager->logoutAndSowLoginView();
}

/*
 * 上报闪屏
 */
void HeroUsdkSupportKit::postSplashScreenEndSuccess()
{
	PlatformManager->postSplashScreenEndSuccess();
}

/*
 *  ============================== Android ===========================
 */
/*
 * 渠道ID
 */
int HeroUsdkSupportKit::getChannelId()
{
	return PlatformManager->getChannelId();
}

int HeroUsdkSupportKit::getMirrorChannelId()
{
	return PlatformManager->getMirrorChannelId();
}

/*
 * 渠道名称
 */
FString HeroUsdkSupportKit::getChannelName()
{
	return PlatformManager->getChannelName();
}

/*
 * 获取渠道SDK的版本名
 */
FString HeroUsdkSupportKit::getChannelSdkVersionName()
{
	return PlatformManager->getChannelSdkVersionName();
}

/*
 * 判断当前渠道在调用退出接口时是否会弹出退出框
 */
bool HeroUsdkSupportKit::isChannelHasExitDialog()
{
	return PlatformManager->isChannelHasExitDialog();
}

/*
 * 获取英雄官网渠道的ProjectId，常用于游戏需要CPS分包时
 */
FString HeroUsdkSupportKit::getProjectId()
{
	return PlatformManager->getProjectId();
}

/*
 * 获取用户在HeroUSDK后台配置的自定义参数值。
 */
FString HeroUsdkSupportKit::getCustomParams(FString key)
{
	return PlatformManager->getCustomParams(key);
}

/*
 * 调用渠道的扩展方法(如显示/隐藏悬浮框，防沉迷查询，进入用户中心等)。
 */
bool HeroUsdkSupportKit::callExtendApi(int extendType)
{
	return PlatformManager->callExtendApi(extendType);
}

/*
 * 获取当前设备的OAID值
 */
void HeroUsdkSupportKit::getOAID()
{
	PlatformManager->getOAID();
}

FString HeroUsdkSupportKit::getChannelMsg()
{
	return PlatformManager->getChannelMsg();
}

void HeroUsdkSupportKit::GetGAID()
{
	PlatformManager->GetGAID();
}

void HeroUsdkSupportKit::GetAppSetID()
{
	PlatformManager->GetAppSetID();
}

/*
 * android【退出】
 */
void HeroUsdkSupportKit::exit()
{
	PlatformManager->exit();
}

/*
 * 获取订单详情列表
 * <f1>如果接入usdk通过中台出全球渠道包，商品id需要传入中台配置的usdk商品id</f1>
 */
void HeroUsdkSupportKit::getGoogleSkuDetailsList(TArray<FString> gameGoodsList)
{
	PlatformManager->getGoogleSkuDetailsList(gameGoodsList);
}

/*
	 * 屏蔽市场插件SDK默认埋点[Android]
	 */
void HeroUsdkSupportKit::setDisableMarketEvent(TMap<MARKET_EVENT,bool> bundle)
{
	PlatformManager->setDisableMarketEvent(bundle);
}

/*
 * 获取邀请链接
 */
void HeroUsdkSupportKit::getAppsflyerOneLinkUrl(const TMap<FString,FString>& bundle)
{
	PlatformManager->getAppsflyerOneLinkUrl(bundle);
}

/*
 * 获取链接跳转参数
 */
FString HeroUsdkSupportKit::getAppsflyerOneLinkData()
{
	return PlatformManager->getAppsflyerOneLinkData();
}

/*
 * 获取appsflyer 唯一标识
 */
FString HeroUsdkSupportKit::getAppsflyerUID()
{
	return PlatformManager->getAppsflyerUID();
}
/*
 * Google积分墙
 */
void HeroUsdkSupportKit::reportAccountInfo(FString serverId,FString serverName,FString roleId,FString roleName,FString cpExt)
{
	PlatformManager->reportAccountInfo(serverId,serverName,roleId,roleName,cpExt);
	
}

/*
	 * =================== 市场插件相关API ===================
	 */

/*
 * 市场插件日志上报
 */
void HeroUsdkSupportKit::logEvent(FString eventName,TMap<FString, FString> propertys)
{
	PlatformManager->logEvent(eventName,propertys);
}

/*
 * 市场插件支付日志上报
 */
void HeroUsdkSupportKit::logPurchaseWithOrderId(FString orderId,double amount,FString currency,TMap<FString, FString> propertys)
{
	PlatformManager->logPurchaseWithOrderId(orderId,amount,currency,propertys);
	
}