


#include "IosGlobalManager.h"

#include <string>

#include "Manager/Usdk/UsdkManager.h"
#include "Config/Channel/Global/GlobalConfig.h"
#include "Http/UsdkHttpManager.h"
#include "Tools/UsdkCommonTools.h"

void FIosGlobalManager::GenInitConfig()
{
	this->CreatePostRequest("v1/sys/init.lg", {}, [this](int32 statueCode, FString ContentString, bool bWasSuccessful)
	{
		auto setting = GetMutableDefault<UUsdkSettings>();
		setting->IosGlobalInitConfig = ContentString;
		setting->SaveConfig(CPF_Config, *FPaths::Combine(FPaths::ProjectConfigDir(),TEXT("DefaultGame.ini")));
	});

}

FIosGlobalManager::~FIosGlobalManager()
{
}

void FIosGlobalManager::Init(TFunction<void(bool bSuccess, const FString& Msg)> Callback)
{
}

void FIosGlobalManager::Logout()
{
}

void FIosGlobalManager::Pay(const FHeroUPaymentParameters& paymentParametersData, const FPayOrderResult& PayOrderResult)
{
}

FString FIosGlobalManager::GetQueryVersionUrl()
{
	return TEXT("");
}

FString FIosGlobalManager::GetDownloadCompletedName()
{
	return TEXT("");
}

FString FIosGlobalManager::GetDownLoadWebUrl()
{
	return TEXT("");
}

FString FIosGlobalManager::GetChannelWebDir()
{
	return TEXT("");
}

void FIosGlobalManager::CreatePostRequest(FString url, const TMap<FString, FString>& Parameter,
                                          const TFunction<void(int32 statueCode, FString contentString,
                                                               bool bWasSuccessful)>& Callback)
{
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	const FString bodyStr = Encrypt(Parameter);
	FUsdkHttpManager::GetInst().Post(url, bodyStr, Callback);
#endif
}

TMap<FString, FString> FIosGlobalManager::GetCommonParameter()
{
	TMap<FString, FString> commonMap;
	const FString dn = FPlatformMisc::GetLoginId().ToUpper();
	commonMap.Emplace("dn", dn);

	const auto channel_global = StaticCastSharedPtr<FGlobalConfig>(Config);

	commonMap.Emplace("gid", channel_global->game_id);
	commonMap.Emplace("lang", HeroUsdkSupportPcDelegate::GetInstance()->GetCurrentLanguage());
	commonMap.Emplace("pk", channel_global->package);
	commonMap.Emplace("platform", "2");
	commonMap.Emplace("projectId", channel_global->projectId);
	// commonMap.Emplace("svc", HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version());
	commonMap.Emplace("vn", channel_global->gameName);

	return commonMap;
}

FString FIosGlobalManager::Encrypt(const TMap<FString, FString>& Parameter)
{
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	TMap<FString, FString> AllParam;
	AllParam.Append(Parameter);
	AllParam.Append(GetCommonParameter());
	AllParam.KeySort([](const FString& A, const FString& B) { return A < B; });
	auto Json = FUsdkCommonTools::converMapToString(AllParam);
	auto base64 = FBase64::Encode(Json);
	auto Data = EncryptSwap(base64);

	FDateTime Time = FDateTime::UtcNow();
	int64 unixTimestamp = Time.ToUnixTimestamp();

	FString SignRaw = FString::Printf(TEXT("data=%s&pcode=%s&timestamp=%lld&%s"), *Data,
	                                  *Config->GetProductId(), unixTimestamp, *Config->GetProductKey());
	std::string std_Sign = TCHAR_TO_UTF8(*SignRaw);

	FString SignHash = FMD5::HashBytes((const uint8*)std_Sign.c_str(), std_Sign.length());
	FString Result = FString::Printf(
		TEXT("data=%s&pcode=%s&timestamp=%lld&sign=%s"), *FGenericPlatformHttp::UrlEncode(Data),
		*Config->GetProductId(), unixTimestamp, *SignHash);


	return Result;
#endif
	return "";
}

FString FIosGlobalManager::EncryptSwap(const FString& In)
{
	FString Result = In;
	const TArray<int32> ChangePos = {1, 33, 10, 42, 18, 50, 19, 51};
	if (Result.Len() > 51)
	{
		for (int32 i = 0; i < ChangePos.Num(); i += 2)
		{
			auto& A = Result[ChangePos[i]];
			auto& B = Result[ChangePos[i + 1]];
			Swap(A, B);
		}
	}
	return Result;
}
