#pragma once
#include "Manager/Channel/Base/ChannelManagerBase.h"

class HEROUSDKPLUGIN_API FIosGlobalManager : public FChannelManagerBase
{
public:
	FIosGlobalManager(UHeroUsdkSubsystem* InSubsystem, const TSharedPtr<FChannelConfigBase>& ChannelConfig,
	                  const TSharedPtr<FEnvModeBase>& InEnvMode)
		: FChannelManagerBase(InSubsystem, ChannelConfig, InEnvMode)
	{
	}

	virtual ~FIosGlobalManager() override;
	virtual void Init(TFunction<void(bool bSuccess, const FString& Msg)> Callback) override;
	virtual void Logout() override;
	virtual TMap<FString, FString> GetJsParamter() override { return {}; }
	virtual void Pay(const FHeroUPaymentParameters& paymentParametersData,
	                 const FPayOrderResult& PayOrderResult) override;
	virtual FString GetQueryVersionUrl() override;
	virtual FString GetDownloadCompletedName() override;
	virtual FString GetDownLoadWebUrl() override;
	virtual FString GetChannelWebDir() override;

	void GenInitConfig();

private:
	void CreatePostRequest(FString url, const TMap<FString, FString>& Parameter,
	                       const TFunction<void(int32 statueCode, FString contentString, bool bWasSuccessful)>&
	                       Callback);
	TMap<FString, FString> GetCommonParameter();
	FString Encrypt(const TMap<FString, FString>& Parameter);
	FString EncryptSwap(const FString& In);
};
