

#include "IosMainlandManager.h"

#include <cstring>
#include <string>

#include "Manager/Usdk/UsdkManager.h"
#include "HeroUsdkSupportKit.h"
#include "Manager/HeroUsdkSupportPcDelegate.h"
#include "LogHeroUsdk.h"
#include "DotManager/DotManager.h"
#include "Platform/IOS/Config/Channel/Mainland/IosMainlandConfig.h"


FHttpModule* FIosMainlandManager::GetHttpModule()
{
	static FHttpModule* HTTPModule = nullptr;
	if (HTTPModule == nullptr)
	{
		HTTPModule = &FHttpModule::Get();
		HTTPModule->SetHttpTimeout(60);
		HTTPModule->SetMaxReadBufferSize(1024 * 1024 * 50);
		HTTPModule->SetHttpDelayTime(0.001);
	}
	return HTTPModule;
}

FHttpManager& FIosMainlandManager::GetHttpMgr()
{
	return GetHttpModule()->GetHttpManager();
}

void FIosMainlandManager::CreatePostRequest(FString url, const TMap<FString, FString>& Parameter,
                                            const FGameNetWorkComplete& netWorkComplete)
{
	TSharedRef<IHttpRequest, ESPMode::ThreadSafe> ret_request = GetHttpModule()->CreateRequest();
	const FString fullUrl = EnvMode->GetChannelUrl() + url;
	UE_LOG(LogHeroUsdk, Log, TEXT(" createPostReuquest : %s"), *fullUrl);
	ret_request->SetURL(fullUrl);
	ret_request->SetHeader(TEXT("Content-Type"), TEXT("application/x-www-form-urlencoded"));
	const FString bodyStr = GetEncodeParames(Parameter);
	ret_request->SetContentAsString(bodyStr);
	ret_request->SetTimeout(30000);
	ret_request->SetVerb(TEXT("POST"));
	ret_request->OnProcessRequestComplete().BindLambda(
		[netWorkComplete](FHttpRequestPtr HttpRequest, FHttpResponsePtr HttpResponse, bool bSuccess)
		{
			if (HttpResponse.IsValid())
			{
				const FString contentStr = HttpResponse->GetContentAsString();
				const int32 statusCode = HttpResponse->GetResponseCode();
				if (netWorkComplete) { netWorkComplete(statusCode, contentStr, bSuccess); }
			}
		});
	ret_request->ProcessRequest();
}


void FIosMainlandManager::GenInitConfig()
{
	TMap<FString, FString> paramters;
	paramters.Add("pkg", Config->package);
	this->CreatePostRequest("c1/sys/conf.lg", paramters,
	                        [this](int32 StatueCode, FString ContentString, bool bWasSuccessful)
	                        {
	                        		auto setting = GetMutableDefault<UUsdkSettings>();
										setting->IosMainlandInitConfig = ContentString;
										setting->SaveConfig(CPF_Config,*FPaths::Combine(FPaths::ProjectConfigDir(),TEXT("DefaultGame.ini")));
	                        });
}


void FIosMainlandManager::createInitRequest(FString url, const FGameNetWorkComplete& netWorkComplete)
{
	TMap<FString, FString> paramters;

#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX

	paramters.Add("pkg", Config->package);

#endif

	this->CreatePostRequest(url, paramters,
	                        [this, netWorkComplete](int32 statueCode, FString contentString, bool bWasSuccessful)
	                        {
		                        if (!bWasSuccessful)
		                        {
			                        return;
		                        }
		                        if (contentString.IsEmpty())
		                        {
			                        return;
		                        }
		                        netWorkComplete(statueCode, contentString, bWasSuccessful);
	                        });
}

FString FIosMainlandManager::GetEncodeParames(const TMap<FString, FString>& paramter)
{
	FString ParamsString;
	TMap<FString, FString> ParamsMap;
	const TMap<FString, FString> CommonParams = GetCommonParameter();
	//合并数据
	ParamsMap.Append(paramter);
	ParamsMap.Append(CommonParams);
	//给所有的Key排序
	ParamsMap.KeySort([](const FString& A, const FString& B) { return A < B; });
	FString MarketValue;
	const bool bIsContain = ParamsMap.RemoveAndCopyValue("market", MarketValue);
	for (TTuple<FString, FString>& Param : ParamsMap)
	{
		if (!Param.Value.IsEmpty())
		{
			ParamsString.Append(Param.Key);
			ParamsString.Append(TEXT("="));
			ParamsString.Append(Param.Value);
			ParamsString.Append(TEXT("&"));
		}
	}
	FString appKey = TEXT("");

#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX

	appKey = Config->GetProductKey();

#endif

	if (appKey.IsEmpty()) { return ""; }

	FString EncryptString = FString::Printf(TEXT("%s"), *ParamsString);

	EncryptString.Append(appKey);

	std::string std_str = TCHAR_TO_UTF8(*EncryptString);
	FString SignCode = FMD5::HashBytes((const uint8*)std_str.c_str(), std_str.length());
	TCHAR* CStr = SignCode.GetCharArray().GetData();
	const TCHAR l = CStr[1];
	const TCHAR r = CStr[13];
	CStr[1] = r;
	CStr[13] = l;

	const TCHAR l1 = CStr[5];
	const TCHAR r1 = CStr[17];
	CStr[5] = r1;
	CStr[17] = l1;

	const TCHAR l2 = CStr[7];
	const TCHAR r2 = CStr[23];
	CStr[7] = r2;
	CStr[23] = l2;

	FString NewString(CStr);

	if (bIsContain)
	{
		ParamsString.Append(TEXT("market="));
		ParamsString.Append(MarketValue);
		ParamsString.Append(TEXT("&"));
	}
	ParamsString.Append(TEXT("sign="));
	ParamsString.Append(NewString);
	UE_LOG(LogHeroUsdk, Log, TEXT(" GetEncodeParames parameUrlEncode : %s"), *ParamsString);
	return ParamsString;
}

TMap<FString, FString> FIosMainlandManager::GetCommonParameter()
{
	TMap<FString, FString> commonMap;
	commonMap.Emplace("__e__", "1");

	const auto ChannelChina = StaticCastSharedPtr<FIosMainlandConfig>(Config);;

	commonMap.Emplace("productId", ChannelChina->productId);
	commonMap.Emplace("projectId", ChannelChina->projectId);
	commonMap.Emplace("serverId", ChannelChina->serverId);
	commonMap.Emplace("appKey", ChannelChina->appKey);
	commonMap.Emplace("appSecret", ChannelChina->appSecret);
	commonMap.Emplace("pkg", ChannelChina->package);

	FString dn = FPlatformMisc::GetLoginId().ToUpper();
	commonMap.Emplace("deviceNum", dn);
	commonMap.Emplace("platform", "ios");
	commonMap.Emplace("sdkVersion", HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version());
	return commonMap;
}

FString FIosMainlandManager::ConverMapToString(const TMap<FString, FString>& parameters)
{
	FString parametersJSON;
	if (parameters.Num())
	{
		TSharedPtr<FJsonObject> FieldsObject = MakeShareable(new FJsonObject());
		for (auto& Elem : parameters)
		{
			if (!Elem.Key.IsEmpty()) { FieldsObject->SetStringField(Elem.Key, Elem.Value); }
		}
		TSharedRef<TJsonWriter<TCHAR>> jsonWriter = TJsonWriterFactory<TCHAR>::Create(&parametersJSON);
		FJsonSerializer::Serialize(FieldsObject.ToSharedRef(), jsonWriter);
	}
	return parametersJSON;
}

