// Fill out your copyright notice in the Description page of Project Settings.

#pragma once
#include "CoreMinimal.h"

#include "Http.h"
#include "Manager/Channel/Base/ChannelManagerBase.h"


typedef TFunction<void(int32 statueCode,const FString& Content,bool bWasSuccessful)> FGameNetWorkComplete;

class FIosMainlandManager :	public  FChannelManagerBase
{
public:
	FIosMainlandManager(UHeroUsdkSubsystem* InSubsystem, const TSharedPtr<FChannelConfigBase>& ChannelConfig,
		const TSharedPtr<FEnvModeBase>& InEnvMode)
		: FChannelManagerBase(InSubsystem, ChannelConfig, InEnvMode)
	{
	}

	virtual void Init(TFunction<void(bool bSuccess, const FString& Msg)> Callback) override{}
	virtual void Logout() override{}
	virtual void Pay(const FHeroUPaymentParameters& paymentParametersData,
		const FPayOrderResult& PayOrderResult) override{}
	virtual FString GetQueryVersionUrl() override { return TEXT(""); }
	virtual FString GetDownloadCompletedName() override { return TEXT(""); }
	virtual FString GetDownLoadWebUrl() override { return TEXT(""); }
	virtual FString GetChannelWebDir() override { return TEXT(""); }

	FHttpModule * GetHttpModule() ;

	FHttpManager& GetHttpMgr() ;

	void CreatePostRequest(FString url,const TMap<FString,FString>& Parameter,const FGameNetWorkComplete& netWorkComplete) ;

	void GenInitConfig();

	FString GetEncodeParames(const TMap<FString ,FString>&);

	TMap<FString, FString> GetCommonParameter();
	
	FString ConverMapToString(const TMap<FString, FString>& parameters);

	virtual TMap<FString,FString> GetJsParamter() override{ return Config->GetJsParameter(); }
	void createInitRequest(FString url,const FGameNetWorkComplete& netWorkComplete);
};
