// Fill out your copyright notice in the Description page of Project Settings.

#include "HeroUsdkSupportAndroidDelegate.h"
#include "HeroUsdkSupportKit.h"
#include "JsonObjectConverter.h"


#include "Android/AndroidJNI.h"
#include "Android/AndroidApplication.h"

void HeroUsdkSupportAndroidDelegate::RunCommandOnGameThread(TFunction<void()> InFunction, bool wait, const TStatId InStatId)
{
    if (IsInGameThread())
        InFunction();
    else {
        FGraphEventRef task = FFunctionGraphTask::CreateAndDispatchWhenReady(MoveTemp(InFunction), InStatId, nullptr, ENamedThreads::GameThread);
        if (wait)
            FTaskGraphInterface::Get().WaitUntilTaskCompletes(task);
    }
}
            
jstring usdkCharTojstring(JNIEnv* env, const char* pat) {
    //定义java String类 strClass
    jclass strClass = (env)->FindClass("java/lang/String");
    //获取String(byte[],String)的构造器,用于将本地byte[]数组转换为一个新String
    jmethodID ctorID = (env)->GetMethodID(strClass, "<init>", "([BLjava/lang/String;)V");
    //建立byte数组
    jbyteArray bytes = (env)->NewByteArray(strlen(pat));
    //将char* 转换为byte数组
    (env)->SetByteArrayRegion(bytes, 0, strlen(pat), (jbyte*) pat);
    // 设置String, 保存语言类型,用于byte数组转换至String时的参数
    jstring encoding = (env)->NewStringUTF("UTF-8");
    //将byte数组转换为java String,并输出
    return (jstring) (env)->NewObject(strClass, ctorID, bytes, encoding);
}
char* usdkJstringToChar(JNIEnv* env, jstring jstr) {
    char* rtn = NULL;
    jclass clsstring = env->FindClass("java/lang/String");
    jstring strencode = env->NewStringUTF("UTF-8");
    jmethodID mid = env->GetMethodID(clsstring, "getBytes", "(Ljava/lang/String;)[B");
    jbyteArray barr = (jbyteArray) env->CallObjectMethod(jstr, mid, strencode);
    jsize alen = env->GetArrayLength(barr);
    jbyte* ba = env->GetByteArrayElements(barr, JNI_FALSE);
    if (alen > 0) {
        rtn = (char*) malloc(alen + 1);
        memcpy(rtn, ba, alen);
        rtn[alen] = 0;
    }
    env->ReleaseByteArrayElements(barr, ba, 0);
    return rtn;
}
JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnInitSuccess
#else
Java_com_epicgames_ue4_GameActivity_nativeOnInitSuccess
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString msg = TEXT("初始化成功");
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onInitCallBack(HeroUsdkSuccess,msg);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnInitFaliure
#else
Java_com_epicgames_ue4_GameActivity_nativeOnInitFaliure
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onInitCallBack(HeroUsdkFailed,json);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnLoginSuccess
#else
Java_com_epicgames_ue4_GameActivity_nativeOnLoginSuccess
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    FString msg = TEXT("登陆成功");
    HeroUsdkSupportAndroidDelegate::RunCommandOnGameThread([=]() {
        HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(HeroUsdkSuccess,json,msg);
    }, true);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnLoginFailed
#else
Java_com_epicgames_ue4_GameActivity_nativeOnLoginFailed
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    FString msg = TEXT("登陆失败");
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(HeroUsdkFailed,json,msg);
    
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnLoginCancel
#else
Java_com_epicgames_ue4_GameActivity_nativeOnLoginCancel
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString msg = TEXT("取消登陆");
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(HeroUsdkFailed,"",msg);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnSwitchAccountCancel
#else
Java_com_epicgames_ue4_GameActivity_nativeOnSwitchAccountCancel
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString msg = TEXT("取消切换账号");
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onSwitchAccountCallBack(HeroUsdkCancel,msg);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnSwtichAccountFaliure
#else
Java_com_epicgames_ue4_GameActivity_nativeOnSwtichAccountFaliure
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onSwitchAccountCallBack(HeroUsdkFailed,json);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnSwitchAccountSuccess
#else
Java_com_epicgames_ue4_GameActivity_nativeOnSwitchAccountSuccess
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    FString msg = TEXT("切换账号成功");
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onSwitchAccountCallBack(HeroUsdkSuccess,msg);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnLogoutSuccess
#else
Java_com_epicgames_ue4_GameActivity_nativeOnLogoutSuccess
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString msg = TEXT("退出登陆成功");
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLogoutCallBack(HeroUsdkSuccess,msg);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnLogoutFailure
#else
Java_com_epicgames_ue4_GameActivity_nativeOnLogoutFailure
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLogoutCallBack(HeroUsdkFailed,json);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnPayCancel
#else
Java_com_epicgames_ue4_GameActivity_nativeOnPayCancel
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    FString msg = TEXT("支付取消");
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkCancel,json,msg);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnPayFailed
#else
Java_com_epicgames_ue4_GameActivity_nativeOnPayFailed
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    FString msg = TEXT("支付失败");
    GEngine->AddOnScreenDebugMessage(-1,10.f,FColor::Yellow,FString::Printf(TEXT("nativeOnPayFailed, json:%s"),*json));
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkFailed,json,msg);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnPayFailedWithBundle
#else
Java_com_epicgames_ue4_GameActivity_nativeOnPayFailedWithBundle
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    FString msg = TEXT("支付失败");
    GEngine->AddOnScreenDebugMessage(-1,10.f,FColor::Yellow,FString::Printf(TEXT("nativeOnPayFailedWithBundle, json:%s"),*json));
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkFailed,json,msg);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnPaySuccess
#else
Java_com_epicgames_ue4_GameActivity_nativeOnPaySuccess
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    FString msg = TEXT("支付成功");
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkSuccess,json,msg);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnExitFailure
#else
Java_com_epicgames_ue4_GameActivity_nativeOnExitFailure
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onExitCallBack(HeroUsdkFailed,json);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnExitSuccess
#else
Java_com_epicgames_ue4_GameActivity_nativeOnExitSuccess
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString msg = TEXT("退出成功");
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onExitCallBack(HeroUsdkSuccess,msg);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnLogonInvalid
#else
Java_com_epicgames_ue4_GameActivity_nativeOnLogonInvalid
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    HeroUsdkSupportAndroidDelegate::RunCommandOnGameThread([json]() {
        HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginInvalid(json);
    }, true);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnShareCancelAction
#else
Java_com_epicgames_ue4_GameActivity_nativeOnShareCancelAction
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString jsonString = FJavaHelper::FStringFromParam(jenv, jsonStr);
    TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
    TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(jsonString);
    if (FJsonSerializer::Deserialize(Reader, JsonObject))
    {
        const TSharedPtr<FJsonValue>* shareTypeValue =JsonObject->Values.Find(TEXT("shareType"));
        if (shareTypeValue->IsValid())
        {
            double shareType = (*shareTypeValue)->AsNumber();
            UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit init shareType : %d"), shareType);
            SharePlatform shareplatform = SharePlatform::HeroUSDKSharePlatformAll ;
           if(shareType == 20001) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformQQ ;
            }
            if(shareType == 20002) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformQZone ;
            }
            if(shareType == 20003) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformWeChat ;
            }
            if(shareType == 20004) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformWeChatMements ;
            }
            if(shareType == 20005) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformSina ;
            }
            if(shareType == 20006) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformDouyin_Contact ;
            }
            if(shareType == 20007) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformDouyin_Moment;
            }
            if(shareType == 20008) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformXHS ;
            }
            if(shareType == 20009) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatform_KuaiShou ;
            }
            if(shareType == 20010) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformB_Dynamic ;
            }
            if(shareType == 20011) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformMYS_D ;
            }
            if(shareType == 20012) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformTapTap;
            }
            if(shareType == 20013) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformDouyin_DIARY;
            }
            if(shareType == 20014) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformMYS_T;
            }
            if(shareType == 30002) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformFaceBook ;
            }
            if(shareType == 30003) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformTwitterFriends ;
            }
            if(shareType == 30004) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformTweets ;
            }
            if(shareType == 30005) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformINSTAGRAM ;
            }
            if(shareType == 30006) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformTIKTOK;
            }
            if(shareType == 30007) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformTIKTOK_MOMENT ;
            }
            if(shareType == 30008) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformLOUNGE ;
            }
            if(shareType == 30009) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformLUNOLOFT;
            }
            if(shareType == 30010) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformKAKAO;
            }
            if(shareType == 30011) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformDISCORD ;
            }
            HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onShareCallBack(HeroUsdkCancel,shareplatform,TEXT("分享取消"));
        }
    }
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate nativeOnShareCancelAction !")) ;
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnShareFailedAction
#else
Java_com_epicgames_ue4_GameActivity_nativeOnShareFailedAction
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString jsonString = FJavaHelper::FStringFromParam(jenv, jsonStr);
    TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
    TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(jsonString);
    if (FJsonSerializer::Deserialize(Reader, JsonObject))
    {
        const TSharedPtr<FJsonValue>* shareTypeValue =JsonObject->Values.Find(TEXT("shareType"));
        if (shareTypeValue->IsValid())
        {
            double shareType = (*shareTypeValue)->AsNumber();
            UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit init shareType : %d"), shareType);
            SharePlatform shareplatform = SharePlatform::HeroUSDKSharePlatformAll ;
            if(shareType == 20001) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformQQ ;
            }
            if(shareType == 20002) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformQZone ;
            }
            if(shareType == 20003) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformWeChat ;
            }
            if(shareType == 20004) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformWeChatMements ;
            }
            if(shareType == 20005) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformSina ;
            }
            if(shareType == 20006) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformDouyin_Contact ;
            }
            if(shareType == 20007) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformDouyin_Moment;
            }
            if(shareType == 20008) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformXHS ;
            }
            if(shareType == 20009) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatform_KuaiShou ;
            }
            if(shareType == 20010) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformB_Dynamic ;
            }
            if(shareType == 20011) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformMYS_D ;
            }
            if(shareType == 20012) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformTapTap;
            }
            if(shareType == 20013) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformDouyin_DIARY;
            }
            if(shareType == 20014) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformMYS_T;
            }
            if(shareType == 30002) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformFaceBook ;
            }
            if(shareType == 30003) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformTwitterFriends ;
            }
            if(shareType == 30004) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformTweets ;
            }
            if(shareType == 30005) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformINSTAGRAM ;
            }
            if(shareType == 30006) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformTIKTOK;
            }
            if(shareType == 30007) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformTIKTOK_MOMENT ;
            }
            if(shareType == 30008) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformLOUNGE ;
            }
            if(shareType == 30009) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformLUNOLOFT;
            }
            if(shareType == 30010) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformKAKAO;
            }
            if(shareType == 30011) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformDISCORD ;
            }
            HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onShareCallBack(HeroUsdkFailed,shareplatform,TEXT("分享失败"));
        }
    }
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate nativeOnShareFailedAction !")) ;
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnShareSuccessdAction
#else
Java_com_epicgames_ue4_GameActivity_nativeOnShareSuccessdAction
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate nativeOnShareSuccessdAction !")) ;
    FString jsonString = FJavaHelper::FStringFromParam(jenv, jsonStr);
    TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
    TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(jsonString);
    if (FJsonSerializer::Deserialize(Reader, JsonObject))
    {
        const TSharedPtr<FJsonValue>* shareTypeValue =JsonObject->Values.Find(TEXT("shareType"));
        if (shareTypeValue->IsValid())
        {
            double shareType = (*shareTypeValue)->AsNumber();
            UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit init shareType : %d"), shareType);
            SharePlatform shareplatform = SharePlatform::HeroUSDKSharePlatformAll ;
           if(shareType == 20001) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformQQ ;
            }
            if(shareType == 20002) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformQZone ;
            }
            if(shareType == 20003) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformWeChat ;
            }
            if(shareType == 20004) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformWeChatMements ;
            }
            if(shareType == 20005) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformSina ;
            }
            if(shareType == 20006) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformDouyin_Contact ;
            }
            if(shareType == 20007) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformDouyin_Moment;
            }
            if(shareType == 20008) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformXHS ;
            }
            if(shareType == 20009) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatform_KuaiShou ;
            }
            if(shareType == 20010) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformB_Dynamic ;
            }
            if(shareType == 20011) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformMYS_D ;
            }
            if(shareType == 20012) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformTapTap;
            }
            if(shareType == 20013) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformDouyin_DIARY;
            }
            if(shareType == 20014) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformMYS_T;
            }
            if(shareType == 30002) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformFaceBook ;
            }
            if(shareType == 30003) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformTwitterFriends ;
            }
            if(shareType == 30004) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformTweets ;
            }
            if(shareType == 30005) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformINSTAGRAM ;
            }
            if(shareType == 30006) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformTIKTOK;
            }
            if(shareType == 30007) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformTIKTOK_MOMENT ;
            }
            if(shareType == 30008) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformLOUNGE ;
            }
            if(shareType == 30009) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformLUNOLOFT;
            }
            if(shareType == 30010) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformKAKAO;
            }
            if(shareType == 30011) {
                shareplatform =  SharePlatform::HeroUSDKSharePlatformDISCORD ;
            }
            HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onShareCallBack(HeroUsdkSuccess,shareplatform,TEXT("分享成功"));
        }
    }
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnHeroUsdkClickProtocol
#else
Java_com_epicgames_ue4_GameActivity_nativeOnHeroUsdkClickProtocol
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate nativeOnClickProtocol start !")) ;
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onProtocolAgree();
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate nativeOnClickProtocol end !")) ;
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnGetOAIDResultAction
#else
Java_com_epicgames_ue4_GameActivity_nativeOnGetOAIDResultAction
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onGetOAIDResultAction(json);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnGetGAIDResultAction
#else
Java_com_epicgames_ue4_GameActivity_nativeOnGetGAIDResultAction
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onGetGAIDResultAction(json);
}

FString HeroUsdkSupportAndroidDelegate::GetDeviceNum()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate GetDeviceNum")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_GetDeviceNum", "()Ljava/lang/String;", false);
        jstring object = (jstring)FJavaWrapper::CallObjectMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
        FString json = FJavaHelper::FStringFromParam(Env, object);
        return json;
    }
    return TEXT("");
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnGetAppSetIDResultAction
#else
Java_com_epicgames_ue4_GameActivity_nativeOnGetAppSetIDResultAction
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onGetAppSetIDResultAction(json);
}


JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnGetGoogleSkuDetailsList
#else
Java_com_epicgames_ue4_GameActivity_nativeOnGetGoogleSkuDetailsList
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onGetGoogleSkuDetailsList(json);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnTrackDataCallBack
#else
Java_com_epicgames_ue4_GameActivity_nativeOnTrackDataCallBack
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onTrackDataCallBack(json);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnGlobalBindStateSuccess
#else
Java_com_epicgames_ue4_GameActivity_nativeOnGlobalBindStateSuccess
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    FString msg = TEXT("获取绑定状态成功");
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onGetGlobalBindState(HeroUsdkSuccess,json,msg);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnGlobalBindStateFailed
#else
Java_com_epicgames_ue4_GameActivity_nativeOnGlobalBindStateFailed
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    FString msg = TEXT("获取绑定状态失败");
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onGetGlobalBindState(HeroUsdkFailed,json,msg);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnScreenShotCallBack
#else
Java_com_epicgames_ue4_GameActivity_nativeOnScreenShotCallBack
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    JNIEnv* Env = AndroidJavaEnv::GetJavaEnv();
    const char* UTFString = Env->GetStringUTFChars(jsonStr, nullptr);
    FString Result(UTF8_TO_TCHAR(UTFString));
    Env->ReleaseStringUTFChars(jsonStr, UTFString);
    Env->DeleteLocalRef(jsonStr);
    if (HeroUsdkSupportKit::GetInstance().NotifyObject)
    {
        HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onScreenShotCallBack(Result);
    }
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnOpenBrowerResultSuccess
#else
Java_com_epicgames_ue4_GameActivity_nativeOnOpenBrowerResultSuccess
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onOpenBrowerResult(HeroUsdkSuccess,json);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnOpenBrowerResultFailed
#else
Java_com_epicgames_ue4_GameActivity_nativeOnOpenBrowerResultFailed
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onOpenBrowerResult(HeroUsdkFailed,json);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_accountDeleteCallBackSuccess
#else
Java_com_epicgames_ue4_GameActivity_accountDeleteCallBackSuccess
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    HeroUsdkSupportAndroidDelegate::GetInstance()->logout();
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onAccountCancellation(HeroUsdkSuccess,json);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_accountDeleteCallBackCancel
#else
Java_com_epicgames_ue4_GameActivity_accountDeleteCallBackCancel
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    FString json = FJavaHelper::FStringFromParam(jenv, jsonStr);
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onAccountUnCancellation(HeroUsdkSuccess,json);
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnGetAppsflyerUrlSuccess
#else
Java_com_epicgames_ue4_GameActivity_nativeOnGetAppsflyerUrlSuccess
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate nativeOnGetAppsflyerUrlSuccess !")) ;
    FString jsonString = FJavaHelper::FStringFromParam(jenv, jsonStr);
    TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
    TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(jsonString);
    if (FJsonSerializer::Deserialize(Reader, JsonObject))
    {
        const TSharedPtr<FJsonValue>* shareTypeValue =JsonObject->Values.Find(TEXT("url"));
        if (shareTypeValue->IsValid())
        {
            FString urlString = (*shareTypeValue)->AsString();
            UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit getAppsflyerUrl : %s"), *urlString);
            HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onGetAppsflyerUrlCallBack(HeroUsdkSuccess,urlString,TEXT("获取成功"));  
        }
    }
}

JNI_METHOD void 
#if ENGINE_MAJOR_VERSION >= 5
Java_com_epicgames_unreal_GameActivity_nativeOnGetAppsflyerUrlFailed
#else
Java_com_epicgames_ue4_GameActivity_nativeOnGetAppsflyerUrlFailed
#endif
    (JNIEnv* jenv, jobject thiz, jstring jsonStr)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate nativeOnGetAppsflyerUrlFailed !")) ;
    FString jsonString = FJavaHelper::FStringFromParam(jenv, jsonStr);
    TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
    TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(jsonString);
    if (FJsonSerializer::Deserialize(Reader, JsonObject))
    {
        const TSharedPtr<FJsonValue>* shareTypeValue =JsonObject->Values.Find(TEXT("msg"));
        if (shareTypeValue->IsValid())
        {
            FString msgString = (*shareTypeValue)->AsString();
            UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit getAppsflyerUrl error: %s"), *msgString);
            HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onGetAppsflyerUrlCallBack(HeroUsdkFailed,"",msgString);  
        }
    }
}


HeroUsdkSupportAndroidDelegate* HeroUsdkSupportAndroidDelegate::singleton_= nullptr;;

/**
 * Static methods should be defined outside the class.
 */
HeroUsdkSupportAndroidDelegate *HeroUsdkSupportAndroidDelegate::GetInstance()
{
    /**
     * This is a safer way to create an instance. instance = new Singleton is
     * dangeruous in case two instance threads wants to access at the same time
     */
    if(singleton_ == nullptr){
        singleton_ = new HeroUsdkSupportAndroidDelegate();
    }
    return singleton_;
}

/*
 * 融合SDK初始化
 */
void HeroUsdkSupportAndroidDelegate::initWithHeroUSDK(const char *jsonString)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate android initConfig !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_Init", "(Ljava/lang/String;)V", false);
        jstring jtext = usdkCharTojstring(Env,jsonString);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jtext);
    }
}

/*
 * 融合SDK登录
 */
void HeroUsdkSupportAndroidDelegate::login()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate login !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_login", "()V", false);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
}

/*
 * 进入游戏
 */
void HeroUsdkSupportAndroidDelegate::enterGame(const char *jsonString)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate enterGame !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_EnterGame", "(Ljava/lang/String;)V", false);
        jstring jtext = usdkCharTojstring(Env,jsonString);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jtext);
    }
}

/*
 * 角色注册
 */
void HeroUsdkSupportAndroidDelegate::createNewRole(const char *jsonString)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate createNewRole !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_CreateNewRole", "(Ljava/lang/String;)V", false);
        jstring jtext = usdkCharTojstring(Env,jsonString);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jtext);
    }
}

/*
 * 角色升级
 */
void HeroUsdkSupportAndroidDelegate::roleLevelUp (const char *jsonString)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate roleLevelUp !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_RoleLevelUp", "(Ljava/lang/String;)V", false);
        jstring jtext = usdkCharTojstring(Env,jsonString);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jtext);
    }
}

/*
 * 注销、退出登录
 */
void HeroUsdkSupportAndroidDelegate::logout()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate logout !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_logout", "()V", false);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
}

/*
 * 支付
 */
void HeroUsdkSupportAndroidDelegate::pay(const char *payJsonString,const char *roleJsonString)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate pay !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_Pay", "(Ljava/lang/String;Ljava/lang/String;)V", false);
        jstring jsession = usdkCharTojstring(Env,payJsonString);
        jstring jdata = usdkCharTojstring(Env,roleJsonString);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jsession,jdata);
    }
}

/*
 * 扫描(登录在PC端登录,SDK需要登录状态）
 */
void HeroUsdkSupportAndroidDelegate::showScanViewWithExt(const char *exit)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate showScanViewWithExt !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_ShowScanViewWithExt", "(Ljava/lang/String;)V", false);
        jstring jtext = usdkCharTojstring(Env,exit);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jtext);
    }
}

/*
 * 收到踢下线结果回调SDK
 */
void HeroUsdkSupportAndroidDelegate::cpKickOffCallBackWithResult(const char *result)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate cpKickOffCallBackWithResult !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_CpKickOffCallBackWithResult", "(Ljava/lang/String;)V", false);
        jstring jtext = usdkCharTojstring(Env,result);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jtext);
    }
}

/*
 * 获取协议内容
 */
FString HeroUsdkSupportAndroidDelegate::getProtocolResult()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getProtocolResult !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_GetProtocolResult", "()Ljava/lang/String;", false);
        jstring object = (jstring)FJavaWrapper::CallObjectMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
        FString json = FJavaHelper::FStringFromParam(Env, object);
        return json ;
    }
    return "" ;
}

/*
 * 点击同意通知
 */
void HeroUsdkSupportAndroidDelegate::setAgreeProtocol()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate setAgreeProtocol !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_SetAgreeProtocol", "()V", false);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
}

/*
 *  ============================== Android ===========================
 */
/*
 * 渠道ID
 */
int HeroUsdkSupportAndroidDelegate::getChannelId()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getChannelId !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_GetChannelId", "()I", false);
        return FJavaWrapper::CallIntMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
    return 0 ;
}

int HeroUsdkSupportAndroidDelegate::getMirrorChannelId()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getChannelId !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_GetMirrorChannelId", "()I", false);
        return FJavaWrapper::CallIntMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
    return 0 ;
}

/*
 * 渠道名称
 */
FString HeroUsdkSupportAndroidDelegate::getChannelName()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getChannelName !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_GetChannelName", "()Ljava/lang/String;", false);
        jstring object = (jstring)FJavaWrapper::CallObjectMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
        FString json = FJavaHelper::FStringFromParam(Env, object);
        return json ;
    }
    return "" ;
}

/*
 * 获取渠道SDK的版本名
 */
FString HeroUsdkSupportAndroidDelegate::getChannelSdkVersionName()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getChannelSdkVersionName !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_GetChannelSdkVersionName", "()Ljava/lang/String;", false);
        jstring object = (jstring)FJavaWrapper::CallObjectMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
        FString json = FJavaHelper::FStringFromParam(Env, object);
        return json ;
    }
    return "" ;
}

/*
 * 判断当前渠道在调用退出接口时是否会弹出退出框
 */
bool HeroUsdkSupportAndroidDelegate::isChannelHasExitDialog()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate isChannelHasExitDialog !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_isChannelHasExitDialog", "(Z)V", false);
        return FJavaWrapper::CallBooleanMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
    return false ;
}

/*
 * 获取英雄官网渠道的ProjectId，常用于游戏需要CPS分包时
 */
FString HeroUsdkSupportAndroidDelegate::getProjectId()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getProjectId !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_GetProjectId", "()Ljava/lang/String;", false);
        jstring object = (jstring)FJavaWrapper::CallObjectMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
        FString json = FJavaHelper::FStringFromParam(Env, object);
        return json ;
    }
    return "" ;
}

/*
 * 获取用户在HeroUSDK后台配置的自定义参数值。
 */
FString HeroUsdkSupportAndroidDelegate::getCustomParams(const char *key)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getCustomParams !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_GetCustomParams", "(Ljava/lang/String;)Ljava/lang/String;", false);
        jstring jroleId = usdkCharTojstring(Env,key);
        jstring object = (jstring)FJavaWrapper::CallObjectMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jroleId);
        FString json = FJavaHelper::FStringFromParam(Env, object);
        return json ;
    }
    return "" ;
}

/*
 * 调用渠道的扩展方法(如显示/隐藏悬浮框，防沉迷查询，进入用户中心等)。
 */
bool HeroUsdkSupportAndroidDelegate::callExtendApi(int extendType)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate callExtendApi !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_CallExtendApi", "(I)Z", false);
        return FJavaWrapper::CallBooleanMethod(Env, FJavaWrapper::GameActivityThis, MethonId,extendType);
    }
    return false ;
}

/*
 * 获取当前设备的OAID值
 */
void HeroUsdkSupportAndroidDelegate::getOAID()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getOAID !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_GetOAID", "()V", false);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
}

/*
 * 获取国内硬核渠道信息
 */
FString HeroUsdkSupportAndroidDelegate::getChannelMsg()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getChannelMsg !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_GetChannelMsg", "()Ljava/lang/String;", false);
        jstring object = (jstring)FJavaWrapper::CallObjectMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
        FString json = FJavaHelper::FStringFromParam(Env, object);
        return json;
    }
    return TEXT("");
}


/*
 * 获取当前设备的GAID值
 */
void HeroUsdkSupportAndroidDelegate::getGAID()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getGAID !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_GetGAID", "()V", false);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
}


/*
 * 获取当前设备的AppSetID值
 */
void HeroUsdkSupportAndroidDelegate::getAppSetID()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getAppSetID !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_GetAppSetID", "()V", false);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
}


/*
 * android【退出】
 */
void HeroUsdkSupportAndroidDelegate::exit()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate exit !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_Exit", "()V", false);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
}

/*
 * 打开用户中心
 */
void HeroUsdkSupportAndroidDelegate::showAccountCenter()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate showAccountCenter !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_Open_Account_Center", "()V", false);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
}

/*
 * 注销账号 
 */
void HeroUsdkSupportAndroidDelegate::accountCancellation()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate accountCancellation !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_AccountCancellation", "()V", false);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
}

/*
 * 撤回注销账号
 */
void HeroUsdkSupportAndroidDelegate::accountUnCancellation()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate accountUnCancellation !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_AccountUnCancellation", "()V", false);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
}

/*
 * 上报问题 
 */
void HeroUsdkSupportAndroidDelegate::uploadIssue()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate uploadIssue !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_UploadIssue", "()V", false);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
}
/*
 * 打开内置浏览器
 * </summary>
 * <param name="openID">中台配置URL地址的ID</param>
 */
void HeroUsdkSupportAndroidDelegate::openBrowser(const char* openID)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate openBrowser !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_Open_Brower_ByID", "(Ljava/lang/String;)V", false);
        jstring jtext = usdkCharTojstring(Env,openID);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jtext);
    }
}
/*
 * 全球无界面切换账号
 */
void HeroUsdkSupportAndroidDelegate::switchAccount()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate switchAccount !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_SwitchAccount", "()V", false);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
}
/*
 * 调用 track 接口，追踪一个带有属性的 event
 */
void HeroUsdkSupportAndroidDelegate::trackWithProperties(const char* eventName,const char* parameters)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate trackWithProperties !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_requestUsdkTrackProperties", "(Ljava/lang/String;Ljava/lang/String;)V", false);
        jstring eventNameStr = usdkCharTojstring(Env,eventName);
        jstring parametersStr = usdkCharTojstring(Env,parameters);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, eventNameStr,parametersStr);
    }
}
/*
 * 获取USDK内部埋点事件
 */
void HeroUsdkSupportAndroidDelegate::trackEventDataCallback()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate trackEventDataCallback !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_requestUsdkTrackEventDataCallBack", "()V", false);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
}
/*
 * 打开Xsolla商城支付
*/
void HeroUsdkSupportAndroidDelegate::startXsollaPayWithXsollaProperties(const char* propertys)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate startXsollaPayWithXsollaProperties !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_requestUsdkStartXsollaPayWithProperties", "(Ljava/lang/String;)V", false);
        jstring jtext = usdkCharTojstring(Env,propertys);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jtext);
    }
}

/*
 * 获取全球渠道账户绑定的状态
 */
void HeroUsdkSupportAndroidDelegate::getGlobalBindState()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getGlobalBindState !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_requestUsdkGetGlobalBindState", "()V", false);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
    }
}

/*
 * 全球绑定接口
 */
void HeroUsdkSupportAndroidDelegate::bindAccountWithType(int32 bindType)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate bindAccountWithType !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_requestUsdkBindAccountWithType", "(Z)I", false);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, bindType);
    }
}

/*
    * 获取订单详情列表
    * <f1>如果接入usdk通过中台出全球渠道包，商品id需要传入中台配置的usdk商品id</f1>
    */
void HeroUsdkSupportAndroidDelegate::getGoogleSkuDetailsList(const char *gameGoodsList)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getGoogleSkuDetailsList !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_GetGoogleSkuDetailsList", "(Ljava/lang/String;)V", false);
        jstring jtext = usdkCharTojstring(Env,gameGoodsList);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jtext);
    }
}
/*
     * 分享
     */
void HeroUsdkSupportAndroidDelegate::share(const char* ShareInfo)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate share !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_requestShare", "(Ljava/lang/String;)V", false);
        jstring jtext = usdkCharTojstring(Env,ShareInfo);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jtext);
    }
}

/*
 * 保存图片到相册
 */
void HeroUsdkSupportAndroidDelegate::addPicToAlbum(const char* imagePath,const char* albumName)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate addPicToAlbum !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_requestUsdkAddPicToAlbum", "(Ljava/lang/String;Ljava/lang/String;)V", false);
        jstring eventNameStr = usdkCharTojstring(Env,imagePath);
        jstring parametersStr = usdkCharTojstring(Env,albumName);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, eventNameStr,parametersStr);
    }
}

/*
 * 应用跳转
 */
void HeroUsdkSupportAndroidDelegate::jumpToApp(const char* url)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate jumpToApp !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_requestUsdkJumpToApp", "(Ljava/lang/String;)V", false);
        jstring jtext = usdkCharTojstring(Env,url);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jtext);
    }
}
/*
* 屏蔽市场插件SDK默认埋点[Android]
*/
void HeroUsdkSupportAndroidDelegate::setDisableMarketEvent(const char* bundle)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate setDisableMarketEvent !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_requestUsdkSetDisableMarketEvent", "(Ljava/lang/String;)V", false);
        jstring jtext = usdkCharTojstring(Env,bundle);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jtext);
    }
}

/*
 * 获取邀请链接
 */
void HeroUsdkSupportAndroidDelegate::getAppsflyerOneLinkUrl(const char* bundle)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getAppsflyerOneLinkUrl !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_requestUsdkGetAppsflyerOneLinkUrl", "(Ljava/lang/String;)V", false);
        jstring jtext = usdkCharTojstring(Env,bundle);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jtext);
    }
}

/*
 * 获取链接跳转参数
 */
FString HeroUsdkSupportAndroidDelegate::getAppsflyerOneLinkData()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getAppsflyerOneLinkData !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_GetUSDKAppsflyerOneLinkData", "()Ljava/lang/String;", false);
        jstring object = (jstring)FJavaWrapper::CallObjectMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
        FString json = FJavaHelper::FStringFromParam(Env, object);
        return json ;
    }
    return "" ;
}

/*
 * 获取appsflyer 唯一标识
 */
FString HeroUsdkSupportAndroidDelegate::getAppsflyerUID()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getAppsflyerUID !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_GetUSDKAppsflyerUID", "()Ljava/lang/String;", false);
        jstring object = (jstring)FJavaWrapper::CallObjectMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
        FString json = FJavaHelper::FStringFromParam(Env, object);
        return json ;
    }
    return "" ;
}
/*
 * Google积分墙
 */
void HeroUsdkSupportAndroidDelegate::reportAccountInfo(const char* serverID,const char* serverName,const char* roleID,const char* roleName,const char* cpExt)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate reportAccountInfo !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_requestReportAccountInfo", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String)V", false);
        jstring serverIDjs = usdkCharTojstring(Env,serverID);
        jstring serverNamejs = usdkCharTojstring(Env,serverName);
        jstring roleIDjs = usdkCharTojstring(Env,roleID);
        jstring roleNamejs = usdkCharTojstring(Env,roleName);
        jstring cpExtjs = usdkCharTojstring(Env,cpExt);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, serverIDjs,serverNamejs,roleIDjs,roleNamejs,cpExtjs);
    }
}
/*
     * 市场插件日志上报
     */
void HeroUsdkSupportAndroidDelegate::logEvent(const char* eventName,const char* propertys)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate logEvent !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_requestUsdkLogEvent", "(Ljava/lang/String;Ljava/lang/String;)V", false);
        jstring jtext = usdkCharTojstring(Env,eventName);
        jstring jtext1 = usdkCharTojstring(Env,propertys);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jtext,jtext1);
    }
}

/*
 * 市场插件支付日志上报
 */
void HeroUsdkSupportAndroidDelegate::logPurchaseWithOrderId(const char* orderId,double amount,const char* currency,const char* propertys)
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate logPurchaseWithOrderId !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_requestUsdkLogPurchaseWithOrderId", "(Ljava/lang/String;DLjava/lang/String;Ljava/lang/String;)V", false);
        jstring jtext = usdkCharTojstring(Env,orderId);
        jstring jtext1 = usdkCharTojstring(Env,currency);
        jstring jtext2 = usdkCharTojstring(Env,propertys);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, jtext,amount,jtext1,jtext2);
    }
}

jobject HeroUsdkSupportAndroidDelegate::GetUsdkInstance()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate GetUsdkInstance !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "getUsdkInstance", "()Lcom/herosdk/HeroSdk;", false);
        jobject instance = FJavaWrapper::CallObjectMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
        return instance;
    }
    return NULL;
}

void HeroUsdkSupportAndroidDelegate::SetSdkLanguage(int Language)
{
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "AndroidThunk_Java_UsdkSupport_setUsdkLanguage", "(I)V", false);
        FJavaWrapper::CallVoidMethod(Env, FJavaWrapper::GameActivityThis, MethonId, Language);
    }
}

/*
 * 获取当前登录的用户信息对象。
 */
jobject HeroUsdkSupportAndroidDelegate::getUserInfo()
{
    UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportAndroidDelegate getUserInfo !")) ;
    if (JNIEnv* Env = FAndroidApplication::GetJavaEnv())
    {
        static jmethodID MethonId = FJavaWrapper::FindMethod(Env, FJavaWrapper::GameActivityClassID, "usdkGetUserInfo", "()Lcom/herosdk/bean/UserInfo;", false);
        jobject instance = FJavaWrapper::CallObjectMethod(Env, FJavaWrapper::GameActivityThis, MethonId);
        return instance;
    }
    return NULL;
}

FString HeroUsdkSupportAndroidDelegate::getUserId()
{
    JNIEnv* env = FAndroidApplication::GetJavaEnv();
    FString ResultStr = "Undefined";
    jobject jUserInfo = getUserInfo();
    jclass userInfoClass = env->GetObjectClass(jUserInfo);
    jmethodID getUidMethod = env->GetMethodID(userInfoClass, "getUid", "()Ljava/lang/String;");
    jstring uid = (jstring)env->CallObjectMethod(jUserInfo, getUidMethod);
    if (uid != NULL)
    {
        const char *uidStr = env->GetStringUTFChars(uid, NULL);
        ResultStr = FString(uidStr);
        env->ReleaseStringUTFChars(uid, uidStr);
        env->DeleteLocalRef(uid);
    }
    return ResultStr;
}

FString HeroUsdkSupportAndroidDelegate::getUserName()
{
    JNIEnv* env = FAndroidApplication::GetJavaEnv();
    FString ResultStr = "Undefined";
    jobject jUserInfo = getUserInfo();
    jclass userInfoClass = env->GetObjectClass(jUserInfo);
    jmethodID getNameMethod = env->GetMethodID(userInfoClass, "getUsername", "()Ljava/lang/String;");
    jstring name = (jstring)env->CallObjectMethod(jUserInfo, getNameMethod);
    if (name != NULL)
    {
        const char *nameStr = env->GetStringUTFChars(name, NULL);
        ResultStr = FString(UTF8_TO_TCHAR(nameStr));
        env->ReleaseStringUTFChars(name, nameStr);
        env->DeleteLocalRef(name);
    }
    return ResultStr;
}

