// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "LogHeroUsdk.h"

#include "Android/AndroidJNI.h"
#include "Android/AndroidApplication.h"
/**
 * 
 */
class HEROUSDKPLUGIN_API HeroUsdkSupportAndroidDelegate
{
protected:
	HeroUsdkSupportAndroidDelegate()
	{
	}

	static HeroUsdkSupportAndroidDelegate* singleton_;

public:
	/**
	 * Singletons should not be cloneable.
	 */
	HeroUsdkSupportAndroidDelegate(HeroUsdkSupportAndroidDelegate& other) = delete;
	/**
	 * Singletons should not be assignable.
	 */
	void operator=(const HeroUsdkSupportAndroidDelegate&) = delete;
	/**
	 * This is the static method that controls the access to the singleton
	 * instance. On the first run, it creates a singleton object and places it
	 * into the static field. On subsequent runs, it returns the client existing
	 * object stored in the static field.
	 */

	static HeroUsdkSupportAndroidDelegate* GetInstance();


public:
	/*
	 * 融合SDK初始化
	 */
	void initWithHeroUSDK(const char* jsonString);

	/*
	 * 融合SDK登录
	 */
	void login();

	/*
	 * 进入游戏
	 */
	void enterGame(const char* jsonString);

	/*
	 * 角色注册
	 */
	void createNewRole(const char* jsonString);

	/*
	 * 角色升级
	 */
	void roleLevelUp(const char* jsonString);

	/*
	 * 注销、退出登录
	 */
	void logout();

	/*
	 * 支付
	 */
	void pay(const char* payJsonString, const char* roleJsonString);

	/*
	 * 扫描(登录在PC端登录,SDK需要登录状态）
	 */
	void showScanViewWithExt(const char* exit);

	/*
	 * 收到踢下线结果回调SDK
	 */
	void cpKickOffCallBackWithResult(const char* result);

	/*
	 * 获取协议内容
	 */
	FString getProtocolResult();

	/*
	 * 点击同意通知
	 */
	void setAgreeProtocol();

	/*
	 *  ============================== Android ===========================
	 */
	/*
	 * 渠道ID
	 */
	int getChannelId();

	int getMirrorChannelId();

	/*
	 * 渠道名称
	 */
	FString getChannelName();

	/*
	 * 获取渠道SDK的版本名
	 */
	FString getChannelSdkVersionName();

	/*
	 * 判断当前渠道在调用退出接口时是否会弹出退出框
	 */
	bool isChannelHasExitDialog();

	/*
	 * 获取英雄官网渠道的ProjectId，常用于游戏需要CPS分包时
	 */
	FString getProjectId();

	/*
	 * 获取用户在HeroUSDK后台配置的自定义参数值。
	 */
	FString getCustomParams(const char* key);

	/*
	 * 调用渠道的扩展方法(如显示/隐藏悬浮框，防沉迷查询，进入用户中心等)。
	 */
	bool callExtendApi(int extendType);

	/*
	 * 获取当前设备的OAID值
	 */
	void getOAID();
	
	FString getChannelMsg();

	/*
	 * 获取当前设备的GAID值
	 */
	void getGAID();
	
	/*
	 * 获取当前设备的AppSetID值
	 */
	void getAppSetID();

	/*
	 * 获取设备号
	 */
	FString GetDeviceNum();

	/*
	 * android【退出】
	 */
	void exit();

	/*
	 * 打开用户中心
	 */
	void showAccountCenter() ;
	
	/*
	 * 注销账号 
	 */
	void accountCancellation();

	/*
	 * 撤回注销账号
	 */
	void accountUnCancellation();

	/*
	 * 上报问题 
	 */
	void uploadIssue();

	/*
	 * 打开内置浏览器
	 * </summary>
	 * <param name="openID">中台配置URL地址的ID</param>
	 */
	void openBrowser(const char* openID) ;

	/*
	 * 全球无界面切换账号
	 */
	void switchAccount() ;

	/*
	 * 调用 track 接口，追踪一个带有属性的 event
	*/
	void trackWithProperties(const char* eventName,const char* parameters) ;

	/*
	 * 获取USDK内部埋点事件
	 */
	void trackEventDataCallback();
	
	/*
	 * 打开Xsolla商城支付
	 */
	void startXsollaPayWithXsollaProperties(const char* propertys);

	/*
	 * 获取全球渠道账户绑定的状态
	 */
	void getGlobalBindState();

	/*
	 * 全球绑定接口
	 */
	void bindAccountWithType(int32 bindType);
	
	/*
	* 获取订单详情列表
	* <f1>如果接入usdk通过中台出全球渠道包，商品id需要传入中台配置的usdk商品id</f1>
	*/
	void getGoogleSkuDetailsList(const char* gameGoodsList);

	/*
	 * 分享
	 */
	void share(const char* ShareInfo);

	void SetSdkLanguage(int Language);
	/*
	 * 保存图片到相册
	 */
	void addPicToAlbum(const char* imagePath,const char* albumName) ;

	/*
	 * 应用跳转
	 */
	void jumpToApp(const char* url) ;

	/*
	* 屏蔽市场插件SDK默认埋点[Android]
	*/
	void setDisableMarketEvent(const char* bundle);

	/*
	 * 获取邀请链接
	 */
	void getAppsflyerOneLinkUrl(const char* bundle) ;

	/*
	 * 获取链接跳转参数
	 */
	FString getAppsflyerOneLinkData();

	/*
	 * 获取appsflyer 唯一标识
	 */
	FString getAppsflyerUID();

	/*
	 * Google积分墙
	 */
	void reportAccountInfo(const char* serverID,const char* serverName,const char* roleID,const char* roleName,const char* cpExt) ;
	
	/*
	 * 市场插件日志上报
	 */
	void logEvent(const char* eventName,const char* propertys) ;

	/*
	 * 市场插件支付日志上报
	 */
	void logPurchaseWithOrderId(const char* orderId,double amount,const char* currency,const char* propertys) ;

	// 获取当前登录的用户信息对象
	jobject getUserInfo();
	jobject GetUsdkInstance();
	FString getUserId();
	FString getUserName();

	static void RunCommandOnGameThread(TFunction<void()> InFunction, bool wait = false, const TStatId InStatId = TStatId());
};