#include "PlatformManagerAndroid.h"
#include <string>
#include "HeroUsdkSupportAndroidDelegate.h"
#include "HeroUsdkSupportKit.h"
#include "JsonObjectConverter.h"
#include "Setting/UsdkSettings.h"

void FPlatformManagerAndroid::SetNotify()
{
	UE_LOG(LogHeroUsdk, Log, TEXT("FPlatformManagerAndroid SetNotify"));
	marketBundleMap.Add(MARKET_ALL, "MARKET_ALL");
	marketBundleMap.Add(MARKET_REGISTER_SUCCESS, "MARKET_REGISTER_SUCCESS");
	marketBundleMap.Add(MARKET_LOGIN_SUCCESS, "MARKET_LOGIN_SUCCESS");
	marketBundleMap.Add(MARKET_LOGIN_FAILED, "MARKET_LOGIN_FAILED");
	marketBundleMap.Add(MARKET_LOGIN_CANCEL, "MARKET_LOGIN_CANCEL");
	marketBundleMap.Add(MARKET_LOGOUT_SUCCESS, "MARKET_LOGOUT_SUCCESS");
	marketBundleMap.Add(MARKET_PAY_SUCCESS, "MARKET_PAY_SUCCESS");
	marketBundleMap.Add(MARKET_PAY_FAILED, "MARKET_PAY_FAILED");
	marketBundleMap.Add(MARKET_PAY_CANCEL, "MARKET_PAY_CANCEL");
	marketBundleMap.Add(MARKET_BEFORE_PAY, "MARKET_BEFORE_PAY");
	HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onProtocolAgree();
}

void FPlatformManagerAndroid::Init()
{
	auto setting = GetMutableDefault<UUsdkSettings>();
	std::string t = TCHAR_TO_UTF8(*setting->UsdkConfig);

	HeroUsdkSupportAndroidDelegate::GetInstance()->initWithHeroUSDK(t.c_str());
}

void FPlatformManagerAndroid::Login()
{
	HeroUsdkSupportAndroidDelegate::GetInstance()->login();
}

void FPlatformManagerAndroid::EnterGame(FHeroHDCGameRoleInfo roleInfo)
{
	FString profile;
	FJsonObjectConverter::UStructToJsonObjectString(roleInfo, profile, 0, 0);
	if (profile.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit enterGame 转换失败 "));
		return;
	}
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit enterGame JSON : %s"), *profile);
	std::string t = TCHAR_TO_UTF8(*profile);
	HeroUsdkSupportAndroidDelegate::GetInstance()->enterGame(t.c_str());
}

void FPlatformManagerAndroid::CreateNewRole(FHeroHDCGameRoleInfo roleInfo)
{
	FString profile;
	FJsonObjectConverter::UStructToJsonObjectString(roleInfo, profile, 0, 0);
	if (profile.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit createNewRole 转换失败 "));
		return;
	}
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit createNewRole JSON : %s"), *profile);
	std::string t = TCHAR_TO_UTF8(*profile);



	//android角色注册
	HeroUsdkSupportAndroidDelegate::GetInstance()->createNewRole(t.c_str());
	
}

void FPlatformManagerAndroid::RoleLevelUp(FHeroHDCGameRoleInfo roleInfo)
{
	FString profile;
	FJsonObjectConverter::UStructToJsonObjectString(roleInfo, profile, 0, 0);
	if (profile.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit roleLevelUp 转换失败 "));
		return;
	}
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit roleLevelUp JSON : %s"), *profile);
	std::string t = TCHAR_TO_UTF8(*profile);


	//android角色升级
	HeroUsdkSupportAndroidDelegate::GetInstance()->roleLevelUp(t.c_str());
}

void FPlatformManagerAndroid::logout()
{
	HeroUsdkSupportAndroidDelegate::GetInstance()->logout();
}

void FPlatformManagerAndroid::Pay(FHeroUPaymentParameters paymentParametersData, FHeroHDCGameRoleInfo roleInfo)
{
	FString profile;
	FString paramFile;
	FJsonObjectConverter::UStructToJsonObjectString(roleInfo, profile, 0, 0);
	FJsonObjectConverter::UStructToJsonObjectString(paymentParametersData, paramFile, 0, 0);
	if (profile.IsEmpty() || paramFile.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit pay 转换失败 "));
		return;
	}
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit pay params JSON : %s"), *paramFile);
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit pay roleInfo JSON : %s"), *profile);
	std::string t = TCHAR_TO_UTF8(*paramFile);
	std::string t1 = TCHAR_TO_UTF8(*profile);



	//android内购
	HeroUsdkSupportAndroidDelegate::GetInstance()->pay(t.c_str(),t1.c_str());
}

void FPlatformManagerAndroid::showScanViewWithExt(FString exit)
{
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit showScanViewWithExt : %s"), *exit);
	std::string t = TCHAR_TO_UTF8(*exit);
	HeroUsdkSupportAndroidDelegate::GetInstance()->showScanViewWithExt(t.c_str());

}

void FPlatformManagerAndroid::cpKickOffCallBackWithResult(FString result)
{
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit cpKickOffCallBackWithResult : %s"), *result);
	std::string t = TCHAR_TO_UTF8(*result);
	HeroUsdkSupportAndroidDelegate::GetInstance()->cpKickOffCallBackWithResult(t.c_str());
}

FString FPlatformManagerAndroid::getProtocolResult()
{
	return  HeroUsdkSupportAndroidDelegate::GetInstance()->getProtocolResult();
}

void FPlatformManagerAndroid::setAgreeProtocol()
{
	HeroUsdkSupportAndroidDelegate::GetInstance()->setAgreeProtocol();
}

void FPlatformManagerAndroid::showAccountCenter()
{
	HeroUsdkSupportAndroidDelegate::GetInstance()->showAccountCenter();
}

void FPlatformManagerAndroid::accountCancellation()
{
	HeroUsdkSupportAndroidDelegate::GetInstance()->accountCancellation();
}

void FPlatformManagerAndroid::accountUnCancellation()
{
	HeroUsdkSupportAndroidDelegate::GetInstance()->accountUnCancellation();
}

void FPlatformManagerAndroid::uploadIssue()
{
	HeroUsdkSupportAndroidDelegate::GetInstance()->uploadIssue();
}

void FPlatformManagerAndroid::SetUsdkLanguage(EHeroUsdkLanguageFlag Language)
{
	HeroUsdkSupportAndroidDelegate::GetInstance()->SetSdkLanguage((int)Language);
}

void FPlatformManagerAndroid::openBrowser(FString openID)
{
	std::string t = TCHAR_TO_UTF8(*openID);
	HeroUsdkSupportAndroidDelegate::GetInstance()->openBrowser(t.c_str());
}

void FPlatformManagerAndroid::OpenSurvey(const FString& WebId)
{
	//None
}

void FPlatformManagerAndroid::OpenService()
{
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit Android Open Service")) ;
	bool bIsSuccess = HeroUsdkSupportAndroidDelegate::GetInstance()->callExtendApi(15);
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit Android Open Service Result: %s"), bIsSuccess ? TEXT("true") : TEXT("false"));
}

void FPlatformManagerAndroid::switchAccount()
{
	HeroUsdkSupportAndroidDelegate::GetInstance()->switchAccount();
}

void FPlatformManagerAndroid::trackWithProperties(FString eventName, TMap<FString, FString> propertys)
{
	FString parametersJSON = checkPostParamster(propertys);
	if (parametersJSON.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroMarketSupportKit trackWithProperties 内容参数不能为空 !!! "));
		return;
	}
	else
	{
		std::string eventNamet = TCHAR_TO_UTF8(*eventName);
		std::string paramst = TCHAR_TO_UTF8(*parametersJSON);
		//android事件上报
		HeroUsdkSupportAndroidDelegate::GetInstance()->trackWithProperties(eventNamet.c_str(),paramst.c_str());


	}
}

void FPlatformManagerAndroid::trackEventDataCallback()
{
	HeroUsdkSupportAndroidDelegate::GetInstance()->trackEventDataCallback();
}

void FPlatformManagerAndroid::startXsollaPayWithXsollaProperties(TMap<FString, FString> propertys)
{
	FString parametersJSON = checkPostParamster(propertys);
	if (parametersJSON.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit startXsollaPayWithXsollaProperties 内容参数不能为空 !!! "));
		return;
	}
	else
	{
		std::string paramst = TCHAR_TO_UTF8(*parametersJSON);


		//android事件上报
		HeroUsdkSupportAndroidDelegate::GetInstance()->startXsollaPayWithXsollaProperties(paramst.c_str());
	}
}

void FPlatformManagerAndroid::getGlobalBindState()
{
	HeroUsdkSupportAndroidDelegate::GetInstance()->getGlobalBindState();
}


void FPlatformManagerAndroid::share(FShareInfo shareInfo)
{
	/*if ((shareInfo.sharePlatform == SharePlatform::HeroUSDKSharePlatformTwitter && shareInfo.shareType == ShareType::HeroUSDKShareTypeLink) ||
				(shareInfo.sharePlatform == SharePlatform::HeroUSDKSharePlatformTwitter && shareInfo.shareType == ShareType::HeroUSDKShareTypeText))
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("===========> Twitter 仅支持图片分享 <==========="));
		return ;
	}
	if (shareInfo.sharePlatform == SharePlatform::HeroUSDKSharePlatformFaceBook && shareInfo.shareType == ShareType::HeroUSDKShareTypeText)
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("===========> Facebook 不支持文本分享 <==========="));
		return;
	}*/
	FString profile;
	FJsonObjectConverter::UStructToJsonObjectString(shareInfo, profile, 0, 0);
	if (profile.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit share 转换失败 "));
		return;
	}
	UE_LOG(LogHeroUsdk, Log, TEXT(" share : %s"), *profile);
	std::string c = TCHAR_TO_UTF8(*profile);

	//android点击同意通知
	HeroUsdkSupportAndroidDelegate::GetInstance()->share(c.c_str());

}

void FPlatformManagerAndroid::addPicToAlbum(FString imagePath, FString albumName)
{
	std::string imagePathstd = TCHAR_TO_UTF8(*imagePath);
	std::string albumNamestd = TCHAR_TO_UTF8(*albumName);



	//android保存图片到手机相册
	HeroUsdkSupportAndroidDelegate::GetInstance()->addPicToAlbum(imagePathstd.c_str(),albumNamestd.c_str());
}

void FPlatformManagerAndroid::jumpToApp(FString url)
{
	std::string urlstd = TCHAR_TO_UTF8(*url);
	HeroUsdkSupportAndroidDelegate::GetInstance()->jumpToApp(urlstd.c_str());
}


int FPlatformManagerAndroid::getChannelId()
{
	return HeroUsdkSupportAndroidDelegate::GetInstance()->getChannelId();
}

FString FPlatformManagerAndroid::getChannelName()
{
	return HeroUsdkSupportAndroidDelegate::GetInstance()->getChannelName();
}

FString FPlatformManagerAndroid::getChannelSdkVersionName()
{
	return HeroUsdkSupportAndroidDelegate::GetInstance()->getChannelSdkVersionName();
}

FString FPlatformManagerAndroid::getProjectId()
{
	return HeroUsdkSupportAndroidDelegate::GetInstance()->getProjectId();
}

void FPlatformManagerAndroid::logEvent(FString eventName, TMap<FString, FString> propertys)
{
	FString parametersJSON = checkPostParamster(propertys);
	std::string t = TCHAR_TO_UTF8(*eventName);
	if (parametersJSON.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit logEvent 内容参数不能为空 !!! "));
		return;
	} else {
		std::string paramst = TCHAR_TO_UTF8(*parametersJSON);


		//android市场插件事件上报
		HeroUsdkSupportAndroidDelegate::GetInstance()->logEvent(t.c_str(),paramst.c_str());

	}
}

void FPlatformManagerAndroid::logPurchaseWithOrderId(FString orderId, double amount, FString currency,
	TMap<FString, FString> propertys)
{
	FString parametersJSON = checkPostParamster(propertys);
	std::string tOrder = TCHAR_TO_UTF8(*orderId);
	std::string tcurrency = TCHAR_TO_UTF8(*currency);
	std::string paramst = TCHAR_TO_UTF8(*parametersJSON);
		

	//android市场插件支付事件上报
	HeroUsdkSupportAndroidDelegate::GetInstance()->logPurchaseWithOrderId(tOrder.c_str(),amount,tcurrency.c_str(),paramst.c_str());


}

FString FPlatformManagerAndroid::getUserName()
{
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit getUserName !"));
	return HeroUsdkSupportAndroidDelegate::GetInstance()->getUserName();
}

FString FPlatformManagerAndroid::getUserId()
{
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit getUserId !"));
	
	// 通过AndroidSDK获取UserId
	return HeroUsdkSupportAndroidDelegate::GetInstance()->getUserId();
}

FString FPlatformManagerAndroid::getSdkId()
{
	return "";
}

FString FPlatformManagerAndroid::getDeviceNum()
{
	return HeroUsdkSupportAndroidDelegate::GetInstance()->GetDeviceNum();
}

void FPlatformManagerAndroid::getIDFA()
{

}

void FPlatformManagerAndroid::getIDFV()
{
}

void FPlatformManagerAndroid::logoutAndSowLoginView()
{
	//None
}

void FPlatformManagerAndroid::postSplashScreenEndSuccess()
{
	//None
}

bool FPlatformManagerAndroid::isChannelHasExitDialog()
{
	//android判断当前渠道在调用退出接口时是否会弹出退出框
	return HeroUsdkSupportAndroidDelegate::GetInstance()->isChannelHasExitDialog();
}

FString FPlatformManagerAndroid::getCustomParams(FString key)
{
	//android获取英雄官网渠道的ProjectId，常用于游戏需要CPS分包时
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit getCustomParams : %s"),*key) ;
	std::string t = TCHAR_TO_UTF8(*key);
	return HeroUsdkSupportAndroidDelegate::GetInstance()->getCustomParams(t.c_str());
}

bool FPlatformManagerAndroid::callExtendApi(int extendType)
{
	//android调用渠道的扩展方法
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit callExtendApi")) ;
	return HeroUsdkSupportAndroidDelegate::GetInstance()->callExtendApi(extendType);
}

void FPlatformManagerAndroid::getOAID()
{
	//android获取当前设备的OAID值
	HeroUsdkSupportAndroidDelegate::GetInstance()->getOAID();
}

FString FPlatformManagerAndroid::getChannelMsg()
{
	//android获取硬核渠道信息
	return HeroUsdkSupportAndroidDelegate::GetInstance()->getChannelMsg();
}

void FPlatformManagerAndroid::GetGAID()
{
	//android获取当前设备的OAID值
	HeroUsdkSupportAndroidDelegate::GetInstance()->getGAID();
}

void FPlatformManagerAndroid::GetAppSetID()
{
	//android获取当前设备的OAID值
	HeroUsdkSupportAndroidDelegate::GetInstance()->getAppSetID();
}

void FPlatformManagerAndroid::exit()
{
	//android【退出】
	HeroUsdkSupportAndroidDelegate::GetInstance()->exit();
}

void FPlatformManagerAndroid::getGoogleSkuDetailsList(TArray<FString> gameGoodsList)
{
	FString joinedStr;
	for (auto& str : gameGoodsList)
	{
		joinedStr += str;
		joinedStr += TEXT(",");
	}
	if (joinedStr.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("getGoogleSkuDetailsList 未获取到传入订单ID列表 "));
		return;
	}
	std::string t = TCHAR_TO_UTF8(*joinedStr);
	

	//android【获取Google订单】
	HeroUsdkSupportAndroidDelegate::GetInstance()->getGoogleSkuDetailsList(t.c_str());

}

void FPlatformManagerAndroid::setDisableMarketEvent(TMap<MARKET_EVENT, bool> bundle)
{
	TMap<FString, FString> tempBundle ;
	for(TMap<MARKET_EVENT,bool>::TIterator it = bundle.CreateIterator();it;++it)
	{
		bool valueT = it->Value ;
		tempBundle.Add(marketBundleMap[it->Key],(valueT ? "true":"false"));
	}
	FString parametersJSON = checkPostParamster(tempBundle);
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit setDisableMarketEvent : %s"),*parametersJSON) ;
	if (parametersJSON.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit setDisableMarketEvent 内容参数不能为空 !!! "));
		return;
	} else {
		std::string paramst = TCHAR_TO_UTF8(*parametersJSON);
		
	//android市场插件事件上报开关
		HeroUsdkSupportAndroidDelegate::GetInstance()->setDisableMarketEvent(paramst.c_str());

	}
}

void FPlatformManagerAndroid::getAppsflyerOneLinkUrl(const TMap<FString, FString>& bundle)
{
	FString parametersJSON = checkPostParamster(bundle);
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit getAppsflyerOneLinkUrl : %s"),*parametersJSON) ;
	if (parametersJSON.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit getAppsflyerOneLinkUrl 内容参数不能为空 !!! "));
		return;
	} else
	{
		std::string paramst = TCHAR_TO_UTF8(*parametersJSON);

		//android市场插件事件上报开关
		HeroUsdkSupportAndroidDelegate::GetInstance()->getAppsflyerOneLinkUrl(paramst.c_str());
	}
}

FString FPlatformManagerAndroid::getAppsflyerOneLinkData()
{
	//android获取链接跳转参数
	return HeroUsdkSupportAndroidDelegate::GetInstance()->getAppsflyerOneLinkData();
}

FString FPlatformManagerAndroid::getAppsflyerUID()
{
	return HeroUsdkSupportAndroidDelegate::GetInstance()->getAppsflyerUID();
}

void FPlatformManagerAndroid::reportAccountInfo(FString serverId, FString serverName, FString roleId, FString roleName,
	FString cpExt)
{
	std::string serverIdStd = TCHAR_TO_UTF8(*serverId);
	std::string serverNameStd = TCHAR_TO_UTF8(*serverName);
	std::string roleIdStd = TCHAR_TO_UTF8(*roleId);
	std::string roleNameStd = TCHAR_TO_UTF8(*roleName);
	std::string cpExtStd = TCHAR_TO_UTF8(*cpExt);
	

	//android Google积分墙
	HeroUsdkSupportAndroidDelegate::GetInstance()->reportAccountInfo(serverIdStd.c_str(),serverNameStd.c_str(),
		roleIdStd.c_str(),roleNameStd.c_str(),cpExtStd.c_str());

}

int FPlatformManagerAndroid::getMirrorChannelId()
{
	return HeroUsdkSupportAndroidDelegate::GetInstance()->getMirrorChannelId();
}
