#pragma once
#include "Platform/Base/PlatformManagerBase.h"

class FPlatformManagerAndroid:public FPlatformManagerBase
{
public:
	FPlatformManagerAndroid(UHeroUsdkSubsystem* InSubsystem):FPlatformManagerBase(InSubsystem)
	{
	}
	virtual void SetNotify() override;
	virtual void Init() override;
	virtual void Login() override;
	virtual void EnterGame(FHeroHDCGameRoleInfo roleInfo) override;
	virtual void CreateNewRole(FHeroHDCGameRoleInfo roleInfo) override;
	virtual void RoleLevelUp(FHeroHDCGameRoleInfo roleInfo) override;
	virtual void logout() override;
	virtual void Pay(FHeroUPaymentParameters paymentParametersData, FHeroHDCGameRoleInfo roleInfo) override;
	virtual void showScanViewWithExt(FString exit) override;
	virtual void cpKickOffCallBackWithResult(FString result) override;
	virtual FString getProtocolResult() override;
	virtual void setAgreeProtocol() override;
	virtual void showAccountCenter() override;
	virtual void accountCancellation() override;
	virtual void accountUnCancellation() override;
	virtual void uploadIssue() override;
	virtual void SetUsdkLanguage(EHeroUsdkLanguageFlag Language) override;
	virtual void openBrowser(FString openID) override;
	virtual void OpenSurvey(const FString& WebId) override;
	virtual void OpenService() override;
	virtual void switchAccount() override;
	virtual void trackWithProperties(FString event, TMap<FString, FString> propertys) override;
	virtual void trackEventDataCallback() override;
	virtual void startXsollaPayWithXsollaProperties(TMap<FString, FString> propertys) override;
	virtual void getGlobalBindState() override;
	virtual void share(FShareInfo shareInfo) override;
	virtual void addPicToAlbum(FString imagePath, FString albumName) override;
	virtual void jumpToApp(FString url) override;
	virtual int getChannelId() override;
	virtual FString getChannelName() override;
	virtual FString getChannelSdkVersionName() override;
	virtual FString getProjectId() override;
	virtual void logEvent(FString eventName, TMap<FString, FString> propertys) override;
	virtual void logPurchaseWithOrderId(FString orderId, double amount, FString currency,
		TMap<FString, FString> propertys) override;
	virtual FString getUserName() override;
	virtual FString getUserId() override;
	virtual FString getSdkId() override;
	virtual FString getDeviceNum() override;
	virtual void getIDFA() override;
	virtual void getIDFV() override;
	virtual void logoutAndSowLoginView() override;
	virtual void postSplashScreenEndSuccess() override;
	virtual bool isChannelHasExitDialog() override;
	virtual FString getCustomParams(FString key) override;
	virtual bool callExtendApi(int extendType) override;
	virtual void getOAID() override;
	virtual FString getChannelMsg() override;
	virtual void GetGAID() override;
	virtual void GetAppSetID() override;
	virtual void exit() override;
	virtual void getGoogleSkuDetailsList(TArray<FString> gameGoodsList) override;
	virtual void setDisableMarketEvent(TMap<MARKET_EVENT, bool> bundle) override;
	virtual void getAppsflyerOneLinkUrl(const TMap<FString, FString>& bundle) override;
	virtual FString getAppsflyerOneLinkData() override;
	virtual FString getAppsflyerUID() override;
	virtual void reportAccountInfo(FString serverId, FString serverName, FString roleId, FString roleName,
		FString cpExt) override;
	virtual int getMirrorChannelId() override;

private:
	/*
	 * 市场插件bundleKey对照表
	 */
	TMap<MARKET_EVENT,FString> marketBundleMap ;
};
