﻿#pragma once
#include <map>
#include <string>

#include "Setting/UsdkSettingsTypes.h"


class FChannelConfigBase
{
public:
	
	virtual ~FChannelConfigBase() = default;
	virtual TMap<FString, FString> GetFormData() = 0;
	virtual TMap<FString, FString> GetJsParameter() = 0;
	virtual FString GetCancelParam() = 0;

	FString GetGameName() const
	{
		return gameName;
	}

	FString GetProjectId() const
	{
		return projectId;
	}

	int32 GetChannelId() const;

	int32 GetMirrorChannelId() const;

	virtual FString GetProductId() const = 0;
	virtual FString GetProductKey() const = 0;
	virtual FString GetGameId() const = 0;
	
	virtual  void Parse(const TSharedPtr<FJsonObject>& JsonObj) = 0;

	virtual EHeroUSDKChannel GetChannel() const
	{
		return EHeroUSDKChannel::China; 
	}

	FString gameName;						  //游戏名称
	int32 cid =-1;						      //中台渠道ID
	FString package; 							  //包名
	FString projectId;                  	  //项目ID
	FString custom_themeStyle="0";
	int32 pcid = 0;
};
