#include "Platform/Base/PlatformManagerBase.h"
#include "LogHeroUsdk.h"

FString FPlatformManagerBase::checkPostParamster(TMap<FString, FString> parameters)
{
	FString parametersJSON;
	if (parameters.Num())
	{
		TSharedPtr<FJsonObject> FieldsObject = MakeShareable(new FJsonObject());
		for (auto& Elem : parameters)
		{
			if (!Elem.Key.IsEmpty()) { FieldsObject->SetStringField(Elem.Key, Elem.Value); }
		}
		TSharedRef<TJsonWriter<TCHAR>> jsonWriter = TJsonWriterFactory<TCHAR>::Create(&parametersJSON);
		FJsonSerializer::Serialize(FieldsObject.ToSharedRef(), jsonWriter);
		UE_LOG(LogHeroUsdk, Log, TEXT(" CheckPostParamster : %s"), *parametersJSON);
	}
	return parametersJSON;
}
