﻿#pragma once
#include "Manager/HeroUsdkSupportPcDelegate.h"
#include "Platform/Base/ChannelConfigBase.h"

class FIosGlobalConfig : public FChannelConfigBase
{
public:
	virtual TMap<FString, FString> GetFormData() override
	{
		TMap<FString, FString> commonMap;

		commonMap.Emplace("cid", FString::FromInt(cid));
		commonMap.Emplace("channel", "heroglobalpc");

		return commonMap;
	}

	virtual TMap<FString, FString> GetJsParameter() override { return {}; }

	virtual void Parse(const TSharedPtr<FJsonObject>& JsonObj) override
	{
		game_id = JsonObj->GetStringField("base_gameId");
		product_code = JsonObj->GetStringField("base_productCode");
		projectId = JsonObj->GetStringField("base_projectId");
		package = JsonObj->GetStringField("package");
		product_key = JsonObj->GetStringField("base_productKey");
		cid = JsonObj->GetIntegerField("cid");
		gameName = JsonObj->GetStringField("gameName");
		custom_themeStyle = JsonObj->GetStringField("custom_themeStyle");
	}

	FString GetCancelParam() override
	{
		FString result = "lang=";
		result += HeroUsdkSupportPcDelegate::GetInstance()->GetCurrentLanguage();
		result += "&platform=ios";
		result += "&gameName=";
		result += gameName;
		return result;
	}

	EHeroUSDKChannel GetChannel() const override
	{
		return EHeroUSDKChannel::Global;
	}

	virtual FString GetProductId() const override
	{
		return product_code;
	}

	virtual FString GetGameId() const override
	{
		return game_id;
	}

	virtual FString GetProductKey() const override
	{
		return product_key;
	}


	FString game_id; //游戏ID
	FString product_code; //产品ID


	FString product_key; //AppKey
	FString facebookID; //facebookAppID 
	FString googleID; //Google Client ID
	FString globalServerUrl; //全球服务器地址
};
