﻿#pragma once
#include "HeroUsdkSupportKit.h"
#include "Manager/HeroUsdkSupportPcDelegate.h"

class FIosMainlandConfig : public FChannelConfigBase
{
public:
	virtual TMap<FString, FString> GetFormData() override
	{
		TMap<FString, FString> commonMap;
		commonMap.Emplace("cid", FString::FromInt(cid));
		commonMap.Emplace("channel", "ios");

		return commonMap;
	}

	virtual TMap<FString, FString> GetJsParameter() override
	{
		//获取设置唯一标识符
		FString devicesID = FPlatformMisc::GetLoginId();
		FString sdkVersion = HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version();
		TMap<FString, FString> paramsDic;
		paramsDic.Emplace("__e__", "1");

		paramsDic.Emplace("productId", productId);
		paramsDic.Emplace("projectId", projectId);
		paramsDic.Emplace("serverId", serverId);
		paramsDic.Emplace("appKey", appKey);
		paramsDic.Emplace("appSecret", appSecret);
		paramsDic.Emplace("pkg", package);
		paramsDic.Emplace("engine", "ue4");
		paramsDic.Emplace("custom_themeStyle", custom_themeStyle);

		paramsDic.Emplace("deviceNum", devicesID);
		paramsDic.Emplace("platform", "PC");
		paramsDic.Emplace("sdkVersion", sdkVersion);

		paramsDic.Emplace("gameName", gameName);
		paramsDic.Emplace("pcode", HeroUsdkSupportKit::GetInstance().GetProductId());
		return paramsDic;
	}

	virtual void Parse(const TSharedPtr<FJsonObject>& JsonObj) override
	{
		productId = JsonObj->GetStringField("base_productId");
		projectId = JsonObj->GetStringField("base_projectId");
		serverId = JsonObj->GetStringField("base_serverId");
		appKey = JsonObj->GetStringField("base_appKey");
		appSecret = JsonObj->GetStringField("base_secretKey");
		gameName = JsonObj->GetStringField("gameName");
		cid = JsonObj->GetIntegerField("cid");
		package = JsonObj->GetStringField("package");
		custom_themeStyle = JsonObj->GetStringField("custom_themeStyle");
	}

	FString GetCancelParam() override
	{
		FString result = "projectId=";
		result += projectId;
		result += "&productId=";
		result += productId;
		result += "&lang=";
		result += HeroUsdkSupportPcDelegate::GetInstance()->GetCurrentLanguage();
		result += "&platform=ios";
		result += "&gameName=";
		result += gameName;
		return result;
	}

	EHeroUSDKChannel GetChannel() const override
	{
		return EHeroUSDKChannel::China;
	}

	virtual FString GetProductId() const override
	{
		return productId;
	}

	virtual FString GetGameId() const override
	{
		return productId;
	}

	virtual FString GetProductKey() const override
	{
		return appKey;
	}

	FString productId;
	FString serverId;
	FString appKey;
	FString appSecret;
};
