// Fill out your copyright notice in the Description page of Project Settings.
#include "HeroUsdkSupportiOSDelegate.h"

#include "Core.h"
#include "Engine.h"
#include "HeroUsdkSupportKit.h"
#include "EngineMinimal.h"
#include "Async/Async.h"


#import <HeroUSDK/HeroUSDK.h>
#import "objc/runtime.h"
#import <HeroUSDK/HeroUPlatform.h>
typedef void(^TextChangeBlock)(NSString *text);

#include "IOS/IOSAppDelegate.h"
#include "IOS/IOSView.h"
#include "IOS/IOSApplication.h"

#import <objc/runtime.h>
#import <objc/message.h>

@interface IOSAppDelegate(HeroUsdkSupport)

@end

@implementation IOSAppDelegate(HeroUsdkSupport)


- (BOOL)application:(UIApplication *)application openURL:(NSURL *)url sourceApplication:(NSString *)sourceApplication annotation:(id)annotation
{
    [[HeroUPlatform sharedInstance] heroU_application:application handleOpenURL:url] ;

    SEL applicationSel = NSSelectorFromString(@"application:openURL:sourceApplication:annotation:");
    Class clazz = NSClassFromString(@"MarketEventPlatform");
    SEL sel = NSSelectorFromString(@"defaultPlatform");
    if (clazz && [clazz respondsToSelector:sel]) {
        id globalClass = ((id(*)(id, SEL))objc_msgSend)(clazz, sel);
        if (globalClass && [globalClass respondsToSelector:applicationSel]) {
            id (*custom_msgSend)(id, SEL, UIApplication *, NSURL *,NSString *,id) = (id (*)(id, SEL, UIApplication *, NSURL *,NSString *,id))objc_msgSend;
            custom_msgSend(globalClass,applicationSel,application,url,sourceApplication,annotation);
        }
    }

    return YES;
}


- (BOOL)application:(UIApplication *)application handleOpenURL:(NSURL *)url
{
    [[HeroUPlatform sharedInstance] heroU_application:application handleOpenURL:url] ;

    SEL applicationSel = NSSelectorFromString(@"application:handleOpenURL:");
    Class clazz = NSClassFromString(@"MarketEventPlatform");
    SEL sel = NSSelectorFromString(@"defaultPlatform");
    if (clazz && [clazz respondsToSelector:sel]) {
        id globalClass = ((id(*)(id, SEL))objc_msgSend)(clazz, sel);
        if (globalClass && [globalClass respondsToSelector:applicationSel]) {
            id (*custom_msgSend)(id, SEL, UIApplication *, NSURL *) = (id (*)(id, SEL, UIApplication *, NSURL *))objc_msgSend;
            custom_msgSend(globalClass,applicationSel,application,url);
        }
    }

    return YES;
}

- (BOOL)application:(UIApplication *)app openURL:(NSURL *)url options:(NSDictionary<UIApplicationOpenURLOptionsKey,id> *)options
{
    [[HeroUPlatform sharedInstance] heroU_application:app handleOpenURL:url] ;

    SEL applicationSel = NSSelectorFromString(@"application:openURL:options:");
    Class clazz = NSClassFromString(@"MarketEventPlatform");
    SEL sel = NSSelectorFromString(@"defaultPlatform");
    if (clazz && [clazz respondsToSelector:sel]) {
        id globalClass = ((id(*)(id, SEL))objc_msgSend)(clazz, sel);
        if (globalClass && [globalClass respondsToSelector:applicationSel]) {
            id (*custom_msgSend)(id, SEL, UIApplication *, NSURL *,id) = (id (*)(id, SEL, UIApplication *, NSURL *,id))objc_msgSend;
            custom_msgSend(globalClass,applicationSel,app,url,options);
        }
    }

    return YES;
}

// 3.4.6后新增
- (BOOL)application:(UIApplication *)application continueUserActivity:(NSUserActivity *)userActivity restorationHandler:(void(^)(NSArray<id<UIUserActivityRestoring>> * __nullable restorableObjects))restorationHandler
{
    [[HeroUPlatform sharedInstance] handleOpenUniversalLink:userActivity];

    SEL applicationSel = NSSelectorFromString(@"application:continueUserActivity:restorationHandler:");
    Class clazz = NSClassFromString(@"MarketEventPlatform");
    SEL sel = NSSelectorFromString(@"defaultPlatform");
    if (clazz && [clazz respondsToSelector:sel]) {
        id globalClass = ((id(*)(id, SEL))objc_msgSend)(clazz, sel);
        if (globalClass && [globalClass respondsToSelector:applicationSel]) {
            id (*custom_msgSend)(id, SEL, UIApplication *, NSUserActivity *, id) = (id (*)(id, SEL, UIApplication *, NSUserActivity *, id))objc_msgSend;
            custom_msgSend(globalClass,applicationSel,nil,userActivity, nil);
        }
    }

    return YES ;
}

@end


@implementation HeroUsdkSupportiOSDelegate

/**
 *  严格单例，唯一获得实例的方法.
 *
 *  @return 实例对象.
 */
+ (instancetype)getInstance
{
    static HeroUsdkSupportiOSDelegate *instance = nil ;

    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        instance = [[HeroUsdkSupportiOSDelegate alloc] init] ;
    });
    return instance ;
}

-(instancetype)init
{
    if ([super init]) {
        //添加通知
        [self addNotifications];
    }
    return self ;
}
/*
 * 添加通知
 */
-(void)addNotifications
{
    //添加通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(initNotification:) name:GAME_PUBLIC_NOTIFICATION_NAME_INIT object:nil];
    //监听用户登陆成功的通知 单机版游戏不用监听
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(loginNotification:) name:GAME_PUBLIC_NOTIFICATION_NAME_LOGIN object:nil];
    //监听点击切换账号
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(changeAccountNotification:) name:GAME_PUBLIC_NOTIFICATION_NAME_CHANGE_ACCOUNT  object:nil];
    //内购通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(iapNotification:) name:GAME_PUBLIC_NOTIFICATION_NAME_IAPPURCHASE_FINISH object:nil];
    //踢下线
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(loginValidNotification:) name:GAME_PUBLIC_NOTIFICATION_NAME_LOGONINVALID object:nil];
    //同意协议通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(clickProtocol) name:GAME_PUBLIC_NOTIFICATION_NAME_PROTOCOL object:nil];
    //注销成功通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(onAccountCancellationNotification) name:GAME_PUBLIC_NOTIFICATION_NAME_EXIT_LOGIN object:nil];
    //截屏通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(onScreenShotNotify) name:GAME_PUBLIC_NOTIFICATION_NAME_SCREEN_SHOT object:nil];
}
#pragma mark =================== SDK通知 ====================
//初始化通知
-(void)initNotification:(NSNotification *)notification
{
    if (HeroUsdkSupportKit::GetInstance().NotifyObject)
    {
        HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onInitCallBack(HeroUsdkSuccess, TEXT("初始化成功"));
    }
}
//注销成功
-(void)onAccountCancellationNotification
{
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onAccountCancellation(HeroUsdkSuccess,TEXT("注销账号成功"));
}
//截屏通知
-(void)onScreenShotNotify
{
    if (HeroUsdkSupportKit::GetInstance().NotifyObject)
    {
        HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onScreenShotCallBack(TEXT("ScreenShot"));
    }
}
//登录通知
-(void)loginNotification:(NSNotification *)notification
{
    if (notification.object == nil) {
        NSLog(@"Notification object is nil.");
        return;
    }
    
    BOOL isLoginSuccess = [[notification.object valueForKey:GAME_PUBLIC_TAG_LOGIN_IS_SUCCESS] boolValue];
    if (isLoginSuccess) {
        [self handleLoginSuccess:notification];
    } else {
        [self handleLoginFailure:notification];
    }
}

- (void)handleLoginSuccess:(NSNotification *)notification {
    NSString * accessCode = [notification.object valueForKey:GAME_PUBLIC_TAG_ACCESS_CODE];
    NSString * accessToken = [notification.object valueForKey:GAME_PUBLIC_TAG_HEROU_ACCESS_TOKEN];
    NSString * sdkuserId = [[HeroUPlatform sharedInstance] getUserId] ;
    NSString * username = [[HeroUPlatform sharedInstance] getUserName] ;
    
    NSMutableDictionary *params = [NSMutableDictionary dictionary];
    if (accessCode != nil ) {
        params[@"accessCode"] = accessCode ;
    }
    if (accessToken != nil ) {
        params[@"accessToken"] = accessToken ;
    }
    if (sdkuserId != nil ) {
        params[@"sdkUserId"] = sdkuserId ;
    }
    if (username != nil ) {
        params[@"userName"] = username ;
    }
    
    NSString *paramsString = [self getParamsValueWithDictionary:params] ;
    NSString *msgString = @"登录成功" ;
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(HeroUsdkSuccess,FString(paramsString),FString(msgString));
    NSLog(@"用户登陆成功!");
}

- (void)handleLoginFailure:(NSNotification *)notification {
    NSMutableDictionary *params = [NSMutableDictionary dictionary];
    params[@"msg"] = @"用户登陆失败!" ;
    
    NSString *paramsString = [self getParamsValueWithDictionary:params] ;
    NSString *msgString = @"登录失败" ;
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(HeroUsdkFailed,FString(paramsString),FString(msgString));
    NSLog(@"用户登陆失败!");
}

//切换账号通知
-(void)changeAccountNotification:(NSNotification *)notification
{
    NSMutableDictionary *params = [[NSMutableDictionary alloc] init] ;
    params[@"msg"] = @"切换账号成功!" ;
    //发送消息到UE4
    NSString *paramsString = [self getParamsValueWithDictionary:params] ;
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onSwitchAccountCallBack(HeroUsdkSuccess,FString(paramsString));

}
//内购通知
-(void)iapNotification:(NSNotification *)notification
{
    BOOL isIapPurchaseSucess = [notification.object[GAME_PUBLIC_TAG_IAPPURCHASE_IS_SUCCESS] boolValue];
    if (isIapPurchaseSucess) {
        GamePaymentOrder * paymentOrder = notification.object[GAME_PUBLIC_TAG_PAYMENT_ORDER];
        NSMutableDictionary  *params = [[NSMutableDictionary alloc] init];
        if (paymentOrder.orderId != nil) {
            params[@"sdkOrderId"] = paymentOrder.orderId ;
        }
        if (paymentOrder.orderAmount != nil) {
            params[@"orderAmount"] = paymentOrder.orderAmount ;
        }
        if (paymentOrder.currency != nil) {
            params[@"currency"] = paymentOrder.currency ;
        }
        //发送消息到UE4
        NSString *paramsString = [self getParamsValueWithDictionary:params] ;
        NSString *msgString = @"支付成功" ;
        HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkSuccess,FString(paramsString),FString(msgString)) ;
        
        NSLog(@"iap购买成功");
        NSLog(@"支付成功订单:iap订单id: %@",paymentOrder.orderId);
        
    } else {
        GamePaymentOrder * paymentOrder = notification.object[GAME_PUBLIC_TAG_PAYMENT_ORDER];
        NSMutableDictionary *params = [[NSMutableDictionary alloc] init];
        params[@"code"] = [NSString stringWithFormat:@"%ld",(long)paymentOrder.errorCode] ;
        if (paymentOrder.errorDescription != nil) {
            params[@"msg"] = paymentOrder.errorDescription ;
        }
        //发送消息到UE4
        NSString *paramsString = [self getParamsValueWithDictionary:params] ;
        NSString *msgString = @"支付失败" ;
        HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkFailed,FString(paramsString),FString(msgString)) ;
        
        NSLog(@"iap购买失败");
    }
}
//登录失效、踢下线通知
-(void)loginValidNotification:(NSNotification *)notification
{
    NSString *reason = notification.userInfo[GAME_PUBLIC_CP_KICKOFF_REASON] ;
    if (reason != nil) {
        //被踢下线
        NSMutableDictionary *params = [[NSMutableDictionary alloc] init];
        params[@"msg"] = reason ;
        //发送消息到UE4
        NSString *paramsString = [self getParamsValueWithDictionary:params] ;
        FFunctionGraphTask::CreateAndDispatchWhenReady([paramsString]()
        {
            HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginInvalid(FString(paramsString)) ;
        }, TStatId(), nullptr, ENamedThreads::GameThread);
        
    } else {
        //登录失效
        NSMutableDictionary *params = [[NSMutableDictionary alloc] init];
        params[@"msg"] = @"登录失效,请尝试重新登录" ;
        //发送消息到UE4
        NSString *paramsString = [self getParamsValueWithDictionary:params] ;
        FFunctionGraphTask::CreateAndDispatchWhenReady([paramsString]()
        {
            HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLogoutCallBack(HeroUsdkFailed, FString(paramsString));
        }, TStatId(), nullptr, ENamedThreads::GameThread);
    }
}
//这里处理同意协议后的逻辑
-(void)clickProtocol
{
    NSMutableDictionary *params = [[NSMutableDictionary alloc] init];
    //发送消息到UE4
    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onProtocolAgree() ;
}

-(NSString *)getParamsValueWithDictionary:(NSMutableDictionary *)params
{
    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:params options:NSJSONWritingPrettyPrinted error:nil];
    NSString *jsonString = [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
    return jsonString ;
}
//
// /*
//  * 融合SDK初始化
//  */
// -(void) initWithHeroUSDK:(NSString *)productKey
//                productID:(NSString *)productID
//            channelParams:(NSDictionary *)channelParams
// {
//     dispatch_async(dispatch_get_main_queue(), ^{
//         NSData *jsonData = [jsonString dataUsingEncoding:NSUTF8StringEncoding] ;
//         NSDictionary *dictionary = [NSJSONSerialization JSONObjectWithData:jsonData options:NSJSONReadingMutableContainers error:nil];
//         NSLog(@"-----------> HeroUsdkSupportiOSDelegate initWithHeroUSDK %@ ",dictionary) ;
//         if (dictionary.allValues.count > 0) {
//             NSDictionary *channelParams = dictionary[@"channelParams"] ;
//             if ([channelParams isKindOfClass:[NSString class]]) {
//                 NSString *channelJSON = (NSString *)channelParams ;
//                 NSData *channelData = [channelJSON dataUsingEncoding:NSUTF8StringEncoding] ;
//                 channelParams = [NSJSONSerialization JSONObjectWithData:channelData options:NSJSONReadingMutableContainers error:nil] ;
//             }
//             int type = [channelParams[@"type"] intValue] ;
//             NSString * usdkProductKey = dictionary[@"usdkProductKey"] ;
//             NSAssert(usdkProductKey, @"The usdkProductKey should not be nil.");
//             NSString * usdkProductId = dictionary[@"usdkProductId"] ;
//             NSAssert(usdkProductId, @"The usdkProductId should not be nil.");
//             if (type == 1) {
//                 //国内SDK
//                 [self gameChannelInitWithKey:usdkProductKey productID:usdkProductId channelParams:channelParams] ;
//             } else if (type == 2) {
//                 [self globalChannelInitWithKey:usdkProductKey productID:usdkProductId channelParams:channelParams] ;
//                 //全球
//             } else {
//                 [self gameChannelInitWithKey:usdkProductKey productID:usdkProductId channelParams:channelParams] ;
//             }
//         } else {
//             NSLog(@">>>>>>>>>>>>>>>> 解析json失败 : %@ <<<<<<<<<<< ",jsonString) ;
//         }
//     });
// }
/*
 * 全球SDK初始化
 */
-(void)globalChannelInitWithKey:(NSString *)productKey
                      productID:(NSString *)productID
                  channelParams:(NSDictionary *)channelParams
{
    
    HeroUProject *_uProject = [[HeroUProject alloc] init];
    //原usdkProductId
    _uProject.usdkProductId = productID;
    //原usdkProductKey
    _uProject.usdkProductKey = productKey ;
    
    UIApplication* sharedApp = [UIApplication sharedApplication];
    NSDictionary* launchDict = [IOSAppDelegate GetDelegate].launchOptions;
    
    if (sharedApp != nil) {
        _uProject.application = sharedApp;
    }
    if (launchDict != nil) {
        _uProject.launchOptions = launchDict ;
    }
    
    /*
        _uProject.imgId = @"" ; //配置镜像ID
        _uProject.trackUrl = @"" ; //配置埋点地址
        _uProject.backupUrls = @[]; //灾备地址
        _uProject.supportedInterfaceOrientations = UIInterfaceOrientationMaskLandscape ; //屏幕方向
    */
    
     //横屏方向
    _uProject.supportedInterfaceOrientations = UIInterfaceOrientationMaskLandscape ;
    [_uProject channelInitWithParameters:channelParams];
    [[HeroUPlatform sharedInstance] initWithProject:_uProject];
}
/*
 * 国内SDK初始化
 */
-(void)gameChannelInitWithKey:(NSString *)productKey
                    productID:(NSString *)productID
                channelParams:(NSDictionary *)channelParams
{
    NSString *cprojectID = channelParams[@"projectId"] ;
    NSString *cproductID = channelParams[@"productId"] ;
    NSString *cserverId = channelParams[@"serverId"] ;
    NSString *cappkey = channelParams[@"appKey"] ;
    NSString *csecretKey = channelParams[@"secretKey"] ;
    
    BOOL closeAutoLogin = [channelParams[@"closeAutoLogin"] boolValue] ;
    BOOL openPublicVersion = [channelParams[@"openPublicVersion"] boolValue] ;
    BOOL closeIAPFunction = [channelParams[@"closeIAPFunction"] boolValue] ;
    BOOL isOnlineGame = [channelParams[@"isOnlineGame"] boolValue] ;
    //国内登录设置
    GameChinaProject *project = [GameChinaProject projectWithId:cprojectID
                         productId:cproductID
                          serverId:cserverId
                            appkey:cappkey
                    usdkProductKey:productKey
                     usdkProductId:productID
                  initializerBlock:^(GameProject *aSelf)
    {
        GameChinaProject * aProject = (GameChinaProject *)aSelf;
        // 是否网络游戏,默认为网络游戏
        aProject.isOnlineGame = isOnlineGame ;
        // 设置保存图片的appkey及appSecrect,由用户中心提供,这个如果不填写，在自动登录后将无法保存账号到相册
        // 设置secretKey, SDK将会帮助游戏完成登陆成功之后的验证过程. 在回调中得到AccessToken;
        // 如果不设置, 那么SDK不会进行验证过程, 在回调中得到AccessCode
        aProject.secretKey = csecretKey ;
        //aProject.imageAppKey = @"ttyx";
        //aProject.imageAppSecret = @"1612f59c8a3fbf89ab6ed5e07f20cbcf";
        // 设置公共版, 默认为NO, 公共版游戏请设为YES
        aProject.openPublicVersion = openPublicVersion;
        //关闭自动登录
        aProject.closeAutoLogin = closeAutoLogin ;
        //SDK默认开启IAP内购功能，在初始化时，将“aProject.closeIAPFunction“设置为 YES 可禁用该功能
        aProject.closeIAPFunction = closeIAPFunction ;
        
    }];

    NSDictionary* params = [project hb_JSONObject];
    HeroUProject *_uProject = [[HeroUProject alloc] init];
    //原usdkProductId
    _uProject.usdkProductId = productID;
    //原usdkProductKey
    _uProject.usdkProductKey = productKey ;
    NSMutableDictionary *mutableDictionary = [NSMutableDictionary dictionaryWithDictionary:params];
    [mutableDictionary addEntriesFromDictionary:channelParams];
    [_uProject channelInitWithParameters:mutableDictionary];
    [[HeroUPlatform sharedInstance] initWithProject:_uProject];
    
}
/*
 * 融合SDK登录
 */
-(void) login
{
    dispatch_async(dispatch_get_main_queue(), ^{
        [[HeroUPlatform sharedInstance] enterLoginView] ;
    });
}

/*
 * 进入游戏
 */
-(void) enterGame:(NSString *)jsonString
{
    dispatch_async(dispatch_get_main_queue(), ^{
        NSData *jsonData = [jsonString dataUsingEncoding:NSUTF8StringEncoding] ;
        NSDictionary *dictionary = [NSJSONSerialization JSONObjectWithData:jsonData options:NSJSONReadingMutableContainers error:nil];
        NSLog(@"-----------> HeroUsdkSupportiOSDelegate enterGame %@ ",dictionary) ;
        if (dictionary.allValues.count > 0) {
            NSString * channelUserId = dictionary[@"channelUserId"] ;
            NSAssert(channelUserId, @"The channelUserId should not be nil.");
            NSString * gameUserId = dictionary[@"gameUserId"] ;
            NSAssert(gameUserId, @"The gameUserId should not be nil.");
            NSString * serverId = dictionary[@"serverId"] ;
            NSAssert(serverId, @"The serverId should not be nil.");
            NSString * serverName = dictionary[@"serverName"] ;
            NSAssert(serverName, @"The serverName should not be nil.");
            NSString * roleId = dictionary[@"roleId"] ;
            NSAssert(roleId, @"The roleId should not be nil.");
            NSString * roleName = dictionary[@"roleName"] ;
            NSAssert(roleName, @"The roleName should not be nil.");
            NSString * roleAvatar = dictionary[@"roleAvatar"] ;
            NSAssert(roleAvatar, @"The roleAvatar should not be nil.");
            
            HeroHDCBaseGameRoleInfo *baseRoleInfo = [HeroHDCBaseGameRoleInfo sharedInstance];
            baseRoleInfo.channelUserId = channelUserId ;
            baseRoleInfo.gameUserId = gameUserId ;
            baseRoleInfo.serverId = serverId ;
            baseRoleInfo.serverName = serverName ;
            baseRoleInfo.roleId = roleId ;
            baseRoleInfo.roleName = roleName ;
            baseRoleInfo.roleAvatar = roleAvatar ;
            [[HeroUPlatform sharedInstance] setBaseRoleInfoWithData:baseRoleInfo] ;
            
            HeroHDCGameRoleInfo *roleInfo = [self getGameRoleInfoWithDictionary:dictionary] ;
            //SDK登录
            [[HeroUPlatform sharedInstance] roleLoginWithGameRoleInfo:roleInfo];
        } else {
            NSLog(@">>>>>>>>>>>>>>>>enterGame 解析json失败 : %@ <<<<<<<<<<< ",jsonString) ;
        }
    }) ;
}

/*
 * 获取角色信息
 */
-(HeroHDCGameRoleInfo *)getGameRoleInfoWithDictionary:(NSDictionary *)dictionary
{
    NSString * level = dictionary[@"level"] ;
    NSAssert(level, @"The level should not be nil.");
    NSString * gold1 = dictionary[@"gold1"] ;
    NSAssert(gold1, @"The gold1 should not be nil.");
    NSString * gold2 = dictionary[@"gold2"] ;
    NSAssert(gold2, @"The gold2 should not be nil.");
    NSString * sumPay = dictionary[@"sumPay"] ;
    NSAssert(sumPay, @"The sumPay should not be nil.");
    
    HeroHDCGameRoleInfo *roleInfo = [[HeroHDCGameRoleInfo alloc] init];
    roleInfo.level = level ;
    roleInfo.gold1 = gold1 ;
    roleInfo.gold2 = gold2 ;
    roleInfo.sumPay = sumPay ;
    if (dictionary[@"vipLevel"] != nil) {
        roleInfo.vipLevel = dictionary[@"vipLevel"] ;
    }
    if (dictionary[@"levelExp"] != nil) {
        roleInfo.levelExp = dictionary[@"levelExp"] ;
    }
    if (dictionary[@"vipScore"] != nil) {
        roleInfo.vipScore = dictionary[@"vipScore"] ;
    }
    if (dictionary[@"rankLevel"] != nil) {
        roleInfo.rankLevel = dictionary[@"rankLevel"] ;
    }
    if (dictionary[@"rankExp"] != nil) {
        roleInfo.rankExp = dictionary[@"rankExp"] ;
    }
    if (dictionary[@"rankLeve2"] != nil) {
        roleInfo.rankLeve2 = dictionary[@"rankLeve2"] ;
    }
    if (dictionary[@"rankExp2"] != nil) {
        roleInfo.rankExp2 = dictionary[@"rankExp2"] ;
    }
    if (dictionary[@"cupCount1"] != nil) {
        roleInfo.cupCount1 = dictionary[@"cupCount1"] ;
    }
    if (dictionary[@"cupCount2"] != nil) {
        roleInfo.cupCount2 = dictionary[@"cupCount2"] ;
    }
    if (dictionary[@"totalKill"] != nil) {
        roleInfo.totalKill = dictionary[@"totalKill"] ;
    }
    if (dictionary[@"totalHead"] != nil) {
        roleInfo.totalHead = dictionary[@"totalHead"] ;
    }
    if (dictionary[@"avgKD"] != nil) {
        roleInfo.avgKD = dictionary[@"avgKD"] ;
    }
    if (dictionary[@"maxKD"] != nil) {
        roleInfo.maxKD = dictionary[@"maxKD"] ;
    }
    if (dictionary[@"maxCK"] != nil) {
        roleInfo.maxCK = dictionary[@"maxCK"] ;
    }
    if (dictionary[@"mainWeaponId"] != nil) {
        roleInfo.mainWeaponId = dictionary[@"mainWeaponId"] ;
    }
    if (dictionary[@"viceWeaponId"] != nil) {
        roleInfo.viceWeaponId = dictionary[@"viceWeaponId"] ;
    }
    if (dictionary[@"medalCount"] != nil) {
        roleInfo.medalCount = dictionary[@"medalCount"] ;
    }
    if (dictionary[@"teamId"] != nil) {
        roleInfo.teamId = dictionary[@"teamId"] ;
    }
    if (dictionary[@"teamName"] != nil) {
        roleInfo.teamName = dictionary[@"teamName"] ;
    }
    if (dictionary[@"floatHidden"] != nil) {
        roleInfo.floatHidden = [dictionary[@"floatHidden"] boolValue] ;
    }
    return roleInfo ;
}

/*
 * 角色注册
 */
-(void) createNewRole:(NSString *)jsonString
{
    dispatch_async(dispatch_get_main_queue(), ^{
        NSData *jsonData = [jsonString dataUsingEncoding:NSUTF8StringEncoding] ;
        NSDictionary *dictionary = [NSJSONSerialization JSONObjectWithData:jsonData options:NSJSONReadingMutableContainers error:nil];
        NSLog(@"-----------> HeroUsdkSupportiOSDelegate createNewRole %@ ",dictionary) ;
        if (dictionary.allValues.count > 0) {
            NSString * channelUserId = dictionary[@"channelUserId"] ;
            NSAssert(channelUserId, @"The channelUserId should not be nil.");
            NSString * gameUserId = dictionary[@"gameUserId"] ;
            NSAssert(gameUserId, @"The gameUserId should not be nil.");
            NSString * serverId = dictionary[@"serverId"] ;
            NSAssert(serverId, @"The serverId should not be nil.");
            NSString * serverName = dictionary[@"serverName"] ;
            NSAssert(serverName, @"The serverName should not be nil.");
            NSString * roleId = dictionary[@"roleId"] ;
            NSAssert(roleId, @"The roleId should not be nil.");
            NSString * roleName = dictionary[@"roleName"] ;
            NSAssert(roleName, @"The roleName should not be nil.");
            NSString * roleAvatar = dictionary[@"roleAvatar"] ;
            NSAssert(roleAvatar, @"The roleAvatar should not be nil.");
            
            HeroHDCBaseGameRoleInfo *baseRoleInfo = [HeroHDCBaseGameRoleInfo sharedInstance];
            baseRoleInfo.channelUserId = channelUserId ;
            baseRoleInfo.gameUserId = gameUserId ;
            baseRoleInfo.serverId = serverId ;
            baseRoleInfo.serverName = serverName ;
            baseRoleInfo.roleId = roleId ;
            baseRoleInfo.roleName = roleName ;
            baseRoleInfo.roleAvatar = roleAvatar ;
            [[HeroUPlatform sharedInstance] setBaseRoleInfoWithData:baseRoleInfo] ;
            
            HeroHDCGameRoleInfo *roleInfo = [self getGameRoleInfoWithDictionary:dictionary] ;
            //SDK角色注册
            [[HeroUPlatform sharedInstance] roleRegisterWithGameRoleInfo:roleInfo];
        } else {
            NSLog(@">>>>>>>>>>>>>>>>createNewRole 解析json失败 : %@ <<<<<<<<<<< ",jsonString) ;
        }
    }) ;
}

/*
 * 角色升级
 */
-(void) roleLevelUp:(NSString *)jsonString
{
    dispatch_async(dispatch_get_main_queue(), ^{
        NSData *jsonData = [jsonString dataUsingEncoding:NSUTF8StringEncoding] ;
        NSDictionary *dictionary = [NSJSONSerialization JSONObjectWithData:jsonData options:NSJSONReadingMutableContainers error:nil];
        NSLog(@"-----------> HeroUsdkSupportiOSDelegate roleLevelUp %@ ",dictionary) ;
        if (dictionary.allValues.count > 0) {
            NSString * channelUserId = dictionary[@"channelUserId"] ;
            NSAssert(channelUserId, @"The channelUserId should not be nil.");
            NSString * gameUserId = dictionary[@"gameUserId"] ;
            NSAssert(gameUserId, @"The gameUserId should not be nil.");
            NSString * serverId = dictionary[@"serverId"] ;
            NSAssert(serverId, @"The serverId should not be nil.");
            NSString * serverName = dictionary[@"serverName"] ;
            NSAssert(serverName, @"The serverName should not be nil.");
            NSString * roleId = dictionary[@"roleId"] ;
            NSAssert(roleId, @"The roleId should not be nil.");
            NSString * roleName = dictionary[@"roleName"] ;
            NSAssert(roleName, @"The roleName should not be nil.");
            NSString * roleAvatar = dictionary[@"roleAvatar"] ;
            NSAssert(roleAvatar, @"The roleAvatar should not be nil.");
            
            HeroHDCBaseGameRoleInfo *baseRoleInfo = [HeroHDCBaseGameRoleInfo sharedInstance];
            baseRoleInfo.channelUserId = channelUserId ;
            baseRoleInfo.gameUserId = gameUserId ;
            baseRoleInfo.serverId = serverId ;
            baseRoleInfo.serverName = serverName ;
            baseRoleInfo.roleId = roleId ;
            baseRoleInfo.roleName = roleName ;
            baseRoleInfo.roleAvatar = roleAvatar ;
            [[HeroUPlatform sharedInstance] setBaseRoleInfoWithData:baseRoleInfo] ;
            
            HeroHDCGameRoleInfo *roleInfo = [self getGameRoleInfoWithDictionary:dictionary] ;
            //SDK角色升级
            [[HeroUPlatform sharedInstance] roleLevelUpWithGameRoleInfo:roleInfo];
        } else {
            NSLog(@">>>>>>>>>>>>>>>>roleLevelUp 解析json失败 : %@ <<<<<<<<<<< ",jsonString) ;
        }
    }) ;
}

/*
 * 注销、退出登录
 */
-(void) logout
{
    dispatch_async(dispatch_get_main_queue(), ^{
        [[HeroUPlatform sharedInstance] logout] ;
        NSString *msg = @"退出登录成功";
        //发送UE4消息
        HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLogoutCallBack(HeroUsdkSuccess,FString(msg));
    });
}

/*
 * 支付
 */
-(void) pay:(NSString *)paymentParametersData
   roleInfo:(NSString *)roleInfo
{
    dispatch_async(dispatch_get_main_queue(), ^{
        NSData *jsonData = [paymentParametersData dataUsingEncoding:NSUTF8StringEncoding] ;
        NSDictionary *dictionary = [NSJSONSerialization JSONObjectWithData:jsonData options:NSJSONReadingMutableContainers error:nil];
        NSLog(@"-----------> HeroUsdkSupportiOSDelegate pay %@ ",dictionary) ;
        if (dictionary.allValues.count > 0) {
            NSString * goodsId = dictionary[@"goodsId"] ;
            NSAssert(goodsId, @"The goodsId should not be nil.");
            NSString * extraParams = dictionary[@"extraParams"] ;
            NSAssert(extraParams, @"The extraParams should not be nil.");
            NSString * cpOrder = dictionary[@"cpOrder"] ;
            NSAssert(cpOrder, @"The cpOrder should not be nil.");
            
            GamePaymentParameters *paymentParameters = [[GamePaymentParameters alloc] init] ;
            paymentParameters.gamePropID = goodsId ;
            paymentParameters.gameRole = extraParams ;
            paymentParameters.cpOrder = cpOrder ;
            if (dictionary[@"callbackUrl"] != nil) {
                paymentParameters.callbackUrl = dictionary[@"callbackUrl"] ;
            }
            //SDK内购
            [[HeroUPlatform sharedInstance] iapPurchaseWithData:paymentParameters];
        } else {
            NSLog(@">>>>>>>>>>>>>>>>pay 解析json失败 : %@ <<<<<<<<<<< ",paymentParametersData) ;
        }
    }) ;
}

/*
 * 扫描(登录在PC端登录,SDK需要登录状态）
 */
-(void) showScanViewWithExt:(NSString *)exit
{
    dispatch_async(dispatch_get_main_queue(), ^{
        [[HeroUPlatform sharedInstance] showScanViewWithExt:exit] ;
    });
}

/*
 * 收到踢下线结果回调SDK
 */
-(void) cpKickOffCallBackWithResult:(NSString *)result
{
    dispatch_async(dispatch_get_main_queue(), ^{
        NSMutableDictionary *params = [[NSMutableDictionary alloc] init] ;
        //1-成功 0-失败
        params[GAME_PUBLIC_CP_KICKOFF_RESULT] = @"1" ;
        [[HeroUPlatform sharedInstance] cpKickOffCallBackWithResult:params] ;
    });
}

/*
 * 获取协议内容
 */
-(NSString *) getProtocolResult
{
    NSDictionary *resultDic = [[HeroUPlatform sharedInstance] getProtocolResult];
    if (resultDic.allValues.count > 0) {
        NSData *jsonData = [NSJSONSerialization dataWithJSONObject:resultDic options:NSJSONWritingPrettyPrinted error:nil];
        NSString *jsonString = [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
        return jsonString ;
    } else {
        return @"" ;
    }
}

/*
 * 点击同意通知
 */
-(void) setAgreeProtocol
{
    dispatch_async(dispatch_get_main_queue(), ^{
        [[HeroUPlatform sharedInstance] setAgreeProtocol] ;
    });
}


/*
 *  ============================== iOS ===========================
 */

/*
 * 获取登录用户名
 */
-(NSString *) getUserName
{
    return [[HeroUPlatform sharedInstance] getUserName] ;
}

/*
 * 获取登录用户ID
 */
-(NSString *) getUserId
{
    return [[HeroUPlatform sharedInstance] getUserId] ;
}

/*
 * 获取ID（部分游戏使用@"id"字段作为唯一标示符）
 */
-(NSString *) getSdkId
{
    return [[HeroUPlatform sharedInstance] getSdkId] ;
}

/*
 * 获取设备号(优先取的IDFA、没取到则取的UUID)
 */
-(NSString *) getDeviceNum
{
    return [[HeroUPlatform sharedInstance] getDeviceNum] ;
}

/*
 * 获取IDFA
 */
-(void) getIDFAWithCompletion
{
    [[HeroUPlatform sharedInstance] getIDFAWithCompletion:^(NSString * _Nonnull firstIdfa, NSString * _Nonnull currentIdfa, NSString * _Nonnull error) {
      NSLog(@"firstIdfa = %@, currentIdfa = %@, error = %@", firstIdfa, currentIdfa, error);
      HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onGetIDFAResultAction(FString(firstIdfa), FString(currentIdfa), FString(error));
  }];
}

/*
 * 获取IDFV
 */
-(void) getIDFVWithCompletion
{
    [[HeroUPlatform sharedInstance] getIDFVWithCompletion:^(NSString * _Nonnull firstIdfv, NSString * _Nonnull currentIdfv, NSString * _Nonnull error) {
      NSLog(@"firstIdfv = %@, currentIdfv = %@, error = %@", firstIdfv, currentIdfv, error);
      HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onGetIDFAResultAction(FString(firstIdfv), FString(currentIdfv), FString(error));
  }];
}

/*
 * 渠道ID
 */
-(int)getChannelId 
{
    return [[[HeroUPlatform sharedInstance] getChannelId] intValue];
}

/*
 * 渠道名称
 */
-(NSString *)getChannelName 
{
    return [[HeroUPlatform sharedInstance] getChannelName];
}


/*
 * 获取英雄官网渠道的ProjectId，常用于游戏需要CPS分包时
 */
-(NSString *)getProjectId 
{
    return [[HeroUPlatform sharedInstance] getProjectId];
}

/*
 * 渠道SDK版本名称
 */
-(NSString *)getChannelSdkVersionName 
{
    return [[HeroUPlatform sharedInstance] getChannelSdkVersionName];
}

/*
 * iOS【注销、退出登陆并显示账号历史界面】
 */
-(void) logoutAndSowLoginView
{
    dispatch_async(dispatch_get_main_queue(), ^{
        [[HeroUPlatform sharedInstance] logoutAndSowLoginView] ;
    });
}

/*
 * 上报闪屏
 */
-(void) postSplashScreenEndSuccess
{
    dispatch_async(dispatch_get_main_queue(), ^{
        [[HeroUPlatform sharedInstance] postSplashScreenEndSuccess:^(id  _Nonnull obj) {
            NSLog(@"---------> 上报闪屏接口调用成功 <----------- %@ ",obj) ;
        } faild:^(id  _Nonnull obj) {
            NSLog(@"---------> 上报闪屏接口调用失败 <----------- %@ ",obj) ;
        }] ;
    });
}
/*
* 用户中心
*/
-(void)showAccountCenter
{
    dispatch_async(dispatch_get_main_queue(), ^{
        [[HeroUPlatform sharedInstance] showUserCenter];
    });
}
/*
  * 注销账号 
  */
-(void) accountCancellation
{
    dispatch_async(dispatch_get_main_queue(), ^{
        [[HeroUPlatform sharedInstance] accountCancellation];
    });
}

/*
 * 撤回注销账号
 */
-(void)accountUnCancellation
{
dispatch_async(dispatch_get_main_queue(), ^{
    [[HeroUPlatform sharedInstance] accountUnCancellationWithSuccess:^(id  _Nonnull obj) {
             NSString *msg = @"Success";
             HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onAccountUnCancellation(HeroUsdkSuccess,FString(msg));
        } failure:^(id  _Nonnull obj) {
            NSString *msg = [NSString stringWithFormat:@"%@",obj];
            HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onAccountUnCancellation(HeroUsdkFailed,FString(msg));
        }];
    });
}

/*
 * 上报问题 
 */
-(void) uploadIssue
{
    dispatch_async(dispatch_get_main_queue(), ^{
        [[HeroUPlatform sharedInstance] uploadIssue] ;
    });
}
/*
 * 打开内置浏览器
 * </summary>
 * <param name="openID">中台配置URL地址的ID</param>
 */
-(void) openBrowser:(NSString *)openID
{
dispatch_async(dispatch_get_main_queue(), ^{
    [[HeroUPlatform sharedInstance] heroUOpenBrowserByWebId:openID success:^(NSDictionary * _Nonnull dic) {
            NSString *msg = @"通过webId获取信息成功";
            HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onOpenBrowerResult(HeroUsdkSuccess,FString(msg));
     } failure:^(NSString * _Nonnull error) {
           NSString *msg = error;
           HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onOpenBrowerResult(HeroUsdkFailed,FString(msg));
     }];
   });
}

/*
  * 全球无界面切换账号
  */
-(void)OpenServicePanel
{
    dispatch_async(dispatch_get_main_queue(), ^{
        [[HeroUPlatform sharedInstance] openServiceView];
    });
}

/*
  * 全球无界面切换账号
  */
-(void)switchAccount 
{
    dispatch_async(dispatch_get_main_queue(), ^{
        [[HeroUPlatform sharedInstance] logoutAndSowLoginView];
    });
}
/*
 * 调用 track 接口，追踪一个带有属性的 event
 */
-(void) track:(NSString *)eventName withProperties:(NSString *)properties 
{
    dispatch_async(dispatch_get_main_queue(), ^{
        NSData *data = [properties dataUsingEncoding:NSUTF8StringEncoding];
             if (data != NULL) {
                NSDictionary *info = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingMutableContainers error:nil];
                if (info != NULL) {
                  [[HeroUPlatform sharedInstance] track:eventName withProperties:info];
                }
             }
    });
}
/*
  * 获取USDK内部埋点事件
  */
-(void) trackEventDataCallback 
{
 dispatch_async(dispatch_get_main_queue(), ^{
         [[HeroUPlatform sharedInstance] trackEventDataCallback:^(NSDictionary * _Nonnull data) {
                NSMutableDictionary *dataDic = [[NSMutableDictionary alloc] init];
                dataDic[@"data"] = [data hb_JSONString] ;
                //发送消息到UE4
                NSString *paramsString = [self getParamsValueWithDictionary:dataDic] ;
                HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onTrackDataCallBack(FString(paramsString));
            }];
    });
}

/*
 * 打开Xsolla商城支付
 */
-(void) startXsollaPayWithXsollaProperties:(NSString *)properties 
{
    dispatch_async(dispatch_get_main_queue(), ^{
        NSData *data = [properties dataUsingEncoding:NSUTF8StringEncoding];
                if (data != NULL) {
                    NSDictionary *info = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingMutableContainers error:nil];
                    if (info != NULL) {
                        HeroUXsollaModel *model = [[HeroUXsollaModel alloc] init] ;
                        if ( info[@"serverId"] != NULL) {
                            model.serverId = info[@"serverId"] ;
                        }
                        if ( info[@"roleName"] != NULL) {
                            model.roleName = info[@"roleName"] ;
                        }
                        if ( info[@"roleId"] != NULL) {
                            model.roleId = info[@"roleId"] ;
                        }
                        if ( info[@"cpUid"] != NULL) {
                            model.cpUid = info[@"cpUid"] ;
                        }
                        model.isJumpOutBrowser = [info[@"isJumpOutBrowser"] boolValue];
                        [[HeroUPlatform sharedInstance] startXsollaPayWithXsollaModel:model];
                    }
                }
    });
}

/*
 * 获取全球渠道账户绑定的状态
 */
-(void) getGlobalBindState 
{
    dispatch_async(dispatch_get_main_queue(), ^{
            [[HeroUPlatform sharedInstance] getBindStateWithSuccess:^(NSDictionary * _Nonnull result) {
                         NSMutableDictionary *dataDic = [[NSMutableDictionary alloc] init];
                         dataDic[@"data"] = [result hb_JSONString] ;
                         dataDic[@"status"] = @"1" ;
                         //发送消息到UE4
                         NSString *paramsString = [self getParamsValueWithDictionary:dataDic] ;
                         NSString *message = @"获取绑定状态成功";
                         HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onGetGlobalBindState(HeroUsdkSuccess,FString(paramsString),FString(message));
                     } failure:^(NSString * _Nonnull error) {
                         NSMutableDictionary *dataDic = [[NSMutableDictionary alloc] init];
                         dataDic[@"msg"] = @"获取绑定信息失败" ;
                         dataDic[@"status"] = @"0" ;
                         //发送消息到UE4
                         NSString *paramsString = [self getParamsValueWithDictionary:dataDic] ;
                         NSString *message = @"获取绑定信息失败";
                         HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onGetGlobalBindState(HeroUsdkFailed,FString(paramsString),FString(message));
                     }];
    });
}

/*
 * 全球绑定接口
 */
-(void) bindAccountWithType:(int)bindType 
{
     dispatch_async(dispatch_get_main_queue(), ^{
            [[HeroUPlatform sharedInstance] bindAccountWithType:bindType success:^(NSDictionary * _Nonnull result) {
                        NSMutableDictionary *dataDic = [[NSMutableDictionary alloc] init];
                        dataDic[@"data"] = [result hb_JSONString] ;
                        dataDic[@"status"] = @"1" ;
                        NSString *paramsString = [self getParamsValueWithDictionary:dataDic] ;
                        NSString *message = @"绑定成功";
                        HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onBindAccountWithType(HeroUsdkSuccess,FString(paramsString),FString(message));
                    } failure:^(NSString * _Nonnull error) {
                        NSMutableDictionary *dataDic = [[NSMutableDictionary alloc] init];
                        dataDic[@"msg"] = @"绑定账号失败" ;
                        dataDic[@"status"] = @"0" ;
                        NSString *paramsString = [self getParamsValueWithDictionary:dataDic] ;
                        NSString *message = @"绑定失败";
                        HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onBindAccountWithType(HeroUsdkFailed,FString(paramsString),FString(message));
                    }];
        });
}

/*
 * 分享
 */
-(void)share:(NSString *)shareJSON 
{
 dispatch_async(dispatch_get_main_queue(), ^{
        NSData *jsonData = [shareJSON dataUsingEncoding:NSUTF8StringEncoding];
            NSDictionary *dictionary = [NSJSONSerialization JSONObjectWithData:jsonData options:NSJSONReadingMutableContainers error:nil];
            HeroUShareModel *shareModel = [[HeroUShareModel alloc] init];
            NSString *sharePlatformString = [dictionary[@"sharePlatform"] stringValue];
            NSString *shareType = [dictionary[@"shareType"] stringValue];
          // 使用枚举值进行比较
if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformQQ"]) {
    // QQ分享
    shareModel.sharePlatform = HeroU_Share_Platform_QQ;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformQZone"]) {
    // QQ空间分享
    shareModel.sharePlatform = HeroU_Share_Platform_QQ_Space;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformWeChat"]) {
    // 微信分享
    shareModel.sharePlatform = HeroU_Share_Platform_WeChat;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformWeChatMements"]) {
    // 微信朋友圈分享
    shareModel.sharePlatform = HeroU_Share_Platform_WXTimeLine;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformSina"]) {
    // 新浪分享
    shareModel.sharePlatform = HeroU_Share_Platform_Weibo;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformAll"]) {
    // 有界面分享
    shareModel.sharePlatform = HeroU_Share_Platform_All;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformTwitter"]) {
    // Twitter无界面分享
    shareModel.sharePlatform = HeroU_Share_Platform_Twitter;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformFaceBook"]) {
    // Facebook无界面分享
    shareModel.sharePlatform = HeroU_Share_Platform_Facebbok;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformDouyin_Contact"]) {
    // 抖音分享到好友
    shareModel.sharePlatform = HeroU_Share_Platform_DouYinIM;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformDouyin_Moment"]) {
    // 抖音分享到投稿发布
    shareModel.sharePlatform = HeroU_Share_Platform_DouYinPublished;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformXHS"]) {
    // 小红书
    shareModel.sharePlatform = HeroU_Share_Platform_XiaoHongShu;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatform_KuaiShou"]) {
    // 快手
    shareModel.sharePlatform = HeroU_Share_Platform_KuaiShou;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformMYS_D"]) {
    // 摸鱼社-动态
    shareModel.sharePlatform = HeroU_Share_Platform_MoyuDynamic;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformMYS_T"]) {
    // 摸鱼社-文章
    shareModel.sharePlatform = HeroU_Share_Platform_MoyuArticle;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformTapTap"]) {
    // taptap
    shareModel.sharePlatform = HeroU_Share_Platform_TapTap;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformDouyin_DIARY"]) {
    // 分享抖音日常
    shareModel.sharePlatform = HeroU_Share_Platform_DouYinDaily;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformINSTAGRAM"]) {
    // Instagram
    shareModel.sharePlatform = HeroU_Share_Platform_Instagram;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformTIKTOK"]) {
    // Tiktok
    shareModel.sharePlatform = HeroU_Share_Platform_Tiktok;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformLUNOLOFT"]) {
    // LunoLoft
    shareModel.sharePlatform = HeroU_Share_Platform_LunoLoft;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformKAKAO"]) {
    // Kakao
    shareModel.sharePlatform = HeroU_Share_Platform_Kakao;
} else if ([sharePlatformString isEqualToString:@"HeroUSDKSharePlatformDISCORD"]) {
    // Discord
    shareModel.sharePlatform = HeroU_Share_Platform_Discord;
}
            if ([shareType isEqualToString:@"HeroUSDKShareTypeLink"]) {
                //分享链接
                shareModel.shareType = HeroUShareType_link ;
                shareModel.shareLinkTitle = dictionary[@"title"];
                shareModel.shareLinkDescription = dictionary[@"text"] ;
                shareModel.shareLink = dictionary[@"linkUrl"] ;
                shareModel.imageLink = dictionary[@"linkImagePath"] ;
                NSString* path = dictionary[@"imagePath"];
                //转换UE传递图片路径
                NSString *imagePath = [self formatUEImagePath:path] ;
                UIImage* image = [UIImage imageWithContentsOfFile:imagePath];
               /*if (!image) return;*/
               shareModel.shareImage = UIImageJPEGRepresentation(image, 1);
            }
            if ([shareType isEqualToString:@"HeroUSDKShareTypeImage"]) {
                //分享图片
                shareModel.shareType = HeroUShareType_image ;
                shareModel.imageLink = dictionary[@"linkImagePath"] ;
                NSString* path = dictionary[@"imagePath"];
                //转换UE传递图片路径
                NSString *imagePath = [self formatUEImagePath:path] ;
                UIImage* image = [UIImage imageWithContentsOfFile:imagePath];
                /*if (!image) return;*/
                shareModel.shareImage = UIImageJPEGRepresentation(image, 1);
            }
            if ([shareType isEqualToString:@"HeroUSDKShareTypeText"]) {
                //分享文本
                shareModel.shareType = HeroUShareType_text ;
                shareModel.shareText = dictionary[@"text"] ;
                shareModel.imageLink = dictionary[@"linkImagePath"] ;
                shareModel.shareLinkTitle = dictionary[@"text"] ;
            }
            [[HeroUPlatform sharedInstance] heroUShareWithShareModel:shareModel success:^(NSString *successMessage, HeroUShareStatus status, HeroUShareTaget target) {
                    NSInteger targetType = 20001 ;
                    SharePlatform sharePlatformt = SharePlatform::HeroUSDKSharePlatformQQ ;
                    if (target == HeroUShareTaget_QQ) {
                        targetType = 20001 ;
                        sharePlatformt = SharePlatform::HeroUSDKSharePlatformQQ ;
                    }
                    if (target == HeroUShareTaget_QQSpace) {
                        targetType = 20002 ;
                        sharePlatformt = SharePlatform::HeroUSDKSharePlatformQZone ;
                    }
                    if (target == HeroUShareTaget_wechat) {
                        targetType = 20003 ;
                        sharePlatformt = SharePlatform::HeroUSDKSharePlatformWeChat ;
                    }
                    if (target == HeroUShareTaget_wechatLine) {
                        targetType = 20004 ;
                        sharePlatformt = SharePlatform::HeroUSDKSharePlatformWeChatMements ;
                    }
                    if (target == HeroUShareTaget_Weibo) {
                        targetType = 20005 ;
                        sharePlatformt = SharePlatform::HeroUSDKSharePlatformSina ;
                    }
                    if (target == HeroUShareTaget_Twitter) {
                        targetType = 30001 ;
                        sharePlatformt = SharePlatform::HeroUSDKSharePlatformTwitter ;
                    }
                    if (target == HeroUShareTaget_Facebbok) {
                        targetType = 30002 ;
                        sharePlatformt = SharePlatform::HeroUSDKSharePlatformFaceBook ;
                    }

                   if (target == HeroUShareTaget_DouYinIM) {
                       targetType = 20006 ;
                       sharePlatformt = SharePlatform::HeroUSDKSharePlatformDouyin_Contact;
                   }
                   if (target == HeroUShareTaget_DouYinPublished) {
                       targetType = 20007 ;
                       sharePlatformt = SharePlatform::HeroUSDKSharePlatformDouyin_Moment;
                   }

                   if (target == HeroUShareTaget_XiaoHongShu) {
                      targetType = 20008 ;
                      sharePlatformt = SharePlatform::HeroUSDKSharePlatformXHS;
                   }

                   if (target == HeroUShareTaget_KuaiShou) {
                     targetType = 20009 ;
                     sharePlatformt = SharePlatform::HeroUSDKSharePlatform_KuaiShou;
                   }
                   if (target ==  HeroUShareTaget_MoyuDynamic) {
                     targetType = 20011 ;
                     sharePlatformt = SharePlatform::HeroUSDKSharePlatformMYS_D;
                   }
                   if (target == HeroUShareTaget_MoyuArticle) {
                     targetType = 20014;
                     sharePlatformt = SharePlatform::HeroUSDKSharePlatformMYS_T;
                   }

                   if (target == HeroUShareTaget_TapTap) {
                     targetType = 20012;
                     sharePlatformt = SharePlatform::HeroUSDKSharePlatformTapTap;
                   }
                
                   if (target == HeroUShareTaget_DouYinDaily) {
                     targetType = 20013;
                     sharePlatformt = SharePlatform::HeroUSDKSharePlatformDouyin_DIARY;
                   }
                   if (target == HeroUShareTaget_Instagram) {
                       targetType = 30005;
                       sharePlatformt = SharePlatform::HeroUSDKSharePlatformINSTAGRAM;
                   }
                if (target == HeroUShareTaget_Tiktok) {
                     targetType = 30006;
                     sharePlatformt = SharePlatform::HeroUSDKSharePlatformTIKTOK;
                 }
                if (target == HeroUShareTaget_LunoLoft) {
                    targetType = 30009;
                    sharePlatformt = SharePlatform::HeroUSDKSharePlatformLUNOLOFT;
                }
                if (target == HeroUShareTaget_Kakao) {
                   targetType = 30010;
                   sharePlatformt = SharePlatform::HeroUSDKSharePlatformKAKAO;
               }

                if (target == HeroUShareTaget_Discord) {
                  targetType = 30011;
                  sharePlatformt = SharePlatform::HeroUSDKSharePlatformDISCORD;
              }
                    NSLog(@"=======> targetType  Success : %ld",targetType) ;
                    NSString *message = @"分享成功";
                    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onShareCallBack(HeroUsdkSuccess, sharePlatformt ,FString(message));
            } failure:^(NSString *failureMessage, HeroUShareStatus status, HeroUShareTaget target) {
                    NSInteger targetType = 20001 ;
                     SharePlatform sharePlatformt = SharePlatform::HeroUSDKSharePlatformQQ ;
                                        if (target == HeroUShareTaget_QQ) {
                        targetType = 20001 ;
                        sharePlatformt = SharePlatform::HeroUSDKSharePlatformQQ ;
                    }
                    if (target == HeroUShareTaget_QQSpace) {
                        targetType = 20002 ;
                        sharePlatformt = SharePlatform::HeroUSDKSharePlatformQZone ;
                    }
                    if (target == HeroUShareTaget_wechat) {
                        targetType = 20003 ;
                        sharePlatformt = SharePlatform::HeroUSDKSharePlatformWeChat ;
                    }
                    if (target == HeroUShareTaget_wechatLine) {
                        targetType = 20004 ;
                        sharePlatformt = SharePlatform::HeroUSDKSharePlatformWeChatMements ;
                    }
                    if (target == HeroUShareTaget_Weibo) {
                        targetType = 20005 ;
                        sharePlatformt = SharePlatform::HeroUSDKSharePlatformSina ;
                    }
                    if (target == HeroUShareTaget_Twitter) {
                        targetType = 30001 ;
                        sharePlatformt = SharePlatform::HeroUSDKSharePlatformTwitter ;
                    }
                    if (target == HeroUShareTaget_Facebbok) {
                        targetType = 30002 ;
                        sharePlatformt = SharePlatform::HeroUSDKSharePlatformFaceBook ;
                    }

                   if (target == HeroUShareTaget_DouYinIM) {
                       targetType = 20006 ;
                       sharePlatformt = SharePlatform::HeroUSDKSharePlatformDouyin_Contact;
                   }
                   if (target ==  HeroUShareTaget_DouYinPublished) {
                       targetType = 20007 ;
                       sharePlatformt = SharePlatform::HeroUSDKSharePlatformDouyin_Moment;
                   }

                   if (target == HeroUShareTaget_XiaoHongShu) {
                      targetType = 20008 ;
                      sharePlatformt = SharePlatform::HeroUSDKSharePlatformXHS;
                   }

                   if (target == HeroUShareTaget_KuaiShou) {
                     targetType = 20009 ;
                     sharePlatformt = SharePlatform::HeroUSDKSharePlatform_KuaiShou;
                   }
                   if (target == HeroUShareTaget_MoyuDynamic) {
                     targetType = 20011 ;
                     sharePlatformt = SharePlatform::HeroUSDKSharePlatformMYS_D;
                   }
                   if (target == HeroUShareTaget_MoyuArticle) {
                     targetType = 20014;
                     sharePlatformt = SharePlatform::HeroUSDKSharePlatformMYS_T;
                   }

                   if (target == HeroUShareTaget_TapTap) {
                     targetType = 20012;
                     sharePlatformt = SharePlatform::HeroUSDKSharePlatformTapTap;
                   }
                
                   if (target == HeroUShareTaget_DouYinDaily) {
                     targetType = 20013;
                     sharePlatformt = SharePlatform::HeroUSDKSharePlatformDouyin_DIARY;
                   }
                   if (target == HeroUShareTaget_Instagram) {
                       targetType = 30005;
                       sharePlatformt = SharePlatform::HeroUSDKSharePlatformINSTAGRAM;
                   }
                if (target == HeroUShareTaget_Tiktok) {
                     targetType = 30006;
                     sharePlatformt = SharePlatform::HeroUSDKSharePlatformTIKTOK;
                 }
                if (target == HeroUShareTaget_LunoLoft) {
                    targetType = 30009;
                    sharePlatformt = SharePlatform::HeroUSDKSharePlatformLUNOLOFT;
                }
                if (target ==  HeroUShareTaget_Kakao) {
                   targetType = 30010;
                   sharePlatformt = SharePlatform::HeroUSDKSharePlatformKAKAO;
               }

                if (target ==  HeroUShareTaget_Discord) {
                  targetType = 30011;
                  sharePlatformt = SharePlatform::HeroUSDKSharePlatformDISCORD;
              }
                                         NSLog(@"=======> targetType  Failed: %ld",targetType) ;
                     NSString *message = @"分享失败";
                    HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onShareCallBack(HeroUsdkFailed, sharePlatformt ,FString(failureMessage));
            }];
    });
}

/*
 转换UE传入的图片路径
 */
-(NSString *)formatUEImagePath:(NSString *)path
{
    NSString *documentPath = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) firstObject];
    NSError *error = nil;
    NSRegularExpression *regex = [NSRegularExpression regularExpressionWithPattern:@"^(\\.\\./)+" options:0 error:&error];
    NSString *cleanPath = [regex stringByReplacingMatchesInString:path options:0 range:NSMakeRange(0, path.length) withTemplate:@""] ;
    NSString *imagePath = [documentPath stringByAppendingPathComponent:cleanPath];
    imagePath = [imagePath stringByReplacingOccurrencesOfString:@"PersistentDownloadDir" withString:@"Saved"] ;
    if ([[NSFileManager defaultManager] fileExistsAtPath:imagePath]) {
        return imagePath ;
    } else {
        NSString *libraryPath = [NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES) firstObject];
        NSString *libImagePath = [libraryPath stringByAppendingPathComponent:cleanPath];
        imagePath = [imagePath stringByReplacingOccurrencesOfString:@"PersistentDownloadDir" withString:@"Saved"] ;
        return imagePath ;
    }
    return path ;
}


/*
 * 添加图片到相册
 */
-(void)addPicToAlbum:(NSString *)imagePath albumName:(NSString *)albumName 
{
 dispatch_async(dispatch_get_main_queue(), ^{
        [[HeroUPlatform sharedInstance] addPicToAlbumWithImageObj:imagePath albumName:albumName success:^(NSDictionary * _Nonnull result) {
                NSLog(@"=======> 保存图片成功 : %@ <=======",result) ;
            } failure:^(NSString * _Nonnull error) {
                NSLog(@"=======> 保存图片失败 : %@ <=======",error) ;
            }];
    });
}

/*
 * 市场插件日志上报
 */
-(void) logEvent:(NSString *)eventName withProperties:(NSString *)properties 
{
    dispatch_async(dispatch_get_main_queue(), ^{
           NSData *data = [properties dataUsingEncoding:NSUTF8StringEncoding];
               if (data != NULL) {
                  NSDictionary *info = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingMutableContainers error:nil];
                  if (info != NULL) {
                      [[HeroUPlatform sharedInstance] logEvent:eventName parameters:info];
                  }
               }
    });
}

/*
 * 市场插件日志上报
 */
-(void) logPurchaseWithOrderId:(NSString *)orderId amount:(double)amount currency:(NSString *)currency propertys:(NSString *)propertys 
{
    dispatch_async(dispatch_get_main_queue(), ^{
           NSData *data = [propertys dataUsingEncoding:NSUTF8StringEncoding];
               if (data != NULL) {
                   NSDictionary *info = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingMutableContainers error:nil];
                   if (info != NULL) {
                       [[HeroUPlatform sharedInstance] logPurchaseWithOrderId:orderId amount:amount currency:currency parameters:info];
                   }
               }
    });
}

-(void) SetSdkLanguage:(int)Language 
{
    dispatch_async(dispatch_get_main_queue(), ^{
        HeroULanguageType enumLanguage = (HeroULanguageType)Language;
        [[HeroUPlatform sharedInstance] setLanguageType:enumLanguage];
    });
}


@end



