// Fill out your copyright notice in the Description page of Project Settings.



#import <UIKit/UIKit.h>
#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN


@interface HeroUsdkSupportiOSDelegate : NSObject

/**
 *  严格单例，唯一获得实例的方法.
 *
 *  @return 实例对象.
 */
+ (instancetype)getInstance ;

/*
 * 融合SDK初始化
 */
// -(void) initWithHeroUSDK:(NSString *)jsonString ;
-(void)gameChannelInitWithKey:(NSString *)productKey
                    productID:(NSString *)productID
                channelParams:(NSDictionary *)channelParams;
-(void)globalChannelInitWithKey:(NSString *)productKey
                     productID:(NSString *)productID
                 channelParams:(NSDictionary *)channelParams;
/*
 * 融合SDK登录
 */
-(void) login ;

/*
 * 进入游戏
 */
-(void) enterGame:(NSString *)jsonString ;

/*
 * 角色注册
 */
-(void) createNewRole:(NSString *)jsonString ;

/*
 * 角色升级
 */
-(void) roleLevelUp:(NSString *)jsonString ;

/*
 * 注销、退出登录
 */
-(void) logout ;

/*
 * 支付
 */
-(void) pay:(NSString *)paymentParametersData
   roleInfo:(NSString *)roleInfo ;

/*
 * 扫描(登录在PC端登录,SDK需要登录状态）
 */
-(void) showScanViewWithExt:(NSString *)exit ;

/*
 * 收到踢下线结果回调SDK
 */
-(void) cpKickOffCallBackWithResult:(NSString *)result ;

/*
 * 获取协议内容
 */
-(NSString *) getProtocolResult ;

/*
 * 点击同意通知
 */
-(void) setAgreeProtocol ;


/*
 *  ============================== iOS ===========================
 */

/*
 * 获取登录用户名
 */
-(NSString *) getUserName ;

/*
 * 获取登录用户ID
 */
-(NSString *) getUserId ;

/*
 * 获取ID（部分游戏使用@"id"字段作为唯一标示符）
 */
-(NSString *) getSdkId ;

/*
 * 获取设备号(优先取的IDFA、没取到则取的UUID)
 */
-(NSString *) getDeviceNum ;

/*
 * 获取设备号IDFA
 */
-(void) getIDFAWithCompletion ;

/*
 * 获取设备IDFV
 */
-(void) getIDFVWithCompletion ;

/*
 * 渠道ID
 */
-(int)getChannelId ;

/*
 * 渠道名称
 */
-(NSString *)getChannelName ;


/*
 * 获取英雄官网渠道的ProjectId，常用于游戏需要CPS分包时
 */
-(NSString *)getProjectId ;

/*
 * 渠道SDK版本名称
 */
-(NSString *)getChannelSdkVersionName ;

/*
 * iOS【注销、退出登陆并显示账号历史界面】
 */
-(void) logoutAndSowLoginView ;

/*
 * 上报闪屏
 */
-(void) postSplashScreenEndSuccess ;

/*
 * 打开用户中心
 */
-(void) showAccountCenter ;

/*
  * 注销账号 
  */
-(void) accountCancellation;

/*
 * 撤回注销账号
 */
-(void) accountUnCancellation;

/*
 * 上报问题 
 */
-(void) uploadIssue;
/*
 * 打开内置浏览器
 * </summary>
 * <param name="openID">中台配置URL地址的ID</param>
 */
-(void) openBrowser:(NSString *)openID ;

-(void) OpenServicePanel;
/*
  * 全球无界面切换账号
  */
-(void) switchAccount ;

/*
 * 调用 track 接口，追踪一个带有属性的 event
 */
-(void) track:(NSString *)eventName withProperties:(NSString *)properties ;

/*
 * 市场插件日志上报
 */
-(void) logEvent:(NSString *)eventName withProperties:(NSString *)properties ;

/*
 * 市场插件日志上报
 */
-(void) logPurchaseWithOrderId:(NSString *)orderId amount:(double)amount currency:(NSString *)currency propertys:(NSString *)propertys ;

/*
  * 获取USDK内部埋点事件
  */
-(void) trackEventDataCallback ;

/*
 * 打开Xsolla商城支付
 */
-(void) startXsollaPayWithXsollaProperties:(NSString *)properties ;

/*
 * 获取全球渠道账户绑定的状态
 */
-(void) getGlobalBindState ;

/*
 * 全球绑定接口
 */
-(void) bindAccountWithType:(int )bindType ;

/*
 * 分享
 */
-(void)share:(NSString *)jsonstring ;

/*
 * 添加图片到相册
 */
-(void)addPicToAlbum:(NSString *)imagePath albumName:(NSString *)albumName ;

-(void) SetSdkLanguage: (int) Language;

@end


NS_ASSUME_NONNULL_END


