#include "PlatformManagerIOS.h"
#include <string>
#import "HeroUsdkSupportiOSDelegate.h"
#include "JsonObjectConverter.h"
#include "LogHeroUsdk.h"
#include "IOS/IOSAppDelegate.h"
#include "IOS/IOSApplication.h"
#include "Setting/UsdkSettings.h"
#include "Setting/UsdkSettingsTypes.h"
#import "IOSAppDelegate.h"
#import <HeroUSDK/HeroUPlatform.h>

#include "Config/Channel/Global/IosGlobalConfig.h"
#include "Config/Channel/Mainland/IosMainlandConfig.h"
#include "Interfaces/IHttpRequest.h"
#include "Interfaces/IHttpResponse.h"


FPlatformManagerIOS::FPlatformManagerIOS(UHeroUsdkSubsystem* InSubsystem, const TSharedPtr<FJsonObject>& Config):FPlatformManagerBase(InSubsystem)
{
	HeroConfig = Config;
	FIOSCoreDelegates::OnDidBecomeActive.AddLambda([this](){
				[[HeroUPlatform sharedInstance] applicationDidBecomeActive:[UIApplication sharedApplication]];
					NSLog(@"OnDidBecomeActive %s,%d",__FUNCTION__,__LINE__);
			// Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
		});
	FIOSCoreDelegates::OnOpenURL.AddLambda([this](UIApplication* application, NSURL* url, NSString* sourceApplication, id annotation) {
			[[HeroUPlatform sharedInstance] heroU_application:application handleOpenURL:url] ;
				NSLog(@"OnOpenURL %s,%d",__FUNCTION__,__LINE__);
		});
}

void FPlatformManagerIOS::SetNotify()
{
}

void FPlatformManagerIOS::Init()
{
	auto Setting = GetMutableDefault<UUsdkSettings>();
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit Channel : %d"), Setting->Channel);
	std::string	ProductId = TCHAR_TO_UTF8(*HeroConfig->GetStringField(TEXT("productId")));
	std::string	ProductKey = TCHAR_TO_UTF8(*HeroConfig->GetStringField(TEXT("productKey")));
	
	FString ChannelString;

	if (Setting->Channel == EHeroUSDKChannel::China)
	{
		const TSharedPtr<FJsonObject> IheroValue = HeroConfig->GetObjectField(TEXT("ihero"));

		const TSharedPtr<FJsonObject> CustomJsonObject = HandleIosConfig(IheroValue);
		CustomJsonObject->SetNumberField(TEXT("type"), 1);
//		CustomJsonObject->SetStringField(TEXT("mainlandInitParams"), Setting->IosMainlandInitConfig);
//		CustomJsonObject->SetStringField(TEXT("usdkInitParams"), Setting->UsdkInitConfig);
		const TSharedRef<TJsonWriter<>> Writer = TJsonWriterFactory<>::Create(&ChannelString);
		FJsonSerializer::Serialize(CustomJsonObject.ToSharedRef(), Writer);
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit MainlandChannel JSON : %s"), *ChannelString);
        std::string ChannelConfig = TCHAR_TO_UTF8(*ChannelString);
        NSString *NSChannelString = [NSString stringWithCString:ChannelConfig.c_str() encoding:NSUTF8StringEncoding];
        NSData *NSChannel = [NSChannelString dataUsingEncoding:NSUTF8StringEncoding];
        NSMutableDictionary *ChannelDic = [NSJSONSerialization JSONObjectWithData:NSChannel options:NSJSONReadingMutableContainers error:nil];
        std::string MainlandInitcfg = TCHAR_TO_UTF8(*Setting->IosMainlandInitConfig);
        NSString *NSMainlandInitcfg = [NSString stringWithCString:MainlandInitcfg.c_str() encoding:NSUTF8StringEncoding];
        [ChannelDic setObject:NSMainlandInitcfg forKey:@"mainlandInitParams"];
        
        std::string UsdkInitcfg = TCHAR_TO_UTF8(*Setting->UsdkInitConfig);
        NSString *NSUsdkInitcfg = [NSString stringWithCString:UsdkInitcfg.c_str() encoding:NSUTF8StringEncoding];
        [ChannelDic setObject:NSUsdkInitcfg forKey:@"usdkInitParams"];
        NSLog(@">>>>>>>>>>>>>>>> initWithMSDK 解析NSUsdkInitcfg : %@ <<<<<<<<<<< ",NSUsdkInitcfg) ;
        NSString *NSProductKey = [NSString stringWithCString:ProductKey.c_str() encoding:NSUTF8StringEncoding];
		NSString *NSProductId = [NSString stringWithCString:ProductId.c_str() encoding:NSUTF8StringEncoding];
		dispatch_async(dispatch_get_main_queue(), ^{
			[[HeroUsdkSupportiOSDelegate getInstance] gameChannelInitWithKey:NSProductKey productID:NSProductId channelParams:ChannelDic];
			if(Setting->bIsJuLiang)
			{
				[[HeroUPlatform sharedInstance] startBDASDK];
			}
			if(Setting->bIsJuLiang)
			{
				[[HeroUPlatform sharedInstance] startDouYinUnionSDK];
			}
        });
	}
	else if (Setting->Channel == EHeroUSDKChannel::Global)
	{
		const TSharedPtr<FJsonObject> IheroglobalValue = HeroConfig->GetObjectField(TEXT("iheroglobal"));
		const TSharedPtr<FJsonObject> GlobalChannel = HandleIosConfig(IheroglobalValue);
		GlobalChannel->SetNumberField(TEXT("type"), 2);
		// GlobalChannel->SetStringField(TEXT("globalInitParams"), Setting->IosGlobalInitConfig);
		TSharedRef<TJsonWriter<>> Writer = TJsonWriterFactory<>::Create(&ChannelString);
		FJsonSerializer::Serialize(GlobalChannel.ToSharedRef(), Writer);
		if (ChannelString.IsEmpty())
		{ 
			UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit 全球渠道参数转换失败 "));
			return;
		}
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit GlobalChannel JSON : %s"), *ChannelString);
		std::string ChannelConfig = TCHAR_TO_UTF8(*ChannelString);
		NSString *NSChannelString = [NSString stringWithCString:ChannelConfig.c_str() encoding:NSUTF8StringEncoding];
		NSData *NSChannel = [NSChannelString dataUsingEncoding:NSUTF8StringEncoding];
		NSMutableDictionary *ChannelDic = [NSJSONSerialization JSONObjectWithData:NSChannel options:NSJSONReadingMutableContainers error:nil];
		std::string GlobalInitcfg = TCHAR_TO_UTF8(*Setting->IosGlobalInitConfig);
		NSString *NSGlobalInitcfg = [NSString stringWithCString:GlobalInitcfg.c_str() encoding:NSUTF8StringEncoding];
        NSLog(@">>>>>>>>>>>>>>>> initWithMSDK 解析NSGlobalInitcfg : %@ <<<<<<<<<<< ", NSGlobalInitcfg) ;
		[ChannelDic setObject:NSGlobalInitcfg forKey:@"globalInitParams"];
		
		NSString *NSProductKey = [NSString stringWithCString:ProductKey.c_str() encoding:NSUTF8StringEncoding];
		NSString *NSProductId = [NSString stringWithCString:ProductId.c_str() encoding:NSUTF8StringEncoding];
		dispatch_async(dispatch_get_main_queue(), ^{
			[[HeroUsdkSupportiOSDelegate getInstance] globalChannelInitWithKey:NSProductKey productID:NSProductId channelParams:ChannelDic];
		});
	}
}

void FPlatformManagerIOS::Login()
{
	dispatch_async(dispatch_get_main_queue(), ^{
		   //OC登录
		   [[HeroUsdkSupportiOSDelegate getInstance] login];
	   });
}

void FPlatformManagerIOS::EnterGame(FHeroHDCGameRoleInfo roleInfo)
{
	FString profile;
	FJsonObjectConverter::UStructToJsonObjectString(roleInfo, profile, 0, 0);
	if (profile.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit enterGame 转换失败 "));
		return;
	}
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit enterGame JSON : %s"), *profile);
	std::string t = TCHAR_TO_UTF8(*profile);



	dispatch_async(dispatch_get_main_queue(), ^{
		//json字符串
		NSString *jsonStr = [NSString stringWithCString:t.c_str() encoding:NSUTF8StringEncoding];
		NSLog(@"=========>enterGame json %@ ",jsonStr) ;
		//OC进入游戏
		[[HeroUsdkSupportiOSDelegate getInstance] enterGame:jsonStr];
	});
}

void FPlatformManagerIOS::CreateNewRole(FHeroHDCGameRoleInfo roleInfo)
{
	FString profile;
	FJsonObjectConverter::UStructToJsonObjectString(roleInfo, profile, 0, 0);
	if (profile.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit createNewRole 转换失败 "));
		return;
	}
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit createNewRole JSON : %s"), *profile);
	std::string t = TCHAR_TO_UTF8(*profile);

	dispatch_async(dispatch_get_main_queue(), ^{
		//json字符串
		NSString *jsonStr = [NSString stringWithCString:t.c_str() encoding:NSUTF8StringEncoding];
		NSLog(@"=========>createNewRole json %@ ",jsonStr) ;
		//OC角色注册
		[[HeroUsdkSupportiOSDelegate getInstance] createNewRole:jsonStr];
	});
}

void FPlatformManagerIOS::RoleLevelUp(FHeroHDCGameRoleInfo roleInfo)
{
	FString profile;
	FJsonObjectConverter::UStructToJsonObjectString(roleInfo, profile, 0, 0);
	if (profile.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit roleLevelUp 转换失败 "));
		return;
	}
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit roleLevelUp JSON : %s"), *profile);
	std::string t = TCHAR_TO_UTF8(*profile);
	
	dispatch_async(dispatch_get_main_queue(), ^{
		//json字符串
		NSString *jsonStr = [NSString stringWithCString:t.c_str() encoding:NSUTF8StringEncoding];
		NSLog(@"=========>roleLevelUp json %@ ",jsonStr) ;
		//OC角色升级
		[[HeroUsdkSupportiOSDelegate getInstance] roleLevelUp:jsonStr];
	});
}

void FPlatformManagerIOS::logout()
{
	dispatch_async(dispatch_get_main_queue(), ^{
			//OC注销登录
			[[HeroUsdkSupportiOSDelegate getInstance] logout];
		});
}

void FPlatformManagerIOS::Pay(FHeroUPaymentParameters paymentParametersData, FHeroHDCGameRoleInfo roleInfo)
{
	FString profile;
	FString paramFile;
	FJsonObjectConverter::UStructToJsonObjectString(roleInfo, profile, 0, 0);
	FJsonObjectConverter::UStructToJsonObjectString(paymentParametersData, paramFile, 0, 0);
	if (profile.IsEmpty() || paramFile.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit pay 转换失败 "));
		return;
	}
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit pay params JSON : %s"), *paramFile);
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit pay roleInfo JSON : %s"), *profile);
	std::string t = TCHAR_TO_UTF8(*paramFile);
	std::string t1 = TCHAR_TO_UTF8(*profile);

	dispatch_async(dispatch_get_main_queue(), ^{
		//json字符串
		NSString *paramsStr = [NSString stringWithCString:t.c_str() encoding:NSUTF8StringEncoding];
		NSString *roleInfoStr = [NSString stringWithCString:t1.c_str() encoding:NSUTF8StringEncoding];
		NSLog(@"=========>pay paramsStr json %@ ",paramsStr) ;
		NSLog(@"=========>pay roleInfoStr json %@ ",roleInfoStr) ;
		//OC内购
		[[HeroUsdkSupportiOSDelegate getInstance] pay:paramsStr roleInfo:roleInfoStr];
	});
}

void FPlatformManagerIOS::showScanViewWithExt(FString exit)
{
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit showScanViewWithExt : %s"), *exit);
	std::string t = TCHAR_TO_UTF8(*exit);
	

	dispatch_async(dispatch_get_main_queue(), ^{
		//json字符串
		NSString *jsonStr = [NSString stringWithCString:t.c_str() encoding:NSUTF8StringEncoding];
		NSLog(@"=========>showScanViewWithExt json %@ ",jsonStr) ;
		//OC扫描登录
		[[HeroUsdkSupportiOSDelegate getInstance] showScanViewWithExt:jsonStr];
	});
}

void FPlatformManagerIOS::cpKickOffCallBackWithResult(FString result)
{
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit cpKickOffCallBackWithResult : %s"), *result);
	std::string t = TCHAR_TO_UTF8(*result);
	dispatch_async(dispatch_get_main_queue(), ^{
		   //json字符串
		   NSString *jsonStr = [NSString stringWithCString:t.c_str() encoding:NSUTF8StringEncoding];
		   NSLog(@"=========>cpKickOffCallBackWithResult json %@ ",jsonStr) ;
		   //CP回调SDK
		   [[HeroUsdkSupportiOSDelegate getInstance] cpKickOffCallBackWithResult:jsonStr];
	   });
}

FString FPlatformManagerIOS::getProtocolResult()
{
	return [[HeroUsdkSupportiOSDelegate getInstance] getProtocolResult] ;
}

void FPlatformManagerIOS::setAgreeProtocol()
{
	dispatch_async(dispatch_get_main_queue(), ^{
		   //OC点击同意通知
		   [[HeroUsdkSupportiOSDelegate getInstance] setAgreeProtocol];
	   });
}

void FPlatformManagerIOS::showAccountCenter()
{
	dispatch_async(dispatch_get_main_queue(), ^{
		
		[[HeroUsdkSupportiOSDelegate getInstance] showAccountCenter];
	});
}

void FPlatformManagerIOS::accountCancellation()
{
	dispatch_async(dispatch_get_main_queue(), ^{
		
		[[HeroUsdkSupportiOSDelegate getInstance] accountCancellation];
	});

}

void FPlatformManagerIOS::accountUnCancellation()
{
	dispatch_async(dispatch_get_main_queue(), ^{
		
		[[HeroUsdkSupportiOSDelegate getInstance] accountUnCancellation];
	});
}

void FPlatformManagerIOS::uploadIssue()
{
	dispatch_async(dispatch_get_main_queue(), ^{
		[[HeroUsdkSupportiOSDelegate getInstance] uploadIssue];
	});
}

void FPlatformManagerIOS::SetUsdkLanguage(EHeroUsdkLanguageFlag Language)
{
	[[HeroUsdkSupportiOSDelegate getInstance] SetSdkLanguage:(int)Language];
}

void FPlatformManagerIOS::openBrowser(FString openID)
{
	std::string t = TCHAR_TO_UTF8(*openID);
	dispatch_async(dispatch_get_main_queue(), ^{
		NSString *jsonStr = [NSString stringWithCString:t.c_str() encoding:NSUTF8StringEncoding];
		[[HeroUsdkSupportiOSDelegate getInstance] openBrowser:jsonStr];
	});
}

void FPlatformManagerIOS::OpenSurvey(const FString& WebId)
{
	//None
}

void FPlatformManagerIOS::OpenService()
{
	dispatch_async(dispatch_get_main_queue(), ^{
		[[HeroUsdkSupportiOSDelegate getInstance] OpenServicePanel];
	});
}

void FPlatformManagerIOS::switchAccount()
{
	dispatch_async(dispatch_get_main_queue(), ^{
		[[HeroUsdkSupportiOSDelegate getInstance] switchAccount];
	});

}

void FPlatformManagerIOS::trackWithProperties(FString eventName, TMap<FString, FString> propertys)
{
	FString parametersJSON = checkPostParamster(propertys);
	if (parametersJSON.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroMarketSupportKit trackWithProperties 内容参数不能为空 !!! "));
		return;
	}
	else
	{
		std::string eventNamet = TCHAR_TO_UTF8(*eventName);
		std::string paramst = TCHAR_TO_UTF8(*parametersJSON);
		

		dispatch_async(dispatch_get_main_queue(), ^{
			//json字符串
			NSString *eventNameStr = [NSString stringWithCString:eventNamet.c_str() encoding:NSUTF8StringEncoding];
			NSString *jsonStr = [NSString stringWithCString:paramst.c_str() encoding:NSUTF8StringEncoding];
			//OC事件上报
			[[HeroUsdkSupportiOSDelegate getInstance] track:eventNameStr withProperties:jsonStr] ;
		});
	}	

}

void FPlatformManagerIOS::trackEventDataCallback()
{
	dispatch_async(dispatch_get_main_queue(), ^{
	//OC获取USDK内部埋点事件
		[[HeroUsdkSupportiOSDelegate getInstance] trackEventDataCallback] ;
	});
}

void FPlatformManagerIOS::startXsollaPayWithXsollaProperties(TMap<FString, FString> propertys)
{
		FString parametersJSON = checkPostParamster(propertys);
		if (parametersJSON.IsEmpty())
		{
			UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit startXsollaPayWithXsollaProperties 内容参数不能为空 !!! "));
			return;
		}
		else
		{
			std::string paramst = TCHAR_TO_UTF8(*parametersJSON);
			

			dispatch_async(dispatch_get_main_queue(), ^{
				//json字符串
				NSString *jsonStr = [NSString stringWithCString:paramst.c_str() encoding:NSUTF8StringEncoding];
				//OC事件上报
				[[HeroUsdkSupportiOSDelegate getInstance] startXsollaPayWithXsollaProperties:jsonStr] ;
			});
		}
}

void FPlatformManagerIOS::getGlobalBindState()
{
			dispatch_async(dispatch_get_main_queue(), ^{
	//OC获取全球渠道账户绑定的状态
	[[HeroUsdkSupportiOSDelegate getInstance] getGlobalBindState] ;
	});
}

void FPlatformManagerIOS::share(FShareInfo shareInfo)
{
			/*if ((shareInfo.sharePlatform == SharePlatform::HeroUSDKSharePlatformTwitter && shareInfo.shareType == ShareType::HeroUSDKShareTypeLink) ||
					(shareInfo.sharePlatform == SharePlatform::HeroUSDKSharePlatformTwitter && shareInfo.shareType == ShareType::HeroUSDKShareTypeText))
			{
				UE_LOG(LogHeroUsdk, Log, TEXT("===========> Twitter 仅支持图片分享 <==========="));
				return ;
			}
			if (shareInfo.sharePlatform == SharePlatform::HeroUSDKSharePlatformFaceBook && shareInfo.shareType == ShareType::HeroUSDKShareTypeText)
			{
				UE_LOG(LogHeroUsdk, Log, TEXT("===========> Facebook 不支持文本分享 <==========="));
				return;
			}*/
			FString profile;
			FJsonObjectConverter::UStructToJsonObjectString(shareInfo, profile, 0, 0);
			if (profile.IsEmpty())
			{
				UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit share 转换失败 "));
				return;
			}
			UE_LOG(LogHeroUsdk, Log, TEXT(" share : %s"), *profile);
			std::string c = TCHAR_TO_UTF8(*profile);
	


			dispatch_async(dispatch_get_main_queue(), ^{
				//json字符串
				NSString *jsonStr = [NSString stringWithCString:c.c_str() encoding:NSUTF8StringEncoding];
				[[HeroUsdkSupportiOSDelegate getInstance] share:jsonStr];
			});
}

void FPlatformManagerIOS::addPicToAlbum(FString imagePath, FString albumName)
{
			std::string imagePathstd = TCHAR_TO_UTF8(*imagePath);
			std::string albumNamestd = TCHAR_TO_UTF8(*albumName);
			

			dispatch_async(dispatch_get_main_queue(), ^{
				//json字符串
				NSString *jsonStr = [NSString stringWithCString:imagePathstd.c_str() encoding:NSUTF8StringEncoding];
				NSString *jsonStr1 = [NSString stringWithCString:albumNamestd.c_str() encoding:NSUTF8StringEncoding];
				//OC添加图片到手机相册
				[[HeroUsdkSupportiOSDelegate getInstance] addPicToAlbum:jsonStr albumName:jsonStr1] ;
			});
}

void FPlatformManagerIOS::jumpToApp(FString url)
{
			//None
}



int FPlatformManagerIOS::getChannelId()
{
	//iOS渠道ID
	return [[HeroUsdkSupportiOSDelegate getInstance] getChannelId];
}

FString FPlatformManagerIOS::getChannelName()
{
			//iOS渠道名称
			NSString *channelName = [[HeroUsdkSupportiOSDelegate getInstance] getChannelName];
			return FString(channelName);
}

FString FPlatformManagerIOS::getChannelSdkVersionName()
{
			NSString *sdkVerionName = [[HeroUsdkSupportiOSDelegate getInstance] getChannelSdkVersionName];
			return FString(sdkVerionName);
}

FString FPlatformManagerIOS::getProjectId()
{
	NSString *projectID = [[HeroUsdkSupportiOSDelegate getInstance] getProjectId];
	return FString(projectID);
}

void FPlatformManagerIOS::logEvent(FString eventName, TMap<FString, FString> propertys)
{
	FString parametersJSON = checkPostParamster(propertys);
	std::string t = TCHAR_TO_UTF8(*eventName);
	if (parametersJSON.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit logEvent 内容参数不能为空 !!! "));
		return;
	} else
	{
		std::string paramst = TCHAR_TO_UTF8(*parametersJSON);
		dispatch_async(dispatch_get_main_queue(), ^{
			NSString *eventNameStr = [NSString stringWithCString:t.c_str() encoding:NSUTF8StringEncoding];
			NSString *paramstStr = [NSString stringWithCString:paramst.c_str() encoding:NSUTF8StringEncoding];
			//OC市场插件事件上报
			[[HeroUsdkSupportiOSDelegate getInstance] logEvent:eventNameStr withProperties:paramstStr] ;
		});
	}
		
}

void FPlatformManagerIOS::logPurchaseWithOrderId(FString orderId, double amount, FString currency,
	TMap<FString, FString> propertys)
{
	FString parametersJSON = checkPostParamster(propertys);
	std::string tOrder = TCHAR_TO_UTF8(*orderId);
	std::string tcurrency = TCHAR_TO_UTF8(*currency);
	std::string paramst = TCHAR_TO_UTF8(*parametersJSON);
	

	dispatch_async(dispatch_get_main_queue(), ^{

		NSString *tOrderStr = [NSString stringWithCString:tOrder.c_str() encoding:NSUTF8StringEncoding];
		NSString *tcurrencyStr = [NSString stringWithCString:tcurrency.c_str() encoding:NSUTF8StringEncoding];
		NSString *paramstStr = [NSString stringWithCString:paramst.c_str() encoding:NSUTF8StringEncoding];
		//OC市场插件支付事件上报
		[[HeroUsdkSupportiOSDelegate getInstance] logPurchaseWithOrderId:tOrderStr amount:amount currency:tcurrencyStr propertys:paramstStr] ;
	});
}

FString FPlatformManagerIOS::getUserName()
{
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit getUserName !"));
	

	//OC获取登录用户名
	NSString *userName = [[HeroUsdkSupportiOSDelegate getInstance] getUserName];
	return  FString(userName);
}

FString FPlatformManagerIOS::getUserId()
{
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit getUserId !"));
	
	//OC获取登录用户ID
	NSString *userID = [[HeroUsdkSupportiOSDelegate getInstance] getUserId] ;
	return FString(userID);
}

FString FPlatformManagerIOS::getSdkId()
{
	//OC获取ID（部分游戏使用@"id"字段作为唯一标示符）
	NSString *sdkID = [[HeroUsdkSupportiOSDelegate getInstance] getSdkId] ;
	return FString(sdkID);
}

FString FPlatformManagerIOS::getDeviceNum()
{
	NSString *deviceNum = [[HeroUsdkSupportiOSDelegate getInstance] getDeviceNum];
	return FString(deviceNum);
}

void FPlatformManagerIOS::getIDFA()
{
	[[HeroUPlatform sharedInstance] getIDFAWithCompletion:^(NSString * _Nonnull firstIdfa, NSString * _Nonnull currentIdfa, NSString * _Nonnull error) {
		NSLog(@"firstIdfa = %@, currentIdfa = %@, error = %@", firstIdfa, currentIdfa, error);
		HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onGetIDFAResultAction(FString(firstIdfa), FString(currentIdfa), FString(error));
	}];
}

void FPlatformManagerIOS::getIDFV()
{
	[[HeroUPlatform sharedInstance] getIDFVWithCompletion:^(NSString * _Nonnull firstIdfv, NSString * _Nonnull currentIdfv, NSString * _Nonnull error) {
		NSLog(@"firstIdfv = %@, currentIdfv = %@, error = %@", firstIdfv, currentIdfv, error);
		HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onGetIDFVResultAction(FString(firstIdfv), FString(currentIdfv), FString(error));
	}];
}

void FPlatformManagerIOS::logoutAndSowLoginView()
{
	dispatch_async(dispatch_get_main_queue(), ^{
		  //iOS【注销、退出登陆并显示账号历史界面】
		  [[HeroUsdkSupportiOSDelegate getInstance] logoutAndSowLoginView];
	  });
}

void FPlatformManagerIOS::postSplashScreenEndSuccess()
{
	dispatch_async(dispatch_get_main_queue(), ^{
		   //上报闪屏
		   [[HeroUsdkSupportiOSDelegate getInstance] postSplashScreenEndSuccess];
	   });
}

bool FPlatformManagerIOS::isChannelHasExitDialog()
{
	return false;
}

FString FPlatformManagerIOS::getCustomParams(FString key)
{
	return "";
}

bool FPlatformManagerIOS::callExtendApi(int extendType)
{
	return false;
}

void FPlatformManagerIOS::getOAID()
{
	//None
}

FString FPlatformManagerIOS::getChannelMsg()
{
	return TEXT("");
}

void FPlatformManagerIOS::GetGAID()
{
	//None
}

void FPlatformManagerIOS::GetAppSetID()
{
	//None
}

void FPlatformManagerIOS::exit()
{
	//None
}

void FPlatformManagerIOS::getGoogleSkuDetailsList(TArray<FString> gameGoodsList)
{
	//None
}

void FPlatformManagerIOS::setDisableMarketEvent(TMap<MARKET_EVENT, bool> bundle)
{
	//None
}

void FPlatformManagerIOS::getAppsflyerOneLinkUrl(const TMap<FString, FString>& bundle)
{
	//None
}

FString FPlatformManagerIOS::getAppsflyerOneLinkData()
{
	return "" ;
}

FString FPlatformManagerIOS::getAppsflyerUID()
{
	return "" ;
}

void FPlatformManagerIOS::reportAccountInfo(FString serverId, FString serverName, FString roleId, FString roleName,
	FString cpExt)
{
	//None
}


TSharedPtr<FJsonObject> FPlatformManagerIOS::HandleIosConfig(const TSharedPtr<FJsonObject>& OriginConfigObject)
{
	TSharedPtr<FJsonObject> CustomJsonObject = MakeShared<FJsonObject>();
	for (auto CurrJsonValue = OriginConfigObject->Values.CreateConstIterator(); CurrJsonValue; ++CurrJsonValue)
	{
		const FString Name = CurrJsonValue->Key;
		TSharedPtr< FJsonValue > Value = CurrJsonValue->Value;
		if (Name.StartsWith(TEXT("custom_"), ESearchCase::IgnoreCase))
		{
			UE_LOG(LogTemp, Warning, TEXT("Handle Custom Config Key: %s, Value: %s"), *Name, *Value->AsString());
			FString ProcessedKey = RemovePrefix(Name, TEXT("custom_"));
			CustomJsonObject->SetField(ProcessedKey, Value);
		}
		else if (Name.StartsWith(TEXT("bool_"), ESearchCase::IgnoreCase))
		{
			UE_LOG(LogTemp, Warning, TEXT("Handle Bool Config Key: %s, Value: %s"), *Name, *Value->AsString());
			FString ProcessedKey = RemovePrefix(Name, TEXT("bool_"));
			CustomJsonObject->SetStringField(ProcessedKey, *Value->AsString());
		}
		else if (Name.StartsWith(TEXT("base_"), ESearchCase::IgnoreCase))
		{
			UE_LOG(LogTemp, Warning, TEXT("Handle Base Config Key: %s, Value: %s"), *Name, *Value->AsString());
			FString ProcessedKey = RemovePrefix(Name, TEXT("base_"));
			CustomJsonObject->SetStringField(ProcessedKey, *Value->AsString());
		}
		else if (Name.StartsWith(TEXT("ext_"), ESearchCase::IgnoreCase))
		{
			UE_LOG(LogTemp, Warning, TEXT("Handle Ext Config Key: %s, Value: %s"), *Name, *Value->AsString());
			FString ProcessedKey = RemovePrefix(Name, TEXT("ext_"));
			CustomJsonObject->SetStringField(ProcessedKey, *Value->AsString());
		}
		else
		{
			CustomJsonObject->SetField(Name, Value);
		}
	}
	return CustomJsonObject;
}


FString FPlatformManagerIOS::RemovePrefix(const FString& InString, const FString& Prefix)
{
	if (InString.StartsWith(Prefix, ESearchCase::IgnoreCase))
	{
		return InString.RightChop(Prefix.Len());
	}

	return InString;
}

FHttpModule* FPlatformManagerIOS::GetHttpModule()
{
	static FHttpModule* httpModule;
	httpModule = &FHttpModule::Get();
	httpModule->SetHttpTimeout(60);
	httpModule->SetMaxReadBufferSize(1024 * 1024 * 50);
	httpModule->SetHttpDelayTime(0.001);
	return httpModule;
}

void FPlatformManagerIOS::CreatePostRequest(FString Url, const TMap<FString, FString>& Parameter,
                                            const FOnRequestComplete& RequestComplete)
{
	TSharedRef<IHttpRequest, ESPMode::ThreadSafe> ret_request = GetHttpModule()->CreateRequest();
	UE_LOG(LogHeroUsdk, Log, TEXT(" createPostReuquest : %s"), *Url);
	ret_request->SetURL(Url);
	ret_request->SetHeader(TEXT("Content-Type"), TEXT("application/x-www-form-urlencoded"));
	const FString bodyStr = GenPlatformRequestParam(Parameter);
	ret_request->SetContentAsString(bodyStr);
	ret_request->SetTimeout(30000);
	ret_request->SetVerb(TEXT("POST"));
	ret_request->OnProcessRequestComplete().BindLambda(
		[RequestComplete](FHttpRequestPtr HttpRequest, FHttpResponsePtr HttpResponse, bool bSuccess)
		{
			if (HttpResponse.IsValid())
			{
				const FString contentStr = HttpResponse->GetContentAsString();
				const int32 statusCode = HttpResponse->GetResponseCode();
				if (RequestComplete) { RequestComplete(statusCode, contentStr, bSuccess); }
			}
		});
	ret_request->ProcessRequest();
}

// void FPlatformManagerIOS::GenInitConfig(const TSharedPtr<FJsonObject>& JsonObject)
// {
//
//
// }

TMap<FString, FString> FPlatformManagerIOS::GetCommonParameter()
{
	TMap<FString, FString> commonMap;
	commonMap.Emplace("__e__", "1");
	
	const auto ChannelChina =  StaticCastSharedPtr<FIosMainlandConfig>(Config);

	commonMap.Emplace("productId", ChannelChina->productId);
	commonMap.Emplace("projectId", ChannelChina->projectId);
	commonMap.Emplace("serverId", ChannelChina->serverId);
	commonMap.Emplace("appKey", ChannelChina->appKey);
	commonMap.Emplace("appSecret", ChannelChina->appSecret);
	commonMap.Emplace("pkg", ChannelChina->package);

	FString dn = FPlatformMisc::GetLoginId().ToUpper();
	commonMap.Emplace("deviceNum", dn);
	commonMap.Emplace("platform", "pc");
	commonMap.Emplace("sdkVersion", HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version());
	
	//commonMap.Add("market", "PC");

	return commonMap;
}

FString FPlatformManagerIOS::GenPlatformRequestParam(const TMap<FString ,FString>& InParams)
{
	
	return TEXT("");
}
