﻿#pragma once
#include "Manager/HeroUsdkSupportPcDelegate.h"

class FBiliConfig : public FChannelConfigBase
{
public:
	virtual TMap<FString, FString> GetFormData() override
	{
		TMap<FString, FString> commonMap;
		commonMap.Emplace("cid", FString::FromInt(cid));
		commonMap.Emplace("channel", "bilibiliPC");

		return commonMap;
	}

	virtual TMap<FString, FString> GetJsParameter() override{ return {}; }
	virtual void Parse(const TSharedPtr< FJsonObject >& JsonObj) override
	{
		channel_merchant_id = JsonObj->GetStringField("channel_merchant_id");
		channel_app_id = JsonObj->GetStringField("channel_app_id");
		
		gameName = JsonObj->GetStringField("gameName");
		channel_server_id = JsonObj->GetStringField("channel_server_id");
		channel_server_name = JsonObj->GetStringField("channel_server_name");
		
		channel_app_key = JsonObj->GetStringField("channel_app_key");
		cid = JsonObj->GetIntegerField("cid");
		
		package = JsonObj->GetStringField("package");
	
	}

	FString GetCancelParam() override
	{
		FString result = {};
		return result;
	}

	EHeroUSDKChannel GetChannel() const override
	{
		return EHeroUSDKChannel::Bilibili; 
	}

	virtual FString GetProductId() const override
	{
		return {};
	}
	virtual FString GetGameId() const override
	{
		return channel_app_id;
	}

	virtual FString GetProductKey() const override
	{
		return channel_app_key;
	}
	FString channel_merchant_id;				
	FString channel_app_id;	                    
	FString channel_server_id;
	FString channel_server_name;
	FString channel_app_key;
};
