﻿#pragma once
#include "Manager/HeroUsdkSupportPcDelegate.h"

class FChinaConfig : public FChannelConfigBase
{
public:
	virtual TMap<FString, FString> GetFormData() override
	{
		TMap<FString, FString> commonMap;
		if (pcid>0)
		{
			commonMap.Emplace("cid", FString::FromInt(pcid));
			commonMap.Emplace("imgId", FString::FromInt(cid));
		}
		else
		{
			commonMap.Emplace("cid", FString::FromInt(cid));
		}
		
		commonMap.Emplace("channel", "heropc");

		return commonMap;
	}

	virtual TMap<FString, FString> GetJsParameter() override;
	virtual void Parse(const TSharedPtr< FJsonObject >& JsonObj) override
	{

		JsonObj->TryGetStringField("channel_product_id",productId);
		JsonObj->TryGetStringField("channel_project_id",projectId);
		JsonObj->TryGetStringField("channel_server_id",serverId);
		JsonObj->TryGetStringField("channel_app_key",appKey);
		JsonObj->TryGetStringField("channel_app_secret_key",appSecret );
		JsonObj->TryGetStringField("gameName",gameName);
		JsonObj->TryGetNumberField("cid",cid);
		JsonObj->TryGetNumberField("pcid",pcid);
		JsonObj->TryGetStringField("package",package);
		JsonObj->TryGetStringField("custom_themeStyle",custom_themeStyle);
	}

	FString GetCancelParam() override
	{
		FString result = "projectId=";
		result+=projectId;
		result+="&productId=";
		result+=productId;
		result+="&lang=";
		result+=HeroUsdkSupportPcDelegate::GetInstance()->GetCurrentLanguage();
		result+="&platform=pc";
		result+="&gameName=";
		result+=gameName;
		return result;
	}

	EHeroUSDKChannel GetChannel() const override
	{
		return EHeroUSDKChannel::China; 
	}

	virtual FString GetProductId() const override
	{
		return productId;
	}
	virtual FString GetGameId() const override
	{
		return productId;
	}

	virtual FString GetProductKey() const override
	{
		return appKey;
	}
	FString productId;						  //产品ID
	FString serverId;	                      //服务器ID
	FString appKey;							  //AppKey
	FString appSecret;                        //AppSecret

};
