﻿#include "GlobalConfig.h"
#include "HeroUsdkSupportKit.h"
#include "Manager/HeroUsdkSupportPcDelegate.h"

TMap<FString, FString> FGlobalConfig::GetJsParameter()
{
	//获取设置唯一标识符
	FString devicesID =FPlatformMisc::GetLoginId();
	FString sdkVersion = HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version() ;
	TMap<FString, FString> paramsDic ;
	//全球渠道
	
	
	paramsDic.Emplace("gid",		game_id);
	paramsDic.Emplace("pcode",		product_code);
	paramsDic.Emplace("projectId",	projectId);
	paramsDic.Emplace("pk",			package);
	paramsDic.Emplace("vc","");
	paramsDic.Emplace("svc","");
	paramsDic.Emplace("svn", sdkVersion);
	paramsDic.Emplace("plat","2");
	paramsDic.Emplace("dn", devicesID);
	paramsDic.Emplace("custom_themeStyle",custom_themeStyle);
	paramsDic.Emplace("gameName",gameName);
	paramsDic.Emplace("appKey", product_key);

	
	FString lang  = HeroUsdkSupportPcDelegate::GetInstance()->GetCurrentLanguage();

	if (lang.Len()) {
		paramsDic.Emplace("lang",lang);
	}

	if (gameLogo.Len())
	{
		paramsDic.Emplace("gameLogo",gameLogo);
	}
	if (facebookID.Len())
	{
		paramsDic.Emplace("facebookID",facebookID);
	}
	if (googleID.Len())
	{
		paramsDic.Emplace("googleID",googleID);
	}
	if (globalServerUrl.Len())
	{
		paramsDic.Emplace("globalServerUrl",globalServerUrl);
	}
	paramsDic.Emplace("engine", "ue4");
	return paramsDic ;
}

