﻿#pragma once
#include "Manager/HeroUsdkSupportPcDelegate.h"

class FGlobalConfig: public FChannelConfigBase
{
public:

	virtual TMap<FString, FString> GetFormData() override
	{
		 TMap<FString, FString> commonMap;
		
		commonMap.Emplace("cid",FString::FromInt(cid) );
		commonMap.Emplace("channel", "heroglobalpc");

		return commonMap;
	}

	virtual TMap<FString, FString> GetJsParameter() override;
	virtual void Parse(const TSharedPtr< FJsonObject >& JsonObj) override
	{
		game_id = JsonObj->GetStringField("global_game_id");
		product_code = JsonObj->GetStringField("global_product_code");
		projectId = JsonObj->GetStringField("global_project_id");
		package = JsonObj->GetStringField("package");
		product_key = JsonObj->GetStringField("global_product_key");
		cid = JsonObj->GetIntegerField("cid");
		gameName = JsonObj->GetStringField("gameName");
		gameLogo = JsonObj->GetStringField("hgsdk_logo_img");
		facebookID = JsonObj->GetStringField("global_fb_app_id");
		googleID = JsonObj->GetStringField("global_google_web_id");
		globalServerUrl = JsonObj->GetStringField("global_server_address");
		custom_themeStyle = JsonObj->GetStringField("custom_themeStyle");

	}

	FString GetCancelParam() override
	{
		FString result ="lang=";
		result+=HeroUsdkSupportPcDelegate::GetInstance()->GetCurrentLanguage();
		result+="&platform=pc";
		result+="&gameName=";
		result+=gameName;
		return result;
	}

	EHeroUSDKChannel GetChannel() const override
	{
		return EHeroUSDKChannel::Global; 
	}

	virtual FString GetProductId() const override
	{
		return product_code;
	}

	virtual FString GetGameId() const override
	{
		return game_id;
	}

	virtual FString GetProductKey() const override
	{
		return product_key;
	}

	
	FString game_id;                              //游戏ID
	FString product_code;		                      //产品ID


	FString product_key; 					      //AppKey
	FString gameLogo; 	                      //游戏logo
	FString facebookID;                       //facebookAppID 
	FString googleID;                         //Google Client ID
	FString globalServerUrl;	              //全球服务器地址
};
