﻿#pragma once

class FSteamConfig : public FChannelConfigBase
{
public:

	virtual TMap<FString, FString> GetFormData() override
	{
		TMap<FString, FString> commonMap;
		commonMap.Emplace("cid", FString::FromInt(cid) );
		commonMap.Emplace("channel", "steam");

		return commonMap;
	}

	virtual TMap<FString, FString> GetJsParameter() override
	{
		return {};
	}
	virtual void Parse(const TSharedPtr< FJsonObject >& JsonObj) override
	{
		package = JsonObj->GetStringField("package");
		gameName = JsonObj->GetStringField("gameName");
		app_id = JsonObj->GetStringField("app_id");
		cid = JsonObj->GetIntegerField("cid");
		

	}

	FString GetCancelParam() override
	{
		return {};
	}

	EHeroUSDKChannel GetChannel() const override
	{
		return EHeroUSDKChannel::Steam; 
	}

	virtual FString GetProductId() const override
	{
		return {};
	}

	virtual FString GetGameId() const override
	{
		return {};
	}

	virtual FString GetProductKey() const override
	{
		return {};
	}
	FString package;                              //游戏包名				
	FString app_id;								//SteamDevAppId

};
