﻿#pragma once
#include "Config/Channel/China/ChinaConfig.h"
#include "Dom/JsonObject.h"

class FWeGameConfig:public FChinaConfig
{
public:
    typedef FChinaConfig Supper;
    virtual TMap<FString, FString> GetFormData() override
    {
        TMap<FString, FString> commonMap;
        commonMap.Emplace("cid", FString::FromInt(cid));
        commonMap.Emplace("channel", "herowegame");

        return commonMap;
    }


    
    virtual void Parse(const TSharedPtr< FJsonObject >& JsonObj) override
    {
        Supper::Parse(JsonObj);
        JsonObj->TryGetStringField("gameName",gameName);
        JsonObj->TryGetStringField("game_id",game_id);
        JsonObj->TryGetNumberField("cid",cid);
    }

   

    EHeroUSDKChannel GetChannel() const override
    {
        return EHeroUSDKChannel::WeGame; 
    }
    
    FString game_id;
};
