﻿#include "AnalyticsRunnable.h"
#include "HttpModule.h"
#include "LogHeroUsdk.h"


bool FAnalyticsRunnable::Init()
{
	LastPosTime = FDateTime::Now();
	FilePath = FPaths::Combine(FPaths::ProjectSavedDir(),TEXT("PCsdk"),TEXT("Dot"),TEXT("DotData")); 
	if(! FPaths::FileExists(FilePath))
	{
		FFileHelper::SaveStringToFile(TEXT(""),*FilePath);
	}
	else
	{
		FString Cache;
		FFileHelper::LoadFileToString(Cache,*FilePath);
		TArray<FString> CachedMsgArray;
		Cache.ParseIntoArray(CachedMsgArray,*Separator, false);
		for(const auto& Msg:CachedMsgArray)
		{
			if(!Msg.IsEmpty())
			{
				TaskQueue.Enqueue(Msg);
			}
		
		}
	}
	return true;
}

uint32 FAnalyticsRunnable::Run()
{
	while (bRun)
	{
		if(!bIsPaused)
		{
			const double timeInterval = (FDateTime::Now()-LastPosTime).GetTotalSeconds();
			if(timeInterval>1.0)
			{
				Flush();
			}
			else if(TaskNum>FlushBulkSize)
			{
				Flush();
			}
		}
		else
		{
			FPlatformProcess::Sleep(0.1f);
		}
	}
	return 0;
}

TArray<FString> FAnalyticsRunnable::GetReportDatas()
{
	TArray<FString> TaskArray;
	
	for(int32 i = TaskArray.Num();i<FlushBulkSize &&!TaskQueue.IsEmpty();++i)
	{
		FString Json;
		TaskQueue.Dequeue(Json);
		TaskArray.Add(Json);
		--TaskNum;
	}
	
	TArray<FString> RemainArray;
	if (TaskQueue.IsEmpty())
	{
		bIsPaused = true;
		FFileHelper::SaveStringToFile(TEXT(""),*FilePath);
		return TaskArray;
	}
	else
	{
		FString Json;
		TaskQueue.Dequeue(Json);
		RemainArray.Add(Json);
	}

	for(const auto& remainMsg:RemainArray)
	{
		TaskQueue.Enqueue(remainMsg);
	}
	FString saveData = FString::Join(RemainArray,TEXT(""));
	FFileHelper::SaveStringToFile(saveData,*FilePath);

	return TaskArray;
}

static void OnHttpResponse(FHttpRequestPtr Request, FHttpResponsePtr Response, bool bConnectedSuccessfully,
	TArray<FString> PayLoad)
{
	if (!bConnectedSuccessfully || !Response.IsValid())
	{
		UE_LOG(LogHeroUsdk, Error, TEXT("Dot Reprot response is not valid"))
		return;
	}
	UE_LOG(LogHeroUsdk,Log,TEXT("Dot Reprot:%d,response data:%s"),Response->GetResponseCode(),*Response->GetContentAsString())
}


void FAnalyticsRunnable::Flush()
{
	TArray<FString> TaskArray = GetReportDatas();
	

	const FString Data= FAnalyticsTools::Merge2JsonArray(TaskArray);

	const auto CompressData = FAnalyticsTools::EncryptAndCompress(Data);

	const auto HttpRequest = FHttpModule::Get().CreateRequest();
	HttpRequest->SetURL(FAnalyticsTools::GetReportUrl());
	HttpRequest->SetVerb(TEXT("POST"));
	HttpRequest->SetHeader(TEXT("Content-Type"), TEXT("application/octet-stream"));
	HttpRequest->SetHeader(TEXT("Content-Encoding"), TEXT("gzip"));
	HttpRequest->SetContent(CompressData);
	HttpRequest->OnProcessRequestComplete().BindStatic(OnHttpResponse,TaskArray);
	HttpRequest->ProcessRequest();
}



void FAnalyticsRunnable::AddTask(const FString& EventJsonStr)
{
	TaskQueue.Enqueue(EventJsonStr);
	FFileHelper::SaveStringToFile(EventJsonStr+Separator,*FilePath, FFileHelper::EEncodingOptions::AutoDetect,&IFileManager::Get(),FILEWRITE_Append);
	++TaskNum;
	bIsPaused = false;
}

void FAnalyticsRunnable::Exit()
{
	bRun = false;
}

void FAnalyticsRunnable::Stop()
{
	bRun = false;
}

