﻿#pragma once
#include "AnalyticsTools.h"
#include "HttpModule.h"
#include "Interfaces/IHttpResponse.h"

class FAnalyticsRunnable: public FRunnable
{
public:
	FAnalyticsRunnable():bIsPaused(true),TaskNum(0)
	{
		Thread = FRunnableThread::Create(this, TEXT("FUsdkAnalyticsRunnable"), 0, TPri_Normal);
	}
	virtual ~FAnalyticsRunnable() override
	{
		delete Thread;
	}

	virtual bool Init() override;
	virtual uint32 Run() override;

	TArray<FString> GetReportDatas();


	void Flush();

	
	void AddTask(const FString& EventJsonStr);
	
	virtual void Exit() override;
	virtual void Stop() override;

private:
	FString FilePath;
	TAtomic<bool>  bIsPaused;
	TAtomic<int32> TaskNum;
	bool bRun = true;
	TQueue<FString> TaskQueue;
	float duration = 0.f;
	int32 FlushBulkSize =100;
	FDateTime LastPosTime;
	FRunnableThread* Thread = nullptr;
	FString Separator = TEXT("##pad##\r\n");
};

