#include "AnalyticsTools.h"

#include "EncryptionContextOpenSSL.h"
#include "Manager/Usdk/UsdkManager.h"
#include "HeroUsdkSupportKit.h"
#include "Setting/UsdkSettings.h"
#include <string>

#include "LogHeroUsdk.h"
#include "Manager/HeroUsdkSupportPcDelegate.h"


FString FAnalyticsTools::GetReportUrl()
{
	FString ReportUrl;
#if 1
	const auto Setting = GetMutableDefault<UUsdkSettings>();
	if(Setting->Channel == EHeroUSDKChannel::China)
	{
		ReportUrl = TEXT("https://data-track.yingxiong.com");
	}
	else
	{
		ReportUrl = TEXT("https://data-track-global.yingxiong.com");
	}
#else
	ReportUrl = TEXT("http://data-ftp.yingxiong.com");
	//ReportUrl = TEXT("http://10.22.3.237:19530");
#endif

	ReportUrl +=TEXT("/v3/track/pc/data");
	ReportUrl +=TEXT("?app_id=");
	ReportUrl+= HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->package;
	ReportUrl +=TEXT("&cid=");
	ReportUrl+= FString::FromInt( HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->GetChannelId());
	ReportUrl +=TEXT("&sdk_version=");
	ReportUrl +=HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version();
	UE_LOG(LogHeroUsdk,Log,TEXT("Dot report url:%s"),*ReportUrl);
	return ReportUrl;
}

FString FAnalyticsTools::Merge2JsonArray(const TArray<FString>& TaskArray)
{
	FString Data;
	TArray< TSharedPtr<FJsonValue> > DataArray;
	for (int i = 0; i < TaskArray.Num(); i++)
	{
		TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
		TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(TaskArray[i]);
		FJsonSerializer::Deserialize(Reader, JsonObject);
		DataArray.Add( MakeShareable(new FJsonValueObject(JsonObject)));
	}

	auto Writer = TJsonWriterFactory<TCHAR,TCondensedJsonPrintPolicy<TCHAR>>::Create(&Data);
	FJsonSerializer::Serialize(DataArray, Writer);
	return Data;
}

TArray<uint8>  FAnalyticsTools::EncryptAndCompress(const FString& Data)
{
	const FString Base64Str = Base64Encode(AES_256_CBC(Data));

	return GzipCompress(Base64Str);
}


TArray<uint8> FAnalyticsTools::AES_256_CBC(const FString& Data)
{
	
	const std::string std_data = TCHAR_TO_UTF8(*Data);
	
	const std::string keyChar = "c20t20hh5a465ft1c20t20hh5a465ft1";
	auto t = keyChar.c_str();
	const TArray<uint8> Key{( uint8*)keyChar.c_str(),(int32)keyChar.length()};
	const TArray<uint8>  iv{(const uint8*)keyChar.c_str(),(int32)keyChar.length()/2} ;
	

	TArray<uint8> plainText{(uint8*)std_data.c_str(),(int32)std_data.length()};
	EPlatformCryptoResult CryptoResult;
	FEncryptionContextOpenSSL Encryption;
	TArray<uint8> ResultArray = Encryption.Encrypt_AES_256_CBC(plainText,Key,iv,CryptoResult);
	return ResultArray;
}

FString FAnalyticsTools::Base64Encode(const TArray<uint8>& Data)
{
	return FBase64::Encode(Data);
}

TArray<uint8> FAnalyticsTools::GzipCompress(const FString& UnprocessedStr)
{
	// Compatible with Chinese
	const FTCHARToUTF8 ToUtf8Converter(UnprocessedStr.GetCharArray().GetData());
		
	//GZip压缩数据
	int32 CompressBufferLen = FCompression::CompressMemoryBound(NAME_Gzip, ToUtf8Converter.Length());
	void* CompressBuffer = FMemory::Malloc(CompressBufferLen);
	bool Result = FCompression::CompressMemory(NAME_Gzip, CompressBuffer, CompressBufferLen,  ToUtf8Converter.Get(),
											   ToUtf8Converter.Length(), ECompressionFlags::COMPRESS_BiasSpeed);

	TArray<uint8> ResultArray;
	if (Result)
	{
		//auto temp = std::string((char*)CompressBuffer,CompressBufferLen);
		ResultArray = {(uint8*)CompressBuffer,CompressBufferLen};
	}
	FMemory::Free(CompressBuffer);
	return ResultArray;
}
