#include "DotManager.h"

#include "Tools/UsdkCommonTools.h"
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
#include "Manager/Usdk/UsdkManager.h"
#include "HeroUsdkSupportKit.h"
#include "Manager/HeroUsdkSupportPcDelegate.h"
#include "LogHeroUsdk.h"
#include "Setting/UsdkSettings.h"
#include "SocketSubsystem.h"
#endif


int64 GetUtcNowUnixMillisecondTimestamp()
{
	const auto result = (FDateTime::UtcNow().GetTicks() - FDateTime(1970, 1, 1).GetTicks() )/ ETimespan::TicksPerMillisecond;
	return  result;
}

void FDotManager::Register()
{
#if UE_SERVER
	return;
#endif

#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	Runnable = MakeShared<FAnalyticsRunnable>();
	session_id = FGuid::NewGuid().ToString();
	session_time = GetUtcNowUnixMillisecondTimestamp();
#endif
}

void FDotManager::UnRegister()
{
#if UE_SERVER
	return;
#endif
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	if(Runnable)
	{
		Runnable->Stop();
		Runnable = nullptr;
	}
	session_id.Empty();
	session_time = 0;
	_first_time = -1;
#endif
}

void FDotManager::CallDot(const FString& eventId, const TMap<FString, FString>& eventProperties, const double event_duration)
{
#if UE_SERVER
	return;
#endif
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	auto DotString = MakeDot(eventId,eventProperties,event_duration);
	if(Runnable)
	{
		Runnable->AddTask(DotString);
	}
#endif
}

void FDotManager::CallWebDot(const FString& eventId, const TSharedPtr<FJsonObject>& jsonObj, const double event_duration)
{
#if UE_SERVER
	return;
#endif
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	auto DotString = MakeWebDot(eventId,jsonObj,event_duration);
	if(Runnable)
	{
		Runnable->AddTask(DotString);
	}
#endif
}

FString FDotManager::MakeDot(const FString& eventId, const TMap<FString,FString>& eventProperties, const double event_duration)
{
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	FString JsonStr;
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject());
	JsonObject->SetStringField(TEXT("event"),eventId);
	JsonObject->SetStringField(TEXT("event_uuid"),FGuid::NewGuid().ToString());
	JsonObject->SetStringField(TEXT("session_id"),session_id);

	auto currentTime = GetUtcNowUnixMillisecondTimestamp();
	JsonObject->SetNumberField(TEXT("session_time"),currentTime- session_time);

	JsonObject->SetNumberField(TEXT("time"),currentTime);
	JsonObject->SetNumberField(TEXT("microsecond_time"),currentTime*1000);
	JsonObject->SetBoolField(TEXT("is_amend_time"),false);

	{
		TSharedPtr<FJsonObject> libObject = MakeShareable(new FJsonObject());
		libObject->SetStringField("$lib","ue");
		libObject->SetStringField("$lib_method","autoTrack");
		libObject->SetStringField("$lib_version",HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version());
		JsonObject->SetObjectField(TEXT("lib"),libObject);
		
	}

	 {
		TSharedPtr<FJsonObject> commonPropertiesObject = MakeShareable(new FJsonObject());
		

		auto config = HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig();
		FString appName = config->package;


		commonPropertiesObject->SetStringField("$app_id",appName);
		commonPropertiesObject->SetStringField("$app_name",appName);
		commonPropertiesObject->SetStringField("$app_version","");
		commonPropertiesObject->SetStringField("$carrier","");
		commonPropertiesObject->SetStringField("$device_id",FPlatformMisc::GetLoginId().ToUpper());
		commonPropertiesObject->SetStringField("$channel_device_id",FPlatformMisc::GetLoginId().ToUpper());
		commonPropertiesObject->SetStringField("$usdk_device_id",FPlatformMisc::GetLoginId().ToUpper());
		commonPropertiesObject->SetStringField("$hgsdk_device_id",FPlatformMisc::GetLoginId().ToUpper());
		commonPropertiesObject->SetNumberField("$total_duration",event_duration);

        const int64_t initTime = GetFirstTime();
       
        if(GetFirstTime() == -1)
        {
            InitFirstTime();
        }

		/*
		auto now1 = FDateTime::Now().ToString();
		auto temp = FDateTime(FDateTime(1970, 1, 1).GetTicks()+initTime*ETimespan::TicksPerMillisecond).ToString();
		auto now = FDateTime(FDateTime(1970, 1, 1).GetTicks()+currentTime*ETimespan::TicksPerMillisecond).ToString();
		*/
		
        const FTimespan  timeSpawn= (currentTime - GetFirstTime())*ETimespan::TicksPerMillisecond;
        auto day = timeSpawn.GetDays();
        const bool is_first_day = day == 0;
        const bool is_first_time = initTime == -1;
        commonPropertiesObject->SetBoolField("$is_first_day",is_first_day);
        commonPropertiesObject->SetBoolField("$is_first_time",is_first_time);
        commonPropertiesObject->SetStringField( "$manufacturer","windows");
        commonPropertiesObject->SetStringField( "$model","");
        commonPropertiesObject->SetStringField( "$network_type","");
        
        commonPropertiesObject->SetStringField( "$os","Windows");
        commonPropertiesObject->SetStringField( "$os_version",FPlatformMisc::GetOSVersion());

		bool bCanBindAll;
		TSharedPtr<class FInternetAddr> Addr = ISocketSubsystem::Get(PLATFORM_SOCKETSUBSYSTEM)->GetLocalHostAddr(*GLog, bCanBindAll);
		FString MyIP = Addr->ToString(false); 
        commonPropertiesObject->SetStringField( "$ip",MyIP);

		
		auto setting = GetMutableDefault<UUsdkSettings>();
		if (setting->Channel == EHeroUSDKChannel::China)
		{
			commonPropertiesObject->SetStringField( "$project_id", HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->GetProjectId());
			commonPropertiesObject->SetStringField( "$product_id", HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->GetProductId());
		}
		else if (setting->Channel == EHeroUSDKChannel::China)
		{
			commonPropertiesObject->SetStringField( "$hgsdk_project_id", HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->GetProjectId());
			commonPropertiesObject->SetStringField( "$hgsdk_product_id", HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->GetProductId());
	
		}
		commonPropertiesObject->SetStringField( "$usdk_project_id", "");
		commonPropertiesObject->SetStringField( "$usdk_product_id", HeroUsdkSupportKit::GetInstance().GetProductId());
		
        commonPropertiesObject->SetStringField( "$screen_height","");
        commonPropertiesObject->SetStringField( "$screen_orientation","");
        commonPropertiesObject->SetStringField( "$screen_width","");



		FTimespan UTCOffset = FDateTime::Now() - FDateTime::UtcNow();
		int32 offset = - FMath::RoundToInt(UTCOffset.GetTotalSeconds() / 60);
        
        commonPropertiesObject->SetNumberField( "$timezone_offset", offset);
        commonPropertiesObject->SetStringField( "$lang",FPlatformMisc::GetDefaultLanguage());
   
		
		commonPropertiesObject->SetStringField( "$usdk_project_id", "");
	
		
		commonPropertiesObject->SetStringField("$usdk_version",HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version());
		commonPropertiesObject->SetStringField("$hgsdk_version",HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version());
		commonPropertiesObject->SetStringField("$cnsdk_version",HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version());
		commonPropertiesObject->SetStringField("$af_version","");
		commonPropertiesObject->SetStringField("$channel_version",HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version());
        commonPropertiesObject->SetStringField( "$appsflyer_id","");

        commonPropertiesObject->SetStringField( "$push_token","");
        commonPropertiesObject->SetStringField("$push_type","");
		JsonObject->SetObjectField(TEXT("commonProperties"),commonPropertiesObject);
    }
	{
		TSharedPtr<FJsonObject> gamePropertiesObject = MakeShareable(new FJsonObject());
	
		gamePropertiesObject->SetStringField("game_id", HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->GetGameId());
		gamePropertiesObject->SetStringField("channel_id", FString::FromInt(HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->GetChannelId()));
	



		gamePropertiesObject->SetStringField( "user_id", HeroUsdkSupportPcDelegate::GetInstance()->GetUserInfo().sdkUserId);
		auto RoleInfo = HeroUsdkSupportPcDelegate::GetInstance()->GetRoleInfo();
		gamePropertiesObject->SetStringField( "role_id", RoleInfo.roleId);
		gamePropertiesObject->SetStringField( "role_name", RoleInfo.roleName);
		gamePropertiesObject->SetStringField( "server_id", RoleInfo.serverId);
		gamePropertiesObject->SetStringField( "server_name", RoleInfo.serverName);
		JsonObject->SetObjectField(TEXT("gameProperties"),gamePropertiesObject);
	}
	
	if(eventProperties.Num()>0)
	{
		TSharedPtr<FJsonObject> eventPropertiesObject = MakeShareable(new FJsonObject());
		for(const auto& pair :eventProperties)
		{
			eventPropertiesObject->SetStringField(pair.Key,pair.Value);
		}
		JsonObject->SetObjectField(TEXT("eventProperties"),eventPropertiesObject);
	}
		
	
	auto jsonWriter = TJsonWriterFactory<TCHAR,TCondensedJsonPrintPolicy<TCHAR>>::Create(&JsonStr);
	FJsonSerializer::Serialize(JsonObject.ToSharedRef(), jsonWriter);
	UE_LOG(LogHeroUsdk,Log,TEXT("Dot Data:%s"),*JsonStr);
	return JsonStr;
#endif
	return "";
}

FString FDotManager::MakeWebDot(const FString& eventId, const TSharedPtr<FJsonObject>& jsonObj, const double event_duration)
{
	#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	FString JsonStr;
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject());
	JsonObject->SetStringField(TEXT("event"),eventId);
	JsonObject->SetStringField(TEXT("event_uuid"),FGuid::NewGuid().ToString());
	JsonObject->SetStringField(TEXT("session_id"),session_id);

	auto currentTime = GetUtcNowUnixMillisecondTimestamp();
	JsonObject->SetNumberField(TEXT("session_time"),currentTime- session_time);

	JsonObject->SetNumberField(TEXT("time"),currentTime);
	JsonObject->SetNumberField(TEXT("microsecond_time"),currentTime);
	JsonObject->SetBoolField(TEXT("is_amend_time"),false);

	{
		TSharedPtr<FJsonObject> libObject = MakeShareable(new FJsonObject());
		libObject->SetStringField("$lib","ue");
		libObject->SetStringField("$lib_method","autoTrack");
		libObject->SetStringField("$lib_version",HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version());
		JsonObject->SetObjectField(TEXT("lib"),libObject);
		
	}

	 {
		TSharedPtr<FJsonObject> commonPropertiesObject = MakeShareable(new FJsonObject());
		

		FString appName = HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->package;
		
		commonPropertiesObject->SetStringField("$app_id",appName);
		commonPropertiesObject->SetStringField("$app_name",appName);
		commonPropertiesObject->SetStringField("$app_version","");
		commonPropertiesObject->SetStringField("$carrier","");
		commonPropertiesObject->SetStringField("$device_id",FPlatformMisc::GetLoginId().ToUpper());
		commonPropertiesObject->SetStringField("$channel_device_id",FPlatformMisc::GetLoginId().ToUpper());
		commonPropertiesObject->SetStringField("$usdk_device_id",FPlatformMisc::GetLoginId().ToUpper());
		commonPropertiesObject->SetStringField("$hgsdk_device_id",FPlatformMisc::GetLoginId().ToUpper());
		commonPropertiesObject->SetNumberField("$total_duration",event_duration);

        const int64_t initTime = GetFirstTime();
       
        if(GetFirstTime() == -1)
        {
            InitFirstTime();
        }
        const FTimespan  timeSpawn= currentTime - initTime;
        auto day = timeSpawn.GetDays();
        const bool is_first_day =day >=0?true:false;
        const bool is_first_time = (initTime == -1?true:false);
        commonPropertiesObject->SetBoolField("$is_first_day",is_first_day);
        commonPropertiesObject->SetBoolField("$is_first_time",is_first_time);
        commonPropertiesObject->SetStringField( "$manufacturer","windows");
        commonPropertiesObject->SetStringField( "$model","");
        commonPropertiesObject->SetStringField( "$network_type","");
        
        commonPropertiesObject->SetStringField( "$os","Windows");
        commonPropertiesObject->SetStringField( "$os_version",FPlatformMisc::GetOSVersion());

		bool bCanBindAll;
		TSharedPtr<class FInternetAddr> Addr = ISocketSubsystem::Get(PLATFORM_SOCKETSUBSYSTEM)->GetLocalHostAddr(*GLog, bCanBindAll);
		FString MyIP = Addr->ToString(false); 
        commonPropertiesObject->SetStringField( "$ip",MyIP);
		
		auto setting = GetMutableDefault<UUsdkSettings>();
		if (setting->Channel == EHeroUSDKChannel::China)
		{
			commonPropertiesObject->SetStringField( "$project_id", HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->GetProjectId());
			commonPropertiesObject->SetStringField( "$product_id", HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->GetProductId());
		}
		else if (setting->Channel == EHeroUSDKChannel::China)
		{
			commonPropertiesObject->SetStringField( "$hgsdk_project_id", HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->GetProjectId());
			commonPropertiesObject->SetStringField( "$hgsdk_product_id", HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->GetProductId());
	
		}
		commonPropertiesObject->SetStringField( "$usdk_project_id", "");
		commonPropertiesObject->SetStringField( "$usdk_product_id", HeroUsdkSupportKit::GetInstance().GetProductId());
		
        commonPropertiesObject->SetStringField( "$screen_height","");
        commonPropertiesObject->SetStringField( "$screen_orientation","");
        commonPropertiesObject->SetStringField( "$screen_width","");



		FTimespan UTCOffset = FDateTime::Now() - FDateTime::UtcNow();
		int32 offset = - FMath::RoundToInt(UTCOffset.GetTotalSeconds() / 60);
        
        commonPropertiesObject->SetNumberField( "$timezone_offset", offset);
        commonPropertiesObject->SetStringField( "$lang",FPlatformMisc::GetDefaultLanguage());
   
		
		
		commonPropertiesObject->SetStringField( "$usdk_project_id", "");
	
		
		
		commonPropertiesObject->SetStringField("$usdk_version",HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version());
		commonPropertiesObject->SetStringField("$hgsdk_version",HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version());
		commonPropertiesObject->SetStringField("$cnsdk_version",HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version());
		commonPropertiesObject->SetStringField("$af_version","");
		commonPropertiesObject->SetStringField("$channel_version",HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version());
        commonPropertiesObject->SetStringField( "$appsflyer_id","");

        commonPropertiesObject->SetStringField( "$push_token","");
        commonPropertiesObject->SetStringField("$push_type","");
		JsonObject->SetObjectField(TEXT("commonProperties"),commonPropertiesObject);
    }
	{
		TSharedPtr<FJsonObject> gamePropertiesObject = MakeShareable(new FJsonObject());
	
		gamePropertiesObject->SetStringField("game_id", HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->GetGameId());
		gamePropertiesObject->SetStringField("channel_id", FString::FromInt(HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->GetChannelId()));
		
		gamePropertiesObject->SetStringField( "user_id", HeroUsdkSupportPcDelegate::GetInstance()->GetUserInfo().sdkUserId);
		auto RoleInfo = HeroUsdkSupportPcDelegate::GetInstance()->GetRoleInfo();
		gamePropertiesObject->SetStringField( "role_id", RoleInfo.roleId);
		gamePropertiesObject->SetStringField( "role_name", RoleInfo.roleName);
		gamePropertiesObject->SetStringField( "server_id", RoleInfo.serverId);
		gamePropertiesObject->SetStringField( "server_name", RoleInfo.serverName);
		JsonObject->SetObjectField(TEXT("gameProperties"),gamePropertiesObject);
	}
	
	
	JsonObject->SetObjectField(TEXT("eventProperties"),jsonObj);
	
		
	
	auto jsonWriter = TJsonWriterFactory<TCHAR,TCondensedJsonPrintPolicy<TCHAR>>::Create(&JsonStr);
	FJsonSerializer::Serialize(JsonObject.ToSharedRef(), jsonWriter);
	UE_LOG(LogHeroUsdk,Log,TEXT("Dot Data:%s"),*JsonStr);
	return JsonStr;
#endif
	return "";
}

int64 FDotManager::GetFirstTime()
{
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	if(_first_time == -1)
	{
		auto firstTimeStr = FUsdkCommonTools::ReadTextByPath("firstTime");
		if(firstTimeStr.Len()>0)
		{
			_first_time = FCString::Atoi64(*firstTimeStr); 
		}
	}
#endif
	return _first_time;
}

void FDotManager::InitFirstTime()
{
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	_first_time=GetUtcNowUnixMillisecondTimestamp();
	FString TimeStamp = FString::Printf(TEXT("%lld"),_first_time );
	FUsdkCommonTools::WriteText("firstTime",TimeStamp);
#endif
}
