#pragma once
#include "AnalyticsRunnable.h"

class FDotManager
{
public:
	static FDotManager& GetInstance()
	{
		static FDotManager inst;
		return inst;
	}

	void Register();

	void UnRegister();

	void CallDot(const FString& eventId ,const TMap<FString,FString>& eventProperties={}, const double event_duration = 0.0);
	void CallWebDot(const FString& eventId ,const TSharedPtr<FJsonObject>& jsonObj = {}, const double event_duration = 0.0);
private:
	FString MakeDot(const FString& eventId ,const TMap<FString,FString>& eventProperties, const double event_duration);
	FString MakeWebDot(const FString& eventId ,const TSharedPtr<FJsonObject>& jsonObj, const double event_duration);
	int64 GetFirstTime();
	void InitFirstTime();
private:
	FString session_id;
	int64 session_time = 0;
	int64 _first_time = -1;
	TSharedPtr<FAnalyticsRunnable> Runnable;
};
