#include "ChannelManagerBase.h"
#include "HttpModule.h"
#include "LogHeroUsdk.h"
#include "Interfaces/IHttpResponse.h"
#include "Tool/Archive/RuntimeArchiverBase.h"
#include "Tool/Archive/ArchiverZip/RuntimeArchiverZip.h"

void FChannelManagerBase::QueryWebVersion(const FString& LocalPath)
{
	const FString Url = GetQueryVersionUrl();
	const auto request = FHttpModule::Get().CreateRequest();
	UE_LOG(LogHeroUsdk, Log, TEXT("query web version url:%s, local save path: %s"), *Url,*LocalPath);
	request->SetURL(Url);
	request->SetHeader(TEXT("Content-Type"), TEXT("application/x-www-form-urlencoded"));
	request->SetTimeout(8);
	request->SetVerb(TEXT("GET"));
	request->OnProcessRequestComplete().BindLambda([this,LocalPath]( FHttpRequestPtr Request, FHttpResponsePtr Response, bool bConnectedSuccessfully)
	{
		if(bConnectedSuccessfully && Response->GetResponseCode() == EHttpResponseCodes::Ok)
		{
			auto RemoteVersion = Response->GetContentAsString();
			FString LocalVersion;
			FFileHelper::LoadFileToString(LocalVersion,*LocalPath);
			UE_LOG(LogHeroUsdk,Log,TEXT("RemoteWebVersion:%s,LocalVersion:%s"),*RemoteVersion,*LocalVersion);
			if(LocalVersion == RemoteVersion)
			{
				return;
			}
			
			DownLoadWebFile(GetWebBaseMidDir());
		}
	});
	request->ProcessRequest();
}

void FChannelManagerBase::DownLoadWebFile(const FString& StorePath)
{
	const auto RemoteUrl = GetDownLoadWebUrl();
	UE_LOG(LogHeroUsdk,Log,TEXT("Url:%s, DownLoadWebFile to:%s"),*RemoteUrl,*StorePath);
	const auto request = FHttpModule::Get().CreateRequest();
	request->SetURL(RemoteUrl);
	request->SetHeader(TEXT("Content-Type"), TEXT("application/octet-stream"));
	request->SetTimeout(8);
	request->SetVerb(TEXT("GET"));
	request->OnProcessRequestComplete().BindLambda([this,StorePath]( FHttpRequestPtr Request, FHttpResponsePtr Response, bool bConnectedSuccessfully)
	{
		if(bConnectedSuccessfully && Response->GetResponseCode() == EHttpResponseCodes::Ok)
		{
#if UE_EDITOR
			URuntimeArchiverBase* RuntimeArchiver = URuntimeArchiverBase::CreateRuntimeArchiver(GEngine, URuntimeArchiverZip::StaticClass());
#else
			URuntimeArchiverBase* RuntimeArchiver = URuntimeArchiverBase::CreateRuntimeArchiver(Subsystem, URuntimeArchiverZip::StaticClass());
#endif
			UE_LOG(LogHeroUsdk,Log,TEXT("DownLoadWebFile Response Code:%d, Response Content length:%d"),Response->GetResponseCode(),Response->GetContent().Num());
			const FString ZipPath = FPaths::Combine(StorePath,TEXT("dist.zip"));
			FFileHelper::SaveArrayToFile(Response->GetContent(),*ZipPath);
			if(!RuntimeArchiver->OpenArchiveFromStorage(FPaths::Combine(StorePath,TEXT("dist.zip"))))
				return;
			
			RuntimeArchiver->AddToRoot();	
			FRuntimeArchiveEntry Entry;
			auto  OnResult = [RuntimeArchiver,StorePath,ZipPath,this](bool bIsSuccess)
			{
				if(bIsSuccess)
				{
					auto VersionPath = FPaths::Combine(StorePath,GetDownloadCompletedName());
					FFileHelper::SaveStringToFile(TEXT(""),*VersionPath);
					if (!IsRunningCommandlet())
					{
						RuntimeArchiver->CloseArchive();
						RuntimeArchiver->RemoveFromRoot();
						FPlatformFileManager::Get().GetPlatformFile().DeleteFile(*ZipPath);
					}
				}
			};
			
			//FPlatformFileManager::Get().GetPlatformFile().DeleteDirectoryRecursively(*StorePath);
			RuntimeArchiver->ExtractEntriesToStorage_Directory(OnResult, TEXT(""), StorePath, true, true);
		}
	});
	request->ProcessRequest();
}
