#pragma once
#include "HeroUsdkSubsystem.h"
#include "Data/PayOrderResult.h"
#include "Data/HeroUsdkSupportData.h"
#include "Env/Base/EnvModeBase.h"
#include "Platform/Base/ChannelConfigBase.h"

class FChannelManagerBase
{
public:
	FChannelManagerBase(UHeroUsdkSubsystem* InSubsystem,const TSharedPtr<FChannelConfigBase>& ChannelConfig,const TSharedPtr<FEnvModeBase>& InEnvMode)
	:Subsystem(InSubsystem),Config(ChannelConfig),EnvMode(InEnvMode){}
	virtual ~FChannelManagerBase() = default;
	virtual void Init(TFunction<void(bool bSuccess, const FString& Msg)> Callback) = 0;
	virtual void Logout() = 0;
	virtual TMap<FString, FString> GetJsParamter() = 0;
	virtual void Pay(const FHeroUPaymentParameters& paymentParametersData, const FPayOrderResult& PayOrderResult) =0;

	void SetChannelToken(const FString& Token)
	{
		ChannelAccessToken = Token;
	}

	FString GetChannelToken() const
	{
		return ChannelAccessToken;
	}

	void QueryWebVersion(const FString& LocalPath);
	void DownLoadWebFile(const FString& StorePath);

	virtual FString GetQueryVersionUrl() = 0;
	virtual FString GetDownloadCompletedName() = 0;
	virtual FString GetDownLoadWebUrl() = 0;
	virtual FString GetChannelWebDir() = 0;
protected:
	static FString GetFinalWebBaseDir()
	{
		return  FPaths::ProjectPluginsDir() / TEXT("HeroUSDKPlugin/Resources") / TEXT("Web");
	}
	static FString GetWebBaseMidDir()
	{
		return FPaths::ProjectSavedDir() / TEXT("PCsdk") / TEXT("Web");
	}
public:
	//FHeroUProject ProjectConfig;
	//token
	FString ChannelAccessToken;
	FString LogoutURL;
	UHeroUsdkSubsystem* Subsystem = nullptr;
	TSharedPtr<FChannelConfigBase> Config;
	TSharedPtr<FEnvModeBase> EnvMode;
};
