// Fill out your copyright notice in the Description page of Project Settings.


#include "BiliManager.h"

#include "Async/Async.h"
#include "Kismet/KismetSystemLibrary.h"
#if PLATFORM_WINDOWS
#include "HeroUsdkSupportKit.h"
#include "JsonObjectConverter.h"
#include "LogHeroUsdk.h"
#include "Bili/BiliAnitiData.h"
#include "Bili/BiliFunc.h"
#include "Bili/BiliPayInfo.h"
#include "Config/Channel/Bili/BiliConfig.h"
#include "DotManager/DotManager.h"
#include "Manager/HeroUsdkSupportPcDelegate.h"

BiliSDKInit BiliInitFunc = nullptr;
BiliSDKShowLoginPanel BiliShowLoginPanel = nullptr;
BiliSDKShowPayPanel BiliShowPayPanel = nullptr;
BiliSDKLogout BiliLogout = nullptr;
BiliSDKOpenAntiAddiction BiliOpenAntiAddiction = nullptr;
BiliSDKCloseAccount BiliCloseAccount = nullptr;
BiliSDKUnInit BiliUnInit = nullptr;

FBiliManager* biliManager = nullptr;

FBiliManager::FBiliManager(UHeroUsdkSubsystem* InSubsystem, const TSharedPtr<FChannelConfigBase>& ChannelConfig,
	const TSharedPtr<FEnvModeBase>& InEnvMode):FChannelManagerBase(InSubsystem,ChannelConfig,InEnvMode)
{
	biliManager = this;
}

FBiliManager::~FBiliManager()
{
	biliManager =nullptr;
	if(BiliUnInit)
	{
		BiliUnInit();
	}
}

TFunction<void(bool bSuccess, const FString& Msg)> InitCallback;

void __stdcall InitCallBackHandlerFunc(char* szData, int nLen) {
	FString Result = UTF8_TO_TCHAR(szData);
	UE_LOG(LogHeroUsdk,Log,TEXT("InitCallBackHandlerFunc:%s"),*Result)
	//处理初始化回调,初始化成功后再去调用其他接口
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	const TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(Result);
	if (FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		const int32 code = JsonObject->GetIntegerField(TEXT("code"));
		if (code == 0)
		{
			InitCallback(true,{});
		}
		else if(code == -1||code == -2)
		{
			InitCallback(false,{});
			UKismetSystemLibrary::QuitGame(biliManager->Subsystem,nullptr,EQuitPreference::Quit,false);
		}
	}
}


void* FBiliManager::GetOSWindowHandle()
{
	if (GEngine && GEngine->GameViewport)
	{
		TSharedPtr<SWindow> GameViewportWindow = GEngine->GameViewport->GetWindow();
		if (GameViewportWindow.IsValid() && GameViewportWindow->GetNativeWindow().IsValid())
		{
			return GameViewportWindow->GetNativeWindow()->GetOSWindowHandle();
		}
	}

	TSharedPtr<SWindow> MainWindow = FSlateApplication::Get().GetActiveTopLevelWindow();
	if (MainWindow.IsValid())
	{
		TSharedPtr<FGenericWindow> NativeWindow = MainWindow->GetNativeWindow();
		if (NativeWindow.IsValid())
		{
			return NativeWindow->GetOSWindowHandle();
		}
	}

	return nullptr;
}

void FBiliManager::Init(TFunction<void(bool bSuccess, const FString& Msg)> Callback)
{
	if (BiliInitFunc){
		InitCallback = Callback;
		void* gameHWND = this->GetOSWindowHandle();
		if (gameHWND == nullptr)
		{
			Callback(false,TEXT("can't find game window"));
			return;
		}

		FString initJson;
		TSharedPtr<FJsonObject> jsonObject = MakeShareable(new FJsonObject());
	
		jsonObject->SetStringField(TEXT("gameId"),Config->GetGameId());
		jsonObject->SetStringField(TEXT("appKey"),Config->GetProductKey());
		
		auto jsonWriter = TJsonWriterFactory<TCHAR,TCondensedJsonPrintPolicy<TCHAR>>::Create(&initJson);
		FJsonSerializer::Serialize(jsonObject.ToSharedRef(), jsonWriter);
		int32 ret = BiliInitFunc(TCHAR_TO_UTF8(*initJson), (HWND)gameHWND, false,InitCallBackHandlerFunc);//调用初始化函数
		UE_LOG(LogHeroUsdk,Log,TEXT("Bili call BiliInitFunc with code:%d"),ret);
		
		if (ret == 0)
		{
			return;
		}
		FString ErrorStr;
		if (ret == -1)
		{
			ErrorStr = TEXT("Bili call BiliInitFunc Failed");
		
		}
		else if (ret == 1)
		{
			ErrorStr = TEXT("Bili Already call BiliInitFunc");
		}
		else
		{
			ErrorStr = TEXT("Bili not tell us");
		}
		UE_LOG(LogHeroUsdk,Error,TEXT("%s"),*ErrorStr);
		Callback(false,ErrorStr);
		return;
	}
	Callback(false,TEXT("can't find bili init func"));
}

void __stdcall AntiAddictionCallBackHandler(char*szData, int nLen) {
	FString Result = UTF8_TO_TCHAR(szData);
	UE_LOG(LogHeroUsdk,Log,TEXT("AntiAddictionCallBackHandler:%s"),*Result)
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	const TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(Result);
	if (FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		const int32 code = JsonObject->GetIntegerField(TEXT("code"));
		if (code == 0)
		{
			
		}
		else if(code == 1)
		{
			auto data = JsonObject->GetObjectField(TEXT("data"));
			AsyncTask(ENamedThreads::GameThread,[data]()
			{
				HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginInvalid(data->GetStringField(TEXT("message")));
			});
			
		}
	}
}



void __stdcall LoginCallBackHandlerFunc(char*szData, int nLen) {

	FString Result = UTF8_TO_TCHAR(szData);
	UE_LOG(LogHeroUsdk,Log,TEXT("LoginCallBackHandlerFunc:%s"),*Result)

	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	const TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(Result);
	if (FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		const int32 code = JsonObject->GetIntegerField(TEXT("code"));
		if (code == 0)
		{
			auto dataObject = JsonObject->GetObjectField(TEXT("data"));

			FUserInfo UserInfo;
			UserInfo.plat = TEXT("pc");
			FString uid = dataObject->GetStringField("uid");
			if(uid.IsEmpty())
			{
				uid =dataObject->GetStringField("game_open_id");
			}
			UserInfo.sdkUserId =  uid;
			UserInfo.userName =   dataObject->GetStringField("uname");
			UserInfo.accessToken = dataObject->GetStringField("access_key");
			HeroUsdkSupportPcDelegate::GetInstance()->SetUserInfo(UserInfo);
			TMap<FString, FString> paramter;
			paramter.Add("cToken", UserInfo.accessToken);
				
			HeroUsdkSupportPcDelegate::GetInstance()->SetChannelToken(UserInfo.accessToken);
			HeroUsdkSupportPcDelegate::GetInstance()->GetUsdkManager()->UsdkLogin(paramter,[](EUsdkResult Result, const FString& ErrorMsg,const FUserInfo& UserInfo)
					{
						if(Result == EUsdkResult::Failed)
						{
							if(BiliLogout)
							{
								BiliLogout();
							}
							HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(
									HeroUsdkFailed, {},ErrorMsg);

						}
						else if(Result == EUsdkResult::Success)
						{
							FString profile;
							FJsonObjectConverter::UStructToJsonObjectString(UserInfo, profile, 0, 0);
							if (!profile.IsEmpty() && HeroUsdkSupportKit::GetInstance().NotifyObject != nullptr)
							{
								FString CompUrl = HeroUsdkSupportPcDelegate::GetInstance()->GetEnvMode()->GetPcUrl() ;

								auto UserName = UserInfo.userName.IsEmpty()?UserInfo.sdkUserId:
								UserInfo.userName;
								
								if(HeroUsdkSupportKit::GetInstance().NotifyObject)
								{
									{
										TMap<FString,FString> DotParam;
										DotParam.Emplace("login_type","");
										DotParam.Emplace("is_success","1");
										DotParam.Emplace("reason","");
										FDotManager::GetInstance().CallDot("u_l_backlogmsg_to_cp",DotParam);
									}
								
									HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(
										HeroUsdkSuccess, profile,TEXT("登录成功"));
								}
								
							}
						
							if(BiliOpenAntiAddiction)
							{
								if(biliManager)
								{
									FBiliAntiData AntiData;
									auto BiliConfig = StaticCastSharedPtr<FBiliConfig>(biliManager->Config);
									AntiData.server_id = BiliConfig->channel_server_id;
									AntiData.channel_id = FString::FromInt(BiliConfig->GetChannelId());
									AntiData.ver = GetMutableDefault<UUsdkSettings>()->GameVersion;
									FString Json;
									FJsonObjectConverter::UStructToJsonObjectString(AntiData, Json, 0, 0);
									BiliOpenAntiAddiction(TCHAR_TO_UTF8(*Json), AntiAddictionCallBackHandler);
								}
								
							}
						}

					});
		}
		else if(code == -1)
		{
			auto data = JsonObject->GetObjectField(TEXT("data"));
			
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(
										HeroUsdkFailed, {},data->GetStringField(TEXT("message")));
		}
		else if(code == -2)
		{
			auto data = JsonObject->GetObjectField(TEXT("data"));
			
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(
										HeroUsdkCancel, {},data->GetStringField(TEXT("message")));
		}
	}
}


void FBiliManager::Login()
{
	if (BiliLogout)
	{
		int32 ret = BiliLogout();
		UE_LOG(LogHeroUsdk, Log, TEXT("Bili call BiliLogout with code:%d"),ret)
	}
	
	if (BiliShowLoginPanel != NULL)
	{
		
		int32 ret = BiliShowLoginPanel(TCHAR_TO_UTF8(*Config->GetProductKey()), true, LoginCallBackHandlerFunc); //传入登录回调
		UE_LOG(LogHeroUsdk, Log, TEXT("Bili call BiliShowLoginPanel with code:%d"),ret)
		
		if (ret == 0)
		{
			return;
		}
		FString ErrorStr;
		if (ret == -1)
		{
			ErrorStr = TEXT("Bili call BiliShowLoginPanel Failed");
		
		}
		else if (ret == 1)
		{
			ErrorStr = TEXT("Bili Already call BiliShowLoginPanel");
		}
		else
		{
			ErrorStr = TEXT("Bili not tell us");
		}
		UE_LOG(LogHeroUsdk,Error,TEXT("%s"),*ErrorStr);
		
		HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(
									HeroUsdkCancel, {},ErrorStr);
		return;
		
	}
}

void FBiliManager::SwitchAccount()
{
	if(BiliLogout)
	{
		if (BiliLogout() == 0)
		{
			Login();
		}
	}
}

void FBiliManager::Logout()
{
	if(BiliLogout)
	{
		BiliLogout();
	}
}

TMap<FString, FString> FBiliManager::GetJsParamter()
{
	return {};
}




void __stdcall PayCallBackHandlerFunc(char*szData, int nLen) {
	
	FString Result = UTF8_TO_TCHAR(szData);
	UE_LOG(LogHeroUsdk,Log,TEXT("Bili PayCallBackHandlerFunc:%s"),*Result)
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	
	const TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(Result);
	if (FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		auto code = JsonObject->GetIntegerField(TEXT("code"));
		if(code == 0)
		{
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkSuccess,{},TEXT("Pay Success")) ;
		}
		else if(code == -1)
		{
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkFailed,{},{}) ;

		}
		else if(code == -2)
		{
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkCancel,{},{}) ;
		}
		else if(code == 2 ||code == 3||code == 4||code == 5)
		{
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkFailed,{},{}) ;
		}
	}
}

void FBiliManager::Pay(const FHeroUPaymentParameters& paymentParametersData, const FPayOrderResult& PayOrderResult)
{
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(PayOrderResult.serverMsg);
	if (FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		if (BiliShowPayPanel){
			auto roleInfo = HeroUsdkSupportPcDelegate::GetInstance()->GetRoleInfo();
			auto BConfig = StaticCastSharedPtr<FBiliConfig>(Config);
		
			FBiliPayInfo PayInfo;
			PayInfo.orderSign = JsonObject->GetStringField(TEXT("sign"));
			PayInfo.appKey = BConfig->channel_app_key;
			PayInfo.zoneId = BConfig->channel_server_id;
			PayInfo.tradeNum = JsonObject->GetStringField(TEXT("out_trade_no"));
			PayInfo.game_money = JsonObject->GetStringField(TEXT("game_money"));
			PayInfo.product_name = PayOrderResult.goodsName;
			PayInfo.money = JsonObject->GetStringField(TEXT("money"));
			PayInfo.notify_url = JsonObject->GetStringField(TEXT("notify_url"));
			FString Info = PayInfo.ToString();
			BiliShowPayPanel(TCHAR_TO_UTF8(*Info), PayCallBackHandlerFunc);
		}
	}
	
}

void __stdcall CloseAccountCallBackHandlerFunc(char*szData, int nLen) {
	
	FString Result = UTF8_TO_TCHAR(szData);
	UE_LOG(LogHeroUsdk,Log,TEXT("Bili CloseAccountCallBackHandlerFunc:%s"),*Result)
}

void FBiliManager::accountCancellation()
{
	if(BiliCloseAccount)
	{
		BiliCloseAccount("",CloseAccountCallBackHandlerFunc);
		//BiliCloseAccount
	}
}

FString FBiliManager::GetQueryVersionUrl()
{
	return {};
}

FString FBiliManager::GetDownloadCompletedName()
{
	return {};
}

FString FBiliManager::GetDownLoadWebUrl()
{
	return {};
}

FString FBiliManager::GetChannelWebDir()
{
	return {};
}
#endif