// Fill out your copyright notice in the Description page of Project Settings.

#pragma once
#include "CoreMinimal.h"
#include "Manager/Channel/Base/ChannelManagerBase.h"

#if PLATFORM_WINDOWS
/**
 * 
 */

class FBiliManager : public  FChannelManagerBase
{
public:
	FBiliManager(UHeroUsdkSubsystem* InSubsystem,const TSharedPtr<FChannelConfigBase>& ChannelConfig,const TSharedPtr<FEnvModeBase>& InEnvMode);

	~FBiliManager();
	void* GetOSWindowHandle();
    virtual void Init(TFunction<void(bool bSuccess, const FString& Msg)> Callback) override;
	void Login();
	virtual void Logout() override;
	void SwitchAccount();
    virtual TMap<FString, FString> GetJsParamter() override;
    virtual void Pay(const FHeroUPaymentParameters& paymentParametersData, const FPayOrderResult& PayOrderResult) override;
	void accountCancellation();
    virtual FString GetQueryVersionUrl() override;
    virtual FString GetDownloadCompletedName() override;
    virtual FString GetDownLoadWebUrl() override;
    virtual FString GetChannelWebDir() override;
};
#endif