// Fill out your copyright notice in the Description page of Project Settings.


#include "ChinaManager.h"

#include <cstring>
#include <string>

#include "Manager/Usdk/UsdkManager.h"
#include "HeroUsdkSupportKit.h"
#include "Manager/HeroUsdkSupportPcDelegate.h"
#include "LogHeroUsdk.h"
#include "PC_PayPannel.h"
#include "Config/Channel/China/ChinaConfig.h"
#include "DotManager/DotManager.h"
#include "Setting/UsdkSettings.h"
#include "Tools/UsdkCommonTools.h"


FChinaManager::FChinaManager(UHeroUsdkSubsystem* InSubsystem, const TSharedPtr<FChannelConfigBase>& ChannelConfig,
	const TSharedPtr<FEnvModeBase>& InEnvMode):FChannelManagerBase(InSubsystem,ChannelConfig,InEnvMode)
{}

void FChinaManager::Pay(const FHeroUPaymentParameters& PayParameters, const FPayOrderResult& OrderResult)
{
	PaymentParameters = PayParameters;
	PayOrderResult = OrderResult;
	auto setting = GetMutableDefault<UUsdkSettings>();
	//是否是版署包
	if(setting->bIsPublish )
	{
		float amount = PayOrderResult.price;
		FString UsdkOrder = PayOrderResult.order;
		ppali(amount, UsdkOrder);
		return;
	}
	TMap<FString,FString> DotParam;
	DotParam.Emplace("goods_id",PaymentParameters.goodsId);
	DotParam.Emplace("goods_name",PayOrderResult.goodsName);
	DotParam.Emplace("goods_info",PayOrderResult.goodsDesc);
	DotParam.Emplace("amount",PayOrderResult.goodsDesc);
	DotParam.Emplace("coin_type",PayOrderResult.currency);
	DotParam.Emplace("cp_order",PaymentParameters.cpOrder);
	FDotManager::GetInstance().CallDot("c_p_call",DotParam);
	//支付页面回调
	if(Subsystem->BP_Pay)
	{
		auto Pannel = CreateWidget<UPC_PayPannel>(Subsystem->GetGameInstance(),Subsystem->BP_Pay);
		Pannel->SetPayParam(PaymentParameters,PayOrderResult);
		Pannel->AddToViewport(100);
	}
	
	FDotManager::GetInstance().CallDot("u_p_call",DotParam);
	FDotManager::GetInstance().CallDot("c_p_view_start");
					
	return;
}

FHttpModule* FChinaManager::GetHttpModule()
{
	static FHttpModule* httpModule = NULL;

	if (httpModule == NULL)
	{
		httpModule = &FHttpModule::Get();
		httpModule->SetHttpTimeout(60);
		httpModule->SetMaxReadBufferSize(1024 * 1024 * 50);
		httpModule->SetHttpDelayTime(0.001);;
	}
	return httpModule;
}

FHttpManager& FChinaManager::GetHttpMgr()
{
	return GetHttpModule()->GetHttpManager();
}

void FChinaManager::Logout()
{
	UUsdkBaseWidget::SetUeDataInteral(TEXT("LOGIN_CACHE_INTERNAL"), {});
	StopCountdown();
	StopPoll();
}

//配置接口
void FChinaManager::CreatePostRequest(FString url,const TMap<FString,FString>& Parameter,const FGameNetWorkComplete& netWorkComplete)
{
	TSharedRef<IHttpRequest, ESPMode::ThreadSafe> ret_request = GetHttpModule()->CreateRequest();
	const FString fullUrl = EnvMode->GetChannelUrl()  + url;
	UE_LOG(LogHeroUsdk, Log, TEXT(" createPostReuquest : %s"), *fullUrl);
	ret_request->SetURL(fullUrl);
	ret_request->SetHeader(TEXT("Content-Type"), TEXT("application/x-www-form-urlencoded"));
	const FString bodyStr = GetEncodeParames(Parameter);
	ret_request->SetContentAsString(bodyStr);
	ret_request->SetTimeout(30000);
	ret_request->SetVerb(TEXT("POST"));
	ret_request->OnProcessRequestComplete().BindLambda([netWorkComplete](FHttpRequestPtr HttpRequest, FHttpResponsePtr HttpResponse, bool bSuccess)
	{
		if (HttpResponse.IsValid())
		{
			const FString contentStr = HttpResponse->GetContentAsString();
			const int32 statusCode = HttpResponse->GetResponseCode();
			if (netWorkComplete) { netWorkComplete(statusCode, contentStr, bSuccess); }
		}
	});
	ret_request->ProcessRequest();
}


void FChinaManager::UpdateRemoteInitConfig()
{
	createInitRequest("c1/sys/conf.lg",
	      [this](int32 statueCode, FString contentString, bool bWasSuccessful)
	      {
	          UE_LOG(LogHeroUsdk, Log, TEXT("China remote Init Response : %s"), *contentString);
	          TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	          TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(contentString);
	          if(EHttpResponseCodes::IsOk(statueCode))
	          {
	              if (FJsonSerializer::Deserialize(Reader, JsonObject))
	              {
	                  int32 Codes = -1;
	                  Codes= JsonObject->GetIntegerField(TEXT("codes"));

	                  if (Codes == 0)
	                  {
		                  FUsdkCommonTools::WriteText("ChinaInitConfig",contentString);
	                  }
	              }
	          }

	      });

	QueryWebVersion(FPaths::Combine(GetFinalWebBaseDir(),TEXT("pcwebv3"), TEXT("version.txt")));
}

void FChinaManager::Init(TFunction<void(bool bSuccess, const FString& Msg)> Callback)
{
	ReplaceWebSource(GetFinalWebBaseDir(),GetWebBaseMidDir());
	FDotManager::GetInstance().CallDot("c_init_start");
	
	FString ChinaConfig  = UUsdkBaseWidget::GetUeDataInteral("INIT_DATA_INTERNAL");

	//更新本地初始化数据
	UpdateRemoteInitConfig();

	//处理本地初始化数据
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(ChinaConfig);
	
	if (FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		int32 Codes = -1;
		Codes= JsonObject->GetIntegerField(TEXT("codes"));

		if (Codes == 0)
		{
			FDotManager::GetInstance().CallDot("c_init_end");
			LogoutURL = JsonObject->GetStringField(TEXT("logoutURL"));
			
			if (JsonObject->HasField("heartFreq"))
			{
				const float HeartFreqValue = JsonObject->GetNumberField("heartFreq");
				UE_LOG(LogHeroUsdk, Warning, TEXT("HeartFreq Minutes: %f"), HeartFreqValue);
				this->PollInterval = HeartFreqValue * 60;
			}
			else
			{
				UE_LOG(LogHeroUsdk, Error, TEXT("heartFreq field not found"));
			}

			Callback(true,{});
			return;
		}
	}
	
	/*
	//国内初始化
	createInitRequest("c1/sys/conf.lg",
		[this,Callback](int32 statueCode, FString contentString, bool bWasSuccessful)
		{
			UE_LOG(LogHeroUsdk, Log, TEXT("China Init Response : %s"), *contentString);
			TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
			TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(contentString);
			if(EHttpResponseCodes::IsOk(statueCode))
			{
				if (FJsonSerializer::Deserialize(Reader, JsonObject))
				{
					int32 Codes = -1;
					Codes= JsonObject->GetIntegerField(TEXT("codes"));
	
					if (Codes == 0)
					{
						FDotManager::GetInstance().CallDot("c_init_end");
						LogoutURL = JsonObject->GetStringField(TEXT("logoutURL"));
				
						if (JsonObject->HasField("heartFreq"))
						{
							const float HeartFreqValue = JsonObject->GetNumberField("heartFreq");
							UE_LOG(LogHeroUsdk, Warning, TEXT("HeartFreq Minutes: %f"), HeartFreqValue);
							this->PollInterval = HeartFreqValue * 60;
						}
						else
						{
							UE_LOG(LogHeroUsdk, Error, TEXT("heartFreq field not found"));
						}

						Callback(true,{});
						return;
					}
				}
			}
			Callback(false,{});
		});
	return;*/
}

void FChinaManager::GenInitConfig()
{
	TMap<FString,FString> paramters;
	paramters.Add("pkg",Config->package);
	this->CreatePostRequest("c1/sys/conf.lg",paramters,[this](int32 statueCode,FString contentString,bool bWasSuccessful)
	{
		auto setting = GetMutableDefault<UUsdkSettings>();
			setting->ChinaInitConfig = contentString;
			setting->SaveConfig(CPF_Config,*FPaths::Combine(FPaths::ProjectConfigDir(),TEXT("DefaultGame.ini")));
	}) ;

	DownLoadWebFile(GetFinalWebBaseDir());
}

void FChinaManager::ReplaceWebSource(const FString& Dest, const FString& Source)
{
	if (IFileManager::Get().FileExists(*FPaths::Combine(Source,TEXT("PcCompleted"))))
	{
		FString GlobalSource = FPaths::Combine(Source,TEXT("pcwebv3"));
		FString GlobalDest = FPaths::Combine(Dest,TEXT("pcwebv3"));
		FPlatformFileManager::Get().GetPlatformFile().DeleteDirectoryRecursively(*GlobalDest);
		if(!FPlatformFileManager::Get().GetPlatformFile().DirectoryExists(*Dest))
		{
			FPlatformFileManager::Get().GetPlatformFile().CreateDirectoryTree(*Dest);
		}
		bool ret = FPlatformFileManager::Get().GetPlatformFile().CopyDirectoryTree(*GlobalDest, *GlobalSource, true);
		FPlatformFileManager::Get().GetPlatformFile().DeleteDirectoryRecursively(*Source);
	}
}

//初始化接口
void FChinaManager::createInitRequest(FString url,const FGameNetWorkComplete& netWorkComplete)
{
	TMap<FString,FString> paramters ;

#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	
	paramters.Add("pkg",Config->package);

#endif
	
	this->CreatePostRequest(url,paramters,[this, netWorkComplete](int32 statueCode,FString contentString,bool bWasSuccessful)
	{
		if (!bWasSuccessful)
		{
		
			return;
		}
		if (contentString.IsEmpty())
		{
			return;
		}
		netWorkComplete(statueCode,contentString,bWasSuccessful);
	}) ;
}

//获取用户信息
void FChinaManager::createUserInfoReuquest(FString url,const TMap<FString,FString>& paramter,const FGameNetWorkComplete& netWorkComplete)
{
	this->CreatePostRequest(url,paramter,[this](int32 statueCode,FString contentString,bool bWasSuccessful)
	{
		if (!bWasSuccessful)
		{
			UE_LOG(LogHeroUsdk, Error, TEXT("HeroUsdkSupportKit 国内获取用户信息请求失败 "));
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(HeroUsdkFailed, "",TEXT("登录失败,请稍后重试"));
			return;
		}
		if (contentString.IsEmpty())
		{
			UE_LOG(LogHeroUsdk, Error, TEXT("HeroUsdkSupportKit 国内获取用户信息请求失败 "));
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(HeroUsdkFailed, "",TEXT("登录失败,请稍后重试"));
			return;
		}
		UE_LOG(LogHeroUsdk, Log, TEXT(" UserInfoResponseData : %s"), *contentString);
		TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
		TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(contentString);
		if (FJsonSerializer::Deserialize(Reader, JsonObject))
		{
			const TSharedPtr<FJsonValue>* codeValue = JsonObject->Values.Find(TEXT("codes"));
			if (codeValue->IsValid())
			{
				double resultCode = (*codeValue)->AsNumber();
				if (resultCode == 0)
				{
					const TSharedPtr<FJsonValue>* ageValue = JsonObject->Values.Find(TEXT("age"));
					if (ageValue->IsValid())
					{
						double ageNumber = (*ageValue)->AsNumber();
						if (ageNumber < 18)
						{
							//实名认证
						}
						else
						{
							//回调USDK进行登录认证
							TMap<FString, FString> userInfo;
							const TSharedPtr<FJsonValue>* usernameValue = JsonObject->Values.Find(TEXT("username"));
							if (usernameValue->IsValid())
							{
								FString userNameStr = (*usernameValue)->AsString();
								if (!userNameStr.IsEmpty())
								{
									userInfo.Add("username", userNameStr);
								}
							}
							const TSharedPtr<FJsonValue>* sdkuseridValue = JsonObject->Values.Find(TEXT("sdkuserid"));
							if (sdkuseridValue->IsValid())
							{
								FString sdkuseridStr = (*sdkuseridValue)->AsString();
								if (!sdkuseridStr.IsEmpty())
								{
									userInfo.Add("sdkuserid", sdkuseridStr);
								}
							}
							if (!AccessToken.IsEmpty())
							{
								userInfo.Add("accessToken", AccessToken);
							}
						}
					}
				}
			}
		}
		HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(HeroUsdkFailed, "",TEXT("登录失败,请稍后重试"));
		return;
	}) ;
}

FString ConvertUSDKServiceString(EHeroUsdkLanguageFlag flag)
{
	switch (flag) {
	case EHeroUsdkLanguageFlag::HeroLanguageSystem:
		{
			FString lang = FPlatformMisc::GetDefaultLanguage();
			if(lang == TEXT("zh-CN"))
				lang = "zh";
			
			return lang;
		}
		
	case EHeroUsdkLanguageFlag::HeroLanguageZhHans:
		return TEXT("zh");
	case EHeroUsdkLanguageFlag::HeroLanguageZhHant:
		return TEXT("tc");
	case EHeroUsdkLanguageFlag::HeroLanguageEn:
		return TEXT("en");
	case EHeroUsdkLanguageFlag::HeroLanguageJa:
		return TEXT("ja");
	case EHeroUsdkLanguageFlag::HeroLanguageKo:
		return TEXT("ko");
	}
	return TEXT("en");
}

void FChinaManager::OpenServicePanel(TSubclassOf<UPC_SurveyPanel> UserWidgetClass,
                                     const TFunction<void(bool, const FString&)>& Callback)
{
	FString ChinaInitConfig = UUsdkBaseWidget::GetUeDataInteral("INIT_DATA_INTERNAL");;
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(ChinaInitConfig);
	if (FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		const auto BuoyConf = JsonObject->GetObjectField(TEXT("buoyConf"));
		auto ClubUrl = BuoyConf->GetStringField(TEXT("clubUrl"));
		if (!ClubUrl.IsEmpty())
		{
			if (ClubUrl.Contains("?"))
			{
				ClubUrl += "&";
			}
			else
			{
				ClubUrl += "?";
			}
			UWorld* WorldToRecordIn = nullptr;
			for (const FWorldContext& WorldContext : GEngine->GetWorldContexts())
			{
				if (WorldContext.WorldType == EWorldType::PIE || WorldContext.WorldType == EWorldType::Game)
				{
					WorldToRecordIn = WorldContext.World();
					break;
				}
				else if (WorldContext.WorldType == EWorldType::Editor)
				{
					WorldToRecordIn = WorldContext.World();
				}
			}

			check(WorldToRecordIn);

			if (UserWidgetClass)
			{
				TMap<FString, FString> Data;
				Data.Emplace("roleId", HeroUsdkSupportPcDelegate::GetInstance()->GetRoleInfo().roleId);
				Data.Emplace("serverId", HeroUsdkSupportPcDelegate::GetInstance()->GetRoleInfo().serverId);
				Data.Emplace("roleName", HeroUsdkSupportPcDelegate::GetInstance()->GetRoleInfo().roleName);
				Data.Emplace("serverName", HeroUsdkSupportPcDelegate::GetInstance()->GetRoleInfo().serverName);
				Data.Emplace("phone",TEXT(""));
				Data.Emplace("gameId", Config->GetGameId());
				Data.Emplace("uid", HeroUsdkSupportPcDelegate::GetInstance()->GetRoleInfo().roleId);
				Data.Emplace("productId", Config->GetProductId());
				Data.Emplace("loginName", HeroUsdkSupportPcDelegate::GetInstance()->GetUserInfo().userName);
				FString Lang = ConvertUSDKServiceString(HeroUsdkSupportPcDelegate::GetInstance()->PcsdkLanguage);
				const auto FullUrl = ClubUrl +"lang="+Lang + "&roleName=" + FGenericPlatformHttp::UrlEncode(HeroUsdkSupportPcDelegate::GetInstance()->GetRoleInfo().roleName) + TEXT("&data=") + FUsdkManager::SimpleEncryption(Data);
				UE_LOG(LogHeroUsdk,Log,TEXT("OpenServicePanel full url:%s"),*FullUrl)
				auto SurveyPanel = CreateWidget<UPC_SurveyPanel>(WorldToRecordIn, UserWidgetClass);
				SurveyPanel->SetFlags(RF_Transient);
				SurveyPanel->SetUrl(FullUrl);
				SurveyPanel->AddToViewport(100);
			}
		}
	}
}

void FChinaManager::Tick(float DeltaTime)
{
	if(bIsAntiIndulgence)
	{
		AntiRemain -= DeltaTime;
		if (AntiRemain <= 0.f)
		{
			TMap<FString, FString> Params;
			Params.Add("access_token", ChannelAccessToken);
			IndulgenceCheck(Params, [](int32 statueCode, FString contentString, bool bWasSuccessful){});
			bIsAntiIndulgence = false;
			if (isAntiKicked) return;
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginInvalid(AntiMsg);
			isAntiKicked = true;
		}
	}

	if(bIsPoll)
	{
		pollRemain -= DeltaTime;
		if(pollRemain <0.f)
		{
			TMap<FString, FString> Params;
			Params.Add("access_token", ChannelAccessToken);
			UE_LOG(LogHeroUsdk, Error, TEXT("HeroUsdkSupportKit check user status"));
			IndulgenceCheck(Params, [](int32 statueCode, FString contentString, bool bWasSuccessful){});
			pollRemain = PollInterval;
		}
	}
}


TStatId FChinaManager::GetStatId() const
{
	RETURN_QUICK_DECLARE_CYCLE_STAT(FChinaManager, STATGROUP_Tickables);
}

void FChinaManager::SwitchOnlineStatus(FString accessToken)
{
	if(bIsAntiIndulgence)
	{
		TMap<FString,FString> paramter;
		paramter.Add(TEXT("status"), TEXT("0"));
		paramter.Add(TEXT("access_token"), accessToken);
		this->CreatePostRequest("/c1/user/heartbeat/switchStatus.lg",paramter,[this](int32 statueCode,FString contentString, bool bWasSuccessful)
		{
			UE_LOG(LogHeroUsdk,Log,TEXT("SwitchOnlineStatus:%s"),*contentString);
		});
	}
	
}

void FChinaManager::StartCountdown(float Remaining, const FString& Msg)
{
	UE_LOG(LogHeroUsdk, Log, TEXT(" StartCountdown remainTime: %f"), Remaining);
	AntiRemain = Remaining;
	AntiMsg = Msg;
	bIsAntiIndulgence = true;
}

void FChinaManager::StopCountdown()
{
	isAntiKicked = false;
	bIsAntiIndulgence = false;
}

void FChinaManager::StartPoll()
{
	bIsPoll = true;
	pollRemain = PollInterval;
}

void FChinaManager::StopPoll()
{
	bIsPoll = false;
}

void FChinaManager::IndulgenceCheck(const TMap<FString, FString>& paramter,
                                      const FGameNetWorkComplete& netWorkComplete)
{
	this->CreatePostRequest("c1/user/heartbeat/statusCheck.lg",paramter,[this, netWorkComplete](int32 statueCode,FString contentString, bool bWasSuccessful)
	{
		if (!bWasSuccessful)
		{
			UE_LOG(LogHeroUsdk, Error, TEXT("HeroUsdkSupportKit 防沉迷验证请求失败 "));
			return;
		}
		UE_LOG(LogHeroUsdk, Log, TEXT(" AntiAddiction report : %s"), *contentString);


		TSharedPtr<FJsonObject> JsonObject;
		TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(contentString);

		if (FJsonSerializer::Deserialize(Reader, JsonObject))
		{
			if (JsonObject->HasField("data"))
			{
				const TSharedPtr<FJsonObject>& DataObject = JsonObject->GetObjectField("data");
				if (DataObject->HasField("offlineSurplusTime"))
				{
					const int32 temp_AntiRemain = DataObject->GetIntegerField("offlineSurplusTime");
					AntiRemain = temp_AntiRemain;
					UE_LOG(LogHeroUsdk, Warning, TEXT("offlineSurplusTime: %d"), temp_AntiRemain);
					if(temp_AntiRemain==0 && bIsAntiIndulgence)
					{
						const auto temp_AntiMsg = DataObject->GetStringField(TEXT("offlineSurplusMsg"));
						if(!temp_AntiMsg.IsEmpty())
						{
							AntiMsg = temp_AntiMsg;
						}
						HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginInvalid(AntiMsg);
					}
				}
				else
				{
					UE_LOG(LogHeroUsdk, Error, TEXT("offlineSurplusTime field not found"));
				}
			}
		}
		else
		{
			UE_LOG(LogHeroUsdk, Error, TEXT("JSON deserialization failed"));
		}
	});
}

void FChinaManager::ppali(float amount, FString cpOrder)
{
	TMap<FString,FString> ppali;
	ppali.Add("access_token",ChannelAccessToken);
	ppali.Add("way","2");
	ppali.Add("pkg",Config->package);
	ppali.Add("amount",FString::SanitizeFloat(amount));
	ppali.Add("loginName",HeroUsdkSupportPcDelegate::GetInstance()->GetUserInfo().userName);
	ppali.Add("gameRole",cpOrder);
	ppali.Add("cpOrder",cpOrder);
	 
	CreatePostRequest(TEXT("ppali.lg"),ppali,[this](int32 statueCode, FString contentString, bool bWasSuccessful)
	{
		UE_LOG(LogHeroUsdk,Error, TEXT("/ppali.lg-->%s"),*contentString);
		FString platformOrderNum;
		//FString key = UsdkNetAPI->_akStr;
		//FString result = UsdkNetAPI->AESDecrypt(contentString, key);
		TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
		TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(contentString);
		if (FJsonSerializer::Deserialize(Reader, JsonObject))
		{
			if (JsonObject->GetIntegerField("codes") == 0 &&JsonObject->HasTypedField<EJson::String>("platformOrderNum"))
			{
				platformOrderNum = JsonObject->GetStringField("platformOrderNum");
				nzy(platformOrderNum);
				return;
			}

			{
				TMap<FString,FString> DotParam;
				DotParam.Emplace("goods_id",PaymentParameters.goodsId);
				DotParam.Emplace("goods_name",PayOrderResult.goodsName);
				DotParam.Emplace("goods_info",PayOrderResult.goodsDesc);
				DotParam.Emplace("amount",PayOrderResult.goodsDesc);
				DotParam.Emplace("coin_type",PayOrderResult.currency);
				DotParam.Emplace("cp_order",PaymentParameters.cpOrder);
				DotParam.Emplace("result","0");
				DotParam.Emplace("reason",FString("ppali.lg error")+FString::FromInt(JsonObject->GetIntegerField("codes")));
				DotParam.Emplace("usdk_order",PayOrderResult.order);
				DotParam.Emplace("channel_order","");
				FDotManager::GetInstance().CallDot("u_p_backpaymsg_tocp",DotParam);
			}
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkFailed,contentString,JsonObject->GetStringField("error_description"));
			return;
		}
		HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkFailed,contentString,TEXT("ppali.lg"));
	});
}

void FChinaManager::nzy(const FString& platformOrderNum)
{
	TMap<FString,FString> nzy;
	nzy.Add("access_token",ChannelAccessToken);
	nzy.Add("pkg",Config->package);
	nzy.Add("platformOrderNum",platformOrderNum);

	CreatePostRequest(TEXT("nzy.lg"),nzy,[this,platformOrderNum](int32 statueCode, FString contentString, bool bWasSuccessful)
	{
		UE_LOG(LogHeroUsdk,Error, TEXT("nzy.lg-->%s"),*contentString);
		TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
		TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(contentString);
		if (FJsonSerializer::Deserialize(Reader, JsonObject))
		{
			if (JsonObject->GetIntegerField("codes") == 0)
			{
				TMap<FString,FString> paramter;
				paramter.Add("sdkOrderId",platformOrderNum);
				paramter.Add("plat","PC");
				FString payResultJSON = FUsdkCommonTools::converMapToString(paramter);
				HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkSuccess,payResultJSON,platformOrderNum);
				return;
			}
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkFailed,contentString,JsonObject->GetStringField("error_description"));
			return;
		}
		HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkFailed,contentString,TEXT("nzy.lg"));
	
		
	});
}


/*
 * ===================== 结果处理 =============================
 */
//处理初始化结果
void FChinaManager::GetConfigResponseData(FString contentString,const FGameNetWorkComplete& netWorkComplete)
{
	
	// HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onInitCallBack(HeroUsdkFailed,TEXT("初始化失败,请稍后重试"));
	// if (netWorkComplete){netWorkComplete(-1,"",true); } 
}


//编码参数
FString FChinaManager::GetEncodeParames(const TMap<FString ,FString>& paramter)
{
	FString ParamsString;
	TMap<FString, FString> ParamsMap;
	const TMap<FString, FString> CommonParams = GetCommonParameter();
	//合并数据
	ParamsMap.Append(paramter);
	ParamsMap.Append(CommonParams);
	//给所有的Key排序
	ParamsMap.KeySort([](const FString& A, const FString& B) { return A < B; });
	FString MarketValue;
	const bool bIsContain = ParamsMap.RemoveAndCopyValue("market", MarketValue);
	for (TTuple<FString, FString>& Param : ParamsMap)
	{
		if (!Param.Value.IsEmpty())
		{
			ParamsString.Append(Param.Key);
			ParamsString.Append(TEXT("="));
			ParamsString.Append(Param.Value);
			ParamsString.Append(TEXT("&"));
		}
	}
	FString appKey = TEXT("");

#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	
	appKey =Config->GetProductKey() ;

#endif
	
	if (appKey.IsEmpty()) {return "" ; }

	FString EncryptString = FString::Printf(TEXT("%s"), *ParamsString);
	
	//拼接Appkey
	EncryptString.Append(appKey);

	//UE_LOG(LogHeroUsdk, Log, TEXT(" GetEncodeParames Raw param : %s"), *EncryptString);

	std::string std_str =TCHAR_TO_UTF8(*EncryptString);
	//std::string std_str ="__e__=1&access_token=fd144150-7bbb-3ec1-869d-6ca284c4303c&amount=0.01&channelUserId=100128&cpOrder=1697478785&customMsg=customMsg&deviceNum=86785A984483365AD4DDA28689FBF44B&gameUserId=100128&gold1=3&gold2=4&goodsId=test01&pkg=com.sample.pc&platform=PC&productId=D10614A&projectId=P39084A&roleId=000001&roleLevel=1&roleName=钱多多&sdkVersion=4.5.0&serverId=M1603A&serverName=火星服务器&sumPay=5&version=4.5.0&vipLevel=2&way=2&TnCAzFiZrdmMHbsi4u12";
	//MD5加密
	FString SignCode = FMD5::HashBytes((const uint8*)std_str.c_str(),std_str.length());

	//换位
	TCHAR* CStr = SignCode.GetCharArray().GetData();
	const TCHAR l = CStr[1];
	const TCHAR r = CStr[13];
	CStr[1] = r;
	CStr[13] = l;

	const TCHAR l1 = CStr[5];
	const TCHAR r1 = CStr[17];
	CStr[5] = r1;
	CStr[17] = l1;

	const TCHAR l2 = CStr[7];
	const TCHAR r2 = CStr[23];
	CStr[7] = r2;
	CStr[23] = l2;
	
	FString NewString(CStr);

	if (bIsContain)
	{
		ParamsString.Append(TEXT("market="));
		ParamsString.Append(MarketValue);
		ParamsString.Append(TEXT("&"));
	}
	ParamsString.Append(TEXT("sign="));
	ParamsString.Append(NewString);
	UE_LOG(LogHeroUsdk, Log, TEXT(" GetEncodeParames parameUrlEncode : %s"), *ParamsString);
	return ParamsString ;
}

//公共参数
TMap<FString, FString> FChinaManager::GetCommonParameter()
{
	TMap<FString, FString> commonMap;
	commonMap.Emplace("__e__", "1");
	
	const auto ChannelChina =  StaticCastSharedPtr<FChinaConfig>(Config);;

	commonMap.Emplace("productId", ChannelChina->productId);
	commonMap.Emplace("projectId", ChannelChina->projectId);
	commonMap.Emplace("serverId", ChannelChina->serverId);
	commonMap.Emplace("appKey", ChannelChina->appKey);
	commonMap.Emplace("appSecret", ChannelChina->appSecret);
	commonMap.Emplace("pkg", ChannelChina->package);

	FString dn = FPlatformMisc::GetLoginId().ToUpper();
	commonMap.Emplace("deviceNum", dn);
	commonMap.Emplace("platform", "pc");
	commonMap.Emplace("sdkVersion", HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version());
	
	//commonMap.Add("market", "PC");

	return commonMap;
}
//字典转string
FString FChinaManager::ConverMapToString(const TMap<FString,FString>& parameters)
{
	FString parametersJSON;
	if (parameters.Num())
	{
		TSharedPtr<FJsonObject> FieldsObject = MakeShareable(new FJsonObject());
		for (auto& Elem : parameters)
		{
			if (!Elem.Key.IsEmpty()) { FieldsObject->SetStringField(Elem.Key, Elem.Value); }
		}
		TSharedRef<TJsonWriter<TCHAR>> jsonWriter = TJsonWriterFactory<TCHAR>::Create(&parametersJSON);
		FJsonSerializer::Serialize(FieldsObject.ToSharedRef(), jsonWriter);
		UE_LOG(LogHeroUsdk, Log, TEXT(" UHeroUSDKNetAPI : %s"), *parametersJSON);
	}
	return parametersJSON;
}

TMap<FString, FString> FChinaManager::GetJsParamter()
{
	return Config->GetJsParameter();
}


//USDK获取用户信息（防沉迷）
void FChinaManager::UsdkGetUserInfo(const FString UsdkAccessToken, const FGameNetWorkComplete& OnCompleted)
{
	TMap<FString, FString> Params;
	Params.Add("access_token", UsdkAccessToken);
	UE_LOG(LogHeroUsdk, Warning, TEXT(" GetUserInfoResponseData access_token: %s"), *UsdkAccessToken);
	this->CreatePostRequest("auth/getUserInfo.lg", Params,[this, OnCompleted](int32 statueCode, FString Content, bool bWasSuccessful)
	{
		if (!bWasSuccessful)
		{
			UE_LOG(LogHeroUsdk, Error, TEXT("HeroUsdkSupportKit getUserInfo请求失败 "));
			return;
		}
		UE_LOG(LogHeroUsdk, Warning, TEXT(" GetUserInfoResponseData : %s"), *Content);
		if (Content.IsEmpty())
		{
			return;
		}
		if (OnCompleted) { OnCompleted(statueCode,Content,bWasSuccessful); }
	});
}

void FChinaManager::cpKickOffCallBackWithResult(const FString cToken, const FString& Msg)
{
	StopPoll();
	TMap<FString, FString> Params;
	Params.Add("access_token", cToken);
	Params.Add("reason", Msg);
	UE_LOG(LogHeroUsdk, Warning, TEXT(" cpKickOffCallBack access_token: %s"), *cToken);
	this->CreatePostRequest("c1/user/heartbeat/kickOffRpt.lg", Params,[this](int32 statueCode, FString Content, bool bWasSuccessful)
	{
		if (!bWasSuccessful)
		{
			UE_LOG(LogHeroUsdk, Error, TEXT("HeroUsdkSupportKit cpKickOffCallBack请求失败 "));
			return;
		}
		UE_LOG(LogHeroUsdk, Warning, TEXT(" cpKickOffCallBack : %s"), *Content);
		if (Content.IsEmpty())
		{
			return;
		}
	});

	HeroUsdkSupportPcDelegate::GetInstance()->Logout(false);
}
