// Fill out your copyright notice in the Description page of Project Settings.

#pragma once
#include "CoreMinimal.h"

#include "Http.h"
#include "Manager/Channel/Base/ChannelManagerBase.h"


typedef TFunction<void(int32 statueCode,const FString& Content,bool bWasSuccessful)> FGameNetWorkComplete;

/**
 * 
 */

class FChinaManager :	public  FChannelManagerBase, public FTickableGameObject
{


public:
	FChinaManager(UHeroUsdkSubsystem* InSubsystem,const TSharedPtr<FChannelConfigBase>& ChannelConfig,const TSharedPtr<FEnvModeBase>& InEnvMode);
	virtual void Pay(const FHeroUPaymentParameters& paymentParametersData, const FPayOrderResult& PayOrderResult) override;
	FHttpModule * GetHttpModule() ;

	FHttpManager& GetHttpMgr() ;
	
	virtual void Logout() override;

	virtual FString GetQueryVersionUrl() override
	{
		return TEXT("https://sdk-api.yingxiong.com/pcwebv3/version.txt");
	}
	virtual FString GetDownloadCompletedName() override
	{
		return TEXT("PcCompleted");
	}

	virtual FString GetDownLoadWebUrl() override
	{
		return TEXT("https://sdk-api.yingxiong.com/pcwebv3/dist.zip");
	}

	virtual FString GetChannelWebDir() override
	{
		auto Result = FPaths::ConvertRelativePathToFull(FPaths::Combine(GetFinalWebBaseDir(),TEXT("pcwebv3")));
		Result = FPaths::Combine(TEXT("file://"),Result);
		return Result;
	}
	//保存配置
	
	FHeroUPaymentParameters PaymentParameters;
	FPayOrderResult PayOrderResult;
	//access_token
	FString AccessToken ;
	
	float PollInterval = 10 * 60.f;
	float AntiRemain =-1.f;
	FString AntiMsg;
	bool bIsAntiIndulgence = false;
	bool bIsPoll = false;
	float pollRemain = 0.f;
	void Tick(float DeltaTime) override;
	virtual bool IsTickableInEditor() const override
	{
		return true;
	}
	bool IsTickable() const override {return true;}

	TStatId GetStatId() const override;

	void SwitchOnlineStatus(FString accessToken);
	
	//配置接口
	void CreatePostRequest(FString url,const TMap<FString,FString>& Parameter,const FGameNetWorkComplete& netWorkComplete) ;
	void UpdateRemoteInitConfig();

	virtual void Init(TFunction<void(bool bSuccess,const FString& Msg)> Callback) override;

	void GenInitConfig();

	static void ReplaceWebSource(const FString& Dest, const FString& Source);
	//初始化接口
	void createInitRequest(FString url,const FGameNetWorkComplete& netWorkComplete) ;
	
	//获取用户信息
	void createUserInfoReuquest(FString url,const TMap<FString,FString>& paramter,const FGameNetWorkComplete& netWorkComplete) ;
	
	void OpenServicePanel(TSubclassOf<UPC_SurveyPanel> UserWidgetClass, const TFunction<void(bool,const FString&)>& Callback);
	/**
	 * 防沉迷
	 * @param Remaining  seconds left in the countdown
	 */
	void StartCountdown(float Remaining, const FString& Msg);
	void StopCountdown();
	//轮询
	void StartPoll();
	void StopPoll();
	//防沉迷检查
	void IndulgenceCheck(const TMap<FString,FString>& paramter,const FGameNetWorkComplete& netWorkComplete);

	// 国内渠道获取用户信息
	void UsdkGetUserInfo(const FString UsdkAccessToken, const FGameNetWorkComplete& OnCompleted);
	
	void cpKickOffCallBackWithResult(const FString cToken, const FString& Msg);
	
	void ppali(float amount, FString UsdkOrder);

	void nzy(const FString& platformOrderNum);

public:

	//处理初始化结果
	void GetConfigResponseData(FString contentString,const FGameNetWorkComplete& netWorkComplete) ;
	
	//参数编码
	FString GetEncodeParames(const TMap<FString ,FString>&);

	//公共参数
	TMap<FString, FString> GetCommonParameter();
	
	//字典转string
	FString ConverMapToString(const TMap<FString, FString>& parameters);

	virtual TMap<FString,FString> GetJsParamter() override;
	//国内渠道PC通用参数

	bool isAntiKicked = false;
};
