#include "GlobalManager.h"
#include <string>

#include "Manager/Usdk/UsdkManager.h"
#include "HeroUsdkSupportKit.h"
#include "Manager/HeroUsdkSupportPcDelegate.h"
#include "HttpModule.h"
#include "LogHeroUsdk.h"
#include "Config/Channel/Global/GlobalConfig.h"
#include "DotManager/DotManager.h"
#include "Http/UsdkHttpManager.h"
#include "Setting/UsdkSettings.h"
#include "Tool/Archive/RuntimeArchiverBase.h"
#include "Tool/Archive/ArchiverZip/RuntimeArchiverZip.h"
#include "Tools/UsdkCommonTools.h"




FString FGlobalManager::GetQueryVersionUrl()
{
	return TEXT("https://hgsdkcdn.herogame.com/gpcwebv3/version.txt");
}

FString FGlobalManager::GetDownloadCompletedName()
{
	return TEXT("GpcCompleted");
}

FString FGlobalManager::GetDownLoadWebUrl()
{
	return TEXT("https://hgsdkcdn.herogame.com/gpcwebv3/dist.zip");
}



void FGlobalManager::UpdateRemoteInitConfig()
{
	this->CreatePostRequest("v1/sys/init.lg",{},[this](int32 statueCode, FString contentString, bool bWasSuccessful)
	{
		UE_LOG(LogHeroUsdk,Log,TEXT("global remote response:%s"),*contentString);
		TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
		TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(contentString);
		bool bOk = false;
		if (FJsonSerializer::Deserialize(Reader, JsonObject))
		{
			if(JsonObject->HasTypedField<EJson::Number>(TEXT("code")))
			{
				const int32 Code = JsonObject->GetIntegerField(TEXT("code"));
				if(Code == 0)
				{
					FUsdkCommonTools::WriteText("GlobalInitConfig",contentString);
				}
			}
		}
	}) ;
	
	QueryWebVersion(FPaths::Combine(GetFinalWebBaseDir(),TEXT("gpcwebv3"), TEXT("version.txt")));
}

void FGlobalManager::ReplaceWebSource(const FString& Dest, const FString& Source)
{
	if (IFileManager::Get().FileExists(*FPaths::Combine(Source,TEXT("GpcCompleted"))))
	{
		FString GlobalSource = FPaths::Combine(Source,TEXT("gpcwebv3"));
		FString GlobalDest = FPaths::Combine(Dest,TEXT("gpcwebv3"));
		FPlatformFileManager::Get().GetPlatformFile().DeleteDirectoryRecursively(*GlobalDest);
		if(!FPlatformFileManager::Get().GetPlatformFile().DirectoryExists(*Dest))
		{
			FPlatformFileManager::Get().GetPlatformFile().CreateDirectoryTree(*Dest);
		}
		bool ret = FPlatformFileManager::Get().GetPlatformFile().CopyDirectoryTree(*GlobalDest, *GlobalSource, true);
		FPlatformFileManager::Get().GetPlatformFile().DeleteDirectoryRecursively(*Source);
	}
}

void FGlobalManager::Init(TFunction<void(bool bSuccess, const FString& Msg)> Callback)
{
	
	ReplaceWebSource(GetFinalWebBaseDir(),GetWebBaseMidDir());
	
	FDotManager::GetInstance().CallDot("g_init_start");
 
	FString GlobalConfig = UUsdkBaseWidget::GetUeDataInteral("INIT_DATA_GLOBAL");
	if(!GlobalConfig.Len())
	{
		GlobalConfig = GetMutableDefault<UUsdkSettings>()->UsdkInitConfig;
	}

	UpdateRemoteInitConfig();

	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(GlobalConfig);
	bool bOk = false;
	if (FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		if(JsonObject->HasTypedField<EJson::Number>(TEXT("code")))
		{
			const int32 Code = JsonObject->GetIntegerField(TEXT("code"));
			if(Code == 0)
			{
				FDotManager::GetInstance().CallDot("g_init_end");
				bOk = true;
				auto helpInfo = JsonObject->GetObjectField(TEXT("helpInfo"));
				if(helpInfo.IsValid())
				{
					LogoutURL =helpInfo->GetStringField("logoutUrl");
				}
			}
		}
	}
	Callback(bOk,{});
}

void FGlobalManager::GenInitConfig()
{
	this->CreatePostRequest("v1/sys/init.lg",{},[this](int32 statueCode, FString contentString, bool bWasSuccessful)
	{
		auto setting = GetMutableDefault<UUsdkSettings>();
			setting->GlobalInitConfig = contentString;
			setting->SaveConfig(CPF_Config,*FPaths::Combine(FPaths::ProjectConfigDir(),TEXT("DefaultGame.ini")));
	}) ;

	DownLoadWebFile(GetFinalWebBaseDir());
}

void FGlobalManager::Survey(TSubclassOf<UPC_SurveyPanel> UserWidgetClass, const FString& WebId,
                            const TFunction<void(bool, const FString&)>& Callback)
{
	TMap<FString,FString> Req;
	Req.Emplace("webId",WebId);
	this->CreatePostRequest("/v1/h5c/clientConf",Req,[this,Callback, UserWidgetClass](int32 statueCode, FString contentString, bool bWasSuccessful)
	{
		if (!contentString.IsEmpty())
		{
			TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
			TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(contentString);
			if (FJsonSerializer::Deserialize(Reader, JsonObject))
			{
				const auto Url = JsonObject->GetStringField(TEXT("url"));
				if (!Url.IsEmpty())
				{
					UWorld* WorldToRecordIn = nullptr;

					for (const FWorldContext& WorldContext : GEngine->GetWorldContexts())
					{
						if (WorldContext.WorldType == EWorldType::PIE || WorldContext.WorldType == EWorldType::Game )
						{
							WorldToRecordIn = WorldContext.World();
							break;
						}
						else if (WorldContext.WorldType == EWorldType::Editor)
						{
							WorldToRecordIn = WorldContext.World();
						}
					}

					check(WorldToRecordIn);
					
					if (UserWidgetClass)
					{
						TMap<FString,FString> param;
						
						
						param.Emplace("u",HeroUsdkSupportPcDelegate::GetInstance()->GetUserInfo().sdkUserId);
					
						param.Emplace("c",FString::FromInt(HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->GetChannelId()));
						
						param.Emplace("r",HeroUsdkSupportPcDelegate::GetInstance()->GetRoleInfo().roleId);
						const auto Encry = FUsdkManager::SimpleEncryption(param);
						const auto FullUrl = Url+"?sojumpparm="+Encry;
			
						auto SurveyPanel = CreateWidget<UPC_SurveyPanel>(WorldToRecordIn, UserWidgetClass);
						SurveyPanel->SetFlags(RF_Transient);
						SurveyPanel->SetUrl(FullUrl);
						SurveyPanel->AddToViewport(100);
			
					}
				}
			}
		}
	});
}

void FGlobalManager::Logout()
{
	UUsdkBaseWidget::SetUeDataInteral(TEXT("GLOBAL_LOGIN_CACHE"), {});
}

TMap<FString, FString> FGlobalManager::GetJsParamter()
{
	return Config->GetJsParameter();
}

void FGlobalManager::Pay(const FHeroUPaymentParameters& PaymentParameters, const FPayOrderResult& PayOrderResult)
{
	TMap<FString,FString> DotParam;
	DotParam.Emplace("goods_id",PaymentParameters.goodsId);
	DotParam.Emplace("goods_name",PayOrderResult.goodsName);
	DotParam.Emplace("goods_info",PayOrderResult.goodsDesc);
	DotParam.Emplace("amount",PayOrderResult.goodsDesc);
	DotParam.Emplace("coin_type",PayOrderResult.currency);
	DotParam.Emplace("cp_order",PaymentParameters.cpOrder);
	DotParam.Emplace("result","1");
	DotParam.Emplace("reason","");
	FDotManager::GetInstance().CallDot("g_p_call",DotParam);
	//支付页面回调
						
	FDotManager::GetInstance().CallDot("u_p_call",DotParam);
	FDotManager::GetInstance().CallDot("g_p_view_start");
	if(Subsystem->BP_Pay)
	{
		auto Pannel = CreateWidget<UPC_PayPannel>(Subsystem->GetGameInstance(),Subsystem->BP_Pay);
		Pannel->SetPayParam(PaymentParameters,PayOrderResult);
		Pannel->AddToViewport(100);
	}
	
	return;
}

void FGlobalManager::CreatePostRequest(FString url, const TMap<FString, FString>& Parameter, const TFunction<void(int32 statueCode, FString contentString, bool bWasSuccessful)>& Callback)
{
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	const FString bodyStr =Enctrypt(Parameter);
	FUsdkHttpManager::GetInst().Post(url,bodyStr,Callback);
#endif
}

TMap<FString, FString> FGlobalManager::GetCommonParameter()
{
	TMap<FString, FString> commonMap;
	const FString dn = FPlatformMisc::GetLoginId().ToUpper();
	commonMap.Emplace("dn", dn);
	
	const auto channel_global =  StaticCastSharedPtr<FGlobalConfig>(Config);
	
	commonMap.Emplace("gid", channel_global->game_id);
	commonMap.Emplace("lang",  HeroUsdkSupportPcDelegate::GetInstance()->GetCurrentLanguage());
	commonMap.Emplace("pk", channel_global->package);
	commonMap.Emplace("platform", "2");
	commonMap.Emplace("projectId", channel_global->projectId);
	commonMap.Emplace("svc",HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version());
	commonMap.Emplace("svn",HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version());
	commonMap.Emplace("vn", channel_global->gameName);

	return commonMap;
}

FString FGlobalManager::Enctrypt(const TMap<FString, FString>& Parameter)
{
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	TMap<FString, FString> AllParam;
	AllParam.Append(Parameter);
	AllParam.Append(GetCommonParameter());
	AllParam.KeySort([](const FString& A, const FString& B) { return A < B; });
	auto Json = FUsdkCommonTools::converMapToString(AllParam);
	//base64加密
	auto base64 = FBase64::Encode(Json);
	//换位
	auto Data= EnctryptSwap(base64);

	//时间戳
	FDateTime Time = FDateTime::UtcNow();
	int64 unixTimestamp = Time.ToUnixTimestamp();

	//签名原型
	FString SignRaw = FString::Printf(TEXT("data=%s&pcode=%s&timestamp=%lld&%s"),*Data,
		*Config->GetProductId(),unixTimestamp,*Config->GetProductKey());
	std::string std_Sign=TCHAR_TO_UTF8(*SignRaw);

	//hash签名
	FString SignHash = FMD5::HashBytes((const uint8*)std_Sign.c_str(),std_Sign.length());
	FString Result=FString::Printf(TEXT("data=%s&pcode=%s&timestamp=%lld&sign=%s"),*FGenericPlatformHttp::UrlEncode(Data),
		*Config->GetProductId(),unixTimestamp,*SignHash);
	

	return Result;
#endif
	return "";
}
	

	

FString FGlobalManager::EnctryptSwap(const FString& In)
{
	FString Result = In;
	const TArray<int32> ChangePos = {1,33,10,42,18,50,19,51};
	if(Result.Len()>51)
	{
		for(int32 i = 0;i<ChangePos.Num();i+=2)
		{
			auto& A = Result[ChangePos[i]];
			auto& B = Result[ChangePos[i+1]];
			Swap(A,B);
		}
	}
	return Result;
}


