#pragma once
#include "PC_SurveyPanel.h"
#include "Data/HeroUsdkSupportData.h"
#include "Data/PayOrderResult.h"
#include "Manager/Channel/Base/ChannelManagerBase.h"

class FGlobalManager:	public  FChannelManagerBase
{
public:
	FGlobalManager(UHeroUsdkSubsystem* InSubsystem,const TSharedPtr<FChannelConfigBase>& ChannelConfig,const TSharedPtr<FEnvModeBase>& InEnvMode)
	:FChannelManagerBase(InSubsystem,ChannelConfig,InEnvMode){}

	virtual FString GetQueryVersionUrl() override;
	virtual FString GetDownloadCompletedName() override;

	virtual FString GetDownLoadWebUrl() override;
	void UpdateRemoteInitConfig();
	static void ReplaceWebSource(const FString& Dest, const FString& Source);
	virtual void Init(TFunction<void(bool bSuccess,const FString& Msg)> Callback) override;

	void GenInitConfig();
	void Survey(TSubclassOf<UPC_SurveyPanel> UserWidgetClass, const FString& WebId ,const TFunction<void(bool,const FString&)>& Callback);
	virtual void Logout() override;

	virtual TMap<FString,FString> GetJsParamter() override;

	virtual void Pay(const FHeroUPaymentParameters& paymentParametersData, const FPayOrderResult& PayOrderResult) override;

	virtual FString GetChannelWebDir() override
	{
		auto Result = FPaths::ConvertRelativePathToFull(FPaths::Combine(GetFinalWebBaseDir(),TEXT("gpcwebv3")));
		Result = FPaths::Combine(TEXT("file://"),Result);
		return Result;
	}
private:
	void CreatePostRequest(FString url,const TMap<FString,FString>& Parameter, const TFunction<void(int32 statueCode, FString contentString, bool bWasSuccessful)>& Callback);
	TMap<FString, FString> GetCommonParameter();
	FString Enctrypt(const TMap<FString,FString>& Parameter);
	FString EnctryptSwap(const FString& In);
	
};
