#include "WeGameManager.h"
#ifdef USE_WEGAME
#include "Tools/UsdkCommonTools.h"

#include "HeroUsdkSupportKit.h"
#include "LogHeroUsdk.h"
#include "Config/Channel/WeGame/FWeGameConfig.h"

FWeGameManager::FWeGameManager(UHeroUsdkSubsystem* InSubsystem, const TSharedPtr<FChannelConfigBase>& ChannelConfig,
                               const TSharedPtr<FEnvModeBase>& InEnvMode): FChinaManager(InSubsystem, ChannelConfig, InEnvMode)
{
	LoadLib();
#if !UE_BUILD_SHIPPING
	const char* debug_mode = "--rail_debug_mode";
	auto WegameConfig = StaticCastSharedPtr<FWeGameConfig>(Config);
	int id =FCString::Atoi(* WegameConfig->game_id);
	auto ret = invoker.RailNeedRestartAppForCheckingEnvironment( id, 1, &debug_mode);
	if (ret == false) {
		// 初始化失败需要退出
		UE_LOG(LogHeroUsdk, Error, TEXT("WeGame set debug env failed"));
		return;
	}
#endif
}

FWeGameManager::~FWeGameManager()
{
	FreeLib();
}

void FWeGameManager::Init(TFunction<void(bool bSuccess, const FString& Msg)> Callback)
{
	bool ret = invoker.RailInitialize();
	if (ret == false) {
		UE_LOG(LogHeroUsdk, Error, TEXT("WeGame RailInitialize failed"));
		// 初始化失败需要退出
		Callback(false, TEXT("RailInitialize error"));
		return;
	}
	RegisterEventListener(rail::kRailEventSystemStateChanged);
	RegisterEventListener(rail::kRailEventSessionTicketGetSessionTicket);
	RegisterEventListener(rail::kRailEventAntiAddictionCustomizeAntiAddictionActions);
	RegisterEventListener(rail::kRailEventInGameStorePurchasePaymentResult);
	RegisterEventListener(rail::kRailEventInGameStorePurchasePayWindowClosed);
	Supper::Init(Callback);
}

void FWeGameManager::Login()
{
	isAntiKicked = false;
	rail::IRailPlayer* rail_player = invoker.RailFactory()->RailPlayer();
	rail_player->AsyncAcquireSessionTicket({});
}

void FWeGameManager::Logout()
{
}

TMap<FString, FString> FWeGameManager::GetJsParamter()
{
	return {};
}

void FWeGameManager::Pay(const FHeroUPaymentParameters& paymentParametersData, const FPayOrderResult& InPayOrderResult)
{
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(InPayOrderResult.serverMsg);
	if (!FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		UE_LOG(LogHeroUsdk,Error,TEXT("wegame get pay json data error"))
	}
	auto channelOrderId = JsonObject->GetStringField("channelOrderId");
	

	rail::IRailInGameStorePurchaseHelper* helper = invoker.RailFactory()->RailInGameStorePurchaseHelper();
	rail::RailString RailOrderId = TCHAR_TO_UTF8(*channelOrderId); 
	rail::RailString RailUserData;
	rail::RailResult ret = helper->AsyncShowPaymentWindow(RailOrderId,RailUserData);
	isPay= true;
	if (ret!=rail::kSuccess)
	{
		UE_LOG(LogHeroUsdk,Error,TEXT("wegame can't open pay window"))
		HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkFailed,{},{}) ;
  
	}
}

TStatId FWeGameManager::GetStatId() const
{
	RETURN_QUICK_DECLARE_CYCLE_STAT(FWeGameManager, STATGROUP_Tickables);
}


void FWeGameManager::LoadLib()
{
	FString DllName;

	DllName = TEXT("rail_api64.dll");
	
	FString DllPath;
#if WITH_EDITOR
	DllPath = FPaths::ProjectPluginsDir() + "HeroUSDKPlugin/Source/HeroUSDKPlugin/Windows/WeGame/rail/libs/win/Release_64/" + DllName;
#else
	DllPath = FPaths::ConvertRelativePathToFull( FPaths::ProjectDir() + "Binaries/ThirdParty/WeGame/Win64/" + DllName);
#endif

	if (FPaths::FileExists(DllPath)) {
		DllHandle = (HMODULE)FPlatformProcess::GetDllHandle(*DllPath);
		if (!DllHandle) {
			UE_LOG(LogTemp, Error, TEXT("load WeGame Dll failed"));
		}
		else
		{
			invoker=rail::helper::Invoker(DllHandle);

		}
	} else {
		UE_LOG(LogTemp, Error, TEXT("WeGame Dll Path not exist"));
	}
}


void FWeGameManager::FreeLib()
{
	if (DllHandle) {
		FPlatformProcess::FreeDllHandle(DllHandle);
		DllHandle = nullptr;
	}
}

void FWeGameManager::RegisterEventListener(rail::RAILEventID event_id)
{
	invoker.RailRegisterEvent(event_id,this);
}

void FWeGameManager::UnRegisterEventListener(rail::RAILEventID event_id)
{
	invoker.RailUnregisterEvent(event_id, this);
}

void FWeGameManager::OnRailEvent(rail::RAIL_EVENT_ID event_id, rail::EventBase* param)
{
    if (event_id == rail::kRailEventSystemStateChanged) {
        rail::rail_event::RailSystemStateChanged* event =
            static_cast<rail::rail_event::RailSystemStateChanged*>(param);
        if (event->state == rail::kSystemStatePlatformOffline ||
            event->state == rail::kSystemStatePlatformExit ||
            event->state == rail::kSystemStatePlayerOwnershipExpired ||
            event->state == rail::kSystemStateGameExitByAntiAddiction) {
        	HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginInvalid(TEXT("WeGame Quit"));
            }
    }

    else if (event_id == rail:: kRailEventSessionTicketGetSessionTicket)
    {
        rail::rail_event::AcquireSessionTicketResponse* eSessionTicket =  static_cast<rail::rail_event::AcquireSessionTicketResponse*>(param);
        if (eSessionTicket->result==rail::RailResult::kSuccess)
        {
        	FString ticket = UTF8_TO_TCHAR(eSessionTicket->session_ticket.ticket.c_str());
	        rail::RailID railID = eSessionTicket->rail_id;
        	rail::IRailPlayer* rail_player = invoker.RailFactory()->RailPlayer();
        	rail::RailString name;
        	rail_player->GetPlayerName(&name);


        	FString loginInfo;
        	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject());
        	JsonObject->SetStringField("ticket",ticket);
        	JsonObject->SetStringField("railId",FString::Printf(TEXT("%llu"),railID.get_id()));
        	JsonObject->SetStringField("userName",UTF8_TO_TCHAR(name.c_str()));
        	
        	TSharedRef<TJsonWriter<TCHAR>> jsonWriter = TJsonWriterFactory<TCHAR>::Create(&loginInfo);
        	FJsonSerializer::Serialize(JsonObject.ToSharedRef(), jsonWriter);
        	
        	
        	UUsdkBaseWidget::SetUeDataInteral("APP_DATE_WEGAME",loginInfo);
        	if(Subsystem->BP_Login)
        	{
        		POP_USDK_PANNEL(UPC_LoginPannel,Subsystem->BP_Login);
        	}
        }
        else
        {
        	HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(
										HeroUsdkFailed, {},FString::FromInt(eSessionTicket->result));
            UE_LOG(LogTemp,Log,TEXT("WegameManager OnRailEvent rail:: kRailEventSessionTicketGetSessionTicket,errorCode:%d"),eSessionTicket->result);
        }
    }
    //防成谜
    else if (event_id == rail::kRailEventAntiAddictionCustomizeAntiAddictionActions)
    {
        rail::rail_event::RailCustomizeAntiAddictionActions* AddictionActions =  static_cast<rail::rail_event::RailCustomizeAntiAddictionActions*>(param);
        rail::RailString RailAntiAddictionString = AddictionActions->anti_addiction_actions;

    	FString AntiAddMsg = UTF8_TO_TCHAR(RailAntiAddictionString.c_str());
    	/*TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
    	const TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(AntiAddMsg);
    	if (!FJsonSerializer::Deserialize(Reader, JsonObject))
    	{
    		UE_LOG(LogTemp, Error, TEXT("WeGame AntiAddMsg Json Parse Error,Json:%s"), *AntiAddMsg);
    		return;
    	}

    	FString Msg;
    	if (JsonObject->HasTypedField<EJson::Array>("actions"))
    	{
    		auto arr = JsonObject->GetArrayField("actions");
    		for (auto& it : arr)
    		{
    			auto obj = it->AsObject();
    			auto action = obj->GetObjectField("action");
    			if (action->HasTypedField<EJson::String>("content"))
    			{
    				Msg = action->GetStringField("content");
    				break;
    			}
    		}
    	}*/
    	if (isAntiKicked) return;
    	HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginInvalid(AntiAddMsg);
    	isAntiKicked = true;
    }
    //支付结果
    else if(event_id == rail::kRailEventInGameStorePurchasePaymentResult)
    {
    	if (!isPay) return;
        rail::rail_event::RailInGameStorePurchaseResult* PurchaseResult =  static_cast<rail::rail_event::RailInGameStorePurchaseResult*>(param);
        rail::RailString order_id = PurchaseResult->order_id;
        
        UE_LOG(LogHeroUsdk,Log,TEXT("WegameManager OnRailEvent rail::kRailEventInGameStorePurchasePaymentResult: %s"),UTF8_TO_TCHAR(order_id.c_str()));
    	HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkSuccess,{},TEXT("Pay Success")) ;
    }
    else if (event_id == rail::kRailEventInGameStorePurchasePayWindowDisplayed)
    {
        UE_LOG(LogHeroUsdk,Log,TEXT("WegameManager OnRailEvent rail::kRailEventInGameStorePurchasePayWindowDisplayed"))
    }
  
    //关闭支付窗口
    else if(event_id == rail::kRailEventInGameStorePurchasePayWindowClosed)
    {
    	if (!isPay) return;
    	rail::rail_event::RailInGameStorePurchasePayWindowClosed* WindowClosed =  static_cast<rail::rail_event::RailInGameStorePurchasePayWindowClosed*>(param);
    	UE_LOG(LogHeroUsdk,Log,TEXT("WegameManager OnRailEvent rail::kRailEventInGameStorePurchasePaymentResult: %s"),UTF8_TO_TCHAR(WindowClosed->order_id.c_str()));
    	HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkCancel,{},TEXT("cancel")) ;

    }
	
}

void FWeGameManager::GetPurechaseProductInfo()
{
	rail::IRailInGamePurchase* game_purchase = invoker.RailFactory()->RailInGamePurchase();
	game_purchase->AsyncRequestAllPurchasableProducts("dddd");
}

void FWeGameManager::Tick(float DeltaTime)
{
	Supper::Tick(DeltaTime);
	invoker.RailFireEvents();
}


#endif