// Fill out your copyright notice in the Description page of Project Settings.

#pragma once
#include "CoreMinimal.h"
#include "Manager/Channel/China/ChinaManager.h"

#ifdef USE_WEGAME
#include "rail/sdk/rail_event.h"
#include "rail/sdk/rail_function_helper.h"


/**
 * 
 */

class FWeGameManager : public  FChinaManager
	,public  rail::IRailEvent
{
public:
	typedef FChinaManager Supper;
	FWeGameManager(UHeroUsdkSubsystem* InSubsystem, const TSharedPtr<FChannelConfigBase>& ChannelConfig,
		const TSharedPtr<FEnvModeBase>& InEnvMode);
	~FWeGameManager() override;
	virtual void Init(TFunction<void(bool bSuccess, const FString& Msg)> Callback) override;
	void Login();
	virtual void Logout() override;
	virtual TMap<FString, FString> GetJsParamter() override;
	virtual void Pay(const FHeroUPaymentParameters& paymentParametersData,
		const FPayOrderResult& PayOrderResult) override;
	TStatId GetStatId() const override;
private:


	void LoadLib();
	void FreeLib();
	void RegisterEventListener(rail::RAILEventID event_id);
	void UnRegisterEventListener(rail::RAILEventID event_id);
	void OnRailEvent(rail::RAIL_EVENT_ID event_id, rail::EventBase* param) override;
	void GetPurechaseProductInfo();
public:
	virtual void Tick(float DeltaTime) override;

private:
	rail::helper::Invoker invoker{nullptr};
	HMODULE DllHandle = nullptr;
	bool isPay = true;
};
#endif


