// Fill out your copyright notice in the Description page of Project Settings.


#include "Manager/HeroUsdkSupportPcDelegate.h"
#include <string>
#include "Manager/Usdk/UsdkManager.h"
#include "HeroUsdkSubsystem.h"
#include "HeroUsdkSupportKit.h"
#include "JsonObjectConverter.h"
#include "LogHeroUsdk.h"
#include "PC_PayPannel.h"
#include "PC_ProtocolPannel.h"
#include "Blueprint/UserWidget.h"
#include "Channel/Bili/BiliManager.h"
#include "Channel/China/ChinaManager.h"
#include "Channel/Global/GlobalManager.h"
#include "Channel/WeGame/WeGameManager.h"
#include "Config/Channel/Bili/BiliConfig.h"
#include "Config/Channel/China/ChinaConfig.h"
#include "Config/Channel/Global/GlobalConfig.h"
#include "Config/Channel/Steam/SteamConfig.h"
#include "Config/Channel/WeGame/FWeGameConfig.h"
#include "DotManager/DotManager.h"
#include "Env/DebugEnv/Bili/EnvBiliDebug.h"
#include "Env/DebugEnv/China/EnvChinaDebug.h"
#include "Env/DebugEnv/Global/EnvGlobalDebug.h"
#include "Env/ReleaseEnv/Bili/EnvBiliRelease.h"
#include "Env/ReleaseEnv/China/EnvChinaRelease.h"
#include "Env/ReleaseEnv/Global/EnvGlobalRelease.h"
#include "Http/UsdkHttpManager.h"
#include "Kismet/KismetSystemLibrary.h"
#include "Setting/UsdkSettings.h"
#include "Tools/UsdkCommonTools.h"
#ifdef USE_TAPTAP
#include "TapUELogin.h"
#include "TapUECommon.h"
#endif

const TMap<EHeroUsdkLanguageFlag, FString> UsdkLocaleMap = TMap<EHeroUsdkLanguageFlag, FString>({
	{EHeroUsdkLanguageFlag::HeroLanguageSystem, "system"},
	{EHeroUsdkLanguageFlag::HeroLanguageZhHans, "zh-CN"},
	{EHeroUsdkLanguageFlag::HeroLanguageZhHant, "zh-HK"},
	{EHeroUsdkLanguageFlag::HeroLanguageEn, "en"},
	{EHeroUsdkLanguageFlag::HeroLanguageJa, "ja"},
	{EHeroUsdkLanguageFlag::HeroLanguageKo, "ko"},
});

#if PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
#ifdef USE_STEAM

#include "steam/steam_api.h"
#include "Online.h"

#endif

#endif

HeroUsdkSupportPcDelegate* HeroUsdkSupportPcDelegate::Singleton = nullptr;

HeroUsdkSupportPcDelegate* HeroUsdkSupportPcDelegate::GetInstance()
{
	if (Singleton == nullptr)
	{
		Singleton = new HeroUsdkSupportPcDelegate();
	}
	return Singleton;
}

FString HeroUsdkSupportPcDelegate::GetCurrentLanguage()
{
	FString Result;
	if(PcsdkLanguage == EHeroUsdkLanguageFlag::HeroLanguageSystem)
	{
		Result = FPlatformMisc::GetDefaultLanguage();
	}
	else
	{
		Result = UsdkLocaleMap[PcsdkLanguage];
	}
	return Result;
}

//初始化回调


void HeroUsdkSupportPcDelegate::SetSdkLanguage(EHeroUsdkLanguageFlag Language)
{
	FUsdkCommonTools::WriteText("language",FString::FromInt(static_cast<uint8>(Language)));
	PcsdkLanguage = Language;
}

void HeroUsdkSupportPcDelegate::Init()
{

	auto Setting = GetMutableDefault<UUsdkSettings>();
	if (Setting->Channel == EHeroUSDKChannel::Global &&IsPureVersion())
	{
		HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onProtocolAgree();
		ChannelInit();
		return;
	}
	
	UsdkManager->UsdkInit([this,Setting](EUsdkResult Result,bool bPopAgreement, const FString& Msg)
	{
		
		if(Result!=EUsdkResult::Success)
		{
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onInitCallBack(HeroUsdkFailed,TEXT("初始化失败,请稍后重试"));
		}
		else
		{
			if(bPopAgreement &&( Setting->Channel == EHeroUSDKChannel::China || Setting->Channel == EHeroUSDKChannel::WeGame))
			{
				FDotManager::GetInstance().CallDot("u_deal_start");
				bIsInitAgreement = true;
				if(Subsystem->BP_Proto)
				{
					POP_USDK_PANNEL(UPC_ProtocolPannel,Subsystem->BP_Proto);
				}
			}
			else
			{
				HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onProtocolAgree();
				ChannelInit();
			}
		}
	});
}

void HeroUsdkSupportPcDelegate::ChannelInit()
{
	ChannelManager->Init([](bool bSuccess,const FString& msg)
		{
			if(bSuccess)
			{
				HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onInitCallBack(HeroUsdkSuccess,{});
				return;
			}
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onInitCallBack(HeroUsdkFailed,{});
			return;
		});
}


//进行游戏角色信息上报
void HeroUsdkSupportPcDelegate::EnterGame(const FHeroHDCGameRoleInfo& RoleInfo)
{
	TMap<FString, FString> eventProperties;
	eventProperties.Emplace("role_id",RoleInfo.roleId);
	eventProperties.Emplace("role_name",RoleInfo.roleName);
	eventProperties.Emplace("server_id",RoleInfo.serverId);
	eventProperties.Emplace("server_name",RoleInfo.serverName);
	FDotManager::GetInstance().CallDot("u_role_login_success",eventProperties);
	const auto Setting = GetMutableDefault<UUsdkSettings>();
	if (Setting->Channel == EHeroUSDKChannel::Global &&IsPureVersion())
	{
		return;
	}
	_role_info = RoleInfo;
	UsdkManager->EnterGame(RoleInfo);
}

//创建角色信息上报
void HeroUsdkSupportPcDelegate::CreateNewRole(const FHeroHDCGameRoleInfo& RoleInfo)
{
	FDotManager::GetInstance().CallDot("u_creat_role_success");
	const auto Setting = GetMutableDefault<UUsdkSettings>();
	if (Setting->Channel == EHeroUSDKChannel::Global && IsPureVersion())
	{
		return;
	}
	_role_info = RoleInfo;

	UsdkManager->CreateNewRole(RoleInfo);
}

//角色升级信息上报
void HeroUsdkSupportPcDelegate::RoleLevelUp(const FHeroHDCGameRoleInfo& RoleInfo)
{
	const auto Setting = GetMutableDefault<UUsdkSettings>();
	if (Setting->Channel == EHeroUSDKChannel::Global && IsPureVersion())
	{
		return;
	}
	_role_info = RoleInfo;
	UsdkManager->RoleLevelUp(RoleInfo);
}

//登出
void HeroUsdkSupportPcDelegate::Logout(bool DoesNotifyCp)
{
	if (UsdkManager == nullptr) {
		return;
	}

	ChannelManager->Logout();
	
	if (UsdkManager )
	{
		UsdkManager->UsdkAccessToken = nullptr ;
		
	}
#ifdef USE_TAPTAP
	if (isTapTapLogin)
	{
		TapUELogin::Logout();
	}
#endif

	FDotManager::GetInstance().CallDot("u_user_login_out");
	if(DoesNotifyCp)
	{
		HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLogoutCallBack(HeroUsdkSuccess,TEXT("退出登录成功"));
	}
}


//登录
void HeroUsdkSupportPcDelegate::LoginWithPC()
{
	FDotManager::GetInstance().CallDot("u_l_strike");
	FDotManager::GetInstance().CallDot("u_l_call");

	auto setting = GetMutableDefault<UUsdkSettings>();
	if (setting->Channel == EHeroUSDKChannel::Steam)
	{
		// Steam登录
		FString authTicket = GetSteamAuthToken(0);
		_authTicket = authTicket ;
	}
#if PLATFORM_WINDOWS
	else if(setting->Channel == EHeroUSDKChannel::Bilibili)
	{
		auto BiliManager = StaticCastSharedPtr<FBiliManager>(ChannelManager);
		if(BiliManager)
		{
			BiliManager->Login();
		}
	}
#endif
#ifdef USE_WEGAME
	else if(setting->Channel == EHeroUSDKChannel::WeGame)
	{
		auto WeGameManager = StaticCastSharedPtr<FWeGameManager>(ChannelManager);
		if(WeGameManager)
		{
			WeGameManager->Login();
		}
	}
#endif
	else
	{
		
		/*if(isLogining)
		{
			return;
		}
		isLogining = true;*/
		FDotManager::GetInstance().CallDot("u_l_call");
		if(Subsystem->BP_Login)
		{
			POP_USDK_PANNEL(UPC_LoginPannel,Subsystem->BP_Login);
		}
	}
}

/*
 * 获取SteamToken
 */
FString HeroUsdkSupportPcDelegate::GetSteamAuthToken(int32 LocalUserNum)
{
	
#ifdef USE_STEAM
	IOnlineSubsystem *ion = IOnlineSubsystem::Get(STEAM_SUBSYSTEM);
	if (ion)
	{
		return ion->GetIdentityInterface()->GetAuthToken(LocalUserNum);
	}
	UE_LOG(LogHeroUsdk,Warning,TEXT("GetSteamAuthToken couldn`t find the Steam "));
#endif
	
	return "";
}

/*
* 获取Steam当前语言
*/

FString HeroUsdkSupportPcDelegate::GetCurrentGameLanguage()
{
	
#ifdef USE_STEAM
	
	const char *langChar = SteamApps()->GetCurrentGameLanguage();
	FString FrameAsFString = UTF8_TO_TCHAR(langChar);
	return FrameAsFString;
	
#endif

	return "" ;
}

/*
 * Steam登录
 */
void HeroUsdkSupportPcDelegate::steamLogin(TMap<FString, FString> paramter)
{
	UsdkManager->UsdkLogin(paramter,[](EUsdkResult Result, const FString& ErrorMsg,const FUserInfo& LoginUserInfo)
	{
		if(Result == EUsdkResult::Failed)
		{
			if (HeroUsdkSupportKit::GetInstance().NotifyObject != nullptr)
			{
				//登录失败回调
				HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(
					HeroUsdkFailed, "", ErrorMsg);
			}
			HeroUsdkSupportPcDelegate::GetInstance()->Logout();
		}
		else if(Result == EUsdkResult::Success)
		{
			FString profile;
			FJsonObjectConverter::UStructToJsonObjectString(LoginUserInfo, profile, 0, 0);
			if (!profile.IsEmpty() && HeroUsdkSupportKit::GetInstance().NotifyObject != nullptr)
			{
				HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(
					HeroUsdkSuccess, profile,TEXT("登录成功"));
			}
		}
	});
	UsdkManager->UsdkCheckLogin(paramter,[this](int32 statueCode, FString contentString,bool bWasSuccessful)
	{
		if (!bWasSuccessful)
		{
			UE_LOG(LogHeroUsdk, Error, TEXT("HeroUsdkSupportKit 登录验证请求失败 "));
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(HeroUsdkFailed,"",TEXT("登录验证失败,请稍后重试"));
			return;
		}
		UE_LOG(LogHeroUsdk, Log, TEXT(" UsdkCheckLogin : %s"), *contentString);
		if (contentString.IsEmpty())
		{
			UE_LOG(LogHeroUsdk, Log, TEXT(" PhoneLoginResponseData : %s"), *contentString);
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(HeroUsdkFailed,"",TEXT("登录验证失败,请稍后重试"));
		}
	});
}

void HeroUsdkSupportPcDelegate::TapTapLogin()
{
#ifdef USE_TAPTAP
	if (!isTapTapInit)
	{
		auto initData = UUsdkBaseWidget::GetUeDataInteral(TEXT("INIT_DATA_INTERNAL"));

		TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
		TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(initData);
		
		FJsonSerializer::Deserialize(Reader, JsonObject);
	
		auto thirdLogin = JsonObject->GetObjectField("thirdLogin");
		auto taptap = thirdLogin->GetObjectField("taptap");
		//@todo
		FTULoginConfig Config;
		Config.ClientID = taptap->GetStringField("appId");
		Config.RegionType = ERegionType::CN;
		TapUELogin::Init(Config);
		isTapTapInit = true;
	}
	

	// 获取缓存的登录信息
	TSharedPtr<FTUAccessToken> AccessToken = TapUELogin::GetAccessToken();
	if (AccessToken.IsValid())
	{
		// 已登录，可获取用户信息，直接进入游戏
		TapTapLoginCompleted();
	}
	else
	{
		// 未登录, 重新发起登录授权，参数为授权范围，具体可选参数参考 TUType::PermissionScope
		TapUELogin::Login({TUType::PermissionScope::Profile}, [this](const TUAuthResult& Result) {
			if (Result.GetType() == TUAuthResult::Success) {
				
				TapTapLoginCompleted();
			}
			else if (Result.GetType() == TUAuthResult::Cancel) {
				// 登录取消
				POP_USDK_PANNEL(UPC_LoginPannel,Subsystem->BP_Login);
			}
			else {
				// 登录失败
			}
		});
	}
#endif
}

void HeroUsdkSupportPcDelegate::TapTapLoginCompleted()
{
#ifdef USE_TAPTAP
	isTapTapLogin = true;
	// 登录成功，获取用户信息
	TSharedPtr<FTULoginProfileModel> Profile = TapUELogin::GetProfile();
	TSharedPtr<FTUAccessToken> AccessToken = TapUELogin::GetAccessToken();
	FString tokenStr;
	FJsonObjectConverter::UStructToJsonObjectString(*AccessToken,tokenStr);
	FString UserInfoStr;
	FJsonObjectConverter::UStructToJsonObjectString(*Profile,UserInfoStr);
	
	UUsdkBaseWidget::SetUeDataInteral("APP_DATA_TAPTAP",UserInfoStr);
	UUsdkBaseWidget::SetUeDataInteral("APP_DATA_TAPTAP_TOKEN",tokenStr);
	if(Subsystem->BP_Login)
	{
		POP_USDK_PANNEL(UPC_LoginPannel,Subsystem->BP_Login);
		Pannel->JumpToTapTapUrl();
	}
#endif
}


//支付
void HeroUsdkSupportPcDelegate::Pay(const FHeroUPaymentParameters& paymentParametersData,
                                    const FHeroHDCGameRoleInfo& RoleInfo)
{
	_role_info = RoleInfo;
	isPurchase = true;
	//缓存支付信息与角色信息
	
	TMap<FString, FString> paramter = RoleInfo.ParseToMap();
	paramter.Append(paymentParametersData.ParseToMap());
	
	auto Setting = GetMutableDefault<UUsdkSettings>();
	if (Setting->Channel == EHeroUSDKChannel::Steam)
	{
		paramter.Add("cUid",HeroUsdkSupportPcDelegate::GetInstance()->GetUserInfo().sdkUserId);
		FString lang = GetSteamWebLanguage(GetCurrentGameLanguage());
		paramter.Add("lang",lang) ;
	}
	


	if (Setting->Channel == EHeroUSDKChannel::Global && IsPureVersion())
	{
		ChannelManager->Pay(paymentParametersData,{});
		isPurchase = false;
		return;
	}
	else
	{
			UsdkManager->pay(paramter, [paymentParametersData,this](const FPayOrderResult& OrderInfo)
		{
			{
				TMap<FString, FString> DotParam;
				DotParam.Emplace("goods_id", paymentParametersData.goodsId);
				DotParam.Emplace("goods_name", OrderInfo.goodsName);
				DotParam.Emplace("goods_info", OrderInfo.goodsDesc);
				DotParam.Emplace("amount", OrderInfo.goodsDesc);
				DotParam.Emplace("coin_type", OrderInfo.currency);
				DotParam.Emplace("cp_order", paymentParametersData.cpOrder);
				FDotManager::GetInstance().CallDot("u_p_strike", DotParam);
			}
				
			if (OrderInfo.code == 0)
			{
				ChannelManager->Pay(paymentParametersData,OrderInfo);
			}
			else
			{
				{
					TMap<FString,FString> DotParam;
					DotParam.Emplace("goods_id",paymentParametersData.goodsId);
					DotParam.Emplace("goods_name",OrderInfo.goodsName);
					DotParam.Emplace("goods_info",OrderInfo.goodsDesc);
					DotParam.Emplace("amount",OrderInfo.goodsDesc);
					DotParam.Emplace("coin_type",OrderInfo.currency);
					DotParam.Emplace("cp_order",paymentParametersData.cpOrder);
					DotParam.Emplace("result","0");
					DotParam.Emplace("reason",OrderInfo.msg);
					FDotManager::GetInstance().CallDot("u_p_getorder",DotParam);
				}

				{
					TMap<FString,FString> DotParam;
					DotParam.Emplace("goods_id",paymentParametersData.goodsId);
					DotParam.Emplace("goods_name",OrderInfo.goodsName);
					DotParam.Emplace("goods_info",OrderInfo.goodsDesc);
					DotParam.Emplace("amount",OrderInfo.goodsDesc);
					DotParam.Emplace("coin_type",OrderInfo.currency);
					DotParam.Emplace("cp_order",paymentParametersData.cpOrder);
					DotParam.Emplace("result","0");
					DotParam.Emplace("reason",OrderInfo.msg);
					DotParam.Emplace("usdk_order",OrderInfo.order);
					DotParam.Emplace("channel_order","");
					FDotManager::GetInstance().CallDot("u_p_backpaymsg_tocp",DotParam);
				}
			//登录失败回调
				HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(
					HeroUsdkFailed, "", OrderInfo.msg);
					return;
			}
			isPurchase = false;
		});
	}

}


//账号中心
void HeroUsdkSupportPcDelegate::showAccountCenter()
{
	const auto Setting = GetMutableDefault<UUsdkSettings>();
	if (Setting->Channel == EHeroUSDKChannel::Global && Subsystem->BP_AccountCenter)
	{
		POP_USDK_PANNEL(UPC_AccountCenterPannel,Subsystem->BP_AccountCenter);
	}
	
}

//切换账号
void HeroUsdkSupportPcDelegate::SwitchAccount()
{
	const auto Setting = GetMutableDefault<UUsdkSettings>();
	if (Setting->Channel != EHeroUSDKChannel::Bilibili) {
		if(Subsystem->BP_SwitchAccount)
		{
			POP_USDK_PANNEL(UPC_SwitchAccountPannel,Subsystem->BP_SwitchAccount);
		}
	}
#if PLATFORM_WINDOWS
	else
	{
		auto BiliManager = StaticCastSharedPtr<FBiliManager>(ChannelManager);
		if(BiliManager)
		{
			BiliManager->SwitchAccount();
		}
	}
#endif
	FDotManager::GetInstance().CallDot("u_switch_account");
}


//注销账号
void HeroUsdkSupportPcDelegate::accountCancellation(FString FinalUrl)
{
#if PLATFORM_WINDOWS
	
	if(GetMutableDefault<UUsdkSettings>()->Channel == EHeroUSDKChannel::Bilibili)
	{
		auto BiliManager = StaticCastSharedPtr<FBiliManager>(ChannelManager);
		BiliManager->accountCancellation();
		return;
	}
#endif
	if(FinalUrl.Len()==0)
	{
		if (ChannelManager->LogoutURL.IsEmpty())
		{
			UE_LOG(LogHeroUsdk,Log,TEXT("注销地址未配置"))
			return;
		}
		FString url = ChannelManager->LogoutURL ;
		FString gameName = ChannelConfig->gameName ;

		FString link;
		FString getUrlData = TEXT("accessToken=");
		getUrlData += GetChannelToken() ;
		auto setting =  GetMutableDefault<UUsdkSettings>();
		if(setting->Channel == EHeroUSDKChannel::China || setting->Channel == EHeroUSDKChannel::WeGame)
		{
			getUrlData += "&projectId=" ;
			getUrlData +=  ChannelConfig->GetProjectId() ;
			getUrlData += "&productId=" ;
			getUrlData += ChannelConfig->GetProductId();
			link = EnvMode->GetChannelUrl();
		}
		else if(setting->Channel == EHeroUSDKChannel::Global)
		{
			getUrlData += "&pcode=" ;
			getUrlData +=  ChannelConfig->GetProductId();
			link = FUsdkHttpManager::GetInst().GetCurrentFullUrl();
		}
	
		getUrlData += "&lang=" ;
		FString lang = UsdkLocaleMap[PcsdkLanguage];
		if(lang == TEXT("system"))
		{
			lang = FPlatformMisc::GetDefaultLanguage();
		}
		getUrlData += lang;
		getUrlData += "&platform=pc" ;
		getUrlData += "&gameName=" ;
		getUrlData +=  FGenericPlatformHttp::UrlEncode(gameName) ;
		getUrlData += "&link=" ;
		getUrlData +=  FGenericPlatformHttp::UrlEncode(link) ;
		if (url.EndsWith(TEXT("?")))
		{
			url += "&";
			url += getUrlData ;
		} else
		{
			url += "?";
			url += getUrlData ;
		}

		if (ChannelConfig->custom_themeStyle == "1")
		{
			url += "&theme=dark";
		}
		url += "#/";
		UE_LOG(LogHeroUsdk, Log, TEXT(" GetLogoutUrl : %s"), *url);
		FinalUrl = url ;
	}
	


	UWorld* WorldToRecordIn = nullptr;

	for (const FWorldContext& WorldContext : GEngine->GetWorldContexts())
	{
		if (WorldContext.WorldType == EWorldType::PIE || WorldContext.WorldType == EWorldType::Game )
		{
			WorldToRecordIn = WorldContext.World();
			break;
		}
		else if (WorldContext.WorldType == EWorldType::Editor)
		{
			WorldToRecordIn = WorldContext.World();
		}
	}
	auto SurveyPanel = CreateWidget<UPC_SurveyPanel>(WorldToRecordIn, Subsystem->BP_Survey);
	SurveyPanel->isFirstTime = true;
	SurveyPanel->SetFlags(RF_Transient);
	SurveyPanel->SetUrl(FinalUrl);
	SurveyPanel->AddToViewport(1000);
	//UKismetSystemLibrary::LaunchURL(url);

}

void HeroUsdkSupportPcDelegate::OpenSurvey(const FString& WebId)
{
#if PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	if (UsdkManager == nullptr){
		GEngine->AddOnScreenDebugMessage(-1, 10, FColor::Red, TEXT("USDK未初始化"));
		return ;
	}

	if (GetChannelToken().IsEmpty())
	{
		GEngine->AddOnScreenDebugMessage(-1, 10, FColor::Red, TEXT("USDK未登录"));
		return;
	}

	auto setting = GetMutableDefault<UUsdkSettings>();
	if(setting && setting->Channel == EHeroUSDKChannel::Global &&IsPureVersion())
	{
		auto channelGlobal = StaticCastSharedPtr<FGlobalManager>(ChannelManager);
		if(channelGlobal && Subsystem->BP_Survey)
		{
			channelGlobal->Survey(Subsystem->BP_Survey, WebId,[](bool Successful,const FString& Ret)
		{
			if(Successful)
			{
					
				//CreateWidget<UPC_SurveyPanel>(UHeroUSDKNetAPI::GetSingletonObjectIns()->GetWorld());
			}
		});
		}
		
	}
	else
	{
		if(UsdkManager && Subsystem->BP_Survey)
		{
			UsdkManager->UsdkSurvey(Subsystem->BP_Survey, WebId,[](bool Successful,const FString& Ret)
			{
				if(Successful)
				{
						
					//CreateWidget<UPC_SurveyPanel>(UHeroUSDKNetAPI::GetSingletonObjectIns()->GetWorld());
				}
			});
		}
	}
	

#endif
}


void HeroUsdkSupportPcDelegate::OpenServicePanel()
{
#if PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	auto setting = GetMutableDefault<UUsdkSettings>();
	if (setting && setting->Channel == EHeroUSDKChannel::China || setting && setting->Channel == EHeroUSDKChannel::WeGame)
	{
		auto channelGlobal = StaticCastSharedPtr<FChinaManager>(ChannelManager);
		if (channelGlobal && Subsystem->BP_Survey)
		{
			channelGlobal->OpenServicePanel(Subsystem->BP_Survey, [](bool Successful, const FString& Ret)
			{
				if (Successful)
				{
				}
			});
		}
	}
	else //  && !IsPureVersion()
	{
	// do nothing
	}

#endif
}


void HeroUsdkSupportPcDelegate::cpKickOffCallBackWithResult(const FString& Msg)
{
	auto ChannelChina = StaticCastSharedPtr<FChinaManager>(ChannelManager);
	if(ChannelChina)
	{
		ChannelChina->cpKickOffCallBackWithResult(GetChannelToken(), Msg);
	}
}


void HeroUsdkSupportPcDelegate::OnResetPurchase()
{
	isPurchase = false;
}


/*
* 获取对应Steam对应语言
*/
FString HeroUsdkSupportPcDelegate::GetSteamWebLanguage(FString key)
{
	if (key.IsEmpty()){ return ""; }
	static TMap<FString,FString> LanguagesDic;
	if(LanguagesDic.Num() == 0)
	{
		//Steam对应语言
		LanguagesDic.Add("arabic", "ar");
		LanguagesDic.Add("bulgarian", "bg");
		LanguagesDic.Add("schinese", "zh-CN");
		LanguagesDic.Add("tchinese", "zh-TW");
		LanguagesDic.Add("czech", "cs");
		LanguagesDic.Add("danish", "da");
		LanguagesDic.Add("dutch", "nl");
		LanguagesDic.Add("english", "en");
		LanguagesDic.Add("finnish", "fi");
		LanguagesDic.Add("french", "fr");
		LanguagesDic.Add("german", "de");
		LanguagesDic.Add("greek", "el");
		LanguagesDic.Add("hungarian", "hu");
		LanguagesDic.Add("italian", "it");
		LanguagesDic.Add("japanese", "ja");
		LanguagesDic.Add("koreana", "ko");
		LanguagesDic.Add("norwegian", "no");
		LanguagesDic.Add("polish", "pl");
		LanguagesDic.Add("portuguese", "pt");
		LanguagesDic.Add("brazilian", "pt-BR");
		LanguagesDic.Add("romanian", "ro");
		LanguagesDic.Add("russian", "ru");
		LanguagesDic.Add("spanish", "es");
		LanguagesDic.Add("latam", "es-419");
		LanguagesDic.Add("swedish", "sv");
		LanguagesDic.Add("thai", "th");
		LanguagesDic.Add("turkish", "tr");
		LanguagesDic.Add("ukrainian", "uk");
		LanguagesDic.Add("vietnamese", "vn");
	}

	if(LanguagesDic.Find(key))
	{
		return LanguagesDic[key];
	}
	return {};
}


/*
 * Steam支付授权回调
*/
#ifdef USE_STEAM

void HeroUsdkSupportPcDelegate::OnPurchaseResponse(MicroTxnAuthorizationResponse_t *response)
{
	GEngine->AddOnScreenDebugMessage(-1, 5.f, FColor::Red,"OnPurchaseResponse");
	if (response->m_bAuthorized != 0)
	{
		TMap<FString,FString> paramter ;
		FString orderId = FString::Printf(TEXT("%llu"), response->m_ulOrderID);
		GEngine->AddOnScreenDebugMessage(-1, 5.f, FColor::Red,orderId);
		paramter.Add("orderId",orderId);
		paramter.Add("pcode",_uProject.usdkProductId);
		UsdkNetAPI->steamCallback(paramter,[this](int32 statueCode,FString contentString,bool bWasSuccessful)
		{
			FString result = UsdkNetAPI->BaseStringEncodeOrDecode(contentString);
			GEngine->AddOnScreenDebugMessage(-1,10, FColor::Red, result);
			if (!result.IsEmpty() && result.Equals("success"))
			{
				TMap<FString,FString> paramter ;
				paramter.Add("plat", "pc");
				FString payObject = UHeroUSDKNetAPI::GetSingletonObjectIns()->payJSONObj;
				if (!payObject.IsEmpty())
				{
					TSharedPtr<FJsonObject> JsonObject1 = MakeShareable(new FJsonObject);
					TSharedRef<TJsonReader<>> Reader1 = TJsonReaderFactory<>::Create(payObject);
					if (FJsonSerializer::Deserialize(Reader1, JsonObject1))
					{
						const TSharedPtr<FJsonValue>* priceValue = JsonObject1->Values.Find("price");
						FString amount = (*priceValue)->AsString();
						const TSharedPtr<FJsonValue>* orderValue = JsonObject1->Values.Find("order");
						FString order = (*orderValue)->AsString();
						const TSharedPtr<FJsonValue>* currencyValue = JsonObject1->Values.Find("currency");
						FString currency = (*currencyValue)->AsString();
						paramter.Add("sdkOrderId", order);
						paramter.Add("orderAmount", amount);
						paramter.Add("currency", currency);
						FString payResultJSON = UHeroUSDKNetAPI::GetSingletonObjectIns()->converMapToString(paramter);
						if (HeroUsdkSupportKit::GetInstance().NotifyObject != nullptr)
						{
							
							HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(
								HeroUsdkSuccess, payResultJSON,TEXT("Pay Success"));
						}
						//清空缓存信息
						UHeroUSDKNetAPI::GetSingletonObjectIns()->payJSONObj = nullptr;
						return;
					}
				}
			} else {
				HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkFailed, "",TEXT("支付失败,请稍后重试"));
			}
		}) ;
	} else {
		HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkFailed, "",TEXT("支付失败,请稍后重试"));
	}
}

#endif
/**
 * @brief Steam登录授权回调
 * @param response 
 */

#ifdef USE_STEAM

void HeroUsdkSupportPcDelegate::OnAuthTicketResponse(GetAuthSessionTicketResponse_t * response)
{
	GEngine->AddOnScreenDebugMessage(-1, 5.f, FColor::Red,"OnAuthTicketResponse");
	if (response->m_eResult == k_EResultOK && !_authTicket.IsEmpty())
	{
		UE_LOG(LogHeroUsdk, Log, TEXT(" GetSteamAuthToken : %s"), *_authTicket);
		TMap<FString,FString> paramter ;
		paramter.Add("cToken",_authTicket);
		paramter.Add("channel", "steam");
		//Steam登录
		this->steamLogin(paramter);
	} else {
		HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(HeroUsdkFailed,"",TEXT("USDK登录失败,获取Steam Ticket失败"));
	}
}

#endif

HeroUsdkSupportPcDelegate::HeroUsdkSupportPcDelegate()
{
	
}

void HeroUsdkSupportPcDelegate::Register(UHeroUsdkSubsystem* InSubsystem,const TSharedPtr<FJsonObject>& Config)
{
	Subsystem = InSubsystem;
	
	const UUsdkSettings* const Setting = GetMutableDefault<UUsdkSettings>();
	if (Setting->Channel == EHeroUSDKChannel::China)
	{
		ChannelConfig = MakeShareable(new FChinaConfig);
		ChannelConfig->Parse(Config->GetObjectField("herogpc"));
	}
	else if (Setting->Channel == EHeroUSDKChannel::Global)
	{
		ChannelConfig = MakeShareable(new FGlobalConfig);
		ChannelConfig->Parse(Config->GetObjectField("heroglobalpc"));
		FUsdkHttpManager::GetInst().Register(Config);
	}
	else if (Setting->Channel == EHeroUSDKChannel::Steam)
	{
		ChannelConfig = MakeShareable(new FSteamConfig);
		ChannelConfig->Parse(Config->GetObjectField("steam"));
		
	}
	else if (Setting->Channel == EHeroUSDKChannel::Bilibili)
	{
		ChannelConfig = MakeShareable(new FBiliConfig);
		ChannelConfig->Parse(Config->GetObjectField("bilibiliPC"));
		
	}
#ifdef USE_WEGAME
	else if (Setting->Channel == EHeroUSDKChannel::WeGame)
	{
		ChannelConfig = MakeShareable(new FWeGameConfig);
		ChannelConfig->Parse(Config->GetObjectField("herowegame"));
	}
#endif
	const auto LangString = FUsdkCommonTools::ReadTextByPath("language");
	if (LangString.IsEmpty())
	{
		PcsdkLanguage = EHeroUsdkLanguageFlag::HeroLanguageSystem;
	}
	else
	{
		PcsdkLanguage = static_cast<EHeroUsdkLanguageFlag>(FCString::Atoi(*LangString));
	}
	
	auto global = Config->GetObjectField("heroglobalpc");
	if(global->HasTypedField<EJson::String>(TEXT("_hu_pure_version_")) &&
		global->GetStringField(TEXT("_hu_pure_version_")) == "true")
	{
		bIsPureVersion = true;
	}
	
	if (Setting->bIsDebug)
	{
		if (Setting->Channel == EHeroUSDKChannel::China)
		{
			EnvMode = MakeShareable(new FEnvChinaDebug);
			ChannelManager =  MakeShareable(new FChinaManager(Subsystem,ChannelConfig,EnvMode));
		}
#if PLATFORM_WINDOWS
		else if(Setting->Channel == EHeroUSDKChannel::Bilibili)
		{
			EnvMode = MakeShareable(new FEnvBiliDebug);
			ChannelManager =  MakeShareable(new FBiliManager(Subsystem,ChannelConfig,EnvMode));
		}
#endif
#ifdef USE_WEGAME
		else if(Setting->Channel == EHeroUSDKChannel::WeGame)
		{
			EnvMode = MakeShareable(new FEnvChinaDebug);
			ChannelManager =  MakeShareable(new FWeGameManager(Subsystem,ChannelConfig,EnvMode));
		}
#endif
		else 
		{
			EnvMode = MakeShareable(new FEnvGlobalDebug);
			ChannelManager =  MakeShareable(new FGlobalManager(Subsystem,ChannelConfig,EnvMode));
			
		}
		
	}
	else
	{
		if (Setting->Channel == EHeroUSDKChannel::China)
		{
			EnvMode = MakeShareable(new FEnvChinaRelease);
			ChannelManager =  MakeShareable(new FChinaManager(Subsystem,ChannelConfig,EnvMode));
		}
#if PLATFORM_WINDOWS
		else if(Setting->Channel == EHeroUSDKChannel::Bilibili)
		{
			EnvMode = MakeShareable(new FEnvBiliRelease);
			ChannelManager =  MakeShareable(new FBiliManager(Subsystem,ChannelConfig,EnvMode));
		}
#endif
#ifdef USE_WEGAME
		else if(Setting->Channel == EHeroUSDKChannel::WeGame)
		{
			EnvMode = MakeShareable(new FEnvChinaRelease);
			ChannelManager =  MakeShareable(new FWeGameManager(Subsystem,ChannelConfig,EnvMode));
		}
#endif
		else
		{
			EnvMode = MakeShareable(new FEnvGlobalRelease);
			ChannelManager =  MakeShareable(new FGlobalManager(Subsystem,ChannelConfig,EnvMode));
		}	
	
	}
	UsdkManager = MakeShareable(new FUsdkManager(ChannelConfig,ChannelManager,EnvMode));
	
}

void HeroUsdkSupportPcDelegate::GenInitConfig(const TSharedPtr<FJsonObject>& JsonObject)
{
	
	TSharedPtr<FChinaConfig> ChinaConfig = MakeShareable(new FChinaConfig);
	ChinaConfig->Parse(JsonObject->GetObjectField("herogpc"));
	
	auto ChinaEnvMode = MakeShareable(new FEnvChinaRelease);
	static TSharedPtr<FChinaManager> ChinaManager =  MakeShareable(new FChinaManager(nullptr,ChinaConfig,ChinaEnvMode));
	ChinaManager->GenInitConfig();

	TSharedPtr<FGlobalConfig> GlobalConfig = MakeShareable(new FGlobalConfig);
	GlobalConfig->Parse(JsonObject->GetObjectField("heroglobalpc"));
	auto GlobalEnvMode = MakeShareable(new FEnvGlobalRelease);
	static TSharedPtr<FGlobalManager> GlobalManager =  MakeShareable(new FGlobalManager(nullptr,GlobalConfig,GlobalEnvMode));
	GlobalManager->GenInitConfig();

	static TSharedPtr<FUsdkManager>  UsdkManager = MakeShareable(new FUsdkManager(ChinaConfig,ChinaManager,ChinaEnvMode));
	UsdkManager->GenInitConfig();
}

void HeroUsdkSupportPcDelegate::Unregister()
{
	Subsystem = nullptr;
	ChannelManager= nullptr;
	UsdkManager = nullptr;
}

