// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Manager/Usdk/UsdkManager.h"
#include "Data/HeroUsdkSupportData.h"
#include "Channel/Base/ChannelManagerBase.h"
#include "Data/HeroUsdkLanguageFlag.h"
#include "Env/Base/EnvModeBase.h"
#if PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
#ifdef USE_STEAM
#include "steam/steam_api.h"
#endif
#endif

//初始化回调界面，这个地方可以不用这个typedef
typedef TFunction<void(bool bShowProtocol)> FUSDKinitComplete;
//登录回调界面
typedef TFunction<void()> FUSDKLoginComplete;
//支付回调界面
typedef TFunction<void(bool bPaySuccess)> FUSDKPayComplete;

/**
 * PC渠道管理类
 */
class HEROUSDKPLUGIN_API HeroUsdkSupportPcDelegate
{
public:
	
	HeroUsdkSupportPcDelegate();
	void Register(UHeroUsdkSubsystem* InSubsystem,const TSharedPtr<FJsonObject>& Config);

	static void GenInitConfig(const TSharedPtr<FJsonObject>& JsonObject);
	void Unregister();
protected:
	UHeroUsdkSubsystem* Subsystem = nullptr;
	static HeroUsdkSupportPcDelegate* Singleton;
public:

	HeroUsdkSupportPcDelegate(HeroUsdkSupportPcDelegate& other) = delete;

	void operator=(const HeroUsdkSupportPcDelegate&) = delete;

	static HeroUsdkSupportPcDelegate* GetInstance();
	
	FString GetNewAgreements()
	{
		return UsdkManager->_newAgreements;
	}
	

	FString GetCurrentLanguage();
	//保存配置
	//FHeroUProject _uProject ;
	
	bool bIsInitAgreement = false;
	EHeroUsdkLanguageFlag PcsdkLanguage = EHeroUsdkLanguageFlag::HeroLanguageSystem;
	
	// 设置SDK语言
	void SetSdkLanguage(const EHeroUsdkLanguageFlag Language);
	
	//初始化
	void Init() ;

	void ChannelInit();

	//登录
	void LoginWithPC();
	
	//进行游戏角色信息上报
	void EnterGame(const FHeroHDCGameRoleInfo& RoleInfo);

	//创建角色信息上报
	void CreateNewRole(const FHeroHDCGameRoleInfo& RoleInfo);

	//角色升级信息上报
	void RoleLevelUp(const FHeroHDCGameRoleInfo& RoleInfo);
	
	//登出
	void Logout(bool DoesNotifyCp = true);
	
	//支付
	void Pay(const FHeroUPaymentParameters& PaymentParametersData, const FHeroHDCGameRoleInfo& RoleInfo);

	
	
	//账号中心
	void showAccountCenter();

	//切换账号
	void SwitchAccount();

	//注销账号
	void accountCancellation(FString FinalUrl = FString());

	//问卷调查
	void OpenSurvey( const FString& WebId);

	//客服中心
	void OpenServicePanel();
	/*
	 * =================== Steam相关API ===================
	 */
	
	//Steam登录
	void steamLogin(TMap<FString,FString> paramter);

	void TapTapLogin();
	void TapTapLoginCompleted();

	/*
	 * 获取SteamToken
	 */
	FString GetSteamAuthToken(int32 LocalUserNum = 0) ;

	/*
	 * 获取Steam当前语言
	 */
	FString GetCurrentGameLanguage();
	
	
	void cpKickOffCallBackWithResult(const FString& Msg);
	/*
	* 重置支付标记 
	*/
	void OnResetPurchase();

	FHeroHDCGameRoleInfo GetRoleInfo() const
	{
		return _role_info;
	}

	void SetChannelToken(const FString& Token)
	{
		ChannelManager->SetChannelToken(Token);
	}

	FString GetChannelToken() const
	{
		return ChannelManager->GetChannelToken();
	}


	/*
	 * =================== Steam相关API ===================
	 */

	/*
	 * 获取对应Steam对应语言
	 */
	FString GetSteamWebLanguage(FString key);

	/*
	 * 临时记录授权票据
	 */
	FString _authTicket ;

public:
	TSharedPtr<FEnvModeBase> GetEnvMode()
	{
		return EnvMode;
	}

	TSharedPtr<FUsdkManager> GetUsdkManager()
	{
		return UsdkManager;
	}

	TSharedPtr<FChannelManagerBase> GetChannelManager()
	{
		return ChannelManager;
	}
	FUserInfo GetUserInfo() const
	{
		return UserInfo;
	}
	void SetUserInfo(const FUserInfo& InUserInfo)
	{
		UserInfo = InUserInfo;
	}

	TSharedPtr<FChannelConfigBase> GetChannelConfig() const
	{
		return ChannelConfig;
	}

	bool IsPureVersion() const
	{
		return bIsPureVersion;
	}	
private:
	//支付标记
	bool isPurchase = false ;
	FHeroHDCGameRoleInfo _role_info;
	TSharedPtr<FChannelManagerBase> ChannelManager;
	TSharedPtr<FUsdkManager> UsdkManager;
	TSharedPtr<FEnvModeBase> EnvMode;
	FUserInfo UserInfo;
	TSharedPtr<FChannelConfigBase> ChannelConfig;
	bool bIsPureVersion = false;
	bool isTapTapInit = false;
	bool isTapTapLogin = false;
};

#ifdef USE_STEAM
/*
 * Steam支付授权回调
 */
STEAM_CALLBACK(HeroUsdkSupportPcDelegate,OnPurchaseResponse,MicroTxnAuthorizationResponse_t);

/*
 * Steam授权票据回调
 */
STEAM_CALLBACK(HeroUsdkSupportPcDelegate,OnAuthTicketResponse,GetAuthSessionTicketResponse_t);

#endif