// Fill out your copyright notice in the Description page of Project Settings.


#include "UsdkManager.h"
#include "HeroUsdkSupportKit.h"
#include "Http.h"
#include <string>
#include <vector>

#include "DotManager/DotManager.h"
#include "Tools/crypto_aes256cbc.h"
#include "Tools/crypto_base64.h"
#include "HeroUsdkSubsystem.h"
#include "Manager/HeroUsdkSupportPcDelegate.h"
#include "LogHeroUsdk.h"
#include "Blueprint/UserWidget.h"
#include "Setting/UsdkSettings.h"
#include "Tools/UsdkCommonTools.h"



FHttpModule* FUsdkManager::GetHttpModule()
{
	static FHttpModule* httpModule;

	httpModule = &FHttpModule::Get();
	httpModule->SetHttpTimeout(60);
	httpModule->SetMaxReadBufferSize(1024 * 1024 * 50);
	httpModule->SetHttpDelayTime(0.001);
	return httpModule;
}

FHttpManager& FUsdkManager::GetHttpMgr()
{
	return GetHttpModule()->GetHttpManager();
}

void FUsdkManager::UsdkInit(TFunction<void(EUsdkResult Result, bool bPopAgreement, const FString& Msg)> Callback)
{

	FDotManager::GetInstance().CallDot("u_init_start");
	
	FString UsdkConfig = UUsdkBaseWidget::GetUeDataInteral(TEXT("USDK_INIT_DATA_INTERNAL"));

	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	const TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(UsdkConfig);
	if (FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		bool bShouldPopAgreement = false;
		if (JsonObject->HasTypedField<EJson::Number>(TEXT("code")))
		{
			const int32 ResultCode = JsonObject->GetIntegerField(TEXT("code"));
			if (ResultCode == 0)
			{
				FDotManager::GetInstance().CallDot("u_init_end");
				//标记初始化成功
				isInitedSucc = true ;
			
				_ak = JsonObject->GetStringField(TEXT("ak"));
				_aki =JsonObject->GetStringField(TEXT("aki"));
				
		
				const auto newAgreements = JsonObject->GetObjectField(TEXT("newAgreements"));
				if (newAgreements.IsValid())
				{
					int swStatus = -1;
					auto swStatusStr = newAgreements->GetStringField(TEXT("swStatus"));
					swStatus =FCString::Atoi(*swStatusStr);
					
					if(swStatus>0)
					{
						const auto currentVersion = newAgreements->GetIntegerField(TEXT("version"));
						const auto versionStr =FUsdkCommonTools::ReadTextByPath("usdk_proto_version");
						const auto usdk_proto_agree =FUsdkCommonTools::ReadTextByPath("usdk_proto_agree");
						if(versionStr.IsEmpty() ||usdk_proto_agree.IsEmpty())//第一次打开
						{
							FUsdkCommonTools::WriteText("usdk_proto_version",FString::FromInt(currentVersion));
							bShouldPopAgreement = true;
						}
						else
						{
							int32 version =FCString::Atoi(*versionStr);
							if(currentVersion>version)
							{
								FUsdkCommonTools::WriteText("usdk_proto_version",FString::FromInt(currentVersion));
								bShouldPopAgreement = true;
							}
						}
					}

					if(bShouldPopAgreement)
					{
						FString JsonStr;
						TSharedRef<TJsonWriter<>> Writer = TJsonWriterFactory<>::Create(&JsonStr);
						FJsonSerializer::Serialize(newAgreements.ToSharedRef(), Writer);
						if (!JsonStr.IsEmpty() && _newAgreements.IsEmpty())
						{
							_newAgreements = JsonStr;
						}
					}
				}
				Callback(EUsdkResult::Success,bShouldPopAgreement,{});
				return;
			}
		}
			
	}
	Callback(EUsdkResult::Failed,false,TEXT("Init Error"));
	
	/*
	//USDK初始化
	createPostRequest("/sys/init.lg", paramter,
		[this,Callback](int32 statueCode, FString contentString,
		bool bWasSuccessful)
		{
			if (!EHttpResponseCodes::IsOk(statueCode))
			{
				Callback(EUsdkResult::Failed,false,TEXT("HttpError"));
				return;
			}
			
			const FString result = EncryptSwap(contentString);
			TArray<uint8> content;
			FBase64::Decode(result, content);
			const std::string cstr(reinterpret_cast<const char*>(content.GetData()), content.Num());  
			FString FrameAsFString = UTF8_TO_TCHAR(cstr.c_str());
			UE_LOG(LogHeroUsdk, Log, TEXT("Init resultStr : %s"), *FrameAsFString);
			TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
			const TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(FrameAsFString);
			if (FJsonSerializer::Deserialize(Reader, JsonObject))
			{
				bool bShouldPopAgreement = false;
				if (JsonObject->HasTypedField<EJson::Number>(TEXT("code")))
				{
					const int32 ResultCode = JsonObject->GetIntegerField(TEXT("code"));
					if (ResultCode == 0)
					{
						FDotManager::GetInstance().CallDot("u_init_end");
						//标记初始化成功
						isInitedSucc = true ;
					
						_ak = JsonObject->GetStringField(TEXT("ak"));
						_aki =JsonObject->GetStringField(TEXT("aki"));
						
				
						const auto newAgreements = JsonObject->GetObjectField(TEXT("newAgreements"));
						if (newAgreements.IsValid())
						{
							int swStatus = -1;
							auto swStatusStr = newAgreements->GetStringField(TEXT("swStatus"));
							swStatus =FCString::Atoi(*swStatusStr);
							
							if(swStatus>0)
							{
								const auto currentVersion = newAgreements->GetIntegerField(TEXT("version"));
								const auto versionStr =FUsdkCommonTools::ReadTextByPath("usdk_proto_version");
								const auto usdk_proto_agree =FUsdkCommonTools::ReadTextByPath("usdk_proto_agree");
								if(versionStr.IsEmpty() ||usdk_proto_agree.IsEmpty())//第一次打开
								{
									FUsdkCommonTools::WriteText("usdk_proto_version",FString::FromInt(currentVersion));
									bShouldPopAgreement = true;
								}
								else
								{
									int32 version =FCString::Atoi(*versionStr);
									if(currentVersion>version)
									{
										FUsdkCommonTools::WriteText("usdk_proto_version",FString::FromInt(currentVersion));
										bShouldPopAgreement = true;
									}
								}
							}

							if(bShouldPopAgreement)
							{
								FString JsonStr;
								TSharedRef<TJsonWriter<>> Writer = TJsonWriterFactory<>::Create(&JsonStr);
								FJsonSerializer::Serialize(newAgreements.ToSharedRef(), Writer);
								if (!JsonStr.IsEmpty() && _newAgreements.IsEmpty())
								{
									_newAgreements = JsonStr;
								}
							}
						}
						Callback(EUsdkResult::Success,bShouldPopAgreement,{});
						return;
					}
				}
					
			}
			Callback(EUsdkResult::Failed,false,TEXT("Init Error"));
		}
	);*/
}

void FUsdkManager::GenInitConfig()
{
	//初始化请求
	TMap<FString, FString> paramter;
	paramter.Add("smd5", "1");
	FString playerSetting = FUsdkCommonTools::ReadTextByPath("PlayerSetting");
	if (!playerSetting.IsEmpty())
	{
		paramter.Add("active", "1");
	} else
	{
		paramter.Add("active", "0");
	}
	
	
	//USDK初始化
	createPostRequest("/sys/init.lg", paramter,
		[this](int32 statueCode, FString contentString,
		bool bWasSuccessful)
		{
			const FString result = EncryptSwap(contentString);
			TArray<uint8> content;
			FBase64::Decode(result, content);
			const std::string cstr(reinterpret_cast<const char*>(content.GetData()), content.Num());  
			FString FrameAsFString = UTF8_TO_TCHAR(cstr.c_str());
			
			auto setting = GetMutableDefault<UUsdkSettings>();
			setting->UsdkInitConfig = FrameAsFString;
			setting->SaveConfig(CPF_Config,*FPaths::Combine(FPaths::ProjectConfigDir(),TEXT("DefaultGame.ini")));
		}
	);
}

//创建网络请求
void FUsdkManager::createPostRequest(FString url,const TMap<FString,FString>& paramter ,const FUSDKNetWorkComplete& netWorkComplete)
{
	TSharedRef<IHttpRequest, ESPMode::ThreadSafe> ret_request = GetHttpModule()->CreateRequest();
	FString fullUrl = EnvMode->GetBaseUrl() + "v1" + url;
	if (url.Equals("callback/steam"))
	{
		fullUrl =EnvMode->GetBaseUrl()  + url;
	}
	UE_LOG(LogHeroUsdk, Log, TEXT("createPostRequest url %s"), *fullUrl);
	ret_request->SetURL(fullUrl);
	ret_request->SetHeader(TEXT("Content-Type"), TEXT("application/x-www-form-urlencoded"));
	const FString bodyStr = FormatForm(paramter);
	UE_LOG(LogHeroUsdk, Log, TEXT("createPostRequest bodyStr %s"), *bodyStr);
	ret_request->SetContentAsString(bodyStr);
	ret_request->SetTimeout(30000);
	ret_request->SetVerb(TEXT("POST"));
	ret_request->OnProcessRequestComplete().BindLambda([netWorkComplete](FHttpRequestPtr HttpRequest, FHttpResponsePtr HttpResponse, bool bSuccess)
	{
		if (HttpResponse.IsValid())
		{
			const FString contentStr = HttpResponse->GetContentAsString();
			UE_LOG(LogHeroUsdk, Log, TEXT("createPostRequest contentStr %s"), *contentStr);
			const int32 statusCode = HttpResponse->GetResponseCode();
			if (netWorkComplete) { netWorkComplete(statusCode,contentStr,bSuccess) ; }
		}
	});
	ret_request->ProcessRequest();
}

void FUsdkManager::createFullUrlPostRequest(FString fullUrl, const TMap<FString, FString>& paramter,
	const FUSDKNetWorkComplete& netWorkComplete)
{
	TSharedRef<IHttpRequest, ESPMode::ThreadSafe> ret_request = GetHttpModule()->CreateRequest();
	UE_LOG(LogHeroUsdk, Log, TEXT("createPostRequest url %s"), *fullUrl);
	ret_request->SetURL(fullUrl);
	ret_request->SetHeader(TEXT("Content-Type"), TEXT("application/x-www-form-urlencoded"));
	const FString bodyStr = FormatForm(paramter);
	UE_LOG(LogHeroUsdk, Log, TEXT("createPostRequest bodyStr %s"), *bodyStr);
	ret_request->SetContentAsString(bodyStr);
	ret_request->SetTimeout(30000);
	ret_request->SetVerb(TEXT("POST"));
	ret_request->OnProcessRequestComplete().BindLambda([netWorkComplete](FHttpRequestPtr HttpRequest, FHttpResponsePtr HttpResponse, bool bSuccess)
	{
		if (HttpResponse.IsValid())
		{
			const FString contentStr = HttpResponse->GetContentAsString();
			UE_LOG(LogHeroUsdk, Log, TEXT("createPostRequest contentStr %s"), *contentStr);
			const int32 statusCode = HttpResponse->GetResponseCode();
			if (netWorkComplete) { netWorkComplete(statusCode,contentStr,bSuccess) ; }
		}
	});
	ret_request->ProcessRequest();
}

//网络请求
TSharedRef<IHttpRequest, ESPMode::ThreadSafe> FUsdkManager::createUSDKGetReuquest(FString _url)
{
	TSharedRef<IHttpRequest, ESPMode::ThreadSafe> ret_request = GetHttpModule()->CreateRequest();
	ret_request->SetURL(_url);
	ret_request->SetHeader(TEXT("Content-Type"), TEXT("application/x-www-form-urlencoded"));
	ret_request->SetVerb(TEXT("GET"));
	ret_request->OnProcessRequestComplete().BindRaw(this, &FUsdkManager::ResponseData);
	return ret_request;
}



void FUsdkManager::UsdkLogin(const TMap<FString, FString>& paramter,
                               const TFunction<void(EUsdkResult, const FString& ErrorMsg,const FUserInfo& UserInfo)>& Callback)
{
	TMap<FString,FString> DotParam;
	DotParam.Emplace("login_type",loginType);
	DotParam.Emplace("is_success","1");
	DotParam.Emplace("reason","");
	FDotManager::GetInstance().CallDot("u_l_backchamsg_to_us",DotParam);
	
	UsdkCheckLogin(paramter, [this,Callback](int32 statueCode, FString contentString, bool bWasSuccessful)
	{
		
		if (statueCode == 200)
		{
			UsdkCheckLoginResponse(contentString,Callback);
		}
		else
		{
			Callback(EUsdkResult::Failed,TEXT("Http Failed"),{});
			TMap<FString,FString> DotParam;
			DotParam.Emplace("login_type",loginType);
			DotParam.Emplace("is_success","0");
			DotParam.Emplace("reason","Http Failed");
			FDotManager::GetInstance().CallDot("u_l_getcheckmsg",DotParam);
		}
	});
}

void FUsdkManager::UsdkCheckLoginResponse(const FString& Msg,const TFunction<void(EUsdkResult, const FString& ErrorMsg,const FUserInfo&)>& Callback)
{
	FString newResultStr = AESDecrypt(Msg, _akStr);
	UE_LOG(LogHeroUsdk,Log,TEXT("UsdkCheckLoginResponse:%s"),*newResultStr);
	FString ErrorMsg;
	if (!newResultStr.IsEmpty())
	{
		TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
		TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(newResultStr);
		if (FJsonSerializer::Deserialize(Reader, JsonObject))
		{
			const auto code = JsonObject->GetIntegerField(TEXT("code"));
			
			if (code == 0)
			{
				

				UsdkAccessToken = JsonObject->GetStringField(TEXT("accessToken"));
				FUserInfo UserInfo;
				UserInfo.accessToken = UsdkAccessToken;
				UserInfo.sdkUserId = JsonObject->GetStringField(TEXT("cUid"));
				UserInfo.userName = JsonObject->GetStringField(TEXT("cName"));

				HeroUsdkSupportPcDelegate::GetInstance()->SetUserInfo(UserInfo);
				Callback(EUsdkResult::Success, ErrorMsg, UserInfo);

				TMap<FString,FString> DotParam;
				DotParam.Emplace("login_type",loginType);
				DotParam.Emplace("is_success","1");
				DotParam.Emplace("reason","");
				FDotManager::GetInstance().CallDot("u_l_getcheckmsg",DotParam);
				return;
			}
			else
			{
				ErrorMsg = JsonObject->GetStringField(TEXT("msg"));
			}
		}
	}
	TMap<FString,FString> DotParam;
	DotParam.Emplace("login_type",loginType);
	DotParam.Emplace("is_success","0");
	DotParam.Emplace("reason",ErrorMsg);
	FDotManager::GetInstance().CallDot("u_l_getcheckmsg",DotParam);
	
	Callback(EUsdkResult::Failed, ErrorMsg, {});
}

void FUsdkManager::UsdkSurvey(TSubclassOf<UPC_SurveyPanel> UserWidgetClass, const FString& WebId, const TFunction<void(bool,const FString&)>& Callback)
{
	TMap<FString,FString> Req;
	Req.Emplace("webId",WebId);
	Req.Emplace("accessToken",UsdkAccessToken);
	this->createPostRequest("/h5c/clientConf.lg",Req,[this,Callback, UserWidgetClass](int32 statueCode, FString contentString, bool bWasSuccessful)
	{
		FString newResultStr = AESDecrypt(contentString, _akStr);
		UE_LOG(LogHeroUsdk,Log,TEXT("UsdkSurvey Response:%s"),*newResultStr);
		FString ErrorMsg;
		if (!newResultStr.IsEmpty())
		{
			TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
			TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(newResultStr);
			if (FJsonSerializer::Deserialize(Reader, JsonObject))
			{
				const auto Url = JsonObject->GetStringField(TEXT("url"));
				if (!Url.IsEmpty())
				{
					UWorld* WorldToRecordIn = nullptr;

					for (const FWorldContext& WorldContext : GEngine->GetWorldContexts())
					{
						if (WorldContext.WorldType == EWorldType::PIE || WorldContext.WorldType == EWorldType::Game )
						{
							WorldToRecordIn = WorldContext.World();
							break;
						}
						else if (WorldContext.WorldType == EWorldType::Editor)
						{
							WorldToRecordIn = WorldContext.World();
						}
					}

					check(WorldToRecordIn);
					
					if (UserWidgetClass)
					{
						TMap<FString,FString> param;
						
						
						param.Emplace("u",HeroUsdkSupportPcDelegate::GetInstance()->GetUserInfo().sdkUserId);
						
						HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->GetChannelId();
						
						param.Emplace("r",HeroUsdkSupportPcDelegate::GetInstance()->GetRoleInfo().roleId);
						const auto Encry = SimpleEncryption(param);
						const auto FullUrl = Url+"?sojumpparm="+Encry;
						auto SurveyPanel = CreateWidget<UPC_SurveyPanel>(WorldToRecordIn, UserWidgetClass);
						SurveyPanel->SetFlags(RF_Transient);
						SurveyPanel->SetUrl(FullUrl);
						SurveyPanel->AddToViewport(100);
					}
				}
			}
		}
	});
}

//USDK检查token
void FUsdkManager::UsdkCheckLogin(const TMap<FString,FString>& paramter,const FUSDKNetWorkComplete& netWorkComplete)
{
	this->createPostRequest("/login/checklgn.lg",paramter,[this, netWorkComplete](int32 statueCode,FString contentString,bool bWasSuccessful)
	{
		UE_LOG(LogHeroUsdk, Log, TEXT(" UsdkCheckLogin : %s"), *contentString);
		if (bWasSuccessful && contentString.Len())
		{
			FString newResultStr  = AESDecrypt(contentString,_akStr);
			TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
			const TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(newResultStr);
			if (FJsonSerializer::Deserialize(Reader, JsonObject))
			{
			
			}
		}
		if (netWorkComplete) { netWorkComplete(statueCode, contentString, bWasSuccessful); }
	});
}
/*
 * 配置接口回调
 */
void FUsdkManager::ResponseData(FHttpRequestPtr Request, FHttpResponsePtr Response, bool bWasSuccessful)
{

}

FString FUsdkManager::FormatFormWithAdvancedEncryption(const TMap<FString, FString>& paramter)
{
	FString akExchange = EncryptSwap(_ak);
	FString uoutBase64;
	FBase64::Decode(akExchange, uoutBase64);
	_akStr = uoutBase64;
	TMap<FString, FString> commonParams = GetCommonParameter();
	//合并数据
	commonParams.Append(paramter);
	commonParams.Remove("initData");
	FString jsonStr = FUsdkCommonTools::converMapToString(commonParams);
	UE_LOG(LogHeroUsdk, Log, TEXT("USDK Request data  %s "),*jsonStr);
	FString data = AESEncrypt(jsonStr,_akStr);
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit AESEncrypt %s "),*data);
	UE_LOG(LogHeroUsdk, Log, TEXT("HeroUsdkSupportKit BaseStringEncodeOrDecode %s "),*data);
	FString timeStr = FUsdkCommonTools::GetTimestamp();
	FString paramesString ;
	paramesString += "_e_=" ;
	paramesString += _aki ;
	paramesString += "&data=" ;
	paramesString += data ;
	paramesString += "&pcode=" ;
	paramesString += HeroUsdkSupportKit::GetInstance().GetProductId() ;
	paramesString += "&timestamp=" ;
	paramesString += timeStr ;
	paramesString += "&" ;
	paramesString += HeroUsdkSupportKit::GetInstance().GetProductKey() ;
	FString signCode = FMD5::HashAnsiString(*paramesString);
		
	FString encodingString;
	encodingString += "pcode=";
	encodingString += HeroUsdkSupportKit::GetInstance().GetProductId();
	encodingString += "&data=";
	FString urlEncodeStr = FGenericPlatformHttp::UrlEncode(data);
	encodingString += urlEncodeStr;
	encodingString += "&timestamp=";
	encodingString += timeStr;
	encodingString += "&sign=";
	encodingString += signCode;
	encodingString += "&_e_=" ;
	encodingString += _aki ;
	UE_LOG(LogHeroUsdk, Log, TEXT("UHeroUSDKNetAPI GetBodyStrWithDic encodingString : %s"), *encodingString);
	return encodingString;
}

//加密
FString FUsdkManager::FormatForm(const TMap<FString, FString>& paramter)
{
	if (!_ak.IsEmpty() && !_aki.IsEmpty())
	{
		return FormatFormWithAdvancedEncryption(paramter);
	}
	else
	{
		return FormatFormWithSimpleEncryption(paramter);
	}
}

//通用加密
FString FUsdkManager::FormatFormWithSimpleEncryption(const TMap<FString, FString>& paramter)
{

	TMap<FString, FString> commonParams = GetCommonParameter();
	commonParams.Append(paramter);
	//加密换位
	FString data = SimpleEncryption(commonParams);
	//获取时间戳
	FString timeStr = FUsdkCommonTools::GetTimestamp();
	//签名
	FString paramsString;
	paramsString += "data=";
	paramsString += data;
	paramsString += "&pcode=";
	paramsString += HeroUsdkSupportKit::GetInstance().GetProductId() ;
	paramsString += "&timestamp=";
	paramsString += timeStr;
	paramsString += "&";
	paramsString +=HeroUsdkSupportKit::GetInstance().GetProductKey() ;
	//和AppKey一起进行一次加密, MD5运算
	FString signCode = FMD5::HashAnsiString(*paramsString);

	FString encodingString;
	encodingString += "pcode=";
	encodingString += HeroUsdkSupportKit::GetInstance().GetProductId() ;
	encodingString += "&data=";
	FString urlEncodeStr = FGenericPlatformHttp::UrlEncode(data);
	encodingString += urlEncodeStr;
	encodingString += "&timestamp=";
	encodingString += timeStr;
	encodingString += "&sign=";
	encodingString += signCode;
	UE_LOG(LogHeroUsdk, Log, TEXT("UHeroUSDKNetAPI CommonEncodingStringWithDic encodingString : %s"), *encodingString);
	return encodingString;
}

FString FUsdkManager::SimpleEncryption(const TMap<FString, FString>& commonParams)
{
	FString jsonStr = FUsdkCommonTools::converMapToString(commonParams);
	std::string tempStr = TCHAR_TO_UTF8(*jsonStr);
	FString tmpData = FBase64::Encode((uint8*)tempStr.data(),tempStr.length());
	FString finalData = EncryptSwap(tmpData);
	return finalData;
}


//换位
FString FUsdkManager::EncryptSwap(FString data)
{
	const unsigned char heroAESSwapIdx[8] = {1, 33, 10, 42, 18, 50, 19, 51};
	if (data.IsEmpty()){return "";}
	if (data.Len() < 51){ return data; }
	for (int i=1;i<8;i+=2) { 
		int l = heroAESSwapIdx[i-1], r = heroAESSwapIdx[i];
		TCHAR c = data[l];
		data[l] = data[r];
		data[r] = c;
	}
	//UE_LOG(LogHeroUsdk, Log, TEXT("换位后 : %s"), *data);
	return data;

}

//公共参数
TMap<FString, FString> FUsdkManager::GetCommonParameter()
{
	TMap<FString, FString> commonMap = Config->GetFormData();

	const FString svc = HeroUsdkSupportKit::GetInstance().getHeroUsdkUE4Version();
	commonMap.Add("svc", svc);
	const FString dn = FPlatformMisc::GetLoginId();
	commonMap.Add("dn", dn);

	// #warning ========= 测试环境专用 ========
	auto setting = GetMutableDefault<UUsdkSettings>();
	if (setting->bIsDebug)
	{
		commonMap.Add("yxDev","1");
	}

	if (UsdkAccessToken.Len() > 0)
	{
		commonMap.Add("accessToken",UsdkAccessToken);
	}
	

	return commonMap;
}

bool isJSON(const char *p, int l) {
	return p==NULL || p[0]==0 || (p[0] =='{' && p[l-1]=='}') || (p[0]=='[' || p[l-1]==']');
}
//AES解密
FString FUsdkManager::AESDecrypt(FString InputString,FString keyString)
{
	if (InputString.IsEmpty()) {
		return "";
	}
    FString exchange = EncryptSwap(InputString);
    std::string const source =  TCHAR_TO_UTF8(*exchange);
    size_t source_len = source.length();
    //UE_LOG(LogHeroUsdk, Log, TEXT("长度: %d : %d"), source_len, exchange.Len());
	unsigned char * result_base64 = (unsigned char * )FMemory::Malloc(source_len+1+source_len); // 缓存,这里有两次decode,加大缓冲区复用
	FMemory::Memset(result_base64, 0, source_len+1+source_len);
    size_t result_len0, result_len;
	unsigned char * buf0 = result_base64 + source_len;
    FCRYPTO_BASE64::CRYPTO_BASE64_Decode(buf0, &result_len0, (unsigned char *)source.c_str(), source_len);
	if (keyString.IsEmpty() || isJSON((const char *)buf0, result_len0)) { // 直接的base64
		buf0[result_len0] = '\0';
		FString rs = FString(UTF8_TO_TCHAR(buf0));
		FMemory::Free(result_base64);
		return rs;
	}
    FCRYPTO_BASE64::CRYPTO_BASE64_Decode(result_base64, &result_len, buf0, result_len0);
    result_base64[result_len] = '\0';
    //UE_LOG(LogHeroUsdk, Log, TEXT("base64 长度: %d"), result_len);
    CRYPTO_AES256CBC_CTX ctx_aes256cbc;
	memset(&ctx_aes256cbc, 0, sizeof(ctx_aes256cbc));
    FString key = keyString ;
    //UE_LOG(LogHeroUsdk, Log, TEXT("AESDecrypt Key %s"), *key);
    FString iv = key.Mid(0,16);
    //UE_LOG(LogHeroUsdk, Log, TEXT("AESDecrypt Iv %s"), *iv);
    std::string const keyChar = TCHAR_TO_UTF8(*key);
    std::string const ivChar = TCHAR_TO_UTF8(*iv);
    FCRYPTO_AES256CBC::CRYPTO_AES256CBC_init_ctx_iv(&ctx_aes256cbc, (unsigned char *)keyChar.c_str(), (unsigned char *)ivChar.c_str());
    FCRYPTO_AES256CBC::CRYPTO_AES256CBC_decrypt(&ctx_aes256cbc, result_base64, result_len);
	if (result_len > 0) { // padding
		const unsigned char c = result_base64[result_len-1];
		if (c > 0 && c < result_len && c < 0x20 && result_base64[result_len-c] == c) {
			int pass = 1;	
			for (int i = c-1;i>1;i--) {
				if (result_base64[result_len-i] != c) {
					pass = 0;
					break;
				}
			}
			if (pass == 1) {
				result_base64[result_len-c] = 0;
			}
		}
	}
    result_base64[result_len] = '\0';
	FString rs = FString(UTF8_TO_TCHAR(result_base64));
	FMemory::Free(result_base64);
	return rs;
}
//AES加密
FString FUsdkManager::AESEncrypt(FString InputString,FString keyString)
{
	if (InputString.IsEmpty()) return "";
	std::string source =  TCHAR_TO_UTF8(*InputString);
	size_t source_len = source.length();
	int pad_size = (32-source_len%0x20);
	int buf1_size = (source_len + pad_size)*4/3 + 32;
	int buf0_size = buf1_size*4/3 + 32;
	char *buf0 = NULL;
	char *buf1 = NULL;
	size_t result_len0 = 0, result_len1 = 0;
	if (!keyString.IsEmpty()) {
		buf0 = (char*)FMemory::Malloc(buf0_size+buf1_size);
		FMemory::Memset(buf0, 0, buf0_size+buf1_size);
		buf1 = buf0 + buf0_size;
		FMemory::Memcpy(buf0, source.c_str(), source_len);
		if (pad_size > 0) {
			FMemory::Memset(buf0+source_len, pad_size, pad_size);
		}
		CRYPTO_AES256CBC_CTX ctx_aes256cbc;
		FMemory::Memset(&ctx_aes256cbc, 0, sizeof(ctx_aes256cbc));
		FString key = keyString ;
		FString iv = key.Mid(0,16);
		std::string const keyChar = TCHAR_TO_UTF8(*key);
		std::string const ivChar = TCHAR_TO_UTF8(*iv);
		FCRYPTO_AES256CBC::CRYPTO_AES256CBC_init_ctx_iv(&ctx_aes256cbc, (unsigned char *)keyChar.c_str(), (unsigned char *)ivChar.c_str());
		FCRYPTO_AES256CBC::CRYPTO_AES256CBC_encrypt(&ctx_aes256cbc, (unsigned char*)buf0, source_len + pad_size);
		//UE_LOG(LogHeroUsdk, Log, TEXT("AESEncrypt %s"), buf0);
		FCRYPTO_BASE64::CRYPTO_BASE64_Encode((unsigned char*)buf1, &result_len1, (unsigned char *)buf0, source_len + pad_size);
		FCRYPTO_BASE64::CRYPTO_BASE64_Encode((unsigned char*)buf0, &result_len0, (unsigned char *)buf1, result_len1);
	} else {
		buf0 = (char*)FMemory::Malloc(buf1_size);
		FCRYPTO_BASE64::CRYPTO_BASE64_Encode((unsigned char*)buf0, &result_len0, (unsigned char *)source.c_str(), source_len);
	}
	if (result_len0 > 0  && result_len0 < 1024*1024) {
		buf0[result_len0] = 0;
	} else {
		buf0[0] = 0;
	}
	FString exchange = FString(UTF8_TO_TCHAR(buf0));
	FString rs = EncryptSwap(exchange);
	FMemory::Free(buf0);
	return rs;
}

void FUsdkManager::EnterGame(const FHeroHDCGameRoleInfo& RoleInfo)
{
	TMap<FString, FString> eventProperties;
	eventProperties.Emplace("role_id",RoleInfo.roleId);
	eventProperties.Emplace("role_name",RoleInfo.roleName);
	eventProperties.Emplace("server_id",RoleInfo.serverId);
	eventProperties.Emplace("server_name",RoleInfo.serverName);
	FDotManager::GetInstance().CallDot("u_role_login_success",eventProperties);

	auto Setting = GetMutableDefault<UUsdkSettings>();
	
	if (Setting->Channel == EHeroUSDKChannel::Global && HeroUsdkSupportPcDelegate::GetInstance()->IsPureVersion())
	{
		return;
	}
	TMap<FString, FString> paramter = RoleInfo.ParseToMap();
	paramter.Add("type", "1");
	this->createPostRequest( "/role/attr.lg", paramter,[this, paramter](int32 statueCode,FString contentString,bool bWasSuccessful)
	{
		if (EHttpResponseCodes::IsOk(statueCode) && !contentString.IsEmpty())
		{
			FString newResultStr  = AESDecrypt(contentString,_akStr);
			UE_LOG(LogHeroUsdk, Log, TEXT("enterGame  %s"), *newResultStr);
			if (!newResultStr.IsEmpty())
			{
				TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
				TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(newResultStr);
				if (FJsonSerializer::Deserialize(Reader, JsonObject))
				{
					const TSharedPtr<FJsonValue>* codeValue = JsonObject->Values.Find(TEXT("code"));
					if (codeValue->IsValid())
					{
						double code = (* codeValue)->AsNumber() ;
						if(code == 0)
						{
							GEngine->AddOnScreenDebugMessage(-1,10, FColor::Red, TEXT("角色信息上报成功"));
							//国内上报角色信息
							//UHeroGameNetAPI::GetSingletonObjectIns()->createEnterGame(paramter) ;
						}
					}
				}
			}
		}
	});
}

void FUsdkManager::CreateNewRole(const FHeroHDCGameRoleInfo& RoleInfo)
{
	TMap<FString, FString> paramter = RoleInfo.ParseToMap();
	paramter.Add("type", "2");
	this->createPostRequest( "/role/attr.lg",paramter,[this, paramter](int32 statueCode,FString contentString,bool bWasSuccessful)
	{
		if (EHttpResponseCodes::IsOk(statueCode) && !contentString.IsEmpty())
		{
			FString newResultStr  = AESDecrypt(contentString,_akStr);
			UE_LOG(LogHeroUsdk, Log, TEXT("createNewRole  %s"), *newResultStr);
			if (!newResultStr.IsEmpty())
			{
				TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
				TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(newResultStr);
				if (FJsonSerializer::Deserialize(Reader, JsonObject))
				{
					const TSharedPtr<FJsonValue>* codeValue = JsonObject->Values.Find(TEXT("code"));
					if (codeValue->IsValid())
					{
						double code = (* codeValue)->AsNumber() ;
						if(code == 0)
						{
							GEngine->AddOnScreenDebugMessage(-1,10, FColor::Red, TEXT("角色信息上报成功"));
							//国内上报角色信息
							//UHeroGameNetAPI::GetSingletonObjectIns()->createNewRole(paramter) ;
						}
					}
				}
			}
		}
	});
}

void FUsdkManager::RoleLevelUp(const FHeroHDCGameRoleInfo& RoleInfo)
{
	TMap<FString, FString> paramter = RoleInfo.ParseToMap();
	paramter.Add("type", "3");
	this->createPostRequest( "/role/attr.lg",paramter,[this, paramter](int32 statueCode,FString contentString,bool bWasSuccessful)
	{
		if (EHttpResponseCodes::IsOk(statueCode) && !contentString.IsEmpty())
		{
			FString newResultStr  = AESDecrypt(contentString,_akStr);
				UE_LOG(LogHeroUsdk, Log, TEXT("roleLevelUp  %s"), *newResultStr);
				if (!newResultStr.IsEmpty())
				{
					TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
					TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(newResultStr);
					if (FJsonSerializer::Deserialize(Reader, JsonObject))
					{
						const TSharedPtr<FJsonValue>* codeValue = JsonObject->Values.Find(TEXT("code"));
						if (codeValue->IsValid())
						{
							double code = (* codeValue)->AsNumber() ;
							if(code == 0)
							{
								GEngine->AddOnScreenDebugMessage(-1,10, FColor::Red, TEXT("角色信息上报成功"));
								//国内上报角色信息
								//UHeroGameNetAPI::GetSingletonObjectIns()->roleLevelUp(paramter) ;
							}
						}
					}
				}
		}
	});
}

//USDK下单
void FUsdkManager::pay(const TMap<FString,FString>& paramter,const TFunction<void(const FPayOrderResult&)>& OnCompleted)
{
	this->createPostRequest("/pay/order.lg",paramter,[this, OnCompleted](int32 statueCode,FString contentString,bool bWasSuccessful)
	{
		if (!EHttpResponseCodes::IsOk(statueCode) )
		{
			OnCompleted({});
			return ;
		}
		if (contentString.IsEmpty())
		{
			OnCompleted({});
		}

		FString result = AESDecrypt(contentString, _akStr);
		UE_LOG(LogHeroUsdk, Log, TEXT("/pay/order.lg result : %s"), *result);
		auto PayOrderResult = FPayOrderResult::ParseFromJson(result);
		OnCompleted(PayOrderResult);
	}) ;
}
//Steam授权支付回调服务器验证
void FUsdkManager::steamCallback(const TMap<FString,FString>& Map,const FUSDKNetWorkComplete& NetWorkComplete)
{
	this->createPostRequest("callback/steam",Map,[this, NetWorkComplete](int32 statueCode,FString contentString,bool bWasSuccessful)
	{
		if (!EHttpResponseCodes::IsOk(statueCode) )
		{
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkFailed,"",TEXT("支付失败,请稍后重试"));
			return ;
		}
		if (contentString.IsEmpty())
		{
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkFailed,"",TEXT("支付失败,请稍后重试"));
			return;
		}
		if (NetWorkComplete) { NetWorkComplete(statueCode,contentString,bWasSuccessful); }
	}) ;
}