// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Http.h"
#include "PC_SurveyPanel.h"
#include "Data/PayOrderResult.h"
#include "Data/HeroUsdkSupportData.h"
#include "Manager/Channel/Base/ChannelManagerBase.h"
#include "Platform/Base/ChannelConfigBase.h"

typedef TFunction<void(int32 statueCode,FString contentString,bool bWasSuccessful)> FUSDKNetWorkComplete;

UENUM(BlueprintType)
enum class EPayChannel : uint8
{
	Official,
	Xsolla,
};

enum class EUsdkResult
{
	Failed,
	Success,
};

class  FUsdkManager 
{

public:
	FUsdkManager(const TSharedPtr<FChannelConfigBase>& ChannelConfig,const TSharedPtr<FChannelManagerBase>& InChannelManager,const TSharedPtr<FEnvModeBase>& InEnvMode)
	:Config(ChannelConfig),ChannelManager(InChannelManager),EnvMode(InEnvMode)
	{
		
	}

	//加密相关
	FString _ak ;
	FString _aki ;
	FString _akStr;

	//标记是否初始化成功
	bool isInitedSucc ;

	//协议内容
	FString _newAgreements;
	
	//token
	FString UsdkAccessToken;

	//登录类型
	FString loginType;
	
	
	FHttpModule * GetHttpModule() ;

	FHttpManager& GetHttpMgr() ;

	void UsdkInit(TFunction<void(EUsdkResult Result, bool bPopAgreement, const FString& Msg)>Callback);

	void GenInitConfig();

	static FString SimpleEncryption(const TMap<FString, FString>& commonParams);
	//创建网络请求
	void createPostRequest(FString url, const TMap<FString,FString>& paramter ,const FUSDKNetWorkComplete& netWorkComplete);
	void createFullUrlPostRequest(FString fullUrl, const TMap<FString,FString>& paramter ,const FUSDKNetWorkComplete& netWorkComplete);
	
	//获取配置接口
	TSharedRef<IHttpRequest, ESPMode::ThreadSafe> createUSDKGetReuquest(FString _url) ;

	//配置接口回调
	void ResponseData(FHttpRequestPtr Request, FHttpResponsePtr Response, bool bWasSuccessful);
	
	//USDK检查token
	void UsdkLogin(const TMap<FString,FString>& paramter,const TFunction<void(EUsdkResult, const FString& ErrorMsg,const FUserInfo& UserInfo)>& Callback) ;

	//USDK检查token
	void UsdkCheckLogin(const TMap<FString,FString>& paramter,const FUSDKNetWorkComplete& netWorkComplete) ;
	void UsdkCheckLoginResponse(const FString& Msg,const TFunction<void(EUsdkResult, const FString& ErrorMsg,const FUserInfo&)>& Callback);
	void UsdkSurvey(TSubclassOf<UPC_SurveyPanel> UserWidgetClass, const FString& WebId ,const TFunction<void(bool,const FString&)>& Callback);
	
	//AES解密
	FString AESDecrypt(FString inputString,FString keyString) ;
	//AES加密
	FString AESEncrypt(FString inputString,FString keyString) ;

	//换位
	static FString EncryptSwap(FString data) ;

	

	//进行游戏角色上报
	void EnterGame(const FHeroHDCGameRoleInfo& RoleInfo);
	//创建游戏角色上报
	void CreateNewRole(const FHeroHDCGameRoleInfo& RoleInfo);
	//升级游戏角色上报
	void RoleLevelUp(const FHeroHDCGameRoleInfo& RoleInfo);
	//USDK下单
	void pay(const TMap<FString,FString>& paramter,const TFunction<void(const FPayOrderResult&)>& OnCompleted);
	//Steam授权支付回调服务器验证
	void steamCallback(const TMap<FString,FString>& Map,const FUSDKNetWorkComplete& NetWorkComplete) ;

private:

	
	//加密
	FString FormatForm(const TMap<FString,FString>& paramter) ;

	FString FormatFormWithAdvancedEncryption(const TMap<FString, FString>& paramter);
	
	//通用加密
	FString FormatFormWithSimpleEncryption(const TMap<FString,FString>& paramter) ;
	
	
	//公共参数
	TMap<FString,FString> GetCommonParameter() ;
	TSharedPtr<FChannelConfigBase> Config;
	TSharedPtr<FChannelManagerBase> ChannelManager;
	TSharedPtr<FEnvModeBase> EnvMode;
};
