
#include "Data/PayOrderResult.h"

FPayOrderResult FPayOrderResult::ParseFromJson(const FString& json)
{
	FPayOrderResult result;
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(json);
	if (FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		if(JsonObject->HasTypedField<EJson::Number>("code"))
		{
			result.code = JsonObject->GetNumberField("code");
		}
		if(JsonObject->HasTypedField<EJson::Number>("timestamp"))
		{
			result.timestamp = JsonObject->GetNumberField("timestamp");
		}
		if(JsonObject->HasTypedField<EJson::Number>("price"))
		{
			result.price = JsonObject->GetNumberField("price");
		}
		if(JsonObject->HasTypedField<EJson::String>("order"))
		{
			result.order = JsonObject->GetStringField("order");
		}
		if(JsonObject->HasTypedField<EJson::String>("customMsg"))
		{
			result.customMsg = JsonObject->GetStringField("customMsg");
		}
		if(JsonObject->HasTypedField<EJson::String>("goodsName"))
		{
			result.goodsName = JsonObject->GetStringField("goodsName");
		}
		if(JsonObject->HasTypedField<EJson::String>("goodsDesc"))
		{
			result.goodsDesc = JsonObject->GetStringField("goodsDesc");
		}
		if(JsonObject->HasTypedField<EJson::Number>("amount"))
		{
			result.amount = JsonObject->GetNumberField("amount");
		}
		if(JsonObject->HasTypedField<EJson::String>("callbackUrl"))
		{
			result.callbackUrl = JsonObject->GetStringField("callbackUrl");
		}
		if(JsonObject->HasTypedField<EJson::Number>("goodsNum"))
		{
			result.goodsNum = JsonObject->GetNumberField("goodsNum");
		}
		if(JsonObject->HasTypedField<EJson::Number>("type"))
		{
			result.type = JsonObject->GetNumberField("type");
		}
		if(JsonObject->HasTypedField<EJson::String>("currency"))
		{
			result.currency = JsonObject->GetStringField("currency");
		}
		if(JsonObject->HasTypedField<EJson::String>("gameIcon"))
		{
			result.gameIcon = JsonObject->GetStringField("gameIcon");
		}
		if(JsonObject->HasTypedField<EJson::String>("msg"))
		{
			result.msg = JsonObject->GetStringField("msg");
		}
		if(JsonObject->HasTypedField<EJson::String>("serverMsg"))
		{
			result.serverMsg = JsonObject->GetStringField("serverMsg");
		}
	}
	return result;
}
