#include "UsdkCommonTools.h"
#include "LogHeroUsdk.h"
#include "Manager/HeroUsdkSupportPcDelegate.h"

FString GetFileStorePath(const FString& Name)
{
	FString StorePath = FPaths::Combine(FPaths::ProjectSavedDir(), TEXT("PCsdk"),TEXT("Config"));
	
	if (!FPlatformFileManager::Get().GetPlatformFile().DirectoryExists(*StorePath))
	{
		FPlatformFileManager::Get().GetPlatformFile().CreateDirectoryTree(*StorePath);
	}
	return FPaths::ConvertRelativePathToFull(FPaths::Combine(StorePath,Name));
}


FString FUsdkCommonTools::ReadTextByPath(FString path)
{
	FString data;
	FString ProjectDir = GetFileStorePath(path);

	UE_LOG(LogHeroUsdk, Log, TEXT("readTextByPath %s "), *ProjectDir);
	if (!FPlatformFileManager::Get().GetPlatformFile().FileExists(*ProjectDir))
	{
		//GEngine->AddOnScreenDebugMessage(-1, 5.f, FColor::Red, TEXT("Couldn't find file"));
		return FString();
	}
	//GEngine->AddOnScreenDebugMessage(-1, 5.f, FColor::Red, (TEXT("Could find file %s"), *ProjectDir));
	FFileHelper::LoadFileToString(data, *ProjectDir);
	return data;
}

void FUsdkCommonTools::WriteText(FString path, FString data)
{
	FString ProjectDir = GetFileStorePath(path);
	FFileHelper::SaveStringToFile(data, *ProjectDir);
}

void FUsdkCommonTools::DeleteText(const FString Path)
{
	FString ProjectDir = GetFileStorePath(Path);
	
	if (FPlatformFileManager::Get().GetPlatformFile().FileExists(*ProjectDir))
	{
		//删除文件
		FPlatformFileManager::Get().GetPlatformFile().DeleteFile(*ProjectDir);
	}
}

FString FUsdkCommonTools::converMapToString(const TMap<FString, FString>& parameters)
{
	FString parametersJSON;
	if (parameters.Num())
	{
		TSharedPtr<FJsonObject> FieldsObject = MakeShareable(new FJsonObject());
		for (auto& Elem : parameters)
		{
			if (!Elem.Key.IsEmpty()) { FieldsObject->SetStringField(Elem.Key, Elem.Value); }
		}
		auto jsonWriter = TJsonWriterFactory<TCHAR,TCondensedJsonPrintPolicy<TCHAR>>::Create(&parametersJSON);
		FJsonSerializer::Serialize(FieldsObject.ToSharedRef(), jsonWriter);
		UE_LOG(LogHeroUsdk, Log, TEXT(" converMapToString : %s"), *parametersJSON);
	}
	return parametersJSON;
}

FString FUsdkCommonTools::AppendUrlTimestampFix(FString BaseUrl)
{
	const FString Timestamp = FString::Printf(TEXT("timestamp=%s"), *GetTimestamp());
	if ( BaseUrl.Contains("?") )
	{
		BaseUrl += FString::Printf(TEXT("&%s"), *Timestamp);
	}
	else
	{
		BaseUrl += FString::Printf(TEXT("?%s"), *Timestamp);
	}
	return BaseUrl;
}

FString FUsdkCommonTools::GetTimestamp()
{
	FString Timestamp;
	FDateTime Time = FDateTime::UtcNow();
	int64 unixTimestamp = Time.ToUnixTimestamp();
	Timestamp = FString::Printf(TEXT("%lld"), unixTimestamp);
	return Timestamp;
}
