#include "UsdkWebTools.h"
#include "LogHeroUsdk.h"


FString GetWebStorePath(const FString& Name)
{
	FString StorePath = FPaths::Combine(FPaths::ProjectSavedDir(), TEXT("PCsdk"),TEXT("WebStore"));
	
	if (!FPlatformFileManager::Get().GetPlatformFile().DirectoryExists(*StorePath))
	{
		FPlatformFileManager::Get().GetPlatformFile().CreateDirectoryTree(*StorePath);
	}
	return FPaths::ConvertRelativePathToFull(FPaths::Combine(StorePath,Name));
}

FString FUsdkWebTools::ReadTextByPath(FString path)
{
	FString data;
	FString ProjectDir = GetWebStorePath(path);

	UE_LOG(LogHeroUsdk, Log, TEXT("readTextByPath %s "), *ProjectDir);
	if (!FPlatformFileManager::Get().GetPlatformFile().FileExists(*ProjectDir))
	{
		//GEngine->AddOnScreenDebugMessage(-1, 5.f, FColor::Red, TEXT("Couldn't find file"));
		return FString();
	}
	//GEngine->AddOnScreenDebugMessage(-1, 5.f, FColor::Red, (TEXT("Could find file %s"), *ProjectDir));
	FFileHelper::LoadFileToString(data, *ProjectDir);
	return data;
}

void FUsdkWebTools::WriteText(FString path, FString data)
{
	FString ProjectDir = GetWebStorePath(path);
	FFileHelper::SaveStringToFile(data, *ProjectDir);
}

void FUsdkWebTools::DeleteText(const FString Path)
{
	FString ProjectDir = GetWebStorePath(Path);
	
	if (FPlatformFileManager::Get().GetPlatformFile().FileExists(*ProjectDir))
	{
		//删除文件
		FPlatformFileManager::Get().GetPlatformFile().DeleteFile(*ProjectDir);
	}
}

