// Fill out your copyright notice in the Description page of Project Settings.


#include "PC_AccountCenterPannel.h"
#include "Manager/Usdk/UsdkManager.h"
#include "LogHeroUsdk.h"
#include "Manager/HeroUsdkSupportPcDelegate.h"
#include "Tools/UsdkCommonTools.h"

FString UPC_AccountCenterPannel::GetLocalUrl()
{
	FString LocalUrl = FPaths::Combine(HeroUsdkSupportPcDelegate::GetInstance()->GetChannelManager()->GetChannelWebDir(),  TEXT("index.html#/account-center")) ;
	UE_LOG(LogHeroUsdk,Log,TEXT("load Local UPC_AccountCenterPannel url:%s"),*LocalUrl);
	return LocalUrl;
}

FString UPC_AccountCenterPannel::GetRemoteUrl()
{
	const FString BaseUrl = HeroUsdkSupportPcDelegate::GetInstance()->GetEnvMode()->GetPcUrl() ;
	FString FullUrl = FPaths::Combine(BaseUrl,TEXT("#/account-center"));
	FullUrl =  FUsdkCommonTools::AppendUrlTimestampFix(FullUrl);
	UE_LOG(LogHeroUsdk, Log, TEXT("UPC_AccountCenterPannel remote rUrl data %s"), *FullUrl);
	return FullUrl ;
}
