// Fill out your copyright notice in the Description page of Project Settings.


#include "PC_LoginPannel.h"

#include <string>

#include "Manager/Usdk/UsdkManager.h"
#include "HeroUsdkSupportKit.h"
#include "JsonObjectConverter.h"
#include "LogHeroUsdk.h"
#include "DotManager/DotManager.h"
#include "Kismet/GameplayStatics.h"
#include "Kismet/KismetSystemLibrary.h"
#include "Manager/Channel/China/ChinaManager.h"
#include "Misc/FileHelper.h"
#include "Setting/UsdkSettings.h"
#include "Tools/UsdkCommonTools.h"

#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
#include "Manager/HeroUsdkSupportPcDelegate.h"
#endif


void UPC_LoginPannel::JumpToTapTapUrl()
{
	FString url = GetUrl();
	url += "?login_type=taptap";
	JumpURL(url);
}

void UPC_LoginPannel::NativeConstruct()
{
	Super::NativeConstruct();
	Setting = GetMutableDefault<UUsdkSettings>(); 
	if (Setting->Channel == EHeroUSDKChannel::Global)
	{
		GenerateFacebookInjectMap();
	}
}

void UPC_LoginPannel::NativeTick(const FGeometry& MyGeometry, float InDeltaTime)
{
	Super::NativeTick(MyGeometry, InDeltaTime);
}



void UPC_LoginPannel::HandleJSCallBack(FString data)
{
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	UE_LOG(LogHeroUsdk, Log, TEXT("UPC_LoginPannel::HandleJSCallBack data %s"), *data);
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(data);
	if (FJsonSerializer::Deserialize(Reader, JsonObject))
	{
	
		FString urlStr =JsonObject->GetStringField(TEXT("url"));
		
		if (urlStr.Equals("v1/login/checklgn.lg"))
		{
			const TSharedPtr<FJsonObject> dataObject = JsonObject->GetObjectField(TEXT("data"));
			if (dataObject.IsValid())
			{
				FUserInfo UserInfo;
				UserInfo.plat = TEXT("pc");
				UserInfo.sdkUserId =  dataObject->GetStringField("cUid");;
				UserInfo.userName =   dataObject->GetStringField("cName");
				UserInfo.accessToken = dataObject->GetStringField("cToken");
				HeroUsdkSupportPcDelegate::GetInstance()->SetUserInfo(UserInfo);
				
				if (!UserInfo.accessToken.IsEmpty())
				{
					//USDK验证token
					TMap<FString, FString> paramter;
					paramter.Add("cToken", UserInfo.accessToken);
					paramter.Add("cUid", UserInfo.sdkUserId);
				
					HeroUsdkSupportPcDelegate::GetInstance()->SetChannelToken(UserInfo.accessToken);
					UE_LOG(LogHeroUsdk,Warning,TEXT("js callback accessToken:%s"),*UserInfo.accessToken)
					

					const auto setting = GetMutableDefault<UUsdkSettings>(); 
					if(setting && (setting->Channel == EHeroUSDKChannel::China ||setting->Channel == EHeroUSDKChannel::WeGame))
					{
						auto channelManager = HeroUsdkSupportPcDelegate::GetInstance()->GetChannelManager();
						auto ChinaManager = StaticCastSharedPtr<FChinaManager>(channelManager);
						ChinaManager->StopCountdown();
						if(AntiAddictionTime>0)
						{
							ChinaManager->StartCountdown(AntiAddictionTime, msg);
						}
						ChinaManager->StartPoll();
					}

					{
						TMap<FString,FString> DotParam;
						DotParam.Emplace("login_type","");
						DotParam.Emplace("is_success","1");
						DotParam.Emplace("reason","success");
						FDotManager::GetInstance().CallDot("u_l_getchamsg",DotParam);
					}

					//海外去usdk
					if(setting->Channel == EHeroUSDKChannel::Global && HeroUsdkSupportPcDelegate::GetInstance()->IsPureVersion())
					{
						if(HeroUsdkSupportKit::GetInstance().NotifyObject)
						{
							{
								TMap<FString,FString> DotParam;
								DotParam.Emplace("login_type","");
								DotParam.Emplace("is_success","1");
								DotParam.Emplace("reason","");
								FDotManager::GetInstance().CallDot("u_l_backlogmsg_to_cp",DotParam);
							}
							FString profile;
							FJsonObjectConverter::UStructToJsonObjectString(UserInfo, profile, 0, 0);
							OnPopPannel();
							HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(
								HeroUsdkSuccess, profile,TEXT("登录成功"));
							
						}
						return;
					}

					//非去usdk
					HeroUsdkSupportPcDelegate::GetInstance()->GetUsdkManager()->UsdkLogin(paramter,[this](EUsdkResult Result, const FString& ErrorMsg,const FUserInfo& UserInfo)
					{
						if(Result == EUsdkResult::Failed)
						{
							if (HeroUsdkSupportKit::GetInstance().NotifyObject != nullptr)
							{
								auto channelManager = HeroUsdkSupportPcDelegate::GetInstance()->GetChannelManager();
								auto ChinaManager = StaticCastSharedPtr<FChinaManager>(channelManager);
								if(ChinaManager)
								{
									ChinaManager->StopCountdown();
									ChinaManager->StopPoll();
								}
								
								//登录失败回调
								{
									TMap<FString,FString> DotParam;
									DotParam.Emplace("login_type","");
									DotParam.Emplace("is_success","0");
									DotParam.Emplace("reason",ErrorMsg);
									FDotManager::GetInstance().CallDot("u_l_backlogmsg_to_cp",DotParam);
								}
								
								OnPopPannel();
								HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(
									HeroUsdkFailed, "", ErrorMsg);
							}
							HeroUsdkSupportPcDelegate::GetInstance()->Logout(false);
							{
								TMap<FString,FString> DotParam;
								DotParam.Emplace("login_type","");
								DotParam.Emplace("is_success","0");
								DotParam.Emplace("reason",ErrorMsg);
								FDotManager::GetInstance().CallDot("u_l_backlogmsg_to_cp",DotParam);
							}

						}
						else if(Result == EUsdkResult::Success)
						{
							FString profile;
							FJsonObjectConverter::UStructToJsonObjectString(UserInfo, profile, 0, 0);
							if (!profile.IsEmpty() && HeroUsdkSupportKit::GetInstance().NotifyObject != nullptr)
							{
								FString CompUrl = HeroUsdkSupportPcDelegate::GetInstance()->GetEnvMode()->GetPcUrl() ;

								auto UserName = UserInfo.userName.IsEmpty()?UserInfo.sdkUserId:
								UserInfo.userName;
								CompUrl = CompUrl+TEXT("?type=loginSuccess&username=")+FGenericPlatformHttp::UrlEncode(UserName);
								UKismetSystemLibrary::PrintString(this,FString::Printf(TEXT("login munual jump url:%s"),*CompUrl));
								JumpURL(CompUrl);

								if(HeroUsdkSupportKit::GetInstance().NotifyObject)
								{
									{
										TMap<FString,FString> DotParam;
										DotParam.Emplace("login_type","");
										DotParam.Emplace("is_success","1");
										DotParam.Emplace("reason","");
										FDotManager::GetInstance().CallDot("u_l_backlogmsg_to_cp",DotParam);
									}
									OnPopPannel();
									HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(
										HeroUsdkSuccess, profile,TEXT("登录成功"));
								}
								
							}
						}

					});
				}
				else
				{
					UE_LOG(LogHeroUsdk, Error, TEXT("Get Token Failed")) ;
				}
			}
			return;
		}
		else if (urlStr.Equals("v1/tips/exit"))
		{
			{
				TMap<FString,FString> DotParam;
				DotParam.Emplace("login_type","");
				DotParam.Emplace("is_success","0");
				DotParam.Emplace("reason",urlStr);
				FDotManager::GetInstance().CallDot("u_l_getchamsg",DotParam);
			}
			
			//退出应用
			if (HeroUsdkSupportKit::GetInstance().NotifyObject != nullptr)
			{
				{
					TMap<FString,FString> DotParam;
					DotParam.Emplace("login_type","");
					DotParam.Emplace("is_success","0");
					DotParam.Emplace("reason",urlStr);
					FDotManager::GetInstance().CallDot("u_l_backlogmsg_to_cp",DotParam);
				}
				OnPopPannel();
				HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(HeroUsdkFailed,{},TEXT("退出登录"));
			}
			//关闭登录界面
			OnPopPannel();
			if (GetMutableDefault<UUsdkSettings>()->Channel == EHeroUSDKChannel::WeGame)
			{
				UKismetSystemLibrary::QuitGame(this,nullptr,EQuitPreference::Quit,false);
			}
		}
		else if(urlStr.Equals("v1/actioin/errMsg"))
		{
			{
				TMap<FString,FString> DotParam;
				DotParam.Emplace("login_type","");
				DotParam.Emplace("is_success","0");
				DotParam.Emplace("reason",urlStr);
				FDotManager::GetInstance().CallDot("u_l_getchamsg",DotParam);
			}
			//登录失败
			const TSharedPtr<FJsonValue>* dataValue = JsonObject->Values.Find(TEXT("data"));
			TSharedPtr<FJsonObject> dataObject = (*dataValue)->AsObject() ;
			if (dataObject.IsValid())
			{
				const TSharedPtr<FJsonValue>* msgValue = dataObject->Values.Find("msg");
				if (msgValue->IsValid())
				{
					FString msgString = (*msgValue)->AsString();
					if (HeroUsdkSupportKit::GetInstance().NotifyObject != nullptr)
					{
						{
							TMap<FString,FString> DotParam;
							DotParam.Emplace("login_type","");
							DotParam.Emplace("is_success","0");
							DotParam.Emplace("reason",urlStr);
							FDotManager::GetInstance().CallDot("u_l_backlogmsg_to_cp",DotParam);
						}
						//登录失败回调
						OnPopPannel();
						HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(HeroUsdkFailed,"",msgString);
					}
					//关闭登录界面
					OnPopPannel();
					return ;
				}
			}
			//无法解析错误信息也回调登录失败
			if (HeroUsdkSupportKit::GetInstance().NotifyObject != nullptr)
			{
				{
					TMap<FString,FString> DotParam;
					DotParam.Emplace("login_type","");
					DotParam.Emplace("is_success","1");
					DotParam.Emplace("reason","");
					FDotManager::GetInstance().CallDot("u_l_backlogmsg_to_cp",DotParam);
				}
				OnPopPannel();
				HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(HeroUsdkFailed,"",TEXT("登录失败,请稍后重试"));
				return ;
			}
			//跳转到登录页面
			FUsdkCommonTools::DeleteText("Logined");
			JumpURL(GetUrl());	
		}
		else if (urlStr.Equals("v1/action/loginErr"))
		{
			{
				TMap<FString,FString> DotParam;
				DotParam.Emplace("login_type","");
				DotParam.Emplace("is_success","0");
				DotParam.Emplace("reason",urlStr);
				FDotManager::GetInstance().CallDot("u_l_getchamsg",DotParam);
			}
			if (HeroUsdkSupportKit::GetInstance().NotifyObject != nullptr)
			{
				{
					TMap<FString,FString> DotParam;
					DotParam.Emplace("login_type","");
					DotParam.Emplace("is_success","1");
					DotParam.Emplace("reason","");
					FDotManager::GetInstance().CallDot("u_l_backlogmsg_to_cp",DotParam);
				}
				OnPopPannel();
				HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onLoginCallBack(HeroUsdkFailed,"",TEXT("登录失败,请稍后重试"));
				//跳转到登录页面
				FUsdkCommonTools::DeleteText("Logined");
				JumpURL(GetUrl());	
			}
		}
		// 0x0000009fd6f77bb0 L"{"url":"v1/qqLogin/url","data":{"url":"https://graph.qq.com/oauth2.0/authorize?response_type=code&client_id=102010527&redirect_uri=https://other.yingxiong.com/dev_mainland/sdkcom/c1/pc/login/qqRedirect.ul&state=D10309A_com.hero.pc.sdk"}}"
		else if (urlStr.Equals("v1/qqLogin/url")) // qq OAuth登录
		{
			if (JsonObject->HasField("data"))
			{
				const TSharedPtr<FJsonObject>& DataObject = JsonObject->GetObjectField("data");
				if (DataObject->HasField("url"))
				{
					const FString OAuthUrl = DataObject->GetStringField("url");
					UE_LOG(LogHeroUsdk, Warning, TEXT("JavaScript call qqLogin, redirect to qq oAuth: %s"), *OAuthUrl);
					JumpURL(OAuthUrl);
				}
				else
				{
					UE_LOG(LogHeroUsdk, Error, TEXT("JavaScript call qqLogin, but redirect url not found"));
				}
			}
		}
		else if (urlStr.Equals("v1/exitGameTime")) // 防沉迷
		{
			const auto DataObj = JsonObject->GetObjectField(TEXT("data"));
			if(DataObj.IsValid() && DataObj->HasTypedField<EJson::Number>(TEXT("time")))
			{
				AntiAddictionTime = DataObj->GetIntegerField(TEXT("time"));
				msg = DataObj->GetStringField("msg");
				
			}
		}
		else if (urlStr.Equals("v1/actioin/close"))
		{
			//关闭界面
			OnPopPannel();
		}
		else if(urlStr.Equals("v1/del/cookie"))
		{
			const auto DataObj = JsonObject->GetObjectField(TEXT("data"));
			if(DataObj.IsValid() && DataObj->HasTypedField<EJson::String>(TEXT("url")))
			{
				UWebBrowser_0->DeleteCookies(DataObj->GetStringField(TEXT("url")));
			}
		}
		else if(urlStr.Equals("v1/openurl/internal"))
		{
			const TSharedPtr<FJsonObject> dataObject = JsonObject->GetObjectField(TEXT("data"));
			if (dataObject.IsValid())
			{
				auto DataUrl = dataObject->GetStringField("url");
				HeroUsdkSupportPcDelegate::GetInstance()->accountCancellation(DataUrl+"#/");
			}
		}
		else if(urlStr.Equals("v1/taptap/login"))
		{
			HeroUsdkSupportPcDelegate::GetInstance()->TapTapLogin();
			OnPopPannel();
		}
		else
		{
			UE_LOG(LogHeroUsdk, Error, TEXT("JSON deserialization failed"));
		}
		
	}
	
#endif
}

void UPC_LoginPannel::OnWebClose(FString data)
{
	Super::OnWebClose(data);
}

void UPC_LoginPannel::OnCloseClickedImp()
{
	Super::OnCloseClickedImp();
}


void UPC_LoginPannel::OnLoadCompletedImp()
{
	if (Setting->Channel == EHeroUSDKChannel::Global)
	{
		if (UWebBrowser_0 == nullptr || FacebookInjectMap.Num() == 0) {
			return;
		}
		FString CurrentUrl = UWebBrowser_0->GetUrl();
		for (const auto& Elem : FacebookInjectMap) {
			if (CurrentUrl.StartsWith(Elem.Key)) {
				UWebBrowser_0->ExecuteJavascript(Elem.Value);
				break;
			}
		}
	}
}



void UPC_LoginPannel::OnPopPannel()
{
	IsCounting = false;
	RemoveFromParent();
}


FString UPC_LoginPannel::GetLocalUrl()
{
	FString LocalUrl = FPaths::Combine(HeroUsdkSupportPcDelegate::GetInstance()->GetChannelManager()->GetChannelWebDir(),  TEXT("index.html#/middle-page")) ;
	if (GetMutableDefault<UUsdkSettings>()->Channel == EHeroUSDKChannel::WeGame)
	{
		LocalUrl += "?login_type=wegame";
	}
	UE_LOG(LogHeroUsdk,Log,TEXT("load Local login url:%s"),*LocalUrl);
	return LocalUrl;
}

FString UPC_LoginPannel::GetRemoteUrl()
{
	auto PcUrl = HeroUsdkSupportPcDelegate::GetInstance()->GetEnvMode()->GetPcUrl();
	auto RemoteLoginUrl = FPaths::Combine(PcUrl,TEXT("#"),TEXT("middle-page"));
	if (GetMutableDefault<UUsdkSettings>()->Channel == EHeroUSDKChannel::WeGame)
	{
		RemoteLoginUrl += "?login_type=wegame";
	}
	return RemoteLoginUrl;
}

void UPC_LoginPannel::GenerateFacebookInjectMap()
{
	FString PathToJson = HeroUsdkSupportPcDelegate::GetInstance()->GetChannelManager()->GetChannelWebDir();
	PathToJson.RemoveFromStart(TEXT("file://"));
	const FString LocalUrl = FPaths::Combine(PathToJson,  TEXT("fbJson.json"));
	UE_LOG(LogHeroUsdk,Log,TEXT("load Local login url:%s"),*LocalUrl);
	if (FPaths::FileExists(LocalUrl))
	{
		FString JsonString;
		FFileHelper::LoadFileToString(JsonString, *LocalUrl);
		TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
		TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(JsonString);
		if (FJsonSerializer::Deserialize(Reader, JsonObject))
		{
			for (auto& Elem : JsonObject->Values)
			{
				FacebookInjectMap.Add(Elem.Key, Elem.Value->AsString());
			}
		}
	}
}
